#!/usr/bin/env bash
# Run script for Homework 1 CSE 583 Fall 2025
# Usage: sh run.sh <benchmark_dir>
# where <benchmark_dir> is a directory containing
# a src directory with a .c source file.

# ACTION REQUIRED: Ensure that the path to the library and pass name are correct.
DIRNAME=$1
SRC_FILE=$(ls $DIRNAME/src | grep '.c' | head -n 1)

if [ ! -f "$DIRNAME/src/$SRC_FILE" ]; then
    echo "Usage: $0 DIRECTORY"
    echo
    echo "DIRECTORY must contain an src directory with a .c file."
    exit 1
fi

FILENAME=${SRC_FILE%.*}

PATH2LIB="../build/hw1pass/HW1Pass.so"
PASS=hw1

BENCH="src/${FILENAME}.c"

# Delete outputs from previous runs. Update this if you want to retain some files across runs.
cd ${DIRNAME}
rm -f default.profraw *_prof *_fplicm *.bc *.profdata *_output *.ll *.in *.in.Z


# Creates a link to the input file in the local directory.
if [ "${FILENAME}" = "anagram" ]; then 
    ln -sf input/input.in
    ln -sf input/words
elif [ "${FILENAME}" = "compress" ];then
    ln -sf input/compress.in 
fi

# Convert source code to bitcode (IR).
clang -emit-llvm -c ${BENCH} -Xclang -disable-O0-optnone -o ${FILENAME}.bc -Wno-deprecated-non-prototype

# Instrument profiler passes. Generates profile data.
opt -passes='pgo-instr-gen,instrprof' ${FILENAME}.bc -o ${FILENAME}.prof.bc

# Generate binary executable with profiler embedded
clang -fprofile-instr-generate ${FILENAME}.prof.bc -o ${FILENAME}_prof

# When we run the profiler embedded executable, it generates a default.profraw file that contains the profile data.
if [ "${FILENAME}" = "anagram" ]; then 
    ./${FILENAME}_prof words < input.in > /dev/null 2>&1
elif [ "${FILENAME}" = "compress" ];then
    ./${FILENAME}_prof compress.in > /dev/null 
else
    ./${FILENAME}_prof > /dev/null
fi

# Converting it to LLVM form. This step can also be used to combine multiple profraw files,
# in case you want to include different profile runs together.
llvm-profdata merge -o ${FILENAME}.profdata default.profraw

# The "Profile Guided Optimization Instrumentation-Use" pass attaches the profile data to the bc file.
opt -passes="pgo-instr-use" -o ${FILENAME}.profdata.bc -pgo-test-profile-file=${FILENAME}.profdata < ${FILENAME}.bc

# Uncomment this and disable the cleanup if you want to "see" the instumented IR.
# llvm-dis ${FILENAME}.profdata.bc -o ${FILENAME}.prof.ll

# Runs your pass on the instrumented code.
opt --disable-output -load-pass-plugin="${PATH2LIB}" -passes="${PASS}" ${FILENAME}.profdata.bc

# Cleanup: Remove this if you want to retain the created files.
rm -f *.in *.in.Z default.profraw *_prof *_fplicm *.bc *.profdata *_output *.ll words

cd - > /dev/null
