//
//  Trial_Statistics.h
//  SimpleCrowdingModel
//
//  Created by David Kieras on 4/9/18.
//  Copyright © 2018 University of Michigan. All rights reserved.
//

#ifndef TRIAL_STATISTICS_H
#define TRIAL_STATISTICS_H
//#include "EPICLib/Statistics.h"
#include "Statistics.h"

struct Trial_statistics {
    Mean_accumulator mean_RT;
    Mean_accumulator mean_n_fixations;
    Mean_accumulator mean_error_RT;
	Mean_accumulator mean_error_n_fixations;
    Proportion_accumulator prop_errors;
    Mean_accumulator mean_illusory_target_fixations; // mean number of fixations per trial that are illusory target fixations
    Mean_accumulator mean_repeat_fixations; // mean number of fixations per trial that are repeat fixations
    Mean_accumulator mean_target_fixations; // mean number of fixations per trial that are target fixations
    // These accumulators count the mean (over trials) of the number of objects across fixations that have center properties
    // mean number of objects that are illusory distractors per trial that have distractor perceptual property
    Mean_accumulator mean_n_target_illusory_distractor;
    // mean number of objects that are illusory blanks because target sensory property available
    Mean_accumulator mean_n_target_illusory_blank;
    // mean number of objects that are illusory targets per trial
    Mean_accumulator mean_n_illusory_targets;
    // mean number of objects that have the target sensory property
//    Mean_accumulator mean_n_target_sens_property_present;
    // mean number of objects that have the target sensory property
//    Mean_accumulator mean_n_target_perc_property_present;
    // mean number of fixations in which target property was available but got overwritten (sens but not perc)
//    Mean_accumulator mean_n_target_property_overwritten;
};

#endif /* STATISTICS_H */
