//
//  Strategy.h
//  SimpleCrowdingModel
//
//  Created by David Kieras on 4/9/18.
//  Copyright © 2018 University of Michigan. All rights reserved.
//

#ifndef STRATEGY_H
#define STRATEGY_H

#include "Program_constants.h"
#include "Search_object.h"
#include "Display_creator.h"
#include "Trial_statistics.h"
#include <string>
#include <set>

class Visual_model;

class Strategy {
public:
    Strategy(Display_creator& display_creator_, Condition_e cond_, int set_size_, Polarity_e polarity_, Trial_statistics& statistics_)
        : display_creator(display_creator_), condition(cond_), set_size(set_size_), polarity(polarity_), statistics(statistics_), last_response(false)
        {}
    static std::string get_strategy_id_string();
    void do_trial();
    
    


private:
    Display_creator& display_creator;
    Condition_e condition;
    int set_size;
    Polarity_e polarity;
    Trial_statistics& statistics;

    bool response = false;  // response made on the trial
    bool error = false; // true if error made on the trial
    // maintain last response information over trials
    bool last_response = false; // absent is false, present is true;
    

    Search_objects_t search_objects; // available throughout this module
    Search_objects_t::iterator nominated_object_it;
    Search_objects_t::iterator fixated_object_it;
    int fixated_object_ID;  // ID of the Search_object that is target of eye movement

    double move_eye_to_object(Visual_model& visual_model,Search_object& object_to_fixate);


    // returns motor response time
    double make_positive_response();
    double make_negative_response();
    
    // trial data collection -- must be cleared at each trial start
    int n_repeat_fixations = 0;
    int n_target_fixations = 0;
    std::set<int> fixated_objects; // keeps track of which objects have been fixated


};

#endif /* STRATEGY_H */
