#include "Statistics.h"
#include <cmath>
#define USE_ASSERT_THROW

#ifdef USE_ASSERT_THROW
#include "Assert_throw.h"
#define ASSERT Assert
#endif

#ifdef USE_CASSERT
#include <cassert>
#define ASSERT assert
#endif

using namespace std;


double Mean_accumulator::get_sample_var() const
{
	if(n < 2)
		return 0.0;
	long double mean = get_mean();
	
	return (total2 / n - mean * mean);
}

double Mean_accumulator::get_sample_sd() const
{
	return sqrt(get_sample_var());
}

double Mean_accumulator::get_est_var() const
{
	return (n < 2) ? 0.0 : (double(n) / (n -1)) * get_sample_var();
}

double Mean_accumulator::get_est_sd() const
{
	return sqrt(get_est_var());
}

double Mean_accumulator::get_sdm() const
{
	return (n < 2) ? 0.0 : get_est_sd() / sqrt(n);
}

double Mean_accumulator::get_half_95_ci() const
{
	return (n < 2) ? 0.0 : 1.96 * get_sdm();
}

void Distribution_accumulator::add_counts(const Distribution_accumulator& other)
{
    ASSERT(n_bins == other.n_bins);
    ASSERT(bin_size == other.bin_size);
    for(int i = 0; i < n_bins; i++)
        bins[i] += other.bins[i];
    n += other.n;
	if(other.min_value < min_value)
		min_value = other.min_value;
	if(other.max_value > max_value)
		max_value = other.max_value;
}

Discrete_distribution_accumulator::Discrete_distribution_accumulator(int n_bins_, int first_bin_value_, bool count_out_of_range_into_bins_) :
        n_bins(n_bins_), first_bin_value(first_bin_value_), last_bin_value(n_bins_ - first_bin_value_ - 1),
		count_out_of_range_into_bins(count_out_of_range_into_bins_)
{
    ASSERT(n_bins >= 2);
    ASSERT(last_bin_value >= first_bin_value + 1);
    reset();
}

void Discrete_distribution_accumulator::add_counts(const Discrete_distribution_accumulator& other)
{
	ASSERT(n_bins == other.n_bins);
    ASSERT(first_bin_value == other.first_bin_value);
    ASSERT(last_bin_value == other.last_bin_value);
    ASSERT(count_out_of_range_into_bins == other.count_out_of_range_into_bins);
	for(int i = 0; i < n_bins; i++)
        bins[i] += other.bins[i];
    n += other.n;
	if(other.min_value < min_value)
		min_value = other.min_value;
	if(other.max_value > max_value)
		max_value = other.max_value;
}


void Binned_mean_accumulators::update_with_bin_means(const Binned_mean_accumulators& other)
{
	ASSERT(n_bins == other.get_n_bins() && bin_size == other.get_bin_size());
	for(int i = 0; i < n_bins; i++) {
		bins[i].update(other[i].get_mean());
		}
}

void Binned_mean_accumulators::update_with_bin_proportions(const Binned_proportion_accumulators& other)
{
	ASSERT(n_bins == other.get_n_bins() && bin_size == other.get_bin_size());
	for(int i = 0; i < n_bins; i++) {
		bins[i].update(other[i].get_proportion());
		}
}


double Correl_accumulator::get_r() const
{
	long double numerator = n * sumxy - sumx * sumy;
	long double denominator1 = n * sumx2 - sumx * sumx;
	long double denominator2 = n * sumy2 - sumy * sumy;
	long double r = (denominator1 > 0. && denominator2 > 0.) ?
		numerator / (sqrt(denominator1) * sqrt(denominator2)) : 0.0;
	return r;
}


void PredObs_accumulator::update(double predicted, double observed)
{
    corr.update(predicted, observed);
    long double error = predicted - observed;
    total_error2 += error * error;
    sum_abs_error += fabs(error);
    // compute proportion of absolute error relative to observed value
    sum_error_prop += fabs(error) / observed;
}

double PredObs_accumulator::get_rmse() const
{
    return sqrt(total_error2 / corr.get_n());
}


