//
//  Program_constants.h
//  SimpleCrowdingModel
//
//  Created by David Kieras on 3/12/18.
//  Copyright © 2018 University of Michigan. All rights reserved.
//
#ifndef PROGRAM_CONSTANTS_H
#define PROGRAM_CONSTANTS_H

//#include "EPICLib/Geometry.h"
#include "Geometry.h"
#include <array>
namespace GU = Geometry_Utilities;

// Global Types for experiment simulation
enum class Condition_e {CSF, COC, SHP};
enum class Polarity_e {NEGATIVE, POSITIVE};
enum class Run_mode_e {EXPERIMENT, GRID_SEARCH};

// availability constants
constexpr double common_intercept_c = 0;
constexpr double common_sd_c = 0.5;
// other visual constants
constexpr double bouma_fraction_c = 0.5;
// constexpr double bouma_fraction_c = 1.0; // for testing - massive crowding results
constexpr double fovea_radius_c = 1.0; // same as standard_fovea_radius in EPIC architecture


// these are declared as global variables rather than constants
// so that they can be changed in grid searches.
// Their initial values are defined as the constexpr with _c names.

extern double color_slope_g;
//extern double color_crowding_slope_g;
extern double color_crowding_probability_g;
extern double orientation_slope_g;
extern double orientation_crowding_probability_g;
extern double shape_slope_g;
extern double shape_crowding_slope_g;
extern double shape_crowding_probability_g;
extern double visual_delay_time_g;
extern int max_n_fixations_g;

extern int trial_g; // the current trial number, global for debugging output

//constexpr double color_slope_c = 0.0;
//constexpr double color_slope_c = 0.05;
//constexpr double color_slope_c = 0.055;
//constexpr double color_slope_c = 0.075;
//constexpr double color_slope_c = 0.08;
//constexpr double color_slope_c = 0.09;
//constexpr double color_slope_c = 0.095;
//constexpr double color_slope_c = 0.10;
constexpr double color_slope_c = 0.11; // * last setting as of 4/26/23
//constexpr double color_slope_c = 0.115;
//constexpr double color_slope_c = 0.125;
//constexpr double color_slope_c = 0.13;
//constexpr double color_slope_c = 0.135;
//constexpr double color_slope_c = 0.145;
//constexpr double color_slope_c = 0.15;
//constexpr double color_slope_c = 0.16;
//constexpr double color_slope_c = 0.17;
//constexpr double color_slope_c = 0.175;
//constexpr double color_slope_c = 0.18;
//constexpr double color_slope_c = 0.20;
//constexpr double color_slope_c = 0.30;
//constexpr double color_slope_c = 0.40; // for check against SHP
//constexpr double color_slope_c = 0.425; // for check against SHP

//constexpr double color_crowding_probability_c = 0.0;
//constexpr double color_crowding_probability_c = 0.01;
//constexpr double color_crowding_probability_c = 0.015; // * last setting as of 4/26/23
constexpr double color_crowding_probability_c = 0.025;
//constexpr double color_crowding_probability_c = 0.05;
//constexpr double color_crowding_probability_c = 0.075;
//constexpr double color_crowding_probability_c = 0.08;
//constexpr double color_crowding_probability_c = 0.10;
//constexpr double color_crowding_probability_c = 0.125;
//constexpr double color_crowding_probability_c = 0.15;
//constexpr double color_crowding_probability_c = 0.175;
//constexpr double color_crowding_probability_c = 0.2;
//constexpr double color_crowding_probability_c = 0.25;
//constexpr double color_crowding_probability_c = 0.30;
//constexpr double color_crowding_probability_c = 0.40;
//constexpr double color_crowding_probability_c = 0.50;
//constexpr double color_crowding_probability_c = 0.625;
//constexpr double color_crowding_probability_c = 0.75;
//constexpr double color_crowding_probability_c = 0.8;
//constexpr double color_crowding_probability_c = 1.0;

//constexpr double orientation_slope_c = 0.0;
//constexpr double orientation_slope_c = 0.025;
//constexpr double orientation_slope_c = 0.05;
//constexpr double orientation_slope_c = 0.075;
//constexpr double orientation_slope_c = 0.10;
//constexpr double orientation_slope_c = 0.11;
//constexpr double orientation_slope_c = 0.15;
//constexpr double orientation_slope_c = 0.17;
// constexpr double orientation_slope_c = 0.18; // * last setting as of 4/26/23
//constexpr double orientation_slope_c = 0.19;
constexpr double orientation_slope_c = 0.20;
//constexpr double orientation_slope_c = 0.225;
//constexpr double orientation_slope_c = 0.25;
//constexpr double orientation_slope_c = 0.275;
//constexpr double orientation_slope_c = 0.30;
//constexpr double orientation_slope_c = 0.315;
//constexpr double orientation_slope_c = 0.325;
//constexpr double orientation_slope_c = 0.35;
//constexpr double orientation_slope_c = 0.375;
//constexpr double orientation_slope_c = 0.4;
//constexpr double orientation_slope_c = 0.425;

//constexpr double orientation_crowding_probability_c = .0;
//constexpr double orientation_crowding_probability_c = .005;
//constexpr double orientation_crowding_probability_c = .01;
//constexpr double orientation_crowding_probability_c = .015;
constexpr double orientation_crowding_probability_c = .025; // * last setting as of 4/26/23
//constexpr double orientation_crowding_probability_c = .05;
//constexpr double orientation_crowding_probability_c = .075;
//constexpr double orientation_crowding_probability_c = .08;
//constexpr double orientation_crowding_probability_c = .10;
//constexpr double orientation_crowding_probability_c = .15;
//constexpr double orientation_crowding_probability_c = .20;
//constexpr double orientation_crowding_probability_c = .25;
//constexpr double orientation_crowding_probability_c = .30;
//constexpr double orientation_crowding_probability_c = .4;
//constexpr double orientation_crowding_probability_c = .45;
//constexpr double orientation_crowding_probability_c = .5;
//constexpr double orientation_crowding_probability_c = 1.0;

// constexpr double shape_slope_c = 0.0; // * last setting as of 4/26/23
//constexpr double shape_slope_c = 0.01;
//constexpr double shape_slope_c = 0.05;
//constexpr double shape_slope_c = 0.1;
//constexpr double shape_slope_c = 0.15;
//constexpr double shape_slope_c = 0.20;
//constexpr double shape_slope_c = 0.30;
//constexpr double shape_slope_c = 0.315;
//constexpr double shape_slope_c = 0.325;
//constexpr double shape_slope_c = 0.35;
//constexpr double shape_slope_c = 0.375;
//constexpr double shape_slope_c = 0.40;
//constexpr double shape_slope_c = 0.4125;
//constexpr double shape_slope_c = 0.42;
constexpr double shape_slope_c = 0.425;
//constexpr double shape_slope_c = 0.435;
//constexpr double shape_slope_c = 0.45;
//constexpr double shape_slope_c = 0.50;
//constexpr double shape_slope_c = 0.525;
//constexpr double shape_slope_c = 0.535;
//constexpr double shape_slope_c = 0.545;
//constexpr double shape_slope_c = 0.55;
//constexpr double shape_slope_c = 0.60;
//constexpr double shape_slope_c = 0.70;
//constexpr double shape_slope_c = 0.80;


constexpr double shape_crowding_slope_c = 0.0; // used in VM5+
//constexpr double shape_crowding_slope_c = 1.; // used in VM5+

// constexpr double shape_crowding_probability_c = 0.0;  // * last setting as of 4/26/23
//constexpr double shape_crowding_probability_c = 0.005;
//constexpr double shape_crowding_probability_c = 0.01;
//constexpr double shape_crowding_probability_c = 0.02;
//constexpr double shape_crowding_probability_c = 0.025;
//constexpr double shape_crowding_probability_c = 0.05;
constexpr double shape_crowding_probability_c = 0.075;
//constexpr double shape_crowding_probability_c = 0.1;
//constexpr double shape_crowding_probability_c = 0.125;
//constexpr double shape_crowding_probability_c = 0.135;
//constexpr double shape_crowding_probability_c = 0.15;
//constexpr double shape_crowding_probability_c = 0.18;
//constexpr double shape_crowding_probability_c = 0.20;
//constexpr double shape_crowding_probability_c = 0.25;
//constexpr double shape_crowding_probability_c = 0.4;
//constexpr double shape_crowding_probability_c = 0.5;
//constexpr double shape_crowding_probability_c = 0.8;
//constexpr double shape_crowding_probability_c = 1.0;

//constexpr double visual_delay_time_c = 24.; // original value
//constexpr double visual_delay_time_c = 25.;
//constexpr double visual_delay_time_c = 50.;
constexpr double visual_delay_time_c = 100;
//constexpr double visual_delay_time_c = 200;

// error rate parameters
//constexpr double negative_baseline_error_rate_c = .00;
//constexpr double negative_baseline_error_rate_c = .001;
//constexpr double negative_baseline_error_rate_c = .0015;
//constexpr double negative_baseline_error_rate_c = .004;
//constexpr double negative_baseline_error_rate_c = .0045;    // COC 1279
//constexpr double negative_baseline_error_rate_c = .005;
//constexpr double negative_baseline_error_rate_c = .006;
//constexpr double negative_baseline_error_rate_c = .007;
//constexpr double negative_baseline_error_rate_c = .009;
//constexpr double negative_baseline_error_rate_c = .01;
constexpr double negative_baseline_error_rate_c = .014; // average of allsubs negative
//constexpr double negative_baseline_error_rate_c = .02;  // CSF_1279
//constexpr double negative_baseline_error_rate_c = .021;  // CSF_1279 corrected 4/27/23
//constexpr double negative_baseline_error_rate_c = .023;
//constexpr double negative_baseline_error_rate_c = .029;  // COC_58
//constexpr double negative_baseline_error_rate_c = .03; // COC 458 * last setting as of 4/26/23
// constexpr double negative_baseline_error_rate_c = .032; // COC 458 * last setting as of 4/27/23

constexpr double positive_baseline_error_rate_c = negative_baseline_error_rate_c;
//constexpr double positive_baseline_error_rate_c = .005;
//constexpr double positive_baseline_error_rate_c = .006;
//constexpr double positive_baseline_error_rate_c = .007;
//constexpr double positive_baseline_error_rate_c = .01;
//constexpr double positive_baseline_error_rate_c = .011; // Avg ER+ for COC_1279 ss3,6
//constexpr double positive_baseline_error_rate_c = .014; // average of allsubs negative
//constexpr double positive_baseline_error_rate_c = .02;
//constexpr double positive_baseline_error_rate_c = .03;
//constexpr double positive_baseline_error_rate_c = .04;
//constexpr double positive_baseline_error_rate_c = .05;



// Strategy controls

// 5a: max_n_fixations_c = 99; confirm_positive_c = true; confirm_negative_c = true;
// almost 6b: max_n_fixations_c = comnfix; confirm_positive_c = true; confirm_negative_c = true;
// 7: max_n_fixations_c = 0; confirm_positive_c, confirm_negative_c, ignored but set to false;


//constexpr int max_n_fixations_c = 99; // effectively unlimited fixations // * last setting as of 4/26/23
//constexpr int max_n_fixations_c = 12;
//constexpr int max_n_fixations_c = 11;
//constexpr int max_n_fixations_c = 10;
//constexpr int max_n_fixations_c = 9;
//constexpr int max_n_fixations_c = 8;
//constexpr int max_n_fixations_c = 7;
//constexpr int max_n_fixations_c = 6;
//constexpr int max_n_fixations_c = 5;
//constexpr int max_n_fixations_c = 4;
//constexpr int max_n_fixations_c = 3;
//constexpr int max_n_fixations_c = 2;
//constexpr int max_n_fixations_c = 1;
constexpr int max_n_fixations_c = 0; // eyes kept on fixation point

// Probability that actual max number of fixations will be max_n_fixations_c+1
constexpr double max_n_fixations_mixture_probability_c = 0.0; // * last setting as of 4/26/23
//constexpr double max_n_fixations_mixture_probability_c = 0.25;
//constexpr double max_n_fixations_mixture_probability_c = 0.5;
//constexpr double max_n_fixations_mixture_probability_c = 0.75;
//constexpr double max_n_fixations_mixture_probability_c = 0.90;
//constexpr double max_n_fixations_mixture_probability_c = 0.95;

// calculate the average max_n_fixations value based on the _g value and the mixture probability
// assuming the mixture probability is for incrementing the base value by +1
double calculate_average_max_n_fixations();

constexpr bool confirm_positive_c = false;   // make confirmation eye move before positive response
constexpr bool confirm_negative_c = false;   // make confirmation eye move before negative response

constexpr double close_enough_to_bypass_confirm_positive_c = fovea_radius_c;  // default Strategy 8, 9 used this // * last setting as of 4/26/23
//constexpr double close_enough_to_bypass_confirm_positive_c = 2.0;
//constexpr double close_enough_to_bypass_confirm_positive_c = 3.0;
//constexpr double close_enough_to_bypass_confirm_positive_c = 0;  // almost never skip

constexpr int enough_fixations_to_bypass_confirm_negative_c = 1;   // default strategy 8. 9 used this // * last setting as of 4/26/23
//constexpr int enough_fixations_to_bypass_confirm_negative_c = 2;
//constexpr int enough_fixations_to_bypass_confirm_negative_c = 3;
//constexpr int enough_fixations_to_bypass_confirm_negative_c = 99; // never skip

constexpr int too_many_illusory_targets_c = 99; // use value of 99 to effectively turn off this check // * last setting as of 4/26/23
//constexpr int too_many_illusory_targets_c = 2;
//constexpr int too_many_illusory_targets_c = 3;
// constexpr int too_many_illusory_targets_c = 4;
//constexpr int too_many_illusory_targets_c = 5;

// all of below * last setting as of 4/26/23
// visual model mode parameters
// The following specifies policy for allowing properties from crowding objects to overwrite
// properties of an object that are in perceptual store state
enum class Perceptual_store_scramble_policy_e {NO_OVERWRITES, NON_BLANK_OVERWRITES, ALL_OVERWRITES};
constexpr auto perceptual_store_scramble_policy = Perceptual_store_scramble_policy_e::NON_BLANK_OVERWRITES;
constexpr bool apply_crowding_effect = true;
constexpr bool unitary_shape_c = true;
constexpr bool saccade_noise_present_c = true;

// below are initialized to false, and enabled by Strategy if it needs them
extern bool compute_Shape_information_gain_g;
extern bool compute_Feature_information_gain_g; // both Color and Orientation

// Observed data file
constexpr const char* const infile_name_c = "ObsData_AllSubjects.txt";
//constexpr const char* const infile_name_c = "OBsData_All_3610_37.txt";
//constexpr const char* const infile_name_c = "ObsData_48_310_129.txt";
//constexpr const char* const infile_name_c = "ObsData_356_1279_37.txt";
// constexpr const char* const infile_name_c = "ObsData_1279_458_458.txt";
//constexpr const char* const infile_name_c = "ObsData_1279_58_458.txt";


// Experiment control

constexpr auto conditions = {Condition_e::CSF, Condition_e::COC, Condition_e::SHP};
//constexpr auto conditions = {Condition_e::CSF, Condition_e::COC};
//constexpr auto conditions = {Condition_e::CSF};
//constexpr auto conditions = {Condition_e::COC};
//constexpr auto conditions = {Condition_e::SHP};

constexpr auto polarities = {Polarity_e::NEGATIVE, Polarity_e::POSITIVE};
//constexpr auto polarities = {Polarity_e::NEGATIVE};
//constexpr auto polarities = {Polarity_e::POSITIVE};

constexpr auto set_sizes = {3,6,12,18};
//constexpr auto set_sizes = {6};
//constexpr auto set_sizes = {12};
//constexpr auto set_sizes = {18};


// Simulation and Statistics
constexpr Run_mode_e run_mode_c = {Run_mode_e::EXPERIMENT};
//constexpr Run_mode_e run_mode_c = {Run_mode_e::GRID_SEARCH};
//constexpr bool run_experiment_c = false; // true for run experiment, false for do grid search
// number of trials/condition/polarity/setsize to run
//constexpr int n_trials_c = 3;
//constexpr int n_trials_c = 5;
//constexpr int n_trials_c = 10;
//constexpr int n_trials_c = 50;
//constexpr int n_trials_c = 100;
//constexpr int n_trials_c = 1000;
//constexpr int n_trials_c = 100000;
//constexpr int n_trials_c = 500000;
constexpr int n_trials_c = 1000000;

// weight of RT in calculating weighted average FoM for RT and ER [0, 1]
constexpr double RT_FoM_weight_c = 4./5.; // give equal weight for RT FoM ~ 5 and ER FoM ~20


// Additional visual model mode parameters
// SHP representation
// change below together
//constexpr int n_shape_parts_c = 7; // 7-segments
constexpr int n_shape_parts_c = 2;
using Shape_parts_t = std::array<char, n_shape_parts_c>;
//const std::array<int, n_shape_parts_c> part_indices_c{0,1,2,3,4,5,6}; // 7-segments
const std::array<int, n_shape_parts_c> part_indices_c{0,1};
// instead of having a separate variable, shape_slope_g is used when non-unitary shape parts are being detected
//const GU::Size shape_part_size_c = GU::Size(2.1, 0.3); // seven-segment size
const GU::Size shape_part_size_c = GU::Size(1.5, 1.35); // for 2-part shape: half of total shape height, same width




// debugging output
constexpr bool processed_visual_trace_output = false;
constexpr bool detailed_visual_trace_output = false;
constexpr bool crowding_visual_trace_output = false;
constexpr bool target_status_trace_output = false;
constexpr bool strategy_trace_output = false;
constexpr bool compute_and_output_display_statistics = false;

// time parameters
//constexpr double visual_encoding_time_c = 50.; // ms - not currently used - see visual_delay_time
//constexpr double same_key_motor_response_time_c = 50. + 25.;
//constexpr double different_key_motor_response_time_c = 100. + 50. + 25.;
// average of these to permit blocked trials
constexpr double same_key_motor_response_time_c = 50. + 50. + 25.;
constexpr double different_key_motor_response_time_c = 50. + 50. + 25.;
constexpr double em_time_intercept_c = 21.;
constexpr double em_time_slope_c = 2.2; // ms/dva
constexpr int rule_execution_time_c = 50; // ms/cycle


#endif


