--
-- Schema classicmodels with initial data.
--
-- The original file was downloaded from Eclipse BIRT project site: 
-- http://www.eclipse.org/birt/phoenix/db/#mysql
-- ------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


-- This script has been modified to be executed in a H2 database.
-- The original script was designed for MySQL DB. Uncomment this lines and 
-- comment next SET lines to execute this script in a MySQL database
-- CREATE DATABASE IF NOT EXISTS classicmodels;
-- USE classicmodels;
create schema IF NOT EXISTS classicmodels; -- Uncomment this also to execute in MySQL
SET MODE MySQL;
SET IGNORECASE TRUE;


DROP TABLE IF EXISTS `classicmodels`.`Customer`;
CREATE TABLE  `classicmodels`.`Customer` (
  `customerNumber` int(11) NOT NULL,
  `customerName` varchar(50) NOT NULL,
  `contactLastName` varchar(50) NOT NULL,
  `contactFirstName` varchar(50) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `addressLine1` varchar(50) NOT NULL,
  `addressLine2` varchar(50) DEFAULT NULL,
  `city` varchar(50) NOT NULL,
  `state` varchar(50) DEFAULT NULL,
  `postalCode` varchar(15) DEFAULT NULL,
  `country` varchar(50) NOT NULL,
  `salesRepEmployeeNumber` int(11) DEFAULT NULL,
  `creditLimit` double DEFAULT NULL,
  PRIMARY KEY (`customerNumber`)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `classicmodels`.`Customer` (`customerNumber`,`customerName`,`contactLastName`,`contactFirstName`,`phone`,`addressLine1`,`addressLine2`,`city`,`state`,`postalCode`,`country`,`salesRepEmployeeNumber`,`creditLimit`) VALUES 
 (103,'Atelier graphique','Schmitt','Carine ','40.32.2555','54, rue Royale',NULL,'Nantes',NULL,'44000','France',1370,21000),
 (112,'Signal Gift Stores','King','Sue','7025551838','8489 Strong St.',NULL,'Las Vegas','NV','83030','USA',1166,71800),
 (114,'Australian Collectors, Co.','Ferguson','Peter','03 9520 4555','636 St Kilda Road','Level 3','Melbourne','Victoria','3004','Australia',1611,117300),
 (119,'La Rochelle Gifts','Labrune','Janine ','40.67.8555','67, rue des Cinquante Otages',NULL,'Nantes',NULL,'44000','France',1370,118200),
 (121,'Baane Mini Imports','Bergulfsen','Jonas ','07-98 9555','Erling Skakkes gate 78',NULL,'Stavern',NULL,'4110','Norway',1504,81700),
 (124,'Mini Gifts Distributors Ltd.','Nelson','Valarie','4155551450','5677 Strong St.',NULL,'San Rafael','CA','97562','USA',1165,210500),
 (125,'Havel & Zbyszek Co','Piestrzeniewicz','Zbyszek ','(26) 642-7555','ul. Filtrowa 68',NULL,'Warszawa',NULL,'01-012','Poland',NULL,0),
 (128,'Blauer See Auto, Co.','Keitel','Roland','+49 69 66 90 2555','Lyonerstr. 34',NULL,'Frankfurt',NULL,'60528','Germany',1504,59700),
 (129,'Mini Wheels Co.','Murphy','Julie','6505555787','5557 North Pendale Street',NULL,'San Francisco','CA','94217','USA',1165,64600),
 (131,'Land of Toys Inc.','Yu','Kwai','2125557818','897 Long Airport Avenue',NULL,'NYC','NY','10022','USA',1323,114900),
 (141,'Euro+ Shopping Channel','Freyre','Diego ','(91) 555 94 44','C/ Moralzarzal, 86',NULL,'Madrid',NULL,'28034','Spain',1370,227600),
 (144,'Volvo Model Replicas, Co','Berglund','Christina ','0921-12 3555','Berguvsvägen  8',NULL,'Luleå',NULL,'S-958 22','Sweden',1504,53100),
 (145,'Danish Wholesale Imports','Petersen','Jytte ','31 12 3555','Vinbæltet 34',NULL,'Kobenhavn',NULL,'1734','Denmark',1401,83400),
 (146,'Saveley & Henriot, Co.','Saveley','Mary ','78.32.5555','2, rue du Commerce',NULL,'Lyon',NULL,'69004','France',1337,123900),
 (148,'Dragon Souveniers, Ltd.','Natividad','Eric','+65 221 7555','Bronz Sok., Bronz Apt. 3/6 Tesvikiye',NULL,'Singapore',NULL,'079903','Singapore',1621,103800),
 (151,'Muscle Machine Inc','Young','Jeff','2125557413','4092 Furth Circle','Suite 400','NYC','NY','10022','USA',1286,138500),
 (157,'Diecast Classics Inc.','Yu','Kyung','2155551555','7586 Pompton St.',NULL,'Allentown','PA','70267','USA',1216,100600),
 (161,'Technics Stores Inc.','Hirano','Juri','6505556809','9408 Furth Circle',NULL,'Burlingame','CA','94217','USA',1165,84600),
 (166,'Handji Gifts& Co','Victorino','Wendy','+65 224 1555','Village Close - 106 Linden Road Sandown','2nd Floor','Singapore',NULL,'069045','Singapore',1612,97900),
 (167,'Herkku Gifts','Oeztan','Veysel','+47 2267 3215','Drammen 121, PR 744 Sentrum',NULL,'Bergen',NULL,'N 5804','Norway  ',1504,96800),
 (168,'American Souvenirs Inc','Franco','Sue','2035557845','149 Spinnaker Dr.','Suite 101','New Haven','CT','97823','USA',1286,0),
 (169,'Porto Imports Co.','de Castro','Isabel ','(1) 356-5555','Estrada da saúde n. 58',NULL,'Lisboa',NULL,'1756','Portugal',NULL,0),
 (171,'Daedalus Designs Imports','Rancé','Martine ','20.16.1555','184, chaussée de Tournai',NULL,'Lille',NULL,'59000','France',1370,82900),
 (172,'La Corne Dabondance, Co.','Bertrand','Marie','(1) 42.34.2555','265, boulevard Charonne',NULL,'Paris',NULL,'75012','France',1337,84300),
 (173,'Cambridge Collectables Co.','Tseng','Kyung','6175555555','4658 Baden Av.',NULL,'Cambridge','MA','51247','USA',1188,43400),
 (175,'Gift Depot Inc.','King','Julie','2035552570','25593 South Bay Ln.',NULL,'Bridgewater','CT','97562','USA',1323,84300),
 (177,'Osaka Souveniers Co.','Kentary','Mory','+81 06 6342 5555','Dojima Avanza 4F, 1-6-20 Dojima, Kita-ku',NULL,'Osaka','Osaka',' 530-0003','Japan',1621,81200),
 (181,'Vitachrome Inc.','Frick','Michael','2125551500','2678 Kingston Rd.','Suite 101','NYC','NY','10022','USA',1286,76400),
 (186,'Toys of Finland, Co.','Karttunen','Matti','90-224 8555','Keskuskatu 45',NULL,'Helsinki',NULL,'21240','Finland',1501,96500),
 (187,'AV Stores, Co.','Ashworth','Victoria','(171) 555-1555','Fauntleroy Circus',NULL,'Manchester',NULL,'EC2 5NT','UK',1501,136800),
 (189,'Clover Collections, Co.','Cassidy','Dean','+353 1862 1555','25 Maiden Lane','Floor No. 4','Dublin',NULL,'2','Ireland',1504,69400),
 (198,'Auto-Moto Classics Inc.','Taylor','Leslie','6175558428','16780 Pompton St.',NULL,'Brickhaven','MA','58339','USA',1216,23000),
 (201,'UK Collectables, Ltd.','Devon','Elizabeth','(171) 555-2282','Berkeley Gardens 12  Brewery',NULL,'Liverpool',NULL,'WX1 6LT','UK',1501,92700),
 (202,'Canadian Gift Exchange Network','Tannamuri','Yoshi ','(604) 555-3392','1900 Oak St.',NULL,'Vancouver','BC','V3F 2K1','Canada',1323,90300),
 (204,'Online Mini Collectables','Barajas','Miguel','6175557555','7635 Spinnaker Dr.',NULL,'Brickhaven','MA','58339','USA',1188,68700),
 (205,'Toys4GrownUps.com','Young','Julie','6265557265','78934 Hillside Dr.',NULL,'Pasadena','CA','90003','USA',1166,90700),
 (206,'Asian Shopping Network, Co','Walker','Brydey','+612 9411 1555','Penthouse Level, Suntec Tower Three, 8 Temasek',NULL,'Singapore',NULL,'038988','Singapore',NULL,0),
 (209,'Mini Caravy','Citeaux','Frédérique ','88.60.1555','24, place Kléber',NULL,'Strasbourg',NULL,'67000','France',1370,53800),
 (211,'King Kong Collectables, Co.','Sunwoo','Michael','+852 2251 1555','Bank of China Tower, 1 Garden Road','Level 25','Central Hong Kong',NULL,'','Hong Kong',1621,58600),
 (216,'Enaco Distributors','Saavedra','Eduardo ','(93) 203 4555','Rambla de Cataluña, 23',NULL,'Barcelona',NULL,'08022','Spain',1702,60300),
 (219,'Boards & Toys Co.','Young','Leslie','3105552373','4097 Douglas Av.',NULL,'Glendale','CA','92561','USA',1166,11000),
 (223,'Natürlich Autos','Kloss','Horst ','0372-555188','Taucherstraße 10',NULL,'Cunewalde',NULL,'01307','Germany',NULL,0),
 (227,'Heintze Collectables','Ibsen','Palle','86 21 3555','Smagsloget 45',NULL,'Århus',NULL,'8200','Denmark',1401,120800),
 (233,'Québec Home Shopping Network','Fresnière','Jean ','(514) 555-8054','43 rue St. Laurent',NULL,'Montréal','Québec','H1J 1C3','Canada',1286,48700),
 (237,'ANG Resellers','Camino','Alejandra ','(91) 745 6555','Gran Vía, 1',NULL,'Madrid',NULL,'28001','Spain',NULL,0),
 (239,'Collectable Mini Designs Co.','Thompson','Valarie','7605558146','361 Furth Circle',NULL,'San Diego','CA','91217','USA',1166,105000),
 (240,'giftsbymail.co.uk','Bennett','Helen ','(198) 555-8888','Garden House Crowther Way',NULL,'Cowes','Isle of Wight','PO31 7PJ','UK',1501,93900),
 (242,'Alpha Cognac','Roulet','Annette ','61.77.6555','1 rue Alsace-Lorraine',NULL,'Toulouse',NULL,'31000','France',1370,61100),
 (247,'Messner Shopping Network','Messner','Renate ','069-0555984','Magazinweg 7',NULL,'Frankfurt',NULL,'60528','Germany',NULL,0),
 (249,'Amica Models & Co.','Accorti','Paolo ','011-4988555','Via Monte Bianco 34',NULL,'Torino',NULL,'10100','Italy',1401,113000),
 (250,'Lyon Souveniers','Da Cunha','Daniel','+33 1 46 62 7555','27 rue du Colonel Pierre Avia',NULL,'Paris',NULL,'75508','France',1337,68100),
 (256,'Auto Associés & Cie.','Tonini','Daniel ','30.59.8555','67, avenue de lEurope',NULL,'Versailles',NULL,'78000','France',1370,77900),
 (259,'Toms Spezialitäten, Ltd','Pfalzheim','Henriette ','0221-5554327','Mehrheimerstr. 369',NULL,'Köln',NULL,'50739','Germany',1504,120400),
 (260,'Royal Canadian Collectables, Ltd.','Lincoln','Elizabeth ','(604) 555-4555','23 Tsawassen Blvd.',NULL,'Tsawassen','BC','T2F 8M4','Canada',1323,89600),
 (273,'Franken Gifts, Co','Franken','Peter ','089-0877555','Berliner Platz 43',NULL,'München',NULL,'80805','Germany',NULL,0),
 (276,'Annas Decorations, Ltd','OHara','Anna','02 9936 8555','201 Miller Street','Level 15','North Sydney','NSW','2060','Australia',1611,107800),
 (278,'Rovelli Gifts','Rovelli','Giovanni ','035-640555','Via Ludovico il Moro 22',NULL,'Bergamo',NULL,'24100','Italy',1401,119600),
 (282,'Souveniers And Things Co.','Huxley','Adrian','+61 2 9495 8555','Monitor Money Building, 815 Pacific Hwy','Level 6','Chatswood','NSW','2067','Australia',1611,93300),
 (286,'Martas Replicas Co.','Hernandez','Marta','6175558555','39323 Spinnaker Dr.',NULL,'Cambridge','MA','51247','USA',1216,123700),
 (293,'BG&E Collectables','Pon','Ed','+41 26 425 50 01','Rte des Arsenaux 41 ',NULL,'Fribourg',NULL,'1700','Switzerland',NULL,0),
 (298,'Vida Sport, Ltd','Holz','Michael ','0897-034555','Grenzacherweg 237',NULL,'Genève',NULL,'1203','Switzerland',1702,141300),
 (299,'Norway Gifts By Mail, Co.','Klaeboe','Jan','+47 2212 1555','Drammensveien 126 A, PB 744 Sentrum',NULL,'Oslo',NULL,'N 0106','Norway  ',1504,95100),
 (303,'Schuyler Imports','Schuyler','Bradley','+31 20 491 9555','Kingsfordweg 151',NULL,'Amsterdam',NULL,'1043 GR','Netherlands',NULL,0),
 (307,'Der Hund Imports','Anders','Maria ','030-0074555','Obere Str. 57',NULL,'Berlin',NULL,'12209','Germany',NULL,0),
 (311,'Oulu Toy Supplies, Inc.','Koskitalo','Pirkko','981-443655','Torikatu 38',NULL,'Oulu',NULL,'90110','Finland',1501,90500),
 (314,'Petit Auto','Dewey','Catherine ','(02) 5554 67','Rue Joseph-Bens 532',NULL,'Bruxelles',NULL,'B-1180','Belgium',1401,79900),
 (319,'Mini Classics','Frick','Steve','9145554562','3758 North Pendale Street',NULL,'White Plains','NY','24067','USA',1323,102700),
 (320,'Mini Creations Ltd.','Tam','Wing C','5085559555','4575 Hillside Dr.',NULL,'New Bedford','MA','50553','USA',1188,94500),
 (321,'Corporate Gift Ideas Co.','Brown','Julie','6505551386','7734 Strong St.',NULL,'San Francisco','CA','94217','USA',1165,105000),
 (323,'Down Under Souveniers, Inc','Graham','Mike','+64 9 312 5555','162-164 Grafton Road','Level 2','Auckland  ',NULL,'','New Zealand',1612,88000),
 (324,'Stylish Desk Decors, Co.','Brown','Ann ','(171) 555-0297','35 King George',NULL,'London',NULL,'WX3 6FW','UK',1501,77000),
 (328,'Tekni Collectables Inc.','Brown','William','2015559350','7476 Moss Rd.',NULL,'Newark','NJ','94019','USA',1323,44100),
 (333,'Australian Gift Network, Co','Calaghan','Tony','61-7-3844-6555','31 Duncan St. West End',NULL,'South Brisbane','Queensland','4101','Australia',1611,51600),
 (334,'Suominen Souveniers','Suominen','Kalle','+358 9 8045 555','Software Engineering Center, SEC Oy',NULL,'Espoo',NULL,'FIN-02271','Finland',1501,98800),
 (335,'Cramer Spezialitäten, Ltd','Cramer','Philip ','0555-09555','Maubelstr. 90',NULL,'Brandenburg',NULL,'14776','Germany',NULL,0),
 (339,'Classic Gift Ideas, Inc','Cervantes','Francisca','2155554695','782 First Street',NULL,'Philadelphia','PA','71270','USA',1188,81100),
 (344,'CAF Imports','Fernandez','Jesus','+34 913 728 555','Merchants House, 27-30 Merchants Quay',NULL,'Madrid',NULL,'28023','Spain',1702,59600),
 (347,'Men R US Retailers, Ltd.','Chandler','Michael','2155554369','6047 Douglas Av.',NULL,'Los Angeles','CA','91003','USA',1166,57700),
 (348,'Asian Treasures, Inc.','McKenna','Patricia ','2967 555','8 Johnstown Road',NULL,'Cork','Co. Cork',NULL,'Ireland',NULL,0),
 (350,'Marseille Mini Autos','Lebihan','Laurence ','91.24.4555','12, rue des Bouchers',NULL,'Marseille',NULL,'13008','France',1337,65000),
 (353,'Reims Collectables','Henriot','Paul ','26.47.1555','59 rue de lAbbaye',NULL,'Reims',NULL,'51100','France',1337,81100),
 (356,'SAR Distributors, Co','Kuger','Armand','+27 21 550 3555','Century City-Montague Gardens PO Box 37177',NULL,'Chempet',NULL,' 7442','South Africa',NULL,0),
 (357,'GiftsForHim.com','MacKinlay','Wales','64-9-3763555','199 Great North Road',NULL,'Auckland',NULL,'','New Zealand',1612,77700),
 (361,'Kommission Auto','Josephs','Karin','0251-555259','Luisenstr. 48',NULL,'Münster',NULL,'44087','Germany',NULL,0),
 (362,'Gifts4AllAges.com','Yoshido','Juri','6175559555','8616 Spinnaker Dr.',NULL,'Boston','MA','51003','USA',1216,41900),
 (363,'Online Diecast Creations Co.','Young','Valarie','6035558647','2304 Long Airport Avenue',NULL,'Nashua','NH','62005','USA',1216,114200),
 (369,'Lisboa Souveniers, Inc','Rodriguez','Lino ','(1) 354-2555','Jardim das rosas n. 32',NULL,'Lisboa',NULL,'1675','Portugal',NULL,0),
 (376,'Precious Collectables','Wang','Yang ','0452-076555','Hauptstr. 29',NULL,'Bern',NULL,'3012','Switzerland',1702,0),
 (379,'Collectables For Less Inc.','Nelson','Allen','6175558555','7825 Douglas Av.',NULL,'Brickhaven','MA','58339','USA',1188,70700),
 (381,'Royale Belge','Cartrain','Pascale ','(071) 23 67 2555','Boulevard Tirou, 255',NULL,'Charleroi',NULL,'B-6000','Belgium',1401,23500),
 (382,'Salzburg Collectables','Pipps','Georg ','6562-9555','Geislweg 14',NULL,'Salzburg',NULL,'5020','Austria',1401,71700),
 (385,'Cruz & Sons Co.','Cruz','Arnold','+63 2 555 3587','15 McCallum Street - NatWest Center #13-03',NULL,'Makati City',NULL,'1227 MM','Philippines',1621,81500),
 (386,'Lordine Souveniers','Moroni','Maurizio ','0522-556555','Strada Provinciale 124',NULL,'Reggio Emilia',NULL,'42100','Italy',1401,121400),
 (398,'Tokyo Collectables, Ltd','Shimamura','Akiko','+81 3 3584 0555','2-2-8 Roppongi',NULL,'Minato-ku','Tokyo','106-0032','Japan',1621,94400),
 (406,'Auto Canal+ Petit','Perrier','Dominique','(1) 47.55.6555','25, rue Lauriston',NULL,'Paris',NULL,'75016','France',1337,95000),
 (409,'Stuttgart Collectable Exchange','Müller','Rita ','0711-555361','Adenauerallee 900',NULL,'Stuttgart',NULL,'70563','Germany',NULL,0),
 (412,'Extreme Desk Decorations, Ltd','McRoy','Sarah','04 499 9555','101 Lambton Quay','Level 11','Wellington',NULL,'','New Zealand',1612,86800),
 (415,'Bavarian Collectables Imports, Co.','Donnermeyer','Michael',' +49 89 61 08 9555','Hansastr. 15',NULL,'Munich',NULL,'80686','Germany',1504,77000),
 (424,'Classic Legends Inc.','Hernandez','Maria','2125558493','5905 Pompton St.','Suite 750','NYC','NY','10022','USA',1286,67500),
 (443,'Feuer Online Stores, Inc','Feuer','Alexander ','0342-555176','Heerstr. 22',NULL,'Leipzig',NULL,'04179','Germany',NULL,0),
 (447,'Gift Ideas Corp.','Lewis','Dan','2035554407','2440 Pompton St.',NULL,'Glendale','CT','97561','USA',1323,49700),
 (448,'Scandinavian Gift Ideas','Larsson','Maria ','0695-34 6555','Åkergatan 24',NULL,'Bräcke',NULL,'S-844 67','Sweden',1504,116400),
 (450,'The Sharp Gifts Warehouse','Frick','Sue','4085553659','3086 Ingle Ln.',NULL,'San Jose','CA','94217','USA',1165,77600),
 (452,'Mini Auto Werke','Mendel','Roland ','7675-3555','Kirchgasse 6',NULL,'Graz',NULL,'8010','Austria',1401,45300),
 (455,'Super Scale Inc.','Murphy','Leslie','2035559545','567 North Pendale Street',NULL,'New Haven','CT','97823','USA',1286,95400),
 (456,'Microscale Inc.','Kuo','Kee','2125551957','5290 North Pendale Street','Suite 200','NYC','NY','10022','USA',1286,39800),
 (458,'Corrida Auto Replicas, Ltd','Sommer','Martín ','(91) 555 22 82','C/ Araquil, 67',NULL,'Madrid',NULL,'28023','Spain',1702,104600),
 (459,'Warburg Exchange','Ottlieb','Sven ','0241-039123','Walserweg 21',NULL,'Aachen',NULL,'52066','Germany',NULL,0),
 (462,'FunGiftIdeas.com','Benitez','Violeta','5085552555','1785 First Street',NULL,'New Bedford','MA','50553','USA',1216,85800),
 (465,'Anton Designs, Ltd.','Anton','Carmen','+34 913 728555','c/ Gobelas, 19-1 Urb. La Florida',NULL,'Madrid',NULL,'28023','Spain',NULL,0),
 (471,'Australian Collectables, Ltd','Connery','Sean','61-9-3844-6555','7 Allen Street',NULL,'Glen Waverly','Victoria','3150','Australia',1611,60300),
 (473,'Frau da Collezione','Ricotti','Franco','+39 022515555','20093 Cologno Monzese, via Alessandro Volta 16',NULL,'Milan',NULL,'','Italy',1401,34800),
 (475,'West Coast Collectables Co.','Thompson','Steve','3105553722','3675 Furth Circle',NULL,'Burbank','CA','94019','USA',1166,55400),
 (477,'Mit Vergnügen & Co.','Moos','Hanna ','0621-08555','Forsterstr. 57',NULL,'Mannheim',NULL,'68306','Germany',NULL,0),
 (480,'Kremlin Collectables, Co.','Semenov','Alexander ','+7 812 293 0521','2 Pobedy Square',NULL,'Saint Petersburg',NULL,'196143','Russia',NULL,0),
 (481,'Raanan Stores, Inc','Altagar,G M','Raanan','+ 972 9 959 8555','3 Hagalim Blv.,',NULL,'Herzlia',NULL,'47625','Israel',NULL,0),
 (484,'Iberia Gift Imports, Corp.','Roel','José Pedro ','(95) 555 82 82','C/ Romero, 33',NULL,'Sevilla',NULL,'41101','Spain',1702,65700),
 (486,'Motor Mint Distributors Inc.','Hernandez','Rosa','2155559857','11328 Douglas Av.',NULL,'Philadelphia','PA','71270','USA',1323,72600),
 (487,'Signal Collectibles Ltd.','Taylor','Sue','4155554312','2793 Furth Circle',NULL,'Brisbane','CA','94217','USA',1165,60300),
 (489,'Double Decker Gift Stores, Ltd','Hardy','Thomas ','(171) 555-7555','120 Hanover Sq.',NULL,'London',NULL,'WA1 1DP','UK',1501,43300),
 (495,'Diecast Collectables','Franco','Valarie','6175552555','6251 Ingle Ln.',NULL,'Boston','MA','51003','USA',1188,85100),
 (496,'Kellys Gift Shop','Snowden','Tony','+64 9 5555500','Arenales 1938 3A',NULL,'Auckland  ',NULL,'','New Zealand',1612,110000);

DROP TABLE IF EXISTS `classicmodels`.`Employee`;
CREATE TABLE  `classicmodels`.`Employee` (
  `employeeNumber` int(11) NOT NULL,
  `lastName` varchar(50) NOT NULL,
  `firstName` varchar(50) NOT NULL,
  `extension` varchar(10) NOT NULL,
  `email` varchar(100) NOT NULL,
  `officeCode` varchar(50) NOT NULL,
  `reportsTo` int(11) DEFAULT NULL,
  `jobTitle` varchar(50) NOT NULL,
  PRIMARY KEY (`employeeNumber`)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `classicmodels`.`Employee` (`employeeNumber`,`lastName`,`firstName`,`extension`,`email`,`officeCode`,`reportsTo`,`jobTitle`) VALUES 
 (1002,'Murphy','Diane','x5800','dmurphy@classicmodelcars.com','1',NULL,'President'),
 (1056,'Patterson','Mary','x4611','mpatterso@classicmodelcars.com','1',1002,'VP Sales'),
 (1076,'Firrelli','Jeff','x9273','jfirrelli@classicmodelcars.com','1',1002,'VP Marketing'),
 (1088,'Patterson','William','x4871','wpatterson@classicmodelcars.com','6',1056,'Sales Manager (JAPAN, APAC)'),
 (1102,'Bondur','Gerard','x5408','athompson@classicmodelcars.com','4',1056,'Sale Manager (EMEA)'),
 (1143,'Bow','Anthony','x5428','bhoward@classicmodelcars.com','1',1056,'Sales Manager (NA)'),
 (1165,'Jennings','Leslie','x3291','ljennings@classicmodelcars.com','1',1143,'Sales Rep'),
 (1166,'Thompson','Leslie','x4065','lthompson@classicmodelcars.com','1',1143,'Sales Rep'),
 (1188,'Firrelli','Julie','x2173','jfirrelli@classicmodelcars.com','2',1143,'Sales Rep'),
 (1216,'Patterson','Steve','x4334','spatterso@classicmodelcars.com','2',1143,'Sales Rep'),
 (1286,'Tseng','Foon Yue','x2248','ftseng@classicmodelcars.com','3',1143,'Sales Rep'),
 (1323,'Vanauf','George','x4102','gvanauf@classicmodelcars.com','3',1143,'Sales Rep'),
 (1337,'Bondur','Loui','x6493','lbondur@classicmodelcars.com','4',1102,'Sales Rep'),
 (1370,'Hernandez','Gerard','x2028','ghernande@classicmodelcars.com','4',1102,'Sales Rep'),
 (1401,'Castillo','Pamela','x2759','pcastillo@classicmodelcars.com','4',1102,'Sales Rep'),
 (1501,'Bott','Larry','x2311','lbott@classicmodelcars.com','7',1102,'Sales Rep'),
 (1504,'Jones','Barry','x102','bjones@classicmodelcars.com','7',1102,'Sales Rep'),
 (1611,'Fixter','Andy','x101','afixter@classicmodelcars.com','6',1088,'Sales Rep'),
 (1612,'Marsh','Peter','x102','pmarsh@classicmodelcars.com','6',1088,'Sales Rep'),
 (1619,'King','Tom','x103','tking@classicmodelcars.com','6',1088,'Sales Rep'),
 (1621,'Nishi','Mami','x101','mnishi@classicmodelcars.com','5',1088,'Sales Rep'),
 (1625,'Kato','Yoshimi','x102','ekato@classicmodelcars.com','5',1088,'Sales Rep'),
 (1702,'Gerard','Martin','x2312','gmartin@classicmodelcars.com','4',1102,'Sales Rep');

DROP TABLE IF EXISTS `classicmodels`.`Office`;
CREATE TABLE  `classicmodels`.`Office` (
  `officeCode` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `addressLine1` varchar(50) NOT NULL,
  `addressLine2` varchar(50) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `country` varchar(50) NOT NULL,
  `postalCode` varchar(10) NOT NULL,
  `territory` varchar(10) NOT NULL,
  PRIMARY KEY (`officeCode`)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `classicmodels`.`Office` (`officeCode`,`city`,`phone`,`addressLine1`,`addressLine2`,`state`,`country`,`postalCode`,`territory`) VALUES 
 ('1','San Francisco','+1 650 219 4782','100 Market Street','Suite 300','CA','USA','94080','NA'),
 ('2','Boston','+1 215 837 0825','1550 Court Place','Suite 102','MA','USA','02107','NA'),
 ('3','NYC','+1 212 555 3000','523 East 53rd Street','apt. 5A','NY','USA','10022','NA'),
 ('4','Paris','+33 14 723 4404','43 Rue Jouffroy Dabbans',NULL,'','France','75017','EMEA'),
 ('5','Tokyo','+81 33 224 5000','4-1 Kioicho',NULL,'Chiyoda-Ku','Japan','102-8578','Japan'),
 ('6','Sydney','+61 2 9264 2451','5-11 Wentworth Avenue','Floor #2',NULL,'Australia','NSW 2010','APAC'),
 ('7','London','+44 20 7877 2041','25 Old Broad Street','Level 7',NULL,'UK','EC2N 1HN','EMEA');

DROP TABLE IF EXISTS `classicmodels`.`Order`;
CREATE TABLE  `classicmodels`.`Order` (
  `orderNumber` int(11) NOT NULL,
  `orderDate` datetime NOT NULL,
  `requiredDate` datetime NOT NULL,
  `shippedDate` datetime DEFAULT NULL,
  `status` varchar(15) NOT NULL,
  `comments` text,
  `customerNumber` int(11) NOT NULL,
  PRIMARY KEY (`orderNumber`)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `classicmodels`.`Order` (`orderNumber`,`orderDate`,`requiredDate`,`shippedDate`,`status`,`comments`,`customerNumber`) VALUES 
 (10100,'2003-01-06 00:00:00','2003-01-13 00:00:00','2003-01-10 00:00:00','Shipped',NULL,363),
 (10101,'2003-01-09 00:00:00','2003-01-18 00:00:00','2003-01-11 00:00:00','Shipped','Check on availability.',128),
 (10102,'2003-01-10 00:00:00','2003-01-18 00:00:00','2003-01-14 00:00:00','Shipped',NULL,181),
 (10103,'2003-01-29 00:00:00','2003-02-07 00:00:00','2003-02-02 00:00:00','Shipped',NULL,121),
 (10104,'2003-01-31 00:00:00','2003-02-09 00:00:00','2003-02-01 00:00:00','Shipped',NULL,141),
 (10105,'2003-02-11 00:00:00','2003-02-21 00:00:00','2003-02-12 00:00:00','Shipped',NULL,145),
 (10106,'2003-02-17 00:00:00','2003-02-24 00:00:00','2003-02-21 00:00:00','Shipped',NULL,278),
 (10107,'2003-02-24 00:00:00','2003-03-03 00:00:00','2003-02-26 00:00:00','Shipped','Difficult to negotiate with customer. We need more marketing materials',131),
 (10108,'2003-03-03 00:00:00','2003-03-12 00:00:00','2003-03-08 00:00:00','Shipped',NULL,385),
 (10109,'2003-03-10 00:00:00','2003-03-19 00:00:00','2003-03-11 00:00:00','Shipped','Customer requested that FedEx Ground is used for this shipping',486),
 (10110,'2003-03-18 00:00:00','2003-03-24 00:00:00','2003-03-20 00:00:00','Shipped',NULL,187),
 (10111,'2003-03-25 00:00:00','2003-03-31 00:00:00','2003-03-30 00:00:00','Shipped',NULL,129),
 (10112,'2003-03-24 00:00:00','2003-04-03 00:00:00','2003-03-29 00:00:00','Shipped','Customer requested that ad materials (such as posters, pamphlets) be included in the shippment',144),
 (10113,'2003-03-26 00:00:00','2003-04-02 00:00:00','2003-03-27 00:00:00','Shipped',NULL,124),
 (10114,'2003-04-01 00:00:00','2003-04-07 00:00:00','2003-04-02 00:00:00','Shipped',NULL,172),
 (10115,'2003-04-04 00:00:00','2003-04-12 00:00:00','2003-04-07 00:00:00','Shipped',NULL,424),
 (10116,'2003-04-11 00:00:00','2003-04-19 00:00:00','2003-04-13 00:00:00','Shipped',NULL,381),
 (10117,'2003-04-16 00:00:00','2003-04-24 00:00:00','2003-04-17 00:00:00','Shipped',NULL,148),
 (10118,'2003-04-21 00:00:00','2003-04-29 00:00:00','2003-04-26 00:00:00','Shipped','Customer has worked with some of our vendors in the past and is aware of their MSRP',216),
 (10119,'2003-04-28 00:00:00','2003-05-05 00:00:00','2003-05-02 00:00:00','Shipped',NULL,382),
 (10120,'2003-04-29 00:00:00','2003-05-08 00:00:00','2003-05-01 00:00:00','Shipped',NULL,114),
 (10121,'2003-05-07 00:00:00','2003-05-13 00:00:00','2003-05-13 00:00:00','Shipped',NULL,353),
 (10122,'2003-05-08 00:00:00','2003-05-16 00:00:00','2003-05-13 00:00:00','Shipped',NULL,350),
 (10123,'2003-05-20 00:00:00','2003-05-29 00:00:00','2003-05-22 00:00:00','Shipped',NULL,103),
 (10124,'2003-05-21 00:00:00','2003-05-29 00:00:00','2003-05-25 00:00:00','Shipped','Customer very concerned about the exact color of the models. There is high risk that he may dispute the order because there is a slight color mismatch',112),
 (10125,'2003-05-21 00:00:00','2003-05-27 00:00:00','2003-05-24 00:00:00','Shipped',NULL,114),
 (10126,'2003-05-28 00:00:00','2003-06-07 00:00:00','2003-06-02 00:00:00','Shipped',NULL,458),
 (10127,'2003-06-03 00:00:00','2003-06-09 00:00:00','2003-06-06 00:00:00','Shipped','Customer requested special shippment. The instructions were passed along to the warehouse',151),
 (10128,'2003-06-06 00:00:00','2003-06-12 00:00:00','2003-06-11 00:00:00','Shipped',NULL,141),
 (10129,'2003-06-12 00:00:00','2003-06-18 00:00:00','2003-06-14 00:00:00','Shipped',NULL,324),
 (10130,'2003-06-16 00:00:00','2003-06-24 00:00:00','2003-06-21 00:00:00','Shipped',NULL,198),
 (10131,'2003-06-16 00:00:00','2003-06-25 00:00:00','2003-06-21 00:00:00','Shipped',NULL,447),
 (10132,'2003-06-25 00:00:00','2003-07-01 00:00:00','2003-06-28 00:00:00','Shipped',NULL,323),
 (10133,'2003-06-27 00:00:00','2003-07-04 00:00:00','2003-07-03 00:00:00','Shipped',NULL,141),
 (10134,'2003-07-01 00:00:00','2003-07-10 00:00:00','2003-07-05 00:00:00','Shipped',NULL,250),
 (10135,'2003-07-02 00:00:00','2003-07-12 00:00:00','2003-07-03 00:00:00','Shipped',NULL,124),
 (10136,'2003-07-04 00:00:00','2003-07-14 00:00:00','2003-07-06 00:00:00','Shipped','Customer is interested in buying more Ferrari models',242),
 (10137,'2003-07-10 00:00:00','2003-07-20 00:00:00','2003-07-14 00:00:00','Shipped',NULL,353),
 (10138,'2003-07-07 00:00:00','2003-07-16 00:00:00','2003-07-13 00:00:00','Shipped',NULL,496),
 (10139,'2003-07-16 00:00:00','2003-07-23 00:00:00','2003-07-21 00:00:00','Shipped',NULL,282),
 (10140,'2003-07-24 00:00:00','2003-08-02 00:00:00','2003-07-30 00:00:00','Shipped',NULL,161),
 (10141,'2003-08-01 00:00:00','2003-08-09 00:00:00','2003-08-04 00:00:00','Shipped',NULL,334),
 (10142,'2003-08-08 00:00:00','2003-08-16 00:00:00','2003-08-13 00:00:00','Shipped',NULL,124),
 (10143,'2003-08-10 00:00:00','2003-08-18 00:00:00','2003-08-12 00:00:00','Shipped','Can we deliver the new Ford Mustang models by end-of-quarter?',320),
 (10144,'2003-08-13 00:00:00','2003-08-21 00:00:00','2003-08-14 00:00:00','Shipped',NULL,381),
 (10145,'2003-08-25 00:00:00','2003-09-02 00:00:00','2003-08-31 00:00:00','Shipped',NULL,205),
 (10146,'2003-09-03 00:00:00','2003-09-13 00:00:00','2003-09-06 00:00:00','Shipped',NULL,447),
 (10147,'2003-09-05 00:00:00','2003-09-12 00:00:00','2003-09-09 00:00:00','Shipped',NULL,379),
 (10148,'2003-09-11 00:00:00','2003-09-21 00:00:00','2003-09-15 00:00:00','Shipped','They want to reevaluate their terms agreement with Finance.',276),
 (10149,'2003-09-12 00:00:00','2003-09-18 00:00:00','2003-09-17 00:00:00','Shipped',NULL,487),
 (10150,'2003-09-19 00:00:00','2003-09-27 00:00:00','2003-09-21 00:00:00','Shipped','They want to reevaluate their terms agreement with Finance.',148),
 (10151,'2003-09-21 00:00:00','2003-09-30 00:00:00','2003-09-24 00:00:00','Shipped',NULL,311),
 (10152,'2003-09-25 00:00:00','2003-10-03 00:00:00','2003-10-01 00:00:00','Shipped',NULL,333),
 (10153,'2003-09-28 00:00:00','2003-10-05 00:00:00','2003-10-03 00:00:00','Shipped',NULL,141),
 (10154,'2003-10-02 00:00:00','2003-10-12 00:00:00','2003-10-08 00:00:00','Shipped',NULL,219),
 (10155,'2003-10-06 00:00:00','2003-10-13 00:00:00','2003-10-07 00:00:00','Shipped',NULL,186),
 (10156,'2003-10-08 00:00:00','2003-10-17 00:00:00','2003-10-11 00:00:00','Shipped',NULL,141),
 (10157,'2003-10-09 00:00:00','2003-10-15 00:00:00','2003-10-14 00:00:00','Shipped',NULL,473),
 (10158,'2003-10-10 00:00:00','2003-10-18 00:00:00','2003-10-15 00:00:00','Shipped',NULL,121),
 (10159,'2003-10-10 00:00:00','2003-10-19 00:00:00','2003-10-16 00:00:00','Shipped',NULL,321),
 (10160,'2003-10-11 00:00:00','2003-10-17 00:00:00','2003-10-17 00:00:00','Shipped',NULL,347),
 (10161,'2003-10-17 00:00:00','2003-10-25 00:00:00','2003-10-20 00:00:00','Shipped',NULL,227),
 (10162,'2003-10-18 00:00:00','2003-10-26 00:00:00','2003-10-19 00:00:00','Shipped',NULL,321),
 (10163,'2003-10-20 00:00:00','2003-10-27 00:00:00','2003-10-24 00:00:00','Shipped',NULL,424),
 (10164,'2003-10-21 00:00:00','2003-10-30 00:00:00','2003-10-23 00:00:00','Resolved','This order was disputed, but resolved on 11/1/2003; Customer doesnt like the colors and precision of the models.',452),
 (10165,'2003-10-22 00:00:00','2003-10-31 00:00:00','2003-12-26 00:00:00','Shipped','This order was on hold because customerss credit limit had been exceeded. Order will ship when payment is received',148),
 (10166,'2003-10-21 00:00:00','2003-10-30 00:00:00','2003-10-27 00:00:00','Shipped',NULL,462),
 (10167,'2003-10-23 00:00:00','2003-10-30 00:00:00',NULL,'Cancelled','Customer called to cancel. The warehouse was notified in time and the order didnt ship. They have a new VP of Sales and are shifting their sales model. Our VP of Sales should contact them.',448),
 (10168,'2003-10-28 00:00:00','2003-11-03 00:00:00','2003-11-01 00:00:00','Shipped',NULL,161),
 (10169,'2003-11-04 00:00:00','2003-11-14 00:00:00','2003-11-09 00:00:00','Shipped',NULL,276),
 (10170,'2003-11-04 00:00:00','2003-11-12 00:00:00','2003-11-07 00:00:00','Shipped',NULL,452),
 (10171,'2003-11-05 00:00:00','2003-11-13 00:00:00','2003-11-07 00:00:00','Shipped',NULL,233),
 (10172,'2003-11-05 00:00:00','2003-11-14 00:00:00','2003-11-11 00:00:00','Shipped',NULL,175),
 (10173,'2003-11-05 00:00:00','2003-11-15 00:00:00','2003-11-09 00:00:00','Shipped','Cautious optimism. We have happy customers here, if we can keep them well stocked.  I need all the information I can get on the planned shippments of Porches',278),
 (10174,'2003-11-06 00:00:00','2003-11-15 00:00:00','2003-11-10 00:00:00','Shipped',NULL,333),
 (10175,'2003-11-06 00:00:00','2003-11-14 00:00:00','2003-11-09 00:00:00','Shipped',NULL,324),
 (10176,'2003-11-06 00:00:00','2003-11-15 00:00:00','2003-11-12 00:00:00','Shipped',NULL,386),
 (10177,'2003-11-07 00:00:00','2003-11-17 00:00:00','2003-11-12 00:00:00','Shipped',NULL,344),
 (10178,'2003-11-08 00:00:00','2003-11-16 00:00:00','2003-11-10 00:00:00','Shipped','Custom shipping instructions sent to warehouse',242),
 (10179,'2003-11-11 00:00:00','2003-11-17 00:00:00','2003-11-13 00:00:00','Cancelled','Customer cancelled due to urgent budgeting issues. Must be cautious when dealing with them in the future. Since order shipped already we must discuss who would cover the shipping charges.',496),
 (10180,'2003-11-11 00:00:00','2003-11-19 00:00:00','2003-11-14 00:00:00','Shipped',NULL,171),
 (10181,'2003-11-12 00:00:00','2003-11-19 00:00:00','2003-11-15 00:00:00','Shipped',NULL,167),
 (10182,'2003-11-12 00:00:00','2003-11-21 00:00:00','2003-11-18 00:00:00','Shipped',NULL,124),
 (10183,'2003-11-13 00:00:00','2003-11-22 00:00:00','2003-11-15 00:00:00','Shipped','We need to keep in close contact with their Marketing VP. He is the decision maker for all their purchases.',339),
 (10184,'2003-11-14 00:00:00','2003-11-22 00:00:00','2003-11-20 00:00:00','Shipped',NULL,484),
 (10185,'2003-11-14 00:00:00','2003-11-21 00:00:00','2003-11-20 00:00:00','Shipped',NULL,320),
 (10186,'2003-11-14 00:00:00','2003-11-20 00:00:00','2003-11-18 00:00:00','Shipped','They want to reevaluate their terms agreement with the VP of Sales',489),
 (10187,'2003-11-15 00:00:00','2003-11-24 00:00:00','2003-11-16 00:00:00','Shipped',NULL,211),
 (10188,'2003-11-18 00:00:00','2003-11-26 00:00:00','2003-11-24 00:00:00','Shipped',NULL,167),
 (10189,'2003-11-18 00:00:00','2003-11-25 00:00:00','2003-11-24 00:00:00','Shipped','They want to reevaluate their terms agreement with Finance.',205),
 (10190,'2003-11-19 00:00:00','2003-11-29 00:00:00','2003-11-20 00:00:00','Shipped',NULL,141),
 (10191,'2003-11-20 00:00:00','2003-11-30 00:00:00','2003-11-24 00:00:00','Shipped','We must be cautions with this customer. Their VP of Sales resigned. Company may be heading down.',259),
 (10192,'2003-11-20 00:00:00','2003-11-29 00:00:00','2003-11-25 00:00:00','Shipped',NULL,363),
 (10193,'2003-11-21 00:00:00','2003-11-28 00:00:00','2003-11-27 00:00:00','Shipped',NULL,471),
 (10194,'2003-11-25 00:00:00','2003-12-02 00:00:00','2003-11-26 00:00:00','Shipped',NULL,146),
 (10195,'2003-11-25 00:00:00','2003-12-01 00:00:00','2003-11-28 00:00:00','Shipped',NULL,319),
 (10196,'2003-11-26 00:00:00','2003-12-03 00:00:00','2003-12-01 00:00:00','Shipped',NULL,455),
 (10197,'2003-11-26 00:00:00','2003-12-02 00:00:00','2003-12-01 00:00:00','Shipped','Customer inquired about remote controlled models and gold models.',216),
 (10198,'2003-11-27 00:00:00','2003-12-06 00:00:00','2003-12-03 00:00:00','Shipped',NULL,385),
 (10199,'2003-12-01 00:00:00','2003-12-10 00:00:00','2003-12-06 00:00:00','Shipped',NULL,475),
 (10200,'2003-12-01 00:00:00','2003-12-09 00:00:00','2003-12-06 00:00:00','Shipped',NULL,211),
 (10201,'2003-12-01 00:00:00','2003-12-11 00:00:00','2003-12-02 00:00:00','Shipped',NULL,129),
 (10202,'2003-12-02 00:00:00','2003-12-09 00:00:00','2003-12-06 00:00:00','Shipped',NULL,357),
 (10203,'2003-12-02 00:00:00','2003-12-11 00:00:00','2003-12-07 00:00:00','Shipped',NULL,141),
 (10204,'2003-12-02 00:00:00','2003-12-10 00:00:00','2003-12-04 00:00:00','Shipped',NULL,151),
 (10205,'2003-12-03 00:00:00','2003-12-09 00:00:00','2003-12-07 00:00:00','Shipped',' I need all the information I can get on our competitors.',141),
 (10206,'2003-12-05 00:00:00','2003-12-13 00:00:00','2003-12-08 00:00:00','Shipped','Can we renegotiate this one?',202),
 (10207,'2003-12-09 00:00:00','2003-12-17 00:00:00','2003-12-11 00:00:00','Shipped','Check on availability.',495),
 (10208,'2004-01-02 00:00:00','2004-01-11 00:00:00','2004-01-04 00:00:00','Shipped',NULL,146),
 (10209,'2004-01-09 00:00:00','2004-01-15 00:00:00','2004-01-12 00:00:00','Shipped',NULL,347),
 (10210,'2004-01-12 00:00:00','2004-01-22 00:00:00','2004-01-20 00:00:00','Shipped',NULL,177),
 (10211,'2004-01-15 00:00:00','2004-01-25 00:00:00','2004-01-18 00:00:00','Shipped',NULL,406),
 (10212,'2004-01-16 00:00:00','2004-01-24 00:00:00','2004-01-18 00:00:00','Shipped',NULL,141),
 (10213,'2004-01-22 00:00:00','2004-01-28 00:00:00','2004-01-27 00:00:00','Shipped','Difficult to negotiate with customer. We need more marketing materials',489),
 (10214,'2004-01-26 00:00:00','2004-02-04 00:00:00','2004-01-29 00:00:00','Shipped',NULL,458),
 (10215,'2004-01-29 00:00:00','2004-02-08 00:00:00','2004-02-01 00:00:00','Shipped','Customer requested that FedEx Ground is used for this shipping',475),
 (10216,'2004-02-02 00:00:00','2004-02-10 00:00:00','2004-02-04 00:00:00','Shipped',NULL,256),
 (10217,'2004-02-04 00:00:00','2004-02-14 00:00:00','2004-02-06 00:00:00','Shipped',NULL,166),
 (10218,'2004-02-09 00:00:00','2004-02-16 00:00:00','2004-02-11 00:00:00','Shipped','Customer requested that ad materials (such as posters, pamphlets) be included in the shippment',473),
 (10219,'2004-02-10 00:00:00','2004-02-17 00:00:00','2004-02-12 00:00:00','Shipped',NULL,487),
 (10220,'2004-02-12 00:00:00','2004-02-19 00:00:00','2004-02-16 00:00:00','Shipped',NULL,189),
 (10221,'2004-02-18 00:00:00','2004-02-26 00:00:00','2004-02-19 00:00:00','Shipped',NULL,314),
 (10222,'2004-02-19 00:00:00','2004-02-27 00:00:00','2004-02-20 00:00:00','Shipped',NULL,239),
 (10223,'2004-02-20 00:00:00','2004-02-29 00:00:00','2004-02-24 00:00:00','Shipped',NULL,114),
 (10224,'2004-02-21 00:00:00','2004-03-02 00:00:00','2004-02-26 00:00:00','Shipped','Customer has worked with some of our vendors in the past and is aware of their MSRP',171),
 (10225,'2004-02-22 00:00:00','2004-03-01 00:00:00','2004-02-24 00:00:00','Shipped',NULL,298),
 (10226,'2004-02-26 00:00:00','2004-03-06 00:00:00','2004-03-02 00:00:00','Shipped',NULL,239),
 (10227,'2004-03-02 00:00:00','2004-03-12 00:00:00','2004-03-08 00:00:00','Shipped',NULL,146),
 (10228,'2004-03-10 00:00:00','2004-03-18 00:00:00','2004-03-13 00:00:00','Shipped',NULL,173),
 (10229,'2004-03-11 00:00:00','2004-03-20 00:00:00','2004-03-12 00:00:00','Shipped',NULL,124),
 (10230,'2004-03-15 00:00:00','2004-03-24 00:00:00','2004-03-20 00:00:00','Shipped','Customer very concerned about the exact color of the models. There is high risk that he may dispute the order because there is a slight color mismatch',128),
 (10231,'2004-03-19 00:00:00','2004-03-26 00:00:00','2004-03-25 00:00:00','Shipped',NULL,344),
 (10232,'2004-03-20 00:00:00','2004-03-30 00:00:00','2004-03-25 00:00:00','Shipped',NULL,240),
 (10233,'2004-03-29 00:00:00','2004-04-04 00:00:00','2004-04-02 00:00:00','Shipped','Customer requested special shippment. The instructions were passed along to the warehouse',328),
 (10234,'2004-03-30 00:00:00','2004-04-05 00:00:00','2004-04-02 00:00:00','Shipped',NULL,412),
 (10235,'2004-04-02 00:00:00','2004-04-12 00:00:00','2004-04-06 00:00:00','Shipped',NULL,260),
 (10236,'2004-04-03 00:00:00','2004-04-11 00:00:00','2004-04-08 00:00:00','Shipped',NULL,486),
 (10237,'2004-04-05 00:00:00','2004-04-12 00:00:00','2004-04-10 00:00:00','Shipped',NULL,181),
 (10238,'2004-04-09 00:00:00','2004-04-16 00:00:00','2004-04-10 00:00:00','Shipped',NULL,145),
 (10239,'2004-04-12 00:00:00','2004-04-21 00:00:00','2004-04-17 00:00:00','Shipped',NULL,311),
 (10240,'2004-04-13 00:00:00','2004-04-20 00:00:00','2004-04-20 00:00:00','Shipped',NULL,177),
 (10241,'2004-04-13 00:00:00','2004-04-20 00:00:00','2004-04-19 00:00:00','Shipped',NULL,209),
 (10242,'2004-04-20 00:00:00','2004-04-28 00:00:00','2004-04-25 00:00:00','Shipped','Customer is interested in buying more Ferrari models',456),
 (10243,'2004-04-26 00:00:00','2004-05-03 00:00:00','2004-04-28 00:00:00','Shipped',NULL,495),
 (10244,'2004-04-29 00:00:00','2004-05-09 00:00:00','2004-05-04 00:00:00','Shipped',NULL,141),
 (10245,'2004-05-04 00:00:00','2004-05-12 00:00:00','2004-05-09 00:00:00','Shipped',NULL,455),
 (10246,'2004-05-05 00:00:00','2004-05-13 00:00:00','2004-05-06 00:00:00','Shipped',NULL,141),
 (10247,'2004-05-05 00:00:00','2004-05-11 00:00:00','2004-05-08 00:00:00','Shipped',NULL,334),
 (10248,'2004-05-07 00:00:00','2004-05-14 00:00:00',NULL,'Cancelled','Order was mistakenly placed. The warehouse noticed the lack of documentation.',131),
 (10249,'2004-05-08 00:00:00','2004-05-17 00:00:00','2004-05-11 00:00:00','Shipped','Can we deliver the new Ford Mustang models by end-of-quarter?',173),
 (10250,'2004-05-11 00:00:00','2004-05-19 00:00:00','2004-05-15 00:00:00','Shipped',NULL,450),
 (10251,'2004-05-18 00:00:00','2004-05-24 00:00:00','2004-05-24 00:00:00','Shipped',NULL,328),
 (10252,'2004-05-26 00:00:00','2004-06-04 00:00:00','2004-05-29 00:00:00','Shipped',NULL,406),
 (10253,'2004-06-01 00:00:00','2004-06-09 00:00:00','2004-06-02 00:00:00','Cancelled','Customer disputed the order and we agreed to cancel it. We must be more cautions with this customer going forward, since they are very hard to please. We must cover the shipping fees.',201),
 (10254,'2004-06-03 00:00:00','2004-06-13 00:00:00','2004-06-04 00:00:00','Shipped','Customer requested that DHL is used for this shipping',323),
 (10255,'2004-06-04 00:00:00','2004-06-12 00:00:00','2004-06-09 00:00:00','Shipped',NULL,209),
 (10256,'2004-06-08 00:00:00','2004-06-16 00:00:00','2004-06-10 00:00:00','Shipped',NULL,145),
 (10257,'2004-06-14 00:00:00','2004-06-24 00:00:00','2004-06-15 00:00:00','Shipped',NULL,450),
 (10258,'2004-06-15 00:00:00','2004-06-25 00:00:00','2004-06-23 00:00:00','Shipped',NULL,398),
 (10259,'2004-06-15 00:00:00','2004-06-22 00:00:00','2004-06-17 00:00:00','Shipped',NULL,166),
 (10260,'2004-06-16 00:00:00','2004-06-22 00:00:00',NULL,'Cancelled','Customer heard complaints from their customers and called to cancel this order. Will notify the Sales Manager.',357),
 (10261,'2004-06-17 00:00:00','2004-06-25 00:00:00','2004-06-22 00:00:00','Shipped',NULL,233),
 (10262,'2004-06-24 00:00:00','2004-07-01 00:00:00',NULL,'Cancelled','This customer found a better offer from one of our competitors. Will call back to renegotiate.',141),
 (10263,'2004-06-28 00:00:00','2004-07-04 00:00:00','2004-07-02 00:00:00','Shipped',NULL,175),
 (10264,'2004-06-30 00:00:00','2004-07-06 00:00:00','2004-07-01 00:00:00','Shipped','Customer will send a truck to our local warehouse on 7/1/2004',362),
 (10265,'2004-07-02 00:00:00','2004-07-09 00:00:00','2004-07-07 00:00:00','Shipped',NULL,471),
 (10266,'2004-07-06 00:00:00','2004-07-14 00:00:00','2004-07-10 00:00:00','Shipped',NULL,386),
 (10267,'2004-07-07 00:00:00','2004-07-17 00:00:00','2004-07-09 00:00:00','Shipped',NULL,151),
 (10268,'2004-07-12 00:00:00','2004-07-18 00:00:00','2004-07-14 00:00:00','Shipped',NULL,412),
 (10269,'2004-07-16 00:00:00','2004-07-22 00:00:00','2004-07-18 00:00:00','Shipped',NULL,382),
 (10270,'2004-07-19 00:00:00','2004-07-27 00:00:00','2004-07-24 00:00:00','Shipped','Can we renegotiate this one?',282),
 (10271,'2004-07-20 00:00:00','2004-07-29 00:00:00','2004-07-23 00:00:00','Shipped',NULL,124),
 (10272,'2004-07-20 00:00:00','2004-07-26 00:00:00','2004-07-22 00:00:00','Shipped',NULL,157),
 (10273,'2004-07-21 00:00:00','2004-07-28 00:00:00','2004-07-22 00:00:00','Shipped',NULL,314),
 (10274,'2004-07-21 00:00:00','2004-07-29 00:00:00','2004-07-22 00:00:00','Shipped',NULL,379),
 (10275,'2004-07-23 00:00:00','2004-08-02 00:00:00','2004-07-29 00:00:00','Shipped',NULL,119),
 (10276,'2004-08-02 00:00:00','2004-08-11 00:00:00','2004-08-08 00:00:00','Shipped',NULL,204),
 (10277,'2004-08-04 00:00:00','2004-08-12 00:00:00','2004-08-05 00:00:00','Shipped',NULL,148),
 (10278,'2004-08-06 00:00:00','2004-08-16 00:00:00','2004-08-09 00:00:00','Shipped',NULL,112),
 (10279,'2004-08-09 00:00:00','2004-08-19 00:00:00','2004-08-15 00:00:00','Shipped','Cautious optimism. We have happy customers here, if we can keep them well stocked.  I need all the information I can get on the planned shippments of Porches',141),
 (10280,'2004-08-17 00:00:00','2004-08-27 00:00:00','2004-08-19 00:00:00','Shipped',NULL,249),
 (10281,'2004-08-19 00:00:00','2004-08-28 00:00:00','2004-08-23 00:00:00','Shipped',NULL,157),
 (10282,'2004-08-20 00:00:00','2004-08-26 00:00:00','2004-08-22 00:00:00','Shipped',NULL,124),
 (10283,'2004-08-20 00:00:00','2004-08-30 00:00:00','2004-08-23 00:00:00','Shipped',NULL,260),
 (10284,'2004-08-21 00:00:00','2004-08-29 00:00:00','2004-08-26 00:00:00','Shipped','Custom shipping instructions sent to warehouse',299),
 (10285,'2004-08-27 00:00:00','2004-09-04 00:00:00','2004-08-31 00:00:00','Shipped',NULL,286),
 (10286,'2004-08-28 00:00:00','2004-09-06 00:00:00','2004-09-01 00:00:00','Shipped',NULL,172),
 (10287,'2004-08-30 00:00:00','2004-09-06 00:00:00','2004-09-01 00:00:00','Shipped',NULL,298),
 (10288,'2004-09-01 00:00:00','2004-09-11 00:00:00','2004-09-05 00:00:00','Shipped',NULL,166),
 (10289,'2004-09-03 00:00:00','2004-09-13 00:00:00','2004-09-04 00:00:00','Shipped','We need to keep in close contact with their Marketing VP. He is the decision maker for all their purchases.',167),
 (10290,'2004-09-07 00:00:00','2004-09-15 00:00:00','2004-09-13 00:00:00','Shipped',NULL,198),
 (10291,'2004-09-08 00:00:00','2004-09-17 00:00:00','2004-09-14 00:00:00','Shipped',NULL,448),
 (10292,'2004-09-08 00:00:00','2004-09-18 00:00:00','2004-09-11 00:00:00','Shipped','They want to reevaluate their terms agreement with Finance.',131),
 (10293,'2004-09-09 00:00:00','2004-09-18 00:00:00','2004-09-14 00:00:00','Shipped',NULL,249),
 (10294,'2004-09-10 00:00:00','2004-09-17 00:00:00','2004-09-14 00:00:00','Shipped',NULL,204),
 (10295,'2004-09-10 00:00:00','2004-09-17 00:00:00','2004-09-14 00:00:00','Shipped','They want to reevaluate their terms agreement with Finance.',362),
 (10296,'2004-09-15 00:00:00','2004-09-22 00:00:00','2004-09-16 00:00:00','Shipped',NULL,415),
 (10297,'2004-09-16 00:00:00','2004-09-22 00:00:00','2004-09-21 00:00:00','Shipped','We must be cautions with this customer. Their VP of Sales resigned. Company may be heading down.',189),
 (10298,'2004-09-27 00:00:00','2004-10-05 00:00:00','2004-10-01 00:00:00','Shipped',NULL,103),
 (10299,'2004-09-30 00:00:00','2004-10-10 00:00:00','2004-10-01 00:00:00','Shipped',NULL,186),
 (10300,'2003-10-04 00:00:00','2003-10-13 00:00:00','2003-10-09 00:00:00','Shipped',NULL,128),
 (10301,'2003-10-05 00:00:00','2003-10-15 00:00:00','2003-10-08 00:00:00','Shipped',NULL,299),
 (10302,'2003-10-06 00:00:00','2003-10-16 00:00:00','2003-10-07 00:00:00','Shipped',NULL,201),
 (10303,'2004-10-06 00:00:00','2004-10-14 00:00:00','2004-10-09 00:00:00','Shipped','Customer inquired about remote controlled models and gold models.',484),
 (10304,'2004-10-11 00:00:00','2004-10-20 00:00:00','2004-10-17 00:00:00','Shipped',NULL,256),
 (10305,'2004-10-13 00:00:00','2004-10-22 00:00:00','2004-10-15 00:00:00','Shipped','Check on availability.',286),
 (10306,'2004-10-14 00:00:00','2004-10-21 00:00:00','2004-10-17 00:00:00','Shipped',NULL,187),
 (10307,'2004-10-14 00:00:00','2004-10-23 00:00:00','2004-10-20 00:00:00','Shipped',NULL,339),
 (10308,'2004-10-15 00:00:00','2004-10-24 00:00:00','2004-10-20 00:00:00','Shipped','Customer requested that FedEx Ground is used for this shipping',319),
 (10309,'2004-10-15 00:00:00','2004-10-24 00:00:00','2004-10-18 00:00:00','Shipped',NULL,121),
 (10310,'2004-10-16 00:00:00','2004-10-24 00:00:00','2004-10-18 00:00:00','Shipped',NULL,259),
 (10311,'2004-10-16 00:00:00','2004-10-23 00:00:00','2004-10-20 00:00:00','Shipped','Difficult to negotiate with customer. We need more marketing materials',141),
 (10312,'2004-10-21 00:00:00','2004-10-27 00:00:00','2004-10-23 00:00:00','Shipped',NULL,124),
 (10313,'2004-10-22 00:00:00','2004-10-28 00:00:00','2004-10-25 00:00:00','Shipped','Customer requested that FedEx Ground is used for this shipping',202),
 (10314,'2004-10-22 00:00:00','2004-11-01 00:00:00','2004-10-23 00:00:00','Shipped',NULL,227),
 (10315,'2004-10-29 00:00:00','2004-11-08 00:00:00','2004-10-30 00:00:00','Shipped',NULL,119),
 (10316,'2004-11-01 00:00:00','2004-11-09 00:00:00','2004-11-07 00:00:00','Shipped','Customer requested that ad materials (such as posters, pamphlets) be included in the shippment',240),
 (10317,'2004-11-02 00:00:00','2004-11-12 00:00:00','2004-11-08 00:00:00','Shipped',NULL,161),
 (10318,'2004-11-02 00:00:00','2004-11-09 00:00:00','2004-11-07 00:00:00','Shipped',NULL,157),
 (10319,'2004-11-03 00:00:00','2004-11-11 00:00:00','2004-11-06 00:00:00','Shipped','Customer requested that DHL is used for this shipping',456),
 (10320,'2004-11-03 00:00:00','2004-11-13 00:00:00','2004-11-07 00:00:00','Shipped',NULL,144),
 (10321,'2004-11-04 00:00:00','2004-11-12 00:00:00','2004-11-07 00:00:00','Shipped',NULL,462),
 (10322,'2004-11-04 00:00:00','2004-11-12 00:00:00','2004-11-10 00:00:00','Shipped','Customer has worked with some of our vendors in the past and is aware of their MSRP',363),
 (10323,'2004-11-05 00:00:00','2004-11-12 00:00:00','2004-11-09 00:00:00','Shipped',NULL,128),
 (10324,'2004-11-05 00:00:00','2004-11-11 00:00:00','2004-11-08 00:00:00','Shipped',NULL,181),
 (10325,'2004-11-05 00:00:00','2004-11-13 00:00:00','2004-11-08 00:00:00','Shipped',NULL,121),
 (10326,'2004-11-09 00:00:00','2004-11-16 00:00:00','2004-11-10 00:00:00','Shipped',NULL,144),
 (10327,'2004-11-10 00:00:00','2004-11-19 00:00:00','2004-11-13 00:00:00','Resolved','Order was disputed and resolved on 12/1/04. The Sales Manager was involved. Customer claims the scales of the models dont match what was discussed.',145),
 (10328,'2004-11-12 00:00:00','2004-11-21 00:00:00','2004-11-18 00:00:00','Shipped','Customer very concerned about the exact color of the models. There is high risk that he may dispute the order because there is a slight color mismatch',278),
 (10329,'2004-11-15 00:00:00','2004-11-24 00:00:00','2004-11-16 00:00:00','Shipped',NULL,131),
 (10330,'2004-11-16 00:00:00','2004-11-25 00:00:00','2004-11-21 00:00:00','Shipped',NULL,385),
 (10331,'2004-11-17 00:00:00','2004-11-23 00:00:00','2004-11-23 00:00:00','Shipped','Customer requested special shippment. The instructions were passed along to the warehouse',486),
 (10332,'2004-11-17 00:00:00','2004-11-25 00:00:00','2004-11-18 00:00:00','Shipped',NULL,187),
 (10333,'2004-11-18 00:00:00','2004-11-27 00:00:00','2004-11-20 00:00:00','Shipped',NULL,129),
 (10334,'2004-11-19 00:00:00','2004-11-28 00:00:00',NULL,'On Hold','The outstaniding balance for this customer exceeds their credit limit. Order will be shipped when a payment is received.',144),
 (10335,'2004-11-19 00:00:00','2004-11-29 00:00:00','2004-11-23 00:00:00','Shipped',NULL,124),
 (10336,'2004-11-20 00:00:00','2004-11-26 00:00:00','2004-11-24 00:00:00','Shipped','Customer requested that DHL is used for this shipping',172),
 (10337,'2004-11-21 00:00:00','2004-11-30 00:00:00','2004-11-26 00:00:00','Shipped',NULL,424),
 (10338,'2004-11-22 00:00:00','2004-12-02 00:00:00','2004-11-27 00:00:00','Shipped',NULL,381),
 (10339,'2004-11-23 00:00:00','2004-11-30 00:00:00','2004-11-30 00:00:00','Shipped',NULL,398),
 (10340,'2004-11-24 00:00:00','2004-12-01 00:00:00','2004-11-25 00:00:00','Shipped','Customer is interested in buying more Ferrari models',216),
 (10341,'2004-11-24 00:00:00','2004-12-01 00:00:00','2004-11-29 00:00:00','Shipped',NULL,382),
 (10342,'2004-11-24 00:00:00','2004-12-01 00:00:00','2004-11-29 00:00:00','Shipped',NULL,114),
 (10343,'2004-11-24 00:00:00','2004-12-01 00:00:00','2004-11-26 00:00:00','Shipped',NULL,353),
 (10344,'2004-11-25 00:00:00','2004-12-02 00:00:00','2004-11-29 00:00:00','Shipped',NULL,350),
 (10345,'2004-11-25 00:00:00','2004-12-01 00:00:00','2004-11-26 00:00:00','Shipped',NULL,103),
 (10346,'2004-11-29 00:00:00','2004-12-05 00:00:00','2004-11-30 00:00:00','Shipped',NULL,112),
 (10347,'2004-11-29 00:00:00','2004-12-07 00:00:00','2004-11-30 00:00:00','Shipped','Can we deliver the new Ford Mustang models by end-of-quarter?',114),
 (10348,'2004-11-01 00:00:00','2004-11-08 00:00:00','2004-11-05 00:00:00','Shipped',NULL,458),
 (10349,'2004-12-01 00:00:00','2004-12-07 00:00:00','2004-12-03 00:00:00','Shipped',NULL,151),
 (10350,'2004-12-02 00:00:00','2004-12-08 00:00:00','2004-12-05 00:00:00','Shipped',NULL,141),
 (10351,'2004-12-03 00:00:00','2004-12-11 00:00:00','2004-12-07 00:00:00','Shipped',NULL,324),
 (10352,'2004-12-03 00:00:00','2004-12-12 00:00:00','2004-12-09 00:00:00','Shipped',NULL,198),
 (10353,'2004-12-04 00:00:00','2004-12-11 00:00:00','2004-12-05 00:00:00','Shipped',NULL,447),
 (10354,'2004-12-04 00:00:00','2004-12-10 00:00:00','2004-12-05 00:00:00','Shipped',NULL,323),
 (10355,'2004-12-07 00:00:00','2004-12-14 00:00:00','2004-12-13 00:00:00','Shipped',NULL,141),
 (10356,'2004-12-09 00:00:00','2004-12-15 00:00:00','2004-12-12 00:00:00','Shipped',NULL,250),
 (10357,'2004-12-10 00:00:00','2004-12-16 00:00:00','2004-12-14 00:00:00','Shipped',NULL,124),
 (10358,'2004-12-10 00:00:00','2004-12-16 00:00:00','2004-12-16 00:00:00','Shipped','Customer requested that DHL is used for this shipping',141),
 (10359,'2004-12-15 00:00:00','2004-12-23 00:00:00','2004-12-18 00:00:00','Shipped',NULL,353),
 (10360,'2004-12-16 00:00:00','2004-12-22 00:00:00','2004-12-18 00:00:00','Shipped',NULL,496),
 (10361,'2004-12-17 00:00:00','2004-12-24 00:00:00','2004-12-20 00:00:00','Shipped',NULL,282),
 (10362,'2005-01-05 00:00:00','2005-01-16 00:00:00','2005-01-10 00:00:00','Shipped',NULL,161),
 (10363,'2005-01-06 00:00:00','2005-01-12 00:00:00','2005-01-10 00:00:00','Shipped',NULL,334),
 (10364,'2005-01-06 00:00:00','2005-01-17 00:00:00','2005-01-09 00:00:00','Shipped',NULL,350),
 (10365,'2005-01-07 00:00:00','2005-01-18 00:00:00','2005-01-11 00:00:00','Shipped',NULL,320),
 (10366,'2005-01-10 00:00:00','2005-01-19 00:00:00','2005-01-12 00:00:00','Shipped',NULL,381),
 (10367,'2005-01-12 00:00:00','2005-01-21 00:00:00','2005-01-16 00:00:00','Resolved','This order was disputed and resolved on 2/1/2005. Customer claimed that container with shipment was damaged. FedExs investigation proved this wrong.',205),
 (10368,'2005-01-19 00:00:00','2005-01-27 00:00:00','2005-01-24 00:00:00','Shipped','Can we renegotiate this one?',124),
 (10369,'2005-01-20 00:00:00','2005-01-28 00:00:00','2005-01-24 00:00:00','Shipped',NULL,379),
 (10370,'2005-01-20 00:00:00','2005-02-01 00:00:00','2005-01-25 00:00:00','Shipped',NULL,276),
 (10371,'2005-01-23 00:00:00','2005-02-03 00:00:00','2005-01-25 00:00:00','Shipped',NULL,124),
 (10372,'2005-01-26 00:00:00','2005-02-05 00:00:00','2005-01-28 00:00:00','Shipped',NULL,398),
 (10373,'2005-01-31 00:00:00','2005-02-08 00:00:00','2005-02-06 00:00:00','Shipped',NULL,311),
 (10374,'2005-02-02 00:00:00','2005-02-09 00:00:00','2005-02-03 00:00:00','Shipped',NULL,333),
 (10375,'2005-02-03 00:00:00','2005-02-10 00:00:00','2005-02-06 00:00:00','Shipped',NULL,119),
 (10376,'2005-02-08 00:00:00','2005-02-18 00:00:00','2005-02-13 00:00:00','Shipped',NULL,219),
 (10377,'2005-02-09 00:00:00','2005-02-21 00:00:00','2005-02-12 00:00:00','Shipped','Cautious optimism. We have happy customers here, if we can keep them well stocked.  I need all the information I can get on the planned shippments of Porches',186),
 (10378,'2005-02-10 00:00:00','2005-02-18 00:00:00','2005-02-11 00:00:00','Shipped',NULL,141),
 (10379,'2005-02-10 00:00:00','2005-02-18 00:00:00','2005-02-11 00:00:00','Shipped',NULL,141),
 (10380,'2005-02-16 00:00:00','2005-02-24 00:00:00','2005-02-18 00:00:00','Shipped',NULL,141),
 (10381,'2005-02-17 00:00:00','2005-02-25 00:00:00','2005-02-18 00:00:00','Shipped',NULL,321),
 (10382,'2005-02-17 00:00:00','2005-02-23 00:00:00','2005-02-18 00:00:00','Shipped','Custom shipping instructions sent to warehouse',124),
 (10383,'2005-02-22 00:00:00','2005-03-02 00:00:00','2005-02-25 00:00:00','Shipped',NULL,141),
 (10384,'2005-02-23 00:00:00','2005-03-06 00:00:00','2005-02-27 00:00:00','Shipped',NULL,321),
 (10385,'2005-02-28 00:00:00','2005-03-09 00:00:00','2005-03-01 00:00:00','Shipped',NULL,124),
 (10386,'2005-03-01 00:00:00','2005-03-09 00:00:00','2005-03-06 00:00:00','Resolved','Disputed then Resolved on 3/15/2005. Customer doesnt like the craftsmaship of the models.',141),
 (10387,'2005-03-02 00:00:00','2005-03-09 00:00:00','2005-03-06 00:00:00','Shipped','We need to keep in close contact with their Marketing VP. He is the decision maker for all their purchases.',148),
 (10388,'2005-03-03 00:00:00','2005-03-11 00:00:00','2005-03-09 00:00:00','Shipped',NULL,462),
 (10389,'2005-03-03 00:00:00','2005-03-09 00:00:00','2005-03-08 00:00:00','Shipped',NULL,448),
 (10390,'2005-03-04 00:00:00','2005-03-11 00:00:00','2005-03-07 00:00:00','Shipped','They want to reevaluate their terms agreement with Finance.',124),
 (10391,'2005-03-09 00:00:00','2005-03-20 00:00:00','2005-03-15 00:00:00','Shipped',NULL,276),
 (10392,'2005-03-10 00:00:00','2005-03-18 00:00:00','2005-03-12 00:00:00','Shipped',NULL,452),
 (10393,'2005-03-11 00:00:00','2005-03-22 00:00:00','2005-03-14 00:00:00','Shipped','They want to reevaluate their terms agreement with Finance.',323),
 (10394,'2005-03-15 00:00:00','2005-03-25 00:00:00','2005-03-19 00:00:00','Shipped',NULL,141),
 (10395,'2005-03-17 00:00:00','2005-03-24 00:00:00','2005-03-23 00:00:00','Shipped','We must be cautions with this customer. Their VP of Sales resigned. Company may be heading down.',250),
 (10396,'2005-03-23 00:00:00','2005-04-02 00:00:00','2005-03-28 00:00:00','Shipped',NULL,124),
 (10397,'2005-03-28 00:00:00','2005-04-09 00:00:00','2005-04-01 00:00:00','Shipped',NULL,242),
 (10398,'2005-03-30 00:00:00','2005-04-09 00:00:00','2005-03-31 00:00:00','Shipped',NULL,353),
 (10399,'2005-04-01 00:00:00','2005-04-12 00:00:00','2005-04-03 00:00:00','Shipped',NULL,496),
 (10400,'2005-04-01 00:00:00','2005-04-11 00:00:00','2005-04-04 00:00:00','Shipped','Customer requested that DHL is used for this shipping',450),
 (10401,'2005-04-03 00:00:00','2005-04-14 00:00:00',NULL,'On Hold','Customer credit limit exceeded. Will ship when a payment is received.',328),
 (10402,'2005-04-07 00:00:00','2005-04-14 00:00:00','2005-04-12 00:00:00','Shipped',NULL,406),
 (10403,'2005-04-08 00:00:00','2005-04-18 00:00:00','2005-04-11 00:00:00','Shipped',NULL,201),
 (10404,'2005-04-08 00:00:00','2005-04-14 00:00:00','2005-04-11 00:00:00','Shipped',NULL,323),
 (10405,'2005-04-14 00:00:00','2005-04-24 00:00:00','2005-04-20 00:00:00','Shipped',NULL,209),
 (10406,'2005-04-15 00:00:00','2005-04-25 00:00:00','2005-04-21 00:00:00','Disputed','Customer claims container with shipment was damaged during shipping and some items were missing. I am talking to FedEx about this.',145),
 (10407,'2005-04-22 00:00:00','2005-05-04 00:00:00',NULL,'On Hold','Customer credit limit exceeded. Will ship when a payment is received.',450),
 (10408,'2005-04-22 00:00:00','2005-04-29 00:00:00','2005-04-27 00:00:00','Shipped',NULL,398),
 (10409,'2005-04-23 00:00:00','2005-05-05 00:00:00','2005-04-24 00:00:00','Shipped',NULL,166),
 (10410,'2005-04-29 00:00:00','2005-05-10 00:00:00','2005-04-30 00:00:00','Shipped',NULL,357),
 (10411,'2005-05-01 00:00:00','2005-05-08 00:00:00','2005-05-06 00:00:00','Shipped',NULL,233),
 (10412,'2005-05-03 00:00:00','2005-05-13 00:00:00','2005-05-05 00:00:00','Shipped',NULL,141),
 (10413,'2005-05-05 00:00:00','2005-05-14 00:00:00','2005-05-09 00:00:00','Shipped','Customer requested that DHL is used for this shipping',175),
 (10414,'2005-05-06 00:00:00','2005-05-13 00:00:00',NULL,'On Hold','Customer credit limit exceeded. Will ship when a payment is received.',362),
 (10415,'2005-05-09 00:00:00','2005-05-20 00:00:00','2005-05-12 00:00:00','Disputed','Customer claims the scales of the models dont match what was discussed. I keep all the paperwork though to prove otherwise',471),
 (10416,'2005-05-10 00:00:00','2005-05-16 00:00:00','2005-05-14 00:00:00','Shipped',NULL,386),
 (10417,'2005-05-13 00:00:00','2005-05-19 00:00:00','2005-05-19 00:00:00','Disputed','Customer doesnt like the colors and precision of the models.',141),
 (10418,'2005-05-16 00:00:00','2005-05-24 00:00:00','2005-05-20 00:00:00','Shipped',NULL,412),
 (10419,'2005-05-17 00:00:00','2005-05-28 00:00:00','2005-05-19 00:00:00','Shipped',NULL,382),
 (10420,'2005-05-29 00:00:00','2005-06-07 00:00:00',NULL,'In Process',NULL,282),
 (10421,'2005-05-29 00:00:00','2005-06-06 00:00:00',NULL,'In Process','Custom shipping instructions were sent to warehouse',124),
 (10422,'2005-05-30 00:00:00','2005-06-11 00:00:00',NULL,'In Process',NULL,157),
 (10423,'2005-05-30 00:00:00','2005-06-05 00:00:00',NULL,'In Process',NULL,314),
 (10424,'2005-05-31 00:00:00','2005-06-08 00:00:00',NULL,'In Process',NULL,141),
 (10425,'2005-05-31 00:00:00','2005-06-07 00:00:00',NULL,'In Process',NULL,119);

DROP TABLE IF EXISTS `classicmodels`.`OrderDetail`;
CREATE TABLE  `classicmodels`.`OrderDetail` (
  `orderNumber` int(11) NOT NULL,
  `productCode` varchar(50) NOT NULL,
  `quantityOrdered` int(11) NOT NULL,
  `priceEach` double NOT NULL,
  `orderLineNumber` smallint(6) NOT NULL,
  PRIMARY KEY (`orderNumber`,`productCode`)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `classicmodels`.`OrderDetail` (`orderNumber`,`productCode`,`quantityOrdered`,`priceEach`,`orderLineNumber`) VALUES 
 (10100,'S18_1749',30,171.7,3),
 (10100,'S18_2248',50,67.8,2),
 (10100,'S18_4409',22,86.51,4),
 (10100,'S24_3969',49,34.47,1),
 (10101,'S18_2325',25,151.28,4),
 (10101,'S18_2795',26,145.13,1),
 (10101,'S24_1937',45,31.2,3),
 (10101,'S24_2022',46,53.76,2),
 (10102,'S18_1342',39,123.29,2),
 (10102,'S18_1367',41,50.14,1),
 (10103,'S10_1949',26,207.87,11),
 (10103,'S10_4962',42,128.53,4),
 (10103,'S12_1666',27,125.74,8),
 (10103,'S18_1097',35,112,10),
 (10103,'S18_2432',22,54.09,2),
 (10103,'S18_2949',27,83.07,12),
 (10103,'S18_2957',35,57.46,14),
 (10103,'S18_3136',25,101.58,13),
 (10103,'S18_3320',46,104.17,16),
 (10103,'S18_4600',36,117.45,5),
 (10103,'S18_4668',41,47.29,9),
 (10103,'S24_2300',36,102.23,1),
 (10103,'S24_4258',25,114.92,15),
 (10103,'S32_1268',31,104.01,3),
 (10103,'S32_3522',45,75.63,7),
 (10103,'S700_2824',42,106.21,6),
 (10104,'S12_3148',34,175.25,1),
 (10104,'S12_4473',41,112.58,9),
 (10104,'S18_2238',24,144.08,8),
 (10104,'S18_2319',29,130.09,12),
 (10104,'S18_3232',23,198.13,13),
 (10104,'S18_4027',38,140.75,3),
 (10104,'S24_1444',35,55.49,6),
 (10104,'S24_2840',44,39.6,10),
 (10104,'S24_4048',26,112.37,5),
 (10104,'S32_2509',35,47.62,11),
 (10104,'S32_3207',49,65.87,4),
 (10104,'S50_1392',33,112.28,7),
 (10104,'S50_1514',32,53.31,2),
 (10105,'S10_4757',50,144.16,2),
 (10105,'S12_1108',41,211.96,15),
 (10105,'S12_3891',29,157.45,14),
 (10105,'S18_3140',22,139.32,11),
 (10105,'S18_3259',38,113.95,13),
 (10105,'S18_4522',41,82.5,10),
 (10105,'S24_2011',43,147.47,9),
 (10105,'S24_3151',44,72.58,4),
 (10105,'S24_3816',50,79.67,1),
 (10105,'S700_1138',41,70.67,5),
 (10105,'S700_1938',29,70.15,12),
 (10105,'S700_2610',31,65.77,3),
 (10105,'S700_3505',39,81.14,6),
 (10105,'S700_3962',22,116.19,7),
 (10105,'S72_3212',25,56.78,8),
 (10106,'S18_1662',36,146.65,12),
 (10106,'S18_2581',34,90.39,2),
 (10106,'S18_3029',41,83.44,18),
 (10106,'S18_3856',41,116.46,17),
 (10106,'S24_1785',28,88.63,4),
 (10106,'S24_2841',49,74.68,13),
 (10106,'S24_3420',31,52.6,14),
 (10106,'S24_3949',50,64.83,11),
 (10106,'S24_4278',26,63.76,3),
 (10106,'S32_4289',33,72.92,5),
 (10106,'S50_1341',39,40.15,6),
 (10106,'S700_1691',31,106.87,7),
 (10106,'S700_2047',30,105.91,16),
 (10106,'S700_2466',34,110.69,9),
 (10106,'S700_2834',32,124.58,1),
 (10106,'S700_3167',44,74.4,8),
 (10106,'S700_4002',48,61.44,10),
 (10106,'S72_1253',48,52.64,15),
 (10107,'S10_1678',30,95.7,2),
 (10107,'S10_2016',39,99.91,5),
 (10107,'S10_4698',27,224.65,4),
 (10107,'S12_2823',21,144.6,1),
 (10107,'S18_2625',29,70.87,6),
 (10107,'S24_1578',25,113.83,3),
 (10107,'S24_2000',38,83.03,7),
 (10107,'S32_1374',20,92.9,8),
 (10108,'S12_1099',33,159.55,6),
 (10108,'S12_3380',45,136.23,4),
 (10108,'S12_3990',39,89.38,7),
 (10108,'S12_4675',36,103.64,3),
 (10108,'S18_1889',38,82.39,2),
 (10108,'S18_3278',26,68.35,9),
 (10108,'S18_3482',29,139.64,8),
 (10108,'S18_3782',43,67.77,12),
 (10108,'S18_4721',44,126.48,11),
 (10108,'S24_2360',35,58.87,15),
 (10108,'S24_3371',30,63.07,5),
 (10108,'S24_3856',40,136.22,1),
 (10108,'S24_4620',31,68.71,10),
 (10108,'S32_2206',27,43.45,13),
 (10108,'S32_4485',31,118.38,16),
 (10108,'S50_4713',34,82.99,14),
 (10109,'S18_1129',26,168.43,4),
 (10109,'S18_1984',38,116.65,3),
 (10109,'S18_2870',26,121.44,1),
 (10109,'S18_3232',46,179.5,5),
 (10109,'S18_3685',47,132.8,2),
 (10109,'S24_2972',29,32.1,6),
 (10110,'S18_1589',37,146.84,16),
 (10110,'S18_1749',42,144.5,7),
 (10110,'S18_2248',32,50.25,6),
 (10110,'S18_2325',33,116.96,4),
 (10110,'S18_2795',31,163.69,1),
 (10110,'S18_4409',28,89.27,8),
 (10110,'S18_4933',42,61.29,9),
 (10110,'S24_1046',36,85.25,13),
 (10110,'S24_1628',29,59.37,15),
 (10110,'S24_1937',20,35.51,3),
 (10110,'S24_2022',39,44.35,2),
 (10110,'S24_2766',43,78.15,11),
 (10110,'S24_2887',46,129.18,10),
 (10110,'S24_3191',27,73.62,12),
 (10110,'S24_3432',37,100.66,14),
 (10110,'S24_3969',48,34.47,5),
 (10111,'S18_1342',33,99.66,6),
 (10111,'S18_1367',48,49.06,5),
 (10111,'S18_2957',28,64.33,2),
 (10111,'S18_3136',43,112.05,1),
 (10111,'S18_3320',39,107.15,4),
 (10111,'S24_4258',26,86.68,3),
 (10112,'S10_1949',29,248.59,1),
 (10112,'S18_2949',23,110.43,2),
 (10113,'S12_1666',21,162.64,2),
 (10113,'S18_1097',49,100.34,4),
 (10113,'S18_4668',50,49.81,3),
 (10113,'S32_3522',23,68.52,1),
 (10114,'S10_4962',31,138.88,8),
 (10114,'S18_2319',39,106.78,3),
 (10114,'S18_2432',45,68.67,6),
 (10114,'S18_3232',48,171.03,4),
 (10114,'S18_4600',41,117.45,9),
 (10114,'S24_2300',21,139.29,5),
 (10114,'S24_2840',24,30.06,1),
 (10114,'S32_1268',32,114.61,7),
 (10114,'S32_2509',28,55.73,2),
 (10114,'S700_2824',42,113.29,10),
 (10115,'S12_4473',46,124.43,5),
 (10115,'S18_2238',46,160.46,4),
 (10115,'S24_1444',47,69.36,2),
 (10115,'S24_4048',44,126.56,1),
 (10115,'S50_1392',27,105.33,3),
 (10116,'S32_3207',27,63.38,1),
 (10117,'S12_1108',33,182.86,9),
 (10117,'S12_3148',43,137.48,10),
 (10117,'S12_3891',39,152.26,8),
 (10117,'S18_3140',26,136.59,5),
 (10117,'S18_3259',21,95.8,7),
 (10117,'S18_4027',22,126.39,12),
 (10117,'S18_4522',23,97.42,4),
 (10117,'S24_2011',41,126.58,3),
 (10117,'S50_1514',21,49.21,11),
 (10117,'S700_1938',38,79.68,6),
 (10117,'S700_3962',45,83.42,1),
 (10117,'S72_3212',50,43.68,2),
 (10118,'S700_3505',36,117.2,1),
 (10119,'S10_4757',46,108.8,11),
 (10119,'S18_1662',43,160.84,3),
 (10119,'S18_3029',21,89.46,9),
 (10119,'S18_3856',27,99.52,8),
 (10119,'S24_2841',41,59.6,4),
 (10119,'S24_3151',35,87.62,13),
 (10119,'S24_3420',20,72.98,5),
 (10119,'S24_3816',35,90.57,10),
 (10119,'S24_3949',28,70.29,2),
 (10119,'S700_1138',25,76.67,14),
 (10119,'S700_2047',29,94.14,7),
 (10119,'S700_2610',38,65.77,12),
 (10119,'S700_4002',26,59.22,1),
 (10119,'S72_1253',28,48.17,6),
 (10120,'S10_2016',29,96.34,3),
 (10120,'S10_4698',46,201.41,2),
 (10120,'S18_2581',29,71.81,8),
 (10120,'S18_2625',46,58.15,4),
 (10120,'S24_1578',35,98.05,1),
 (10120,'S24_1785',39,119.27,10),
 (10120,'S24_2000',34,83.79,5),
 (10120,'S24_4278',29,85.49,9),
 (10120,'S32_1374',22,111.88,6),
 (10120,'S32_4289',29,72.23,11),
 (10120,'S50_1341',49,50.62,12),
 (10120,'S700_1691',47,82.21,13),
 (10120,'S700_2466',24,107.7,15),
 (10120,'S700_2834',24,142.38,7),
 (10120,'S700_3167',43,76,14),
 (10121,'S10_1678',34,81.35,5),
 (10121,'S12_2823',50,165.68,4),
 (10121,'S24_2360',32,76.88,2),
 (10121,'S32_4485',25,86.74,3),
 (10121,'S50_4713',44,74.85,1),
 (10122,'S12_1099',42,180.95,10),
 (10122,'S12_3380',37,99.82,8),
 (10122,'S12_3990',32,63.84,11),
 (10122,'S12_4675',20,107.1,7),
 (10122,'S18_1129',34,147.2,2),
 (10122,'S18_1889',43,72.38,6),
 (10122,'S18_1984',31,132.29,1),
 (10122,'S18_3232',25,143.94,3),
 (10122,'S18_3278',21,73.17,13),
 (10122,'S18_3482',21,117.59,12),
 (10122,'S18_3782',35,49.74,16),
 (10122,'S18_4721',28,127.97,15),
 (10122,'S24_2972',39,30.96,4),
 (10122,'S24_3371',34,50.21,9),
 (10122,'S24_3856',43,127.79,5),
 (10122,'S24_4620',29,71.14,14),
 (10122,'S32_2206',31,44.66,17),
 (10123,'S18_1589',26,118.22,2),
 (10123,'S18_2870',46,112.2,3),
 (10123,'S18_3685',34,156.82,4),
 (10123,'S24_1628',50,59.87,1),
 (10124,'S18_1749',21,136,6),
 (10124,'S18_2248',42,53.88,5),
 (10124,'S18_2325',42,105.52,3),
 (10124,'S18_4409',36,85.59,7),
 (10124,'S18_4933',23,57.73,8),
 (10124,'S24_1046',22,77.9,12),
 (10124,'S24_1937',45,37.84,2),
 (10124,'S24_2022',22,45.25,1),
 (10124,'S24_2766',32,72.7,10),
 (10124,'S24_2887',25,93.95,9),
 (10124,'S24_3191',49,83.04,11),
 (10124,'S24_3432',43,121,13),
 (10124,'S24_3969',46,33.23,4),
 (10125,'S18_1342',32,101.71,1),
 (10125,'S18_2795',34,190.69,2),
 (10126,'S10_1949',38,192.87,11),
 (10126,'S10_4962',22,152.17,4),
 (10126,'S12_1666',21,116.17,8),
 (10126,'S18_1097',38,101.5,10),
 (10126,'S18_1367',42,54.99,17),
 (10126,'S18_2432',43,65.02,2),
 (10126,'S18_2949',31,90.17,12),
 (10126,'S18_2957',46,73.7,14),
 (10126,'S18_3136',30,97.39,13),
 (10126,'S18_3320',38,82.34,16),
 (10126,'S18_4600',50,141.66,5),
 (10126,'S18_4668',43,53.83,9),
 (10126,'S24_2300',27,126.51,1),
 (10126,'S24_4258',34,105.18,15),
 (10126,'S32_1268',43,96.31,3),
 (10126,'S32_3522',26,62.7,7),
 (10126,'S700_2824',45,102.16,6),
 (10127,'S12_1108',46,245.2,2),
 (10127,'S12_3148',46,160.14,3),
 (10127,'S12_3891',42,193.78,1),
 (10127,'S12_4473',24,106.65,11),
 (10127,'S18_2238',45,158.82,10),
 (10127,'S18_2319',45,139.91,14),
 (10127,'S18_3232',22,174.42,15),
 (10127,'S18_4027',25,137.88,5),
 (10127,'S24_1444',20,60.69,8),
 (10127,'S24_2840',39,38.19,12),
 (10127,'S24_4048',20,96.99,7),
 (10127,'S32_2509',45,51.95,13),
 (10127,'S32_3207',29,70.84,6),
 (10127,'S50_1392',46,134.27,9),
 (10127,'S50_1514',46,69.12,4),
 (10128,'S18_3140',41,135.22,2),
 (10128,'S18_3259',41,117.98,4),
 (10128,'S18_4522',43,92.16,1),
 (10128,'S700_1938',32,97,3),
 (10129,'S10_4757',33,133.28,2),
 (10129,'S24_2011',45,133.95,9),
 (10129,'S24_3151',41,94.71,4),
 (10129,'S24_3816',50,77.99,1),
 (10129,'S700_1138',31,60,5),
 (10129,'S700_2610',45,85.29,3),
 (10129,'S700_3505',42,91.15,6),
 (10129,'S700_3962',30,85.41,7),
 (10129,'S72_3212',32,64.97,8),
 (10130,'S18_3029',40,96.34,2),
 (10130,'S18_3856',33,103.75,1),
 (10131,'S18_1662',21,132.46,4),
 (10131,'S24_2841',35,67.14,5),
 (10131,'S24_3420',29,59.18,6),
 (10131,'S24_3949',50,81.89,3),
 (10131,'S700_2047',22,85.99,8),
 (10131,'S700_2466',40,110.69,1),
 (10131,'S700_4002',26,85.13,2),
 (10131,'S72_1253',21,41.71,7),
 (10132,'S700_3167',36,68.8,1),
 (10133,'S18_2581',49,69.27,3),
 (10133,'S24_1785',41,94.1,5),
 (10133,'S24_4278',46,77.52,4),
 (10133,'S32_1374',23,114.87,1),
 (10133,'S32_4289',49,57.1,6),
 (10133,'S50_1341',27,50.19,7),
 (10133,'S700_1691',24,77.64,8),
 (10133,'S700_2834',27,99.67,2),
 (10134,'S10_1678',41,94.74,2),
 (10134,'S10_2016',27,122.51,5),
 (10134,'S10_4698',31,226.58,4),
 (10134,'S12_2823',20,135.56,1),
 (10134,'S18_2625',30,61.78,6),
 (10134,'S24_1578',35,93.54,3),
 (10134,'S24_2000',43,83.03,7),
 (10135,'S12_1099',42,190.68,7),
 (10135,'S12_3380',48,125.66,5),
 (10135,'S12_3990',24,75.01,8),
 (10135,'S12_4675',29,97.89,4),
 (10135,'S18_1889',48,79.31,3),
 (10135,'S18_3278',45,78,10),
 (10135,'S18_3482',42,129.35,9),
 (10135,'S18_3782',45,50.36,13),
 (10135,'S18_4721',31,151.78,12),
 (10135,'S24_2360',29,61.64,16),
 (10135,'S24_2972',20,35.87,1),
 (10135,'S24_3371',27,66.13,6),
 (10135,'S24_3856',47,134.81,2),
 (10135,'S24_4620',23,87.31,11),
 (10135,'S32_2206',33,40.23,14),
 (10135,'S32_4485',30,89.8,17),
 (10135,'S50_4713',44,96,15),
 (10136,'S18_1129',25,145.79,2),
 (10136,'S18_1984',36,146.52,1),
 (10136,'S18_3232',41,203.21,3),
 (10137,'S18_1589',44,99.55,2),
 (10137,'S18_2870',37,117.48,3),
 (10137,'S18_3685',31,165.3,4),
 (10137,'S24_1628',26,49.81,1),
 (10138,'S18_1749',33,161.5,6),
 (10138,'S18_2248',22,48.43,5),
 (10138,'S18_2325',38,108.06,3),
 (10138,'S18_4409',47,100.31,7),
 (10138,'S18_4933',23,66.99,8),
 (10138,'S24_1046',45,84.51,12),
 (10138,'S24_1937',22,29.21,2),
 (10138,'S24_2022',33,43.01,1),
 (10138,'S24_2766',28,104.5,10),
 (10138,'S24_2887',30,138.58,9),
 (10138,'S24_3191',49,90.75,11),
 (10138,'S24_3432',21,118.86,13),
 (10138,'S24_3969',29,38.16,4),
 (10139,'S18_1342',31,102.74,7),
 (10139,'S18_1367',49,43.13,6),
 (10139,'S18_2795',41,194.06,8),
 (10139,'S18_2949',46,120.56,1),
 (10139,'S18_2957',20,71.2,3),
 (10139,'S18_3136',20,90.06,2),
 (10139,'S18_3320',30,103.18,5),
 (10139,'S24_4258',29,112.97,4),
 (10140,'S10_1949',37,199.3,11),
 (10140,'S10_4962',26,122.62,4),
 (10140,'S12_1666',38,127.1,8),
 (10140,'S18_1097',32,130.67,10),
 (10140,'S18_2432',46,61.99,2),
 (10140,'S18_4600',40,115.03,5),
 (10140,'S18_4668',29,43.27,9),
 (10140,'S24_2300',47,108.62,1),
 (10140,'S32_1268',26,108.83,3),
 (10140,'S32_3522',28,60.76,7),
 (10140,'S700_2824',36,114.3,6),
 (10141,'S12_4473',21,101.91,5),
 (10141,'S18_2238',39,152.27,4),
 (10141,'S18_2319',47,133.78,8),
 (10141,'S18_3232',34,142.25,9),
 (10141,'S24_1444',20,54.33,2),
 (10141,'S24_2840',21,42.43,6),
 (10141,'S24_4048',40,94.62,1),
 (10141,'S32_2509',24,45.99,7),
 (10141,'S50_1392',44,125.01,3),
 (10142,'S12_1108',33,243.13,12),
 (10142,'S12_3148',33,151.08,13),
 (10142,'S12_3891',46,205.89,11),
 (10142,'S18_3140',47,128.39,8),
 (10142,'S18_3259',22,97.81,10),
 (10142,'S18_4027',24,157.98,15),
 (10142,'S18_4522',24,70.22,7),
 (10142,'S24_2011',33,102,6),
 (10142,'S24_3151',49,98.25,1),
 (10142,'S32_3207',42,74.57,16),
 (10142,'S50_1514',42,49.79,14),
 (10142,'S700_1138',41,64,2),
 (10142,'S700_1938',43,84.01,9),
 (10142,'S700_3505',21,111.19,3),
 (10142,'S700_3962',38,85.41,4),
 (10142,'S72_3212',39,44.23,5),
 (10143,'S10_4757',49,114.24,15),
 (10143,'S18_1662',32,164,7),
 (10143,'S18_3029',46,74.84,13),
 (10143,'S18_3856',34,101.64,12),
 (10143,'S24_2841',27,60.97,8),
 (10143,'S24_3420',33,77.59,9),
 (10143,'S24_3816',23,80.51,14),
 (10143,'S24_3949',28,66.19,6),
 (10143,'S50_1341',34,36.66,1),
 (10143,'S700_1691',36,109.61,2),
 (10143,'S700_2047',26,100.48,11),
 (10143,'S700_2466',26,82.77,4),
 (10143,'S700_2610',31,85.29,16),
 (10143,'S700_3167',28,96,3),
 (10143,'S700_4002',34,85.87,5),
 (10143,'S72_1253',37,50.65,10),
 (10144,'S32_4289',20,81.86,1),
 (10145,'S10_1678',45,83.26,6),
 (10145,'S10_2016',37,140.35,9),
 (10145,'S10_4698',33,156.86,8),
 (10145,'S12_2823',49,170.2,5),
 (10145,'S18_2581',30,85.32,14),
 (10145,'S18_2625',30,49.67,10),
 (10145,'S24_1578',43,95.8,7),
 (10145,'S24_1785',40,87.54,16),
 (10145,'S24_2000',47,83.03,11),
 (10145,'S24_2360',27,60.95,3),
 (10145,'S24_4278',33,84.77,15),
 (10145,'S32_1374',33,93.9,12),
 (10145,'S32_2206',31,35.8,1),
 (10145,'S32_4485',27,120.42,4),
 (10145,'S50_4713',38,81.36,2),
 (10145,'S700_2834',20,137.63,13),
 (10146,'S18_3782',47,67.14,2),
 (10146,'S18_4721',29,153.26,1),
 (10147,'S12_1099',48,192.62,7),
 (10147,'S12_3380',31,112.74,5),
 (10147,'S12_3990',21,63.84,8),
 (10147,'S12_4675',33,97.89,4),
 (10147,'S18_1889',26,82.39,3),
 (10147,'S18_3278',36,86.04,10),
 (10147,'S18_3482',37,119.06,9),
 (10147,'S24_2972',25,42.67,1),
 (10147,'S24_3371',30,68.58,6),
 (10147,'S24_3856',23,126.39,2),
 (10147,'S24_4620',31,64.67,11),
 (10148,'S18_1129',23,117.48,13),
 (10148,'S18_1589',47,124.44,9),
 (10148,'S18_1984',25,169.28,12),
 (10148,'S18_2870',27,130.68,10),
 (10148,'S18_3232',32,169.34,14),
 (10148,'S18_3685',28,129.98,11),
 (10148,'S18_4409',34,105.83,1),
 (10148,'S18_4933',29,81.25,2),
 (10148,'S24_1046',25,60.26,6),
 (10148,'S24_1628',47,56.85,8),
 (10148,'S24_2766',21,73.6,4),
 (10148,'S24_2887',34,129.18,3),
 (10148,'S24_3191',31,73.62,5),
 (10148,'S24_3432',27,128.5,7),
 (10149,'S18_1342',50,118.15,4),
 (10149,'S18_1367',30,58.22,3),
 (10149,'S18_1749',34,158.1,11),
 (10149,'S18_2248',24,62.36,10),
 (10149,'S18_2325',33,150.01,8),
 (10149,'S18_2795',23,183.94,5),
 (10149,'S18_3320',42,94.25,2),
 (10149,'S24_1937',36,33.19,7),
 (10149,'S24_2022',49,49.28,6),
 (10149,'S24_3969',26,38.98,9),
 (10149,'S24_4258',20,90.57,1),
 (10150,'S10_1949',45,244.3,8),
 (10150,'S10_4962',20,159.56,1),
 (10150,'S12_1666',30,136.67,5),
 (10150,'S18_1097',34,136.5,7),
 (10150,'S18_2949',47,91.18,9),
 (10150,'S18_2957',30,49.97,11),
 (10150,'S18_3136',26,107.86,10),
 (10150,'S18_4600',49,131.98,2),
 (10150,'S18_4668',30,42.76,6),
 (10150,'S32_3522',49,58.18,4),
 (10150,'S700_2824',20,105.2,3),
 (10151,'S12_4473',24,138.65,3),
 (10151,'S18_2238',43,165.37,2),
 (10151,'S18_2319',49,110.46,6),
 (10151,'S18_2432',39,69.28,9),
 (10151,'S18_3232',21,177.81,7),
 (10151,'S24_2300',42,121.4,8),
 (10151,'S24_2840',30,40.31,4),
 (10151,'S32_1268',27,113.65,10),
 (10151,'S32_2509',41,63.85,5),
 (10151,'S50_1392',26,123.85,1),
 (10152,'S18_4027',35,129.26,1),
 (10152,'S24_1444',25,65.31,4),
 (10152,'S24_4048',23,121.83,3),
 (10152,'S32_3207',33,50.95,2),
 (10153,'S12_1108',20,245.2,11),
 (10153,'S12_3148',42,128.42,12),
 (10153,'S12_3891',49,143.61,10),
 (10153,'S18_3140',31,117.47,7),
 (10153,'S18_3259',29,88.74,9),
 (10153,'S18_4522',22,83.38,6),
 (10153,'S24_2011',40,136.41,5),
 (10153,'S50_1514',31,57.41,13),
 (10153,'S700_1138',43,64.67,1),
 (10153,'S700_1938',31,87.48,8),
 (10153,'S700_3505',50,88.15,2),
 (10153,'S700_3962',20,110.23,3),
 (10153,'S72_3212',50,60.06,4),
 (10154,'S24_3151',31,91.17,2),
 (10154,'S700_2610',36,64.33,1),
 (10155,'S10_4757',32,141.44,13),
 (10155,'S18_1662',38,171.88,5),
 (10155,'S18_3029',44,79.14,11),
 (10155,'S18_3856',29,124.93,10),
 (10155,'S24_2841',23,72.62,6),
 (10155,'S24_3420',34,55.89,7),
 (10155,'S24_3816',37,67.93,12),
 (10155,'S24_3949',44,77.11,4),
 (10155,'S700_2047',32,91.43,9),
 (10155,'S700_2466',20,117.67,2),
 (10155,'S700_3167',43,86.4,1),
 (10155,'S700_4002',44,85.87,3),
 (10155,'S72_1253',34,49.16,8),
 (10156,'S50_1341',20,41.02,1),
 (10156,'S700_1691',48,103.21,2),
 (10157,'S18_2581',33,78.57,3),
 (10157,'S24_1785',40,102.85,5),
 (10157,'S24_4278',33,86.22,4),
 (10157,'S32_1374',34,118.87,1),
 (10157,'S32_4289',28,74.98,6),
 (10157,'S700_2834',48,124.58,2),
 (10158,'S24_2000',22,67.03,1),
 (10159,'S10_1678',49,106.23,14),
 (10159,'S10_2016',37,135.59,17),
 (10159,'S10_4698',22,187.85,16),
 (10159,'S12_1099',41,202.35,2),
 (10159,'S12_2823',38,164.18,13),
 (10159,'S12_3990',24,73.42,3),
 (10159,'S18_2625',42,51.48,18),
 (10159,'S18_3278',21,81.21,5),
 (10159,'S18_3482',25,145.52,4),
 (10159,'S18_3782',21,64.66,8),
 (10159,'S18_4721',32,144.34,7),
 (10159,'S24_1578',44,121.72,15),
 (10159,'S24_2360',27,80.34,11),
 (10159,'S24_3371',50,69.8,1),
 (10159,'S24_4620',23,67.1,6),
 (10159,'S32_2206',35,35.4,9),
 (10159,'S32_4485',23,102.05,12),
 (10159,'S50_4713',31,71.6,10),
 (10160,'S12_3380',46,115.09,6),
 (10160,'S12_4675',50,103.64,5),
 (10160,'S18_1889',38,88.55,4),
 (10160,'S18_3232',20,199.82,1),
 (10160,'S24_2972',42,37,2),
 (10160,'S24_3856',35,136.22,3),
 (10161,'S18_1129',28,134.46,12),
 (10161,'S18_1589',43,143.11,8),
 (10161,'S18_1984',48,128.03,11),
 (10161,'S18_2870',23,138.6,9),
 (10161,'S18_3685',36,154,10),
 (10161,'S18_4933',25,80.54,1),
 (10161,'S24_1046',37,72.76,5),
 (10161,'S24_1628',23,53.33,7),
 (10161,'S24_2766',20,107.23,3),
 (10161,'S24_2887',25,110.39,2),
 (10161,'S24_3191',20,77.05,4),
 (10161,'S24_3432',30,104.94,6),
 (10162,'S18_1342',48,91.44,2),
 (10162,'S18_1367',45,51.21,1),
 (10162,'S18_1749',29,178.5,9),
 (10162,'S18_2248',27,69.62,8),
 (10162,'S18_2325',38,113.15,6),
 (10162,'S18_2795',48,150.19,3),
 (10162,'S18_4409',39,100.31,10),
 (10162,'S24_1937',37,27.22,5),
 (10162,'S24_2022',43,36.29,4),
 (10162,'S24_3969',37,38.98,7),
 (10163,'S10_1949',21,231.44,1),
 (10163,'S18_2949',31,107.39,2),
 (10163,'S18_2957',48,69.96,4),
 (10163,'S18_3136',40,122.52,3),
 (10163,'S18_3320',43,116.08,6),
 (10163,'S24_4258',42,91.55,5),
 (10164,'S10_4962',21,168.42,2),
 (10164,'S12_1666',49,133.94,6),
 (10164,'S18_1097',36,99.17,8),
 (10164,'S18_4600',45,111.39,3),
 (10164,'S18_4668',25,53.83,7),
 (10164,'S32_1268',24,109.79,1),
 (10164,'S32_3522',49,54.94,5),
 (10164,'S700_2824',39,81.93,4),
 (10165,'S12_1108',44,195.33,3),
 (10165,'S12_3148',34,143.53,4),
 (10165,'S12_3891',27,205.89,2),
 (10165,'S12_4473',48,142.2,12),
 (10165,'S18_2238',29,173.55,11),
 (10165,'S18_2319',46,130.09,15),
 (10165,'S18_2432',31,71.1,18),
 (10165,'S18_3232',47,186.27,16),
 (10165,'S18_3259',50,106.89,1),
 (10165,'S18_4027',28,119.2,6),
 (10165,'S24_1444',25,69.36,9),
 (10165,'S24_2300',32,145.68,17),
 (10165,'S24_2840',27,31.82,13),
 (10165,'S24_4048',24,99.36,8),
 (10165,'S32_2509',48,45.99,14),
 (10165,'S32_3207',44,53.44,7),
 (10165,'S50_1392',48,94.92,10),
 (10165,'S50_1514',38,66.78,5),
 (10166,'S18_3140',43,161.18,2),
 (10166,'S18_4522',26,73.73,1),
 (10166,'S700_1938',29,103.93,3),
 (10167,'S10_4757',44,134.64,9),
 (10167,'S18_1662',43,134.04,1),
 (10167,'S18_3029',46,73.12,7),
 (10167,'S18_3856',34,105.87,6),
 (10167,'S24_2011',33,115.52,16),
 (10167,'S24_2841',21,69.88,2),
 (10167,'S24_3151',20,79.66,11),
 (10167,'S24_3420',32,63.12,3),
 (10167,'S24_3816',29,83.86,8),
 (10167,'S700_1138',43,75.34,12),
 (10167,'S700_2047',29,101.38,5),
 (10167,'S700_2610',46,70.11,10),
 (10167,'S700_3505',24,117.2,13),
 (10167,'S700_3962',28,107.25,14),
 (10167,'S72_1253',40,41.71,4),
 (10167,'S72_3212',38,48.59,15),
 (10168,'S10_1678',36,96.66,1),
 (10168,'S10_2016',27,135.59,4),
 (10168,'S10_4698',20,209.15,3),
 (10168,'S18_2581',21,70.96,9),
 (10168,'S18_2625',46,61.18,5),
 (10168,'S24_1578',50,114.95,2),
 (10168,'S24_1785',49,131.3,11),
 (10168,'S24_2000',29,75.41,6),
 (10168,'S24_3949',27,73.02,18),
 (10168,'S24_4278',48,78.25,10),
 (10168,'S32_1374',28,115.87,7),
 (10168,'S32_4289',31,73.61,12),
 (10168,'S50_1341',48,51.93,13),
 (10168,'S700_1691',28,98.65,14),
 (10168,'S700_2466',31,110.69,16),
 (10168,'S700_2834',36,125.77,8),
 (10168,'S700_3167',48,96,15),
 (10168,'S700_4002',39,82.91,17),
 (10169,'S12_1099',30,167.33,2),
 (10169,'S12_2823',35,132.55,13),
 (10169,'S12_3990',36,63.84,3),
 (10169,'S18_3278',32,70.76,5),
 (10169,'S18_3482',36,123.47,4),
 (10169,'S18_3782',38,68.39,8),
 (10169,'S18_4721',33,148.8,7),
 (10169,'S24_2360',38,74.11,11),
 (10169,'S24_3371',34,50.21,1),
 (10169,'S24_4620',24,94.58,6),
 (10169,'S32_2206',26,39.83,9),
 (10169,'S32_4485',34,115.32,12),
 (10169,'S50_4713',48,80.55,10),
 (10170,'S12_3380',47,116.27,4),
 (10170,'S12_4675',41,107.1,3),
 (10170,'S18_1889',20,63.14,2),
 (10170,'S24_3856',34,112.34,1),
 (10171,'S18_1129',35,128.8,2),
 (10171,'S18_1984',35,133.72,1),
 (10171,'S18_3232',39,140.55,3),
 (10171,'S24_2972',36,35.49,4),
 (10172,'S18_1589',42,118.22,6),
 (10172,'S18_2870',39,154.44,7),
 (10172,'S18_3685',48,114.44,8),
 (10172,'S24_1046',32,75.69,3),
 (10172,'S24_1628',34,42.76,5),
 (10172,'S24_2766',22,74.51,1),
 (10172,'S24_3191',24,81.33,2),
 (10172,'S24_3432',22,98.51,4),
 (10173,'S18_1342',43,117.12,6),
 (10173,'S18_1367',48,44.21,5),
 (10173,'S18_1749',24,146.2,13),
 (10173,'S18_2248',26,57.51,12),
 (10173,'S18_2325',31,144.93,10),
 (10173,'S18_2795',22,156.94,7),
 (10173,'S18_2957',28,53.72,2),
 (10173,'S18_3136',31,89.01,1),
 (10173,'S18_3320',29,95.24,4),
 (10173,'S18_4409',21,75.46,14),
 (10173,'S18_4933',39,71.98,15),
 (10173,'S24_1937',31,31.53,9),
 (10173,'S24_2022',27,41.22,8),
 (10173,'S24_2887',23,118.61,16),
 (10173,'S24_3969',35,33.23,11),
 (10173,'S24_4258',22,116.87,3),
 (10174,'S10_1949',34,235.73,4),
 (10174,'S12_1666',43,158.54,1),
 (10174,'S18_1097',48,93.34,3),
 (10174,'S18_2949',46,121.57,5),
 (10174,'S18_4668',49,44.78,2),
 (10175,'S10_4962',33,162.51,9),
 (10175,'S12_4473',26,136.28,1),
 (10175,'S18_2319',48,122.73,4),
 (10175,'S18_2432',41,69.28,7),
 (10175,'S18_3232',29,152.41,5),
 (10175,'S18_4600',47,108.97,10),
 (10175,'S24_2300',28,106.07,6),
 (10175,'S24_2840',37,31.12,2),
 (10175,'S32_1268',22,110.76,8),
 (10175,'S32_2509',50,63.31,3),
 (10175,'S32_3522',29,74.98,12),
 (10175,'S700_2824',42,85.98,11),
 (10176,'S12_1108',33,226.5,2),
 (10176,'S12_3148',47,178.27,3),
 (10176,'S12_3891',50,157.45,1),
 (10176,'S18_2238',20,183.38,10),
 (10176,'S18_4027',36,153.67,5),
 (10176,'S24_1444',27,68.78,8),
 (10176,'S24_4048',29,100.54,7),
 (10176,'S32_3207',22,64,6),
 (10176,'S50_1392',23,135.43,9),
 (10176,'S50_1514',38,64.44,4),
 (10177,'S18_3140',23,159.81,9),
 (10177,'S18_3259',29,105.88,11),
 (10177,'S18_4522',35,74.6,8),
 (10177,'S24_2011',50,121.66,7),
 (10177,'S24_3151',45,72.58,2),
 (10177,'S700_1138',24,76,3),
 (10177,'S700_1938',31,88.34,10),
 (10177,'S700_2610',32,76.62,1),
 (10177,'S700_3505',44,92.16,4),
 (10177,'S700_3962',24,105.27,5),
 (10177,'S72_3212',40,50.23,6),
 (10178,'S10_4757',24,145.52,12),
 (10178,'S18_1662',42,154.54,4),
 (10178,'S18_3029',41,81.72,10),
 (10178,'S18_3856',48,112.22,9),
 (10178,'S24_2841',34,80.84,5),
 (10178,'S24_3420',27,73.64,6),
 (10178,'S24_3816',21,72.12,11),
 (10178,'S24_3949',30,72.33,3),
 (10178,'S700_2047',34,96.86,8),
 (10178,'S700_2466',22,87.75,1),
 (10178,'S700_4002',45,76.25,2),
 (10178,'S72_1253',45,51.15,7),
 (10179,'S18_2581',24,78.57,3),
 (10179,'S24_1785',47,124.74,5),
 (10179,'S24_4278',27,84.77,4),
 (10179,'S32_1374',45,119.87,1),
 (10179,'S32_4289',24,72.23,6),
 (10179,'S50_1341',34,42.77,7),
 (10179,'S700_1691',23,107.78,8),
 (10179,'S700_2834',25,105.6,2),
 (10179,'S700_3167',39,68.8,9),
 (10180,'S10_1678',29,86.13,9),
 (10180,'S10_2016',42,111.8,12),
 (10180,'S10_4698',41,216.9,11),
 (10180,'S12_2823',40,168.69,8),
 (10180,'S18_2625',25,64.2,13),
 (10180,'S18_3782',21,50.36,3),
 (10180,'S18_4721',44,126.48,2),
 (10180,'S24_1578',48,111.57,10),
 (10180,'S24_2000',28,68.55,14),
 (10180,'S24_2360',35,72.03,6),
 (10180,'S24_4620',28,71.14,1),
 (10180,'S32_2206',34,45.46,4),
 (10180,'S32_4485',22,114.3,7),
 (10180,'S50_4713',21,93.56,5),
 (10181,'S12_1099',27,200.41,14),
 (10181,'S12_3380',28,102.17,12),
 (10181,'S12_3990',20,81.4,15),
 (10181,'S12_4675',36,124.37,11),
 (10181,'S18_1129',44,123.14,6),
 (10181,'S18_1589',42,129.42,2),
 (10181,'S18_1889',22,73.92,10),
 (10181,'S18_1984',21,156.48,5),
 (10181,'S18_2870',27,143.88,3),
 (10181,'S18_3232',45,140.55,7),
 (10181,'S18_3278',30,82.82,17),
 (10181,'S18_3482',22,154.34,16),
 (10181,'S18_3685',39,148.34,4),
 (10181,'S24_1628',34,53.83,1),
 (10181,'S24_2972',37,42.67,8),
 (10181,'S24_3371',23,65.52,13),
 (10181,'S24_3856',25,154.47,9),
 (10182,'S18_1342',25,87.33,3),
 (10182,'S18_1367',32,54.45,2),
 (10182,'S18_1749',44,171.7,10),
 (10182,'S18_2248',38,61.15,9),
 (10182,'S18_2325',20,110.6,7),
 (10182,'S18_2795',21,145.13,4),
 (10182,'S18_3320',33,86.31,1),
 (10182,'S18_4409',36,109.52,11),
 (10182,'S18_4933',44,69.84,12),
 (10182,'S24_1046',47,74.22,16),
 (10182,'S24_1937',39,36.84,6),
 (10182,'S24_2022',31,36.74,5),
 (10182,'S24_2766',36,73.6,14),
 (10182,'S24_2887',20,119.79,13),
 (10182,'S24_3191',33,94.17,15),
 (10182,'S24_3432',49,127.43,17),
 (10182,'S24_3969',23,42.26,8),
 (10183,'S10_1949',23,233.59,8),
 (10183,'S10_4962',28,122.62,1),
 (10183,'S12_1666',41,150.34,5),
 (10183,'S18_1097',21,96.84,7),
 (10183,'S18_2949',37,89.15,9),
 (10183,'S18_2957',39,68.08,11),
 (10183,'S18_3136',22,113.1,10),
 (10183,'S18_4600',21,116.24,2),
 (10183,'S18_4668',40,49.3,6),
 (10183,'S24_4258',47,107.13,12),
 (10183,'S32_3522',49,64.64,4),
 (10183,'S700_2824',23,86.99,3),
 (10184,'S12_4473',37,122.06,6),
 (10184,'S18_2238',46,160.46,5),
 (10184,'S18_2319',46,130.09,9),
 (10184,'S18_2432',44,60.16,12),
 (10184,'S18_3232',28,157.49,10),
 (10184,'S24_1444',31,60.11,3),
 (10184,'S24_2300',24,145.68,11),
 (10184,'S24_2840',42,31.82,7),
 (10184,'S24_4048',49,118.28,2),
 (10184,'S32_1268',46,100.16,13),
 (10184,'S32_2509',33,62.77,8),
 (10184,'S32_3207',48,50.95,1),
 (10184,'S50_1392',45,109.96,4),
 (10185,'S12_1108',21,184.94,13),
 (10185,'S12_3148',33,122.37,14),
 (10185,'S12_3891',43,183.4,12),
 (10185,'S18_3140',28,122.93,9),
 (10185,'S18_3259',49,80.67,11),
 (10185,'S18_4027',39,130.69,16),
 (10185,'S18_4522',47,77.24,8),
 (10185,'S24_2011',30,105.69,7),
 (10185,'S24_3151',33,74.35,2),
 (10185,'S50_1514',20,48.62,15),
 (10185,'S700_1138',21,54,3),
 (10185,'S700_1938',30,94.4,10),
 (10185,'S700_2610',39,57.82,1),
 (10185,'S700_3505',37,105.18,4),
 (10185,'S700_3962',22,79.45,5),
 (10185,'S72_3212',28,64.43,6),
 (10186,'S10_4757',26,148.24,9),
 (10186,'S18_1662',32,187.65,1),
 (10186,'S18_3029',32,89.46,7),
 (10186,'S18_3856',46,106.93,6),
 (10186,'S24_2841',22,69.2,2),
 (10186,'S24_3420',21,69.04,3),
 (10186,'S24_3816',36,85.54,8),
 (10186,'S700_2047',24,99.57,5),
 (10186,'S72_1253',28,52.14,4),
 (10187,'S18_2581',45,93.77,1),
 (10187,'S24_1785',46,95.2,3),
 (10187,'S24_3949',43,58,10),
 (10187,'S24_4278',33,59.41,2),
 (10187,'S32_4289',31,60.54,4),
 (10187,'S50_1341',41,38.84,5),
 (10187,'S700_1691',34,92.25,6),
 (10187,'S700_2466',44,105.7,8),
 (10187,'S700_3167',34,88,7),
 (10187,'S700_4002',44,71.81,9),
 (10188,'S10_1678',48,114.84,1),
 (10188,'S10_2016',38,96.34,4),
 (10188,'S10_4698',45,193.66,3),
 (10188,'S18_2625',32,65.42,5),
 (10188,'S24_1578',25,101.43,2),
 (10188,'S24_2000',40,91.4,6),
 (10188,'S32_1374',44,98.89,7),
 (10188,'S700_2834',29,136.45,8),
 (10189,'S12_2823',28,161.16,1),
 (10190,'S24_2360',42,76.19,3),
 (10190,'S32_2206',46,32.99,1),
 (10190,'S32_4485',42,85.72,4),
 (10190,'S50_4713',40,66.72,2),
 (10191,'S12_1099',21,182.9,3),
 (10191,'S12_3380',40,139.75,1),
 (10191,'S12_3990',30,64.64,4),
 (10191,'S18_3278',36,94.88,6),
 (10191,'S18_3482',23,148.46,5),
 (10191,'S18_3782',43,72.74,9),
 (10191,'S18_4721',32,132.43,8),
 (10191,'S24_3371',48,60.01,2),
 (10191,'S24_4620',44,66.29,7),
 (10192,'S12_4675',27,131.28,16),
 (10192,'S18_1129',22,150.03,11),
 (10192,'S18_1589',29,146.84,7),
 (10192,'S18_1889',45,90.86,15),
 (10192,'S18_1984',47,157.9,10),
 (10192,'S18_2870',38,130.68,8),
 (10192,'S18_3232',26,150.71,12),
 (10192,'S18_3685',45,118.68,9),
 (10192,'S24_1046',37,69.82,4),
 (10192,'S24_1628',47,53.83,6),
 (10192,'S24_2766',46,83.6,2),
 (10192,'S24_2887',23,132.71,1),
 (10192,'S24_2972',30,30.59,13),
 (10192,'S24_3191',32,72.77,3),
 (10192,'S24_3432',46,121,5),
 (10192,'S24_3856',45,140.43,14),
 (10193,'S18_1342',28,110.96,7),
 (10193,'S18_1367',46,53.37,6),
 (10193,'S18_1749',21,149.6,14),
 (10193,'S18_2248',42,59.33,13),
 (10193,'S18_2325',44,105.52,11),
 (10193,'S18_2795',22,167.06,8),
 (10193,'S18_2949',28,93.21,1),
 (10193,'S18_2957',24,51.84,3),
 (10193,'S18_3136',23,120.43,2),
 (10193,'S18_3320',32,79.37,5),
 (10193,'S18_4409',24,97.55,15),
 (10193,'S18_4933',25,76.26,16),
 (10193,'S24_1937',26,29.21,10),
 (10193,'S24_2022',20,50.62,9),
 (10193,'S24_3969',22,41.03,12),
 (10193,'S24_4258',20,113.95,4),
 (10194,'S10_1949',42,173.58,11),
 (10194,'S10_4962',26,163.99,4),
 (10194,'S12_1666',38,129.84,8),
 (10194,'S18_1097',21,93.34,10),
 (10194,'S18_2432',45,70.49,2),
 (10194,'S18_4600',32,133.19,5),
 (10194,'S18_4668',41,44.78,9),
 (10194,'S24_2300',49,117.57,1),
 (10194,'S32_1268',37,97.27,3),
 (10194,'S32_3522',39,54.94,7),
 (10194,'S700_2824',26,89.01,6),
 (10195,'S12_4473',49,131.54,6),
 (10195,'S18_2238',27,189.93,5),
 (10195,'S18_2319',35,103.09,9),
 (10195,'S18_3232',50,152.41,10),
 (10195,'S24_1444',44,66.47,3),
 (10195,'S24_2840',32,28.29,7),
 (10195,'S24_4048',34,108.82,2),
 (10195,'S32_2509',32,43.29,8),
 (10195,'S32_3207',33,54.68,1),
 (10195,'S50_1392',49,105.33,4),
 (10196,'S12_1108',47,189.1,5),
 (10196,'S12_3148',24,158.63,6),
 (10196,'S12_3891',38,190.32,4),
 (10196,'S18_3140',49,140.69,1),
 (10196,'S18_3259',35,101.85,3),
 (10196,'S18_4027',27,168.04,8),
 (10196,'S50_1514',46,62.09,7),
 (10196,'S700_1938',50,94.4,2),
 (10197,'S10_4757',45,118.32,6),
 (10197,'S18_3029',46,87.74,4),
 (10197,'S18_3856',22,115.4,3),
 (10197,'S18_4522',50,101.81,14),
 (10197,'S24_2011',41,110.6,13),
 (10197,'S24_3151',47,83.2,8),
 (10197,'S24_3816',22,86.38,5),
 (10197,'S700_1138',23,64.67,9),
 (10197,'S700_2047',24,90.52,2),
 (10197,'S700_2610',50,78.79,7),
 (10197,'S700_3505',27,92.16,10),
 (10197,'S700_3962',35,93.35,11),
 (10197,'S72_1253',29,41.71,1),
 (10197,'S72_3212',42,50.23,12),
 (10198,'S18_1662',42,178.19,4),
 (10198,'S24_2841',48,67.82,5),
 (10198,'S24_3420',27,71.67,6),
 (10198,'S24_3949',43,66.19,3),
 (10198,'S700_2466',42,113.68,1),
 (10198,'S700_4002',40,63.67,2),
 (10199,'S50_1341',29,38.4,1),
 (10199,'S700_1691',48,83.12,2),
 (10199,'S700_3167',38,82.4,3),
 (10200,'S18_2581',28,92.93,3),
 (10200,'S24_1785',33,98.48,5),
 (10200,'S24_4278',39,72.45,4),
 (10200,'S32_1374',35,109.88,1),
 (10200,'S32_4289',27,67.41,6),
 (10200,'S700_2834',39,102.04,2),
 (10201,'S10_1678',22,98.57,2),
 (10201,'S10_2016',24,126.08,5),
 (10201,'S10_4698',49,164.61,4),
 (10201,'S12_2823',25,161.16,1),
 (10201,'S18_2625',30,64.81,6),
 (10201,'S24_1578',39,111.57,3),
 (10201,'S24_2000',25,73.88,7),
 (10202,'S18_3782',30,54.71,3),
 (10202,'S18_4721',43,136.9,2),
 (10202,'S24_2360',50,69.26,6),
 (10202,'S24_4620',50,87.31,1),
 (10202,'S32_2206',27,44.25,4),
 (10202,'S32_4485',31,102.05,7),
 (10202,'S50_4713',40,89.5,5),
 (10203,'S12_1099',20,196.52,8),
 (10203,'S12_3380',20,112.74,6),
 (10203,'S12_3990',44,82.99,9),
 (10203,'S12_4675',47,110.55,5),
 (10203,'S18_1889',45,85.47,4),
 (10203,'S18_3232',48,172.73,1),
 (10203,'S18_3278',33,86.04,11),
 (10203,'S18_3482',32,160.22,10),
 (10203,'S24_2972',21,37,2),
 (10203,'S24_3371',34,64.9,7),
 (10203,'S24_3856',47,148.86,3),
 (10204,'S18_1129',42,147.2,17),
 (10204,'S18_1589',40,100.8,13),
 (10204,'S18_1749',33,178.5,4),
 (10204,'S18_1984',38,169.28,16),
 (10204,'S18_2248',23,71.44,3),
 (10204,'S18_2325',26,123.32,1),
 (10204,'S18_2870',27,154.44,14),
 (10204,'S18_3685',35,163.88,15),
 (10204,'S18_4409',29,85.59,5),
 (10204,'S18_4933',45,76.26,6),
 (10204,'S24_1046',20,62.47,10),
 (10204,'S24_1628',45,49.81,12),
 (10204,'S24_2766',47,96.32,8),
 (10204,'S24_2887',42,101,7),
 (10204,'S24_3191',40,79.62,9),
 (10204,'S24_3432',48,91.02,11),
 (10204,'S24_3969',39,33.23,2),
 (10205,'S18_1342',36,103.77,2),
 (10205,'S18_1367',48,63.61,1),
 (10205,'S18_2795',40,187.31,3),
 (10205,'S24_1937',32,37.17,5),
 (10205,'S24_2022',24,38.08,4),
 (10206,'S10_1949',47,192.87,6),
 (10206,'S12_1666',28,144.87,3),
 (10206,'S18_1097',34,116.67,5),
 (10206,'S18_2949',37,90.17,7),
 (10206,'S18_2957',28,67.46,9),
 (10206,'S18_3136',30,119.38,8),
 (10206,'S18_3320',28,87.3,11),
 (10206,'S18_4668',21,53.33,4),
 (10206,'S24_4258',33,97.39,10),
 (10206,'S32_3522',36,58.82,2),
 (10206,'S700_2824',33,117.33,1),
 (10207,'S10_4962',31,131.49,15),
 (10207,'S12_4473',34,99.54,7),
 (10207,'S18_2238',44,160.46,6),
 (10207,'S18_2319',43,133.78,10),
 (10207,'S18_2432',37,69.89,13),
 (10207,'S18_3232',25,157.49,11),
 (10207,'S18_4027',40,153.67,1),
 (10207,'S18_4600',47,141.66,16),
 (10207,'S24_1444',49,46.82,4),
 (10207,'S24_2300',46,148.24,12),
 (10207,'S24_2840',42,29.7,8),
 (10207,'S24_4048',28,106.45,3),
 (10207,'S32_1268',49,80.9,14),
 (10207,'S32_2509',27,60.06,9),
 (10207,'S32_3207',45,56.55,2),
 (10207,'S50_1392',28,94.92,5),
 (10208,'S12_1108',46,187.02,13),
 (10208,'S12_3148',26,120.86,14),
 (10208,'S12_3891',20,155.72,12),
 (10208,'S18_3140',24,109.27,9),
 (10208,'S18_3259',48,116.97,11),
 (10208,'S18_4522',45,87.77,8),
 (10208,'S24_2011',35,122.89,7),
 (10208,'S24_3151',20,89.4,2),
 (10208,'S50_1514',30,65.61,15),
 (10208,'S700_1138',38,74.67,3),
 (10208,'S700_1938',40,80.55,10),
 (10208,'S700_2610',46,74.45,1),
 (10208,'S700_3505',37,120.2,4),
 (10208,'S700_3962',33,85.41,5),
 (10208,'S72_3212',42,63.88,6),
 (10209,'S10_4757',39,133.28,8),
 (10209,'S18_3029',28,100.64,6),
 (10209,'S18_3856',20,124.93,5),
 (10209,'S24_2841',43,82.21,1),
 (10209,'S24_3420',36,77.59,2),
 (10209,'S24_3816',22,89.73,7),
 (10209,'S700_2047',33,88.71,4),
 (10209,'S72_1253',48,44.69,3),
 (10210,'S10_2016',23,130.83,2),
 (10210,'S10_4698',34,180.1,1),
 (10210,'S18_1662',31,184.5,17),
 (10210,'S18_2581',50,76.88,7),
 (10210,'S18_2625',40,49.67,3),
 (10210,'S24_1785',27,98.48,9),
 (10210,'S24_2000',30,61.7,4),
 (10210,'S24_3949',29,69.6,16),
 (10210,'S24_4278',40,71,8),
 (10210,'S32_1374',46,79.91,5),
 (10210,'S32_4289',39,59.16,10),
 (10210,'S50_1341',43,41.02,11),
 (10210,'S700_1691',21,78.55,12),
 (10210,'S700_2466',26,99.72,14),
 (10210,'S700_2834',25,112.72,6),
 (10210,'S700_3167',31,86.4,13),
 (10210,'S700_4002',42,70.33,15),
 (10211,'S10_1678',41,114.84,14),
 (10211,'S12_1099',41,182.9,2),
 (10211,'S12_2823',36,132.55,13),
 (10211,'S12_3990',28,92.57,3),
 (10211,'S18_3278',35,78,5),
 (10211,'S18_3482',28,133.76,4),
 (10211,'S18_3782',46,54.09,8),
 (10211,'S18_4721',41,138.38,7),
 (10211,'S24_1578',25,90.16,15),
 (10211,'S24_2360',21,63.72,11),
 (10211,'S24_3371',48,48.98,1),
 (10211,'S24_4620',22,92.16,6),
 (10211,'S32_2206',41,42.24,9),
 (10211,'S32_4485',37,109.19,12),
 (10211,'S50_4713',40,80.55,10),
 (10212,'S12_3380',39,126.84,16),
 (10212,'S12_4675',33,126.68,15),
 (10212,'S18_1129',29,144.37,10),
 (10212,'S18_1589',38,118.22,6),
 (10212,'S18_1889',20,66.99,14),
 (10212,'S18_1984',41,118.07,9),
 (10212,'S18_2870',40,122.76,7),
 (10212,'S18_3232',40,138.86,11),
 (10212,'S18_3685',45,141.28,8),
 (10212,'S24_1046',41,82.31,3),
 (10212,'S24_1628',45,53.33,5),
 (10212,'S24_2766',45,88.14,1),
 (10212,'S24_2972',34,43.42,12),
 (10212,'S24_3191',27,79.62,2),
 (10212,'S24_3432',46,87.81,4),
 (10212,'S24_3856',49,141.83,13),
 (10213,'S18_4409',38,94.79,1),
 (10213,'S18_4933',25,83.39,2),
 (10213,'S24_2887',27,103.35,3),
 (10214,'S18_1749',30,198.9,7),
 (10214,'S18_2248',21,62.96,6),
 (10214,'S18_2325',27,133.49,4),
 (10214,'S18_2795',50,190.69,1),
 (10214,'S24_1937',20,34.19,3),
 (10214,'S24_2022',49,47.94,2),
 (10214,'S24_3969',44,34.88,5),
 (10215,'S10_1949',35,173.58,3),
 (10215,'S18_1097',46,112,2),
 (10215,'S18_1342',27,89.38,10),
 (10215,'S18_1367',33,43.13,9),
 (10215,'S18_2949',49,112.45,4),
 (10215,'S18_2957',31,58.71,6),
 (10215,'S18_3136',49,107.86,5),
 (10215,'S18_3320',41,111.12,8),
 (10215,'S18_4668',46,45.28,1),
 (10215,'S24_4258',39,90.57,7),
 (10216,'S12_1666',43,133.94,1),
 (10217,'S10_4962',48,146.26,4),
 (10217,'S18_2432',35,61.38,2),
 (10217,'S18_4600',38,118.66,5),
 (10217,'S24_2300',28,112.46,1),
 (10217,'S32_1268',21,106.9,3),
 (10217,'S32_3522',39,62.05,7),
 (10217,'S700_2824',31,88,6),
 (10218,'S18_2319',22,121.5,1),
 (10218,'S18_3232',34,135.47,2),
 (10219,'S12_4473',48,101.91,2),
 (10219,'S18_2238',43,196.48,1),
 (10219,'S24_2840',21,40.31,3),
 (10219,'S32_2509',35,55.19,4),
 (10220,'S12_1108',32,224.42,2),
 (10220,'S12_3148',30,157.12,3),
 (10220,'S12_3891',27,186.86,1),
 (10220,'S18_4027',50,165.16,5),
 (10220,'S24_1444',26,56.07,8),
 (10220,'S24_4048',37,136.02,7),
 (10220,'S32_3207',20,52.82,6),
 (10220,'S50_1392',37,107.65,9),
 (10220,'S50_1514',30,68.54,4),
 (10221,'S18_3140',33,133.86,3),
 (10221,'S18_3259',23,80.67,5),
 (10221,'S18_4522',39,89.53,2),
 (10221,'S24_2011',49,138.87,1),
 (10221,'S700_1938',23,97,4),
 (10222,'S10_4757',49,122.4,12),
 (10222,'S18_1662',49,141.92,4),
 (10222,'S18_3029',49,94.62,10),
 (10222,'S18_3856',45,85.75,9),
 (10222,'S24_2841',32,81.53,5),
 (10222,'S24_3151',47,70.81,14),
 (10222,'S24_3420',43,70.35,6),
 (10222,'S24_3816',46,80.51,11),
 (10222,'S24_3949',48,56.64,3),
 (10222,'S700_1138',31,62.67,15),
 (10222,'S700_2047',26,102.29,8),
 (10222,'S700_2466',37,87.75,1),
 (10222,'S700_2610',36,80.95,13),
 (10222,'S700_3505',38,110.19,16),
 (10222,'S700_3962',31,95.34,17),
 (10222,'S700_4002',43,74.03,2),
 (10222,'S72_1253',31,45.69,7),
 (10222,'S72_3212',36,63.34,18),
 (10223,'S10_1678',37,107.18,1),
 (10223,'S10_2016',47,115.37,4),
 (10223,'S10_4698',49,199.47,3),
 (10223,'S18_2581',47,100.53,9),
 (10223,'S18_2625',28,60.57,5),
 (10223,'S24_1578',32,91.29,2),
 (10223,'S24_1785',34,106.14,11),
 (10223,'S24_2000',38,69.31,6),
 (10223,'S24_4278',23,74.62,10),
 (10223,'S32_1374',21,117.87,7),
 (10223,'S32_4289',20,66.04,12),
 (10223,'S50_1341',41,46.26,13),
 (10223,'S700_1691',25,101.39,14),
 (10223,'S700_2834',29,110.34,8),
 (10223,'S700_3167',26,67.2,15),
 (10224,'S12_2823',43,141.58,6),
 (10224,'S18_3782',38,58.44,1),
 (10224,'S24_2360',37,80.34,4),
 (10224,'S32_2206',43,39.43,2),
 (10224,'S32_4485',30,111.23,5),
 (10224,'S50_4713',50,77.29,3),
 (10225,'S12_1099',27,167.33,9),
 (10225,'S12_3380',25,99.82,7),
 (10225,'S12_3990',37,77.41,10),
 (10225,'S12_4675',21,127.83,6),
 (10225,'S18_1129',32,141.54,1),
 (10225,'S18_1889',47,64.68,5),
 (10225,'S18_3232',43,149.02,2),
 (10225,'S18_3278',37,95.69,12),
 (10225,'S18_3482',27,169.04,11),
 (10225,'S18_4721',35,150.29,14),
 (10225,'S24_2972',42,36.63,3),
 (10225,'S24_3371',24,50.21,8),
 (10225,'S24_3856',40,113.75,4),
 (10225,'S24_4620',46,70.33,13),
 (10226,'S18_1589',38,109.51,4),
 (10226,'S18_1984',24,162.17,7),
 (10226,'S18_2870',24,134.64,5),
 (10226,'S18_3685',46,159.65,6),
 (10226,'S24_1046',21,60.26,1),
 (10226,'S24_1628',36,43.27,3),
 (10226,'S24_3432',48,92.09,2),
 (10227,'S18_1342',25,118.15,3),
 (10227,'S18_1367',31,48.52,2),
 (10227,'S18_1749',26,142.8,10),
 (10227,'S18_2248',28,50.85,9),
 (10227,'S18_2325',46,152.56,7),
 (10227,'S18_2795',29,192.38,4),
 (10227,'S18_3320',33,111.12,1),
 (10227,'S18_4409',34,104.91,11),
 (10227,'S18_4933',37,57.73,12),
 (10227,'S24_1937',42,29.21,6),
 (10227,'S24_2022',24,48.38,5),
 (10227,'S24_2766',47,88.14,14),
 (10227,'S24_2887',33,131.53,13),
 (10227,'S24_3191',40,79.62,15),
 (10227,'S24_3969',27,43.9,8),
 (10228,'S10_1949',29,222.87,2),
 (10228,'S18_1097',32,105,1),
 (10228,'S18_2949',24,104.35,3),
 (10228,'S18_2957',45,63.71,5),
 (10228,'S18_3136',31,102.63,4),
 (10228,'S24_4258',33,103.23,6),
 (10229,'S10_4962',50,128.53,9),
 (10229,'S12_1666',25,138.04,13),
 (10229,'S12_4473',36,125.61,1),
 (10229,'S18_2319',26,144.82,4),
 (10229,'S18_2432',28,59.55,7),
 (10229,'S18_3232',22,189.66,5),
 (10229,'S18_4600',41,115.03,10),
 (10229,'S18_4668',39,40.25,14),
 (10229,'S24_2300',48,118.84,6),
 (10229,'S24_2840',33,32.88,2),
 (10229,'S32_1268',25,111.72,8),
 (10229,'S32_2509',23,54.11,3),
 (10229,'S32_3522',30,73.04,12),
 (10229,'S700_2824',50,112.28,11),
 (10230,'S12_3148',43,163.17,1),
 (10230,'S18_2238',49,148.99,8),
 (10230,'S18_4027',42,172.34,3),
 (10230,'S24_1444',36,54.33,6),
 (10230,'S24_4048',45,105.27,5),
 (10230,'S32_3207',46,60.9,4),
 (10230,'S50_1392',34,116.91,7),
 (10230,'S50_1514',43,52.14,2),
 (10231,'S12_1108',42,199.49,2),
 (10231,'S12_3891',49,141.88,1),
 (10232,'S18_3140',22,163.91,6),
 (10232,'S18_3259',48,95.8,8),
 (10232,'S18_4522',23,89.53,5),
 (10232,'S24_2011',46,122.89,4),
 (10232,'S700_1938',26,88.34,7),
 (10232,'S700_3505',48,96.16,1),
 (10232,'S700_3962',35,82.43,2),
 (10232,'S72_3212',24,49.69,3),
 (10233,'S24_3151',40,94.71,2),
 (10233,'S700_1138',36,70.67,3),
 (10233,'S700_2610',29,82.4,1),
 (10234,'S10_4757',48,150.96,9),
 (10234,'S18_1662',50,189.23,1),
 (10234,'S18_3029',48,74.84,7),
 (10234,'S18_3856',39,125.99,6),
 (10234,'S24_2841',44,61.66,2),
 (10234,'S24_3420',25,57.2,3),
 (10234,'S24_3816',31,72.96,8),
 (10234,'S700_2047',29,87.8,5),
 (10234,'S72_1253',40,56.12,4),
 (10235,'S18_2581',24,76.03,3),
 (10235,'S24_1785',23,96.29,5),
 (10235,'S24_3949',33,60.05,12),
 (10235,'S24_4278',40,81.14,4),
 (10235,'S32_1374',41,101.89,1),
 (10235,'S32_4289',34,77.73,6),
 (10235,'S50_1341',41,35.35,7),
 (10235,'S700_1691',25,103.21,8),
 (10235,'S700_2466',38,88.75,10),
 (10235,'S700_2834',25,96.11,2),
 (10235,'S700_3167',32,92,9),
 (10235,'S700_4002',34,72.55,11),
 (10236,'S10_2016',22,129.64,1),
 (10236,'S18_2625',23,55.72,2),
 (10236,'S24_2000',36,87.6,3),
 (10237,'S10_1678',23,101.44,7),
 (10237,'S10_4698',39,180.1,9),
 (10237,'S12_2823',32,131.04,6),
 (10237,'S18_3782',26,52.22,1),
 (10237,'S24_1578',20,114.95,8),
 (10237,'S24_2360',26,79.65,4),
 (10237,'S32_2206',26,40.23,2),
 (10237,'S32_4485',27,115.32,5),
 (10237,'S50_4713',20,68.34,3),
 (10238,'S12_1099',28,206.24,3),
 (10238,'S12_3380',29,109.22,1),
 (10238,'S12_3990',20,74.21,4),
 (10238,'S18_3278',41,73.17,6),
 (10238,'S18_3482',49,133.76,5),
 (10238,'S18_4721',44,144.34,8),
 (10238,'S24_3371',47,62.45,2),
 (10238,'S24_4620',22,93.77,7),
 (10239,'S12_4675',21,93.28,5),
 (10239,'S18_1889',46,73.92,4),
 (10239,'S18_3232',47,150.71,1),
 (10239,'S24_2972',20,44.56,2),
 (10239,'S24_3856',29,154.47,3),
 (10240,'S18_1129',41,137.29,3),
 (10240,'S18_1984',37,149.36,2),
 (10240,'S18_3685',37,161.06,1),
 (10241,'S18_1589',21,119.46,11),
 (10241,'S18_1749',41,185.3,2),
 (10241,'S18_2248',33,72.65,1),
 (10241,'S18_2870',44,155.76,12),
 (10241,'S18_4409',42,90.19,3),
 (10241,'S18_4933',30,66.99,4),
 (10241,'S24_1046',22,76.43,8),
 (10241,'S24_1628',21,40.25,10),
 (10241,'S24_2766',47,94.5,6),
 (10241,'S24_2887',28,98.65,5),
 (10241,'S24_3191',26,81.33,7),
 (10241,'S24_3432',27,86.73,9),
 (10242,'S24_3969',46,36.93,1),
 (10243,'S18_2325',47,130.94,2),
 (10243,'S24_1937',33,29.54,1),
 (10244,'S18_1342',40,117.12,7),
 (10244,'S18_1367',20,58.22,6),
 (10244,'S18_2795',43,138.38,8),
 (10244,'S18_2949',30,117.52,1),
 (10244,'S18_2957',24,58.09,3),
 (10244,'S18_3136',29,115.19,2),
 (10244,'S18_3320',36,84.33,5),
 (10244,'S24_2022',39,45.25,9),
 (10244,'S24_4258',40,86.68,4),
 (10245,'S10_1949',34,180.01,9),
 (10245,'S10_4962',28,163.99,2),
 (10245,'S12_1666',38,155.8,6),
 (10245,'S18_1097',29,119,8),
 (10245,'S18_4600',21,113.82,3),
 (10245,'S18_4668',45,59.87,7),
 (10245,'S32_1268',37,111.72,1),
 (10245,'S32_3522',44,69.16,5),
 (10245,'S700_2824',44,105.2,4),
 (10246,'S12_4473',46,110.21,5),
 (10246,'S18_2238',40,163.73,4),
 (10246,'S18_2319',22,98.18,8),
 (10246,'S18_2432',30,61.99,11),
 (10246,'S18_3232',36,198.13,9),
 (10246,'S24_1444',44,52.6,2),
 (10246,'S24_2300',29,121.4,10),
 (10246,'S24_2840',49,36.07,6),
 (10246,'S24_4048',46,137.2,1),
 (10246,'S32_2509',35,48.7,7),
 (10246,'S50_1392',22,133.11,3),
 (10247,'S12_1108',44,241.05,2),
 (10247,'S12_3148',25,175.25,3),
 (10247,'S12_3891',27,153.99,1),
 (10247,'S18_4027',48,140.75,5),
 (10247,'S32_3207',40,49.71,6),
 (10247,'S50_1514',49,63.85,4),
 (10248,'S10_4757',20,145.52,3),
 (10248,'S18_3029',21,73.98,1),
 (10248,'S18_3140',32,118.83,12),
 (10248,'S18_3259',42,121.01,14),
 (10248,'S18_4522',42,75.48,11),
 (10248,'S24_2011',48,145.01,10),
 (10248,'S24_3151',30,101.79,5),
 (10248,'S24_3816',23,76.31,2),
 (10248,'S700_1138',36,71.34,6),
 (10248,'S700_1938',40,103.93,13),
 (10248,'S700_2610',32,75.89,4),
 (10248,'S700_3505',30,108.18,7),
 (10248,'S700_3962',35,90.37,8),
 (10248,'S72_3212',23,65.52,9),
 (10249,'S18_3856',46,121.75,5),
 (10249,'S24_2841',20,67.82,1),
 (10249,'S24_3420',25,69.7,2),
 (10249,'S700_2047',40,95.95,4),
 (10249,'S72_1253',32,57.61,3),
 (10250,'S18_1662',45,181.34,14),
 (10250,'S18_2581',27,98.84,4),
 (10250,'S24_1785',31,88.63,6),
 (10250,'S24_2000',32,87.6,1),
 (10250,'S24_3949',40,75.06,13),
 (10250,'S24_4278',37,74.62,5),
 (10250,'S32_1374',31,105.88,2),
 (10250,'S32_4289',50,61.22,7),
 (10250,'S50_1341',36,51.93,8),
 (10250,'S700_1691',31,91.34,9),
 (10250,'S700_2466',35,111.69,11),
 (10250,'S700_2834',44,137.63,3),
 (10250,'S700_3167',44,67.2,10),
 (10250,'S700_4002',38,62.19,12),
 (10251,'S10_1678',28,113.88,2),
 (10251,'S10_2016',44,130.83,5),
 (10251,'S10_4698',43,164.61,4),
 (10251,'S12_2823',46,164.18,1),
 (10251,'S18_2625',29,61.18,6),
 (10251,'S24_1578',26,101.43,3),
 (10252,'S18_3278',20,76.39,2),
 (10252,'S18_3482',41,164.63,1),
 (10252,'S18_3782',31,52.84,5),
 (10252,'S18_4721',26,136.9,4),
 (10252,'S24_2360',47,65.8,8),
 (10252,'S24_4620',38,87.31,3),
 (10252,'S32_2206',36,48.28,6),
 (10252,'S32_4485',25,113.28,9),
 (10252,'S50_4713',48,72.41,7),
 (10253,'S12_1099',24,163.44,13),
 (10253,'S12_3380',22,109.22,11),
 (10253,'S12_3990',25,90.17,14),
 (10253,'S12_4675',41,119.77,10),
 (10253,'S18_1129',26,117.48,5),
 (10253,'S18_1589',24,140.62,1),
 (10253,'S18_1889',23,83.93,9),
 (10253,'S18_1984',33,135.14,4),
 (10253,'S18_2870',37,139.92,2),
 (10253,'S18_3232',40,169.34,6),
 (10253,'S18_3685',31,129.98,3),
 (10253,'S24_2972',40,42.67,7),
 (10253,'S24_3371',24,52.66,12),
 (10253,'S24_3856',39,132,8),
 (10254,'S18_1749',49,142.8,5),
 (10254,'S18_2248',36,63.57,4),
 (10254,'S18_2325',41,110.6,2),
 (10254,'S18_4409',34,92.95,6),
 (10254,'S18_4933',30,57.73,7),
 (10254,'S24_1046',34,64.67,11),
 (10254,'S24_1628',32,60.37,13),
 (10254,'S24_1937',38,26.88,1),
 (10254,'S24_2766',31,100.87,9),
 (10254,'S24_2887',33,96.3,8),
 (10254,'S24_3191',42,96.74,10),
 (10254,'S24_3432',49,100.66,12),
 (10254,'S24_3969',20,43.49,3),
 (10255,'S18_2795',24,155.25,1),
 (10255,'S24_2022',37,45.7,2),
 (10256,'S18_1342',34,95.55,2),
 (10256,'S18_1367',29,51.75,1),
 (10257,'S18_2949',50,88.14,1),
 (10257,'S18_2957',49,53.72,3),
 (10257,'S18_3136',37,84.82,2),
 (10257,'S18_3320',26,89.29,5),
 (10257,'S24_4258',46,78.89,4),
 (10258,'S10_1949',32,240.02,6),
 (10258,'S12_1666',41,162.64,3),
 (10258,'S18_1097',41,133,5),
 (10258,'S18_4668',21,59.87,4),
 (10258,'S32_3522',20,61.41,2),
 (10258,'S700_2824',45,80.92,1),
 (10259,'S10_4962',26,155.13,12),
 (10259,'S12_4473',46,142.2,4),
 (10259,'S18_2238',30,189.93,3),
 (10259,'S18_2319',34,99.41,7),
 (10259,'S18_2432',30,49.22,10),
 (10259,'S18_3232',27,135.47,8),
 (10259,'S18_4600',41,113.82,13),
 (10259,'S24_1444',28,46.82,1),
 (10259,'S24_2300',47,112.46,9),
 (10259,'S24_2840',31,33.24,5),
 (10259,'S32_1268',45,86.68,11),
 (10259,'S32_2509',40,43.83,6),
 (10259,'S50_1392',29,105.33,2),
 (10260,'S12_1108',46,228.58,5),
 (10260,'S12_3148',30,170.72,6),
 (10260,'S12_3891',44,171.29,4),
 (10260,'S18_3140',32,131.13,1),
 (10260,'S18_3259',29,88.74,3),
 (10260,'S18_4027',23,155.11,8),
 (10260,'S24_4048',23,102.9,10),
 (10260,'S32_3207',27,57.17,9),
 (10260,'S50_1514',21,55.65,7),
 (10260,'S700_1938',33,85.74,2),
 (10261,'S10_4757',27,125.12,1),
 (10261,'S18_4522',20,89.53,9),
 (10261,'S24_2011',36,125.35,8),
 (10261,'S24_3151',22,91.17,3),
 (10261,'S700_1138',34,62,4),
 (10261,'S700_2610',44,68.67,2),
 (10261,'S700_3505',25,88.15,5),
 (10261,'S700_3962',50,81.43,6),
 (10261,'S72_3212',29,50.78,7),
 (10262,'S18_1662',49,134.04,9),
 (10262,'S18_3029',32,84.3,15),
 (10262,'S18_3856',34,120.69,14),
 (10262,'S24_1785',34,97.38,1),
 (10262,'S24_2841',24,67.14,10),
 (10262,'S24_3420',46,70.35,11),
 (10262,'S24_3816',49,87.21,16),
 (10262,'S24_3949',48,61.42,8),
 (10262,'S32_4289',40,79.11,2),
 (10262,'S50_1341',49,37.97,3),
 (10262,'S700_1691',40,84.03,4),
 (10262,'S700_2047',44,94.14,13),
 (10262,'S700_2466',33,90.75,6),
 (10262,'S700_3167',27,76,5),
 (10262,'S700_4002',35,71.07,7),
 (10262,'S72_1253',21,57.11,12),
 (10263,'S10_1678',34,108.14,2),
 (10263,'S10_2016',40,111.8,5),
 (10263,'S10_4698',41,203.34,4),
 (10263,'S12_2823',48,134.05,1),
 (10263,'S18_2581',33,86.17,10),
 (10263,'S18_2625',34,58.75,6),
 (10263,'S24_1578',42,102.56,3),
 (10263,'S24_2000',37,62.46,7),
 (10263,'S24_4278',24,75.35,11),
 (10263,'S32_1374',31,79.91,8),
 (10263,'S700_2834',47,116.28,9),
 (10264,'S18_3782',48,54.71,3),
 (10264,'S18_4721',20,120.53,2),
 (10264,'S24_2360',37,65.1,6),
 (10264,'S24_4620',47,83.27,1),
 (10264,'S32_2206',20,32.59,4),
 (10264,'S32_4485',34,97.97,7),
 (10264,'S50_4713',47,89.5,5),
 (10265,'S18_3278',45,86.84,2),
 (10265,'S18_3482',49,171.98,1),
 (10266,'S12_1099',44,208.19,14),
 (10266,'S12_3380',22,111.57,12),
 (10266,'S12_3990',35,76.61,15),
 (10266,'S12_4675',40,111.71,11),
 (10266,'S18_1129',21,120.31,6),
 (10266,'S18_1589',36,144.35,2),
 (10266,'S18_1889',33,74.69,10),
 (10266,'S18_1984',49,126.6,5),
 (10266,'S18_2870',20,141.24,3),
 (10266,'S18_3232',29,165.95,7),
 (10266,'S18_3685',33,152.58,4),
 (10266,'S24_1628',28,48.3,1),
 (10266,'S24_2972',34,40.4,8),
 (10266,'S24_3371',47,62.45,13),
 (10266,'S24_3856',24,122.17,9),
 (10267,'S18_4933',36,75.55,1),
 (10267,'S24_1046',40,80.1,5),
 (10267,'S24_2766',38,87.24,3),
 (10267,'S24_2887',43,108.04,2),
 (10267,'S24_3191',44,96.74,4),
 (10267,'S24_3432',43,118.86,6),
 (10268,'S18_1342',49,117.12,3),
 (10268,'S18_1367',26,64.69,2),
 (10268,'S18_1749',34,161.5,10),
 (10268,'S18_2248',31,49.04,9),
 (10268,'S18_2325',50,105.52,7),
 (10268,'S18_2795',35,151.88,4),
 (10268,'S18_3320',39,89.29,1),
 (10268,'S18_4409',35,87.43,11),
 (10268,'S24_1937',33,38.83,6),
 (10268,'S24_2022',40,46.14,5),
 (10268,'S24_3969',30,40.62,8),
 (10269,'S18_2957',32,63.08,1),
 (10269,'S24_4258',48,97.39,2),
 (10270,'S10_1949',21,233.59,9),
 (10270,'S10_4962',32,134.44,2),
 (10270,'S12_1666',28,146.24,6),
 (10270,'S18_1097',43,96.84,8),
 (10270,'S18_2949',31,96.24,10),
 (10270,'S18_3136',38,125.66,11),
 (10270,'S18_4600',38,141.66,3),
 (10270,'S18_4668',44,58.36,7),
 (10270,'S32_1268',32,85.72,1),
 (10270,'S32_3522',21,63.35,5),
 (10270,'S700_2824',46,88,4),
 (10271,'S12_4473',31,97.17,5),
 (10271,'S18_2238',50,183.38,4),
 (10271,'S18_2319',50,101.87,8),
 (10271,'S18_2432',25,69.28,11),
 (10271,'S18_3232',20,196.43,9),
 (10271,'S24_1444',45,64.74,2),
 (10271,'S24_2300',43,130.35,10),
 (10271,'S24_2840',38,41.72,6),
 (10271,'S24_4048',22,139.57,1),
 (10271,'S32_2509',35,47.62,7),
 (10271,'S50_1392',34,98.39,3),
 (10272,'S12_1108',35,166.24,2),
 (10272,'S12_3148',27,158.63,3),
 (10272,'S12_3891',39,204.16,1),
 (10272,'S18_4027',25,149.36,5),
 (10272,'S32_3207',45,64.63,6),
 (10272,'S50_1514',43,56.82,4),
 (10273,'S10_4757',30,116.96,4),
 (10273,'S18_3029',34,98.06,2),
 (10273,'S18_3140',40,125.66,13),
 (10273,'S18_3259',47,115.97,15),
 (10273,'S18_3856',50,85.75,1),
 (10273,'S18_4522',33,71.09,12),
 (10273,'S24_2011',22,126.58,11),
 (10273,'S24_3151',27,103.56,6),
 (10273,'S24_3816',48,83.02,3),
 (10273,'S700_1138',21,65.34,7),
 (10273,'S700_1938',21,102.2,14),
 (10273,'S700_2610',42,62.16,5),
 (10273,'S700_3505',40,86.15,8),
 (10273,'S700_3962',26,114.21,9),
 (10273,'S72_3212',37,45.86,10),
 (10274,'S18_1662',41,164,1),
 (10274,'S24_2841',40,65.08,2),
 (10274,'S24_3420',24,72.33,3),
 (10274,'S700_2047',24,90.52,5),
 (10274,'S72_1253',32,58.6,4),
 (10275,'S10_1678',45,92.83,1),
 (10275,'S10_2016',22,132.02,4),
 (10275,'S10_4698',36,191.72,3),
 (10275,'S18_2581',35,90.39,9),
 (10275,'S18_2625',37,63.6,5),
 (10275,'S24_1578',21,102.56,2),
 (10275,'S24_1785',25,95.2,11),
 (10275,'S24_2000',30,79.98,6),
 (10275,'S24_3949',41,81.89,18),
 (10275,'S24_4278',27,62.31,10),
 (10275,'S32_1374',23,81.91,7),
 (10275,'S32_4289',28,63.97,12),
 (10275,'S50_1341',38,45.39,13),
 (10275,'S700_1691',32,89.51,14),
 (10275,'S700_2466',39,114.68,16),
 (10275,'S700_2834',48,132.89,8),
 (10275,'S700_3167',43,73.6,15),
 (10275,'S700_4002',31,72.55,17),
 (10276,'S12_1099',50,192.62,3),
 (10276,'S12_2823',43,120.5,14),
 (10276,'S12_3380',47,116.27,1),
 (10276,'S12_3990',38,83.79,4),
 (10276,'S18_3278',38,69.96,6),
 (10276,'S18_3482',30,130.82,5),
 (10276,'S18_3782',33,50.36,9),
 (10276,'S18_4721',48,119.04,8),
 (10276,'S24_2360',46,75.49,12),
 (10276,'S24_3371',20,61.23,2),
 (10276,'S24_4620',48,75.18,7),
 (10276,'S32_2206',27,36.61,10),
 (10276,'S32_4485',38,113.28,13),
 (10276,'S50_4713',21,70.78,11),
 (10277,'S12_4675',28,111.71,1),
 (10278,'S18_1129',34,137.29,6),
 (10278,'S18_1589',23,113.24,2),
 (10278,'S18_1889',29,90.86,10),
 (10278,'S18_1984',29,129.45,5),
 (10278,'S18_2870',39,110.88,3),
 (10278,'S18_3232',42,152.41,7),
 (10278,'S18_3685',31,132.8,4),
 (10278,'S24_1628',35,45.28,1),
 (10278,'S24_2972',31,38.89,8),
 (10278,'S24_3856',25,126.39,9),
 (10279,'S18_4933',26,60.58,1),
 (10279,'S24_1046',32,74.96,5),
 (10279,'S24_2766',49,79.97,3),
 (10279,'S24_2887',48,116.27,2),
 (10279,'S24_3191',33,71.06,4),
 (10279,'S24_3432',48,128.5,6),
 (10280,'S10_1949',34,235.73,2),
 (10280,'S18_1097',24,116.67,1),
 (10280,'S18_1342',50,104.79,9),
 (10280,'S18_1367',27,57.68,8),
 (10280,'S18_1749',26,141.1,16),
 (10280,'S18_2248',25,62.96,15),
 (10280,'S18_2325',37,128.4,13),
 (10280,'S18_2795',22,202.5,10),
 (10280,'S18_2949',46,111.44,3),
 (10280,'S18_2957',43,68.71,5),
 (10280,'S18_3136',29,103.67,4),
 (10280,'S18_3320',34,102.19,7),
 (10280,'S18_4409',35,105.83,17),
 (10280,'S24_1937',20,28.88,12),
 (10280,'S24_2022',45,47.49,11),
 (10280,'S24_3969',33,41.85,14),
 (10280,'S24_4258',21,78.89,6),
 (10281,'S10_4962',44,159.56,9),
 (10281,'S12_1666',25,117.54,13),
 (10281,'S12_4473',41,127.98,1),
 (10281,'S18_2319',48,120.28,4),
 (10281,'S18_2432',29,57.73,7),
 (10281,'S18_3232',25,167.65,5),
 (10281,'S18_4600',25,99.29,10),
 (10281,'S18_4668',44,59.87,14),
 (10281,'S24_2300',25,111.18,6),
 (10281,'S24_2840',20,40.66,2),
 (10281,'S32_1268',29,82.83,8),
 (10281,'S32_2509',31,55.19,3),
 (10281,'S32_3522',36,77.57,12),
 (10281,'S700_2824',27,85.98,11),
 (10282,'S12_1108',41,172.47,5),
 (10282,'S12_3148',27,161.66,6),
 (10282,'S12_3891',24,157.45,4),
 (10282,'S18_2238',23,140.81,13),
 (10282,'S18_3140',43,155.71,1),
 (10282,'S18_3259',36,115.97,3),
 (10282,'S18_4027',31,150.8,8),
 (10282,'S24_1444',29,46.82,11),
 (10282,'S24_4048',39,123.01,10),
 (10282,'S32_3207',36,59.65,9),
 (10282,'S50_1392',38,113.44,12),
 (10282,'S50_1514',37,66.78,7),
 (10282,'S700_1938',43,86.61,2),
 (10283,'S10_4757',25,119.68,6),
 (10283,'S18_3029',21,98.06,4),
 (10283,'S18_3856',46,125.99,3),
 (10283,'S18_4522',34,105.32,14),
 (10283,'S24_2011',42,126.58,13),
 (10283,'S24_3151',34,92.94,8),
 (10283,'S24_3816',33,72.96,5),
 (10283,'S700_1138',45,78.67,9),
 (10283,'S700_2047',20,94.14,2),
 (10283,'S700_2610',47,65.77,7),
 (10283,'S700_3505',22,88.15,10),
 (10283,'S700_3962',38,89.38,11),
 (10283,'S72_1253',43,57.61,1),
 (10283,'S72_3212',33,51.32,12),
 (10284,'S18_1662',45,127.73,11),
 (10284,'S18_2581',31,71.81,1),
 (10284,'S24_1785',22,105.04,3),
 (10284,'S24_2841',30,73.99,12),
 (10284,'S24_3420',39,71.67,13),
 (10284,'S24_3949',21,55.96,10),
 (10284,'S24_4278',21,71,2),
 (10284,'S32_4289',50,81.86,4),
 (10284,'S50_1341',33,51.93,5),
 (10284,'S700_1691',24,83.12,6),
 (10284,'S700_2466',45,101.71,8),
 (10284,'S700_3167',25,69.6,7),
 (10284,'S700_4002',32,64.41,9),
 (10285,'S10_1678',36,113.88,6),
 (10285,'S10_2016',47,137.97,9),
 (10285,'S10_4698',27,201.41,8),
 (10285,'S12_2823',49,140.08,5),
 (10285,'S18_2625',20,49.06,10),
 (10285,'S24_1578',34,109.32,7),
 (10285,'S24_2000',39,70.08,11),
 (10285,'S24_2360',38,59.56,3),
 (10285,'S32_1374',37,98.89,12),
 (10285,'S32_2206',37,41.03,1),
 (10285,'S32_4485',26,100.01,4),
 (10285,'S50_4713',39,78.92,2),
 (10285,'S700_2834',45,119.84,13),
 (10286,'S18_3782',38,57.2,1),
 (10287,'S12_1099',21,163.44,12),
 (10287,'S12_3380',45,105.7,10),
 (10287,'S12_3990',41,69.43,13),
 (10287,'S12_4675',23,116.31,9),
 (10287,'S18_1129',41,158.52,4),
 (10287,'S18_1889',44,82.39,8),
 (10287,'S18_1984',24,146.52,3),
 (10287,'S18_2870',44,114.84,1),
 (10287,'S18_3232',36,162.57,5),
 (10287,'S18_3278',43,70.76,15),
 (10287,'S18_3482',40,169.04,14),
 (10287,'S18_3685',27,159.65,2),
 (10287,'S18_4721',34,126.48,17),
 (10287,'S24_2972',36,39.65,6),
 (10287,'S24_3371',20,67.97,11),
 (10287,'S24_3856',36,119.37,7),
 (10287,'S24_4620',40,88.12,16),
 (10288,'S18_1589',20,146.84,14),
 (10288,'S18_1749',32,183.6,5),
 (10288,'S18_2248',28,61.75,4),
 (10288,'S18_2325',31,123.32,2),
 (10288,'S18_4409',35,80.99,6),
 (10288,'S18_4933',23,73.41,7),
 (10288,'S24_1046',36,66.14,11),
 (10288,'S24_1628',50,52.32,13),
 (10288,'S24_1937',29,38.17,1),
 (10288,'S24_2766',35,80.87,9),
 (10288,'S24_2887',48,136.23,8),
 (10288,'S24_3191',34,68.49,10),
 (10288,'S24_3432',41,118.86,12),
 (10288,'S24_3969',33,40.62,3),
 (10289,'S18_1342',38,120.21,2),
 (10289,'S18_1367',24,56.07,1),
 (10289,'S18_2795',43,192.38,3),
 (10289,'S24_2022',45,48.38,4),
 (10290,'S18_3320',26,96.23,2),
 (10290,'S24_4258',45,114.92,1),
 (10291,'S10_1949',37,192.87,11),
 (10291,'S10_4962',30,128.53,4),
 (10291,'S12_1666',41,155.8,8),
 (10291,'S18_1097',41,114.34,10),
 (10291,'S18_2432',26,57.73,2),
 (10291,'S18_2949',47,121.57,12),
 (10291,'S18_2957',37,50.59,14),
 (10291,'S18_3136',23,124.62,13),
 (10291,'S18_4600',48,110.18,5),
 (10291,'S18_4668',29,51.82,9),
 (10291,'S24_2300',48,112.46,1),
 (10291,'S32_1268',26,83.79,3),
 (10291,'S32_3522',32,71.75,7),
 (10291,'S700_2824',28,116.32,6),
 (10292,'S12_4473',21,105.47,8),
 (10292,'S18_2238',26,175.19,7),
 (10292,'S18_2319',41,110.46,11),
 (10292,'S18_3232',21,135.47,12),
 (10292,'S18_4027',44,162.29,2),
 (10292,'S24_1444',40,53.75,5),
 (10292,'S24_2840',39,30.06,9),
 (10292,'S24_4048',27,141.94,4),
 (10292,'S32_2509',50,46.53,10),
 (10292,'S32_3207',31,67.73,3),
 (10292,'S50_1392',41,121.54,6),
 (10292,'S50_1514',35,55.07,1),
 (10293,'S12_1108',46,182.86,8),
 (10293,'S12_3148',24,176.76,9),
 (10293,'S12_3891',45,183.4,7),
 (10293,'S18_3140',24,117.47,4),
 (10293,'S18_3259',22,109.92,6),
 (10293,'S18_4522',49,100.94,3),
 (10293,'S24_2011',21,140.09,2),
 (10293,'S700_1938',29,71.89,5),
 (10293,'S72_3212',32,60.06,1),
 (10294,'S700_3962',45,104.28,1),
 (10295,'S10_4757',24,142.8,1),
 (10295,'S24_3151',46,84.97,3),
 (10295,'S700_1138',26,75.34,4),
 (10295,'S700_2610',44,58.55,2),
 (10295,'S700_3505',34,102.17,5),
 (10296,'S18_1662',36,157.69,7),
 (10296,'S18_3029',21,96.34,13),
 (10296,'S18_3856',22,84.7,12),
 (10296,'S24_2841',21,71.25,8),
 (10296,'S24_3420',31,53.92,9),
 (10296,'S24_3816',22,77.15,14),
 (10296,'S24_3949',32,71.65,6),
 (10296,'S50_1341',26,48.44,1),
 (10296,'S700_1691',42,102.3,2),
 (10296,'S700_2047',34,102.29,11),
 (10296,'S700_2466',24,101.71,4),
 (10296,'S700_3167',22,80.8,3),
 (10296,'S700_4002',47,86.62,5),
 (10296,'S72_1253',21,45.19,10),
 (10297,'S18_2581',25,82.79,4),
 (10297,'S24_1785',32,126.93,6),
 (10297,'S24_2000',32,65.51,1),
 (10297,'S24_4278',23,72.45,5),
 (10297,'S32_1374',26,109.88,2),
 (10297,'S32_4289',28,79.8,7),
 (10297,'S700_2834',35,113.9,3),
 (10298,'S10_2016',39,96.34,1),
 (10298,'S18_2625',32,48.46,2),
 (10299,'S10_1678',23,112.93,9),
 (10299,'S10_4698',29,230.46,11),
 (10299,'S12_2823',24,173.21,8),
 (10299,'S18_3782',39,55.95,3),
 (10299,'S18_4721',49,162.19,2),
 (10299,'S24_1578',47,116.08,10),
 (10299,'S24_2360',33,66.49,6),
 (10299,'S24_4620',32,80.84,1),
 (10299,'S32_2206',24,42.24,4),
 (10299,'S32_4485',38,115.32,7),
 (10299,'S50_4713',44,80.55,5),
 (10300,'S12_1099',33,167.33,5),
 (10300,'S12_3380',29,137.4,3),
 (10300,'S12_3990',22,76.61,6),
 (10300,'S12_4675',23,122.07,2),
 (10300,'S18_1889',41,92.4,1),
 (10300,'S18_3278',49,78.8,8),
 (10300,'S18_3482',23,164.63,7),
 (10300,'S24_3371',31,58.78,4),
 (10301,'S18_1129',37,159.94,8),
 (10301,'S18_1589',32,107.02,4),
 (10301,'S18_1984',47,159.32,7),
 (10301,'S18_2870',22,146.52,5),
 (10301,'S18_3232',23,174.42,9),
 (10301,'S18_3685',39,165.3,6),
 (10301,'S24_1046',27,72.02,1),
 (10301,'S24_1628',22,51.32,3),
 (10301,'S24_2972',48,34.36,10),
 (10301,'S24_3432',22,96.37,2),
 (10301,'S24_3856',50,154.47,11),
 (10302,'S18_1749',43,170,1),
 (10302,'S18_4409',38,89.27,2),
 (10302,'S18_4933',23,72.7,3),
 (10302,'S24_2766',49,108.14,5),
 (10302,'S24_2887',45,123.31,4),
 (10302,'S24_3191',48,74.48,6),
 (10303,'S18_2248',46,49.04,2),
 (10303,'S24_3969',24,40.21,1),
 (10304,'S10_1949',47,216.44,6),
 (10304,'S12_1666',39,164,3),
 (10304,'S18_1097',46,98,5),
 (10304,'S18_1342',37,95.55,13),
 (10304,'S18_1367',37,48.52,12),
 (10304,'S18_2325',24,101.7,17),
 (10304,'S18_2795',20,178.88,14),
 (10304,'S18_2949',46,100.3,7),
 (10304,'S18_2957',24,64.96,9),
 (10304,'S18_3136',26,85.87,8),
 (10304,'S18_3320',38,104.17,11),
 (10304,'S18_4668',34,49.3,4),
 (10304,'S24_1937',23,30.2,16),
 (10304,'S24_2022',44,39.42,15),
 (10304,'S24_4258',33,101.29,10),
 (10304,'S32_3522',36,73.04,2),
 (10304,'S700_2824',40,105.2,1),
 (10305,'S10_4962',38,175.81,13),
 (10305,'S12_4473',38,125.61,5),
 (10305,'S18_2238',27,145.72,4),
 (10305,'S18_2319',36,133.78,8),
 (10305,'S18_2432',41,53.48,11),
 (10305,'S18_3232',37,201.51,9),
 (10305,'S18_4600',22,99.29,14),
 (10305,'S24_1444',45,61.85,2),
 (10305,'S24_2300',24,132.9,10),
 (10305,'S24_2840',48,31.47,6),
 (10305,'S24_4048',36,128.93,1),
 (10305,'S32_1268',28,112.68,12),
 (10305,'S32_2509',40,57.9,7),
 (10305,'S50_1392',42,109.96,3),
 (10306,'S12_1108',31,211.96,13),
 (10306,'S12_3148',34,146.55,14),
 (10306,'S12_3891',20,181.67,12),
 (10306,'S18_3140',32,117.47,9),
 (10306,'S18_3259',40,91.76,11),
 (10306,'S18_4027',23,156.55,16),
 (10306,'S18_4522',39,90.4,8),
 (10306,'S24_2011',29,110.6,7),
 (10306,'S24_3151',31,84.08,2),
 (10306,'S32_3207',46,50.33,17),
 (10306,'S50_1514',34,60.34,15),
 (10306,'S700_1138',50,54,3),
 (10306,'S700_1938',38,91.81,10),
 (10306,'S700_2610',43,75.17,1),
 (10306,'S700_3505',32,90.15,4),
 (10306,'S700_3962',30,117.19,5),
 (10306,'S72_3212',35,59.51,6),
 (10307,'S10_4757',22,122.4,9),
 (10307,'S18_1662',39,189.23,1),
 (10307,'S18_3029',31,83.44,7),
 (10307,'S18_3856',48,86.81,6),
 (10307,'S24_2841',25,75.36,2),
 (10307,'S24_3420',22,71.67,3),
 (10307,'S24_3816',22,91.41,8),
 (10307,'S700_2047',34,97.76,5),
 (10307,'S72_1253',34,53.63,4),
 (10308,'S10_2016',34,118.94,2),
 (10308,'S10_4698',20,228.52,1),
 (10308,'S18_2581',27,82.79,7),
 (10308,'S18_2625',34,52.09,3),
 (10308,'S24_1785',31,112.7,9),
 (10308,'S24_2000',47,63.22,4),
 (10308,'S24_3949',43,76.43,16),
 (10308,'S24_4278',44,83.32,8),
 (10308,'S32_1374',24,79.91,5),
 (10308,'S32_4289',46,66.04,10),
 (10308,'S50_1341',47,43.64,11),
 (10308,'S700_1691',21,105.95,12),
 (10308,'S700_2466',35,88.75,14),
 (10308,'S700_2834',31,129.33,6),
 (10308,'S700_3167',21,87.2,13),
 (10308,'S700_4002',39,68.11,15),
 (10309,'S10_1678',41,107.18,5),
 (10309,'S12_2823',26,179.24,4),
 (10309,'S24_1578',21,126.22,6),
 (10309,'S24_2360',24,56.1,2),
 (10309,'S32_4485',50,84.7,3),
 (10309,'S50_4713',28,88.68,1),
 (10310,'S12_1099',33,210.14,10),
 (10310,'S12_3380',24,129.18,8),
 (10310,'S12_3990',49,81.4,11),
 (10310,'S12_4675',25,100.19,7),
 (10310,'S18_1129',37,168.43,2);
INSERT INTO `classicmodels`.`OrderDetail` (`orderNumber`,`productCode`,`quantityOrdered`,`priceEach`,`orderLineNumber`) VALUES 
 (10310,'S18_1889',20,91.63,6),
 (10310,'S18_1984',24,143.67,1),
 (10310,'S18_3232',48,186.27,3),
 (10310,'S18_3278',27,80.41,13),
 (10310,'S18_3482',49,127.88,12),
 (10310,'S18_3782',42,67.14,16),
 (10310,'S18_4721',40,133.92,15),
 (10310,'S24_2972',33,41.91,4),
 (10310,'S24_3371',38,56.94,9),
 (10310,'S24_3856',45,122.17,5),
 (10310,'S24_4620',49,97.01,14),
 (10310,'S32_2206',36,43.05,17),
 (10311,'S18_1589',29,100.8,9),
 (10311,'S18_2870',43,122.76,10),
 (10311,'S18_3685',32,113.02,11),
 (10311,'S18_4409',41,81.91,1),
 (10311,'S18_4933',25,66.99,2),
 (10311,'S24_1046',26,87.45,6),
 (10311,'S24_1628',45,49.3,8),
 (10311,'S24_2766',28,93.6,4),
 (10311,'S24_2887',43,106.87,3),
 (10311,'S24_3191',25,83.04,5),
 (10311,'S24_3432',46,92.09,7),
 (10312,'S10_1949',48,242.16,3),
 (10312,'S18_1097',32,130.67,2),
 (10312,'S18_1342',43,89.38,10),
 (10312,'S18_1367',25,44.21,9),
 (10312,'S18_1749',48,168.3,17),
 (10312,'S18_2248',30,61.15,16),
 (10312,'S18_2325',31,152.56,14),
 (10312,'S18_2795',25,155.25,11),
 (10312,'S18_2949',37,100.3,4),
 (10312,'S18_2957',35,53.72,6),
 (10312,'S18_3136',38,117.29,5),
 (10312,'S18_3320',33,107.15,8),
 (10312,'S18_4668',39,56.85,1),
 (10312,'S24_1937',39,29.54,13),
 (10312,'S24_2022',23,37.63,12),
 (10312,'S24_3969',31,35.29,15),
 (10312,'S24_4258',44,111.02,7),
 (10313,'S10_4962',40,166.95,7),
 (10313,'S12_1666',21,127.1,11),
 (10313,'S18_2319',29,117.82,2),
 (10313,'S18_2432',34,52.87,5),
 (10313,'S18_3232',25,182.89,3),
 (10313,'S18_4600',28,102.92,8),
 (10313,'S24_2300',42,132.9,4),
 (10313,'S32_1268',27,87.64,6),
 (10313,'S32_2509',38,45.45,1),
 (10313,'S32_3522',34,56.24,10),
 (10313,'S700_2824',30,99.13,9),
 (10314,'S12_1108',38,209.88,5),
 (10314,'S12_3148',46,138.99,6),
 (10314,'S12_3891',36,192.05,4),
 (10314,'S12_4473',45,137.46,14),
 (10314,'S18_2238',42,137.53,13),
 (10314,'S18_3140',20,136.59,1),
 (10314,'S18_3259',23,107.9,3),
 (10314,'S18_4027',29,145.06,8),
 (10314,'S24_1444',44,53.18,11),
 (10314,'S24_2840',39,37.13,15),
 (10314,'S24_4048',38,105.27,10),
 (10314,'S32_3207',35,66.49,9),
 (10314,'S50_1392',28,121.54,12),
 (10314,'S50_1514',38,61.51,7),
 (10314,'S700_1938',23,76.22,2),
 (10315,'S18_4522',36,100.06,7),
 (10315,'S24_2011',35,120.43,6),
 (10315,'S24_3151',24,86.74,1),
 (10315,'S700_1138',41,62,2),
 (10315,'S700_3505',31,86.15,3),
 (10315,'S700_3962',37,91.37,4),
 (10315,'S72_3212',40,55.69,5),
 (10316,'S10_4757',33,125.12,17),
 (10316,'S18_1662',27,137.19,9),
 (10316,'S18_3029',21,94.62,15),
 (10316,'S18_3856',47,86.81,14),
 (10316,'S24_1785',25,114.89,1),
 (10316,'S24_2841',34,63.71,10),
 (10316,'S24_3420',47,76.93,11),
 (10316,'S24_3816',25,92.25,16),
 (10316,'S24_3949',30,77.79,8),
 (10316,'S32_4289',24,59.16,2),
 (10316,'S50_1341',34,47.57,3),
 (10316,'S700_1691',34,82.21,4),
 (10316,'S700_2047',45,93.24,13),
 (10316,'S700_2466',23,117.67,6),
 (10316,'S700_2610',48,74.45,18),
 (10316,'S700_3167',48,75.2,5),
 (10316,'S700_4002',44,62.19,7),
 (10316,'S72_1253',34,43.7,12),
 (10317,'S24_4278',35,83.32,1),
 (10318,'S10_1678',46,94.74,1),
 (10318,'S10_2016',45,123.7,4),
 (10318,'S10_4698',37,207.22,3),
 (10318,'S18_2581',31,100.53,9),
 (10318,'S18_2625',42,52.7,5),
 (10318,'S24_1578',48,134.11,2),
 (10318,'S24_2000',26,86.83,6),
 (10318,'S32_1374',47,112.88,7),
 (10318,'S700_2834',50,142.38,8),
 (10319,'S12_2823',30,137.06,9),
 (10319,'S18_3278',46,73.98,1),
 (10319,'S18_3782',44,59.06,4),
 (10319,'S18_4721',45,175.58,3),
 (10319,'S24_2360',31,81.73,7),
 (10319,'S24_4620',43,85.69,2),
 (10319,'S32_2206',29,38.22,5),
 (10319,'S32_4485',22,119.4,8),
 (10319,'S50_4713',45,77.29,6),
 (10320,'S12_1099',31,221.81,3),
 (10320,'S12_3380',35,138.58,1),
 (10320,'S12_3990',38,73.42,4),
 (10320,'S18_3482',25,139.64,5),
 (10320,'S24_3371',26,61.23,2),
 (10321,'S12_4675',24,124.37,15),
 (10321,'S18_1129',41,141.54,10),
 (10321,'S18_1589',44,102.04,6),
 (10321,'S18_1889',37,78.54,14),
 (10321,'S18_1984',25,149.36,9),
 (10321,'S18_2870',27,105.6,7),
 (10321,'S18_3232',33,172.73,11),
 (10321,'S18_3685',28,151.17,8),
 (10321,'S24_1046',30,70.55,3),
 (10321,'S24_1628',48,42.26,5),
 (10321,'S24_2766',30,72.7,1),
 (10321,'S24_2972',37,33.23,12),
 (10321,'S24_3191',39,84.75,2),
 (10321,'S24_3432',21,89.95,4),
 (10321,'S24_3856',26,155.88,13),
 (10322,'S10_1949',40,150.01,1),
 (10322,'S10_4962',46,61.99,8),
 (10322,'S12_1666',27,177.19,9),
 (10322,'S18_1097',22,102.32,10),
 (10322,'S18_1342',43,86.3,14),
 (10322,'S18_1367',41,57.68,5),
 (10322,'S18_2325',50,250.73,6),
 (10322,'S18_2432',35,61.21,11),
 (10322,'S18_2795',36,161.04,2),
 (10322,'S18_2949',33,106.81,12),
 (10322,'S18_2957',41,29.87,13),
 (10322,'S18_3136',48,47.04,7),
 (10322,'S24_1937',20,131.2,3),
 (10322,'S24_2022',30,116.67,4),
 (10323,'S18_3320',33,91.27,2),
 (10323,'S18_4600',47,131.98,1),
 (10324,'S12_3148',27,54.33,1),
 (10324,'S12_4473',26,58.38,7),
 (10324,'S18_2238',47,153.35,8),
 (10324,'S18_2319',33,37.48,10),
 (10324,'S18_3232',27,116.87,12),
 (10324,'S18_4027',49,109.79,13),
 (10324,'S18_4668',38,179.79,6),
 (10324,'S24_1444',25,69.16,14),
 (10324,'S24_2300',31,123.24,2),
 (10324,'S24_2840',30,111.27,9),
 (10324,'S24_4258',33,189.93,3),
 (10324,'S32_1268',20,98.18,11),
 (10324,'S32_3522',48,171.03,4),
 (10324,'S700_2824',34,124.95,5),
 (10325,'S10_4757',47,64.93,6),
 (10325,'S12_1108',42,64,8),
 (10325,'S12_3891',24,107.65,1),
 (10325,'S18_3140',24,69.12,9),
 (10325,'S24_4048',44,121.04,5),
 (10325,'S32_2509',38,232.74,3),
 (10325,'S32_3207',28,192.05,2),
 (10325,'S50_1392',38,136.59,4),
 (10325,'S50_1514',44,134.84,7),
 (10326,'S18_3259',32,118.99,6),
 (10326,'S18_4522',50,86.01,5),
 (10326,'S24_2011',41,105.69,4),
 (10326,'S24_3151',41,85.85,3),
 (10326,'S24_3816',20,92.25,2),
 (10326,'S700_1138',39,60,1),
 (10327,'S18_1662',25,112.19,6),
 (10327,'S18_2581',45,106.26,8),
 (10327,'S18_3029',25,45.86,5),
 (10327,'S700_1938',20,173.46,7),
 (10327,'S700_2610',21,96.31,1),
 (10327,'S700_3505',43,80,2),
 (10327,'S700_3962',37,86.61,3),
 (10327,'S72_3212',37,86.74,4),
 (10328,'S18_3856',34,112.22,6),
 (10328,'S24_1785',47,87.54,14),
 (10328,'S24_2841',48,58.92,1),
 (10328,'S24_3420',20,72.98,2),
 (10328,'S24_3949',35,76.43,3),
 (10328,'S24_4278',43,60.86,4),
 (10328,'S32_4289',24,81.17,5),
 (10328,'S50_1341',34,51.93,7),
 (10328,'S700_1691',27,102.3,8),
 (10328,'S700_2047',41,101.38,9),
 (10328,'S700_2466',37,108.69,10),
 (10328,'S700_2834',33,123.4,11),
 (10328,'S700_3167',33,64,13),
 (10328,'S700_4002',39,85.87,12),
 (10329,'S10_1678',42,104.67,1),
 (10329,'S10_2016',20,158.8,2),
 (10329,'S10_4698',26,225.7,3),
 (10329,'S12_1099',41,71.47,5),
 (10329,'S12_2823',24,147.61,6),
 (10329,'S12_3380',46,83.63,13),
 (10329,'S12_3990',33,109.32,14),
 (10329,'S12_4675',39,64.74,15),
 (10329,'S18_1889',29,101.89,9),
 (10329,'S18_2625',38,138.58,12),
 (10329,'S18_3278',38,59.1,10),
 (10329,'S24_1578',30,87.78,7),
 (10329,'S24_2000',37,94.43,4),
 (10329,'S32_1374',45,63.91,11),
 (10329,'S72_1253',44,86.13,8),
 (10330,'S18_3482',37,119.06,3),
 (10330,'S18_3782',29,69.63,2),
 (10330,'S18_4721',50,122.02,4),
 (10330,'S24_2360',42,81.03,1),
 (10331,'S18_1129',46,139.87,6),
 (10331,'S18_1589',44,110.21,14),
 (10331,'S18_1749',44,74.04,7),
 (10331,'S18_1984',30,32.47,8),
 (10331,'S18_2870',26,64.9,10),
 (10331,'S18_3232',27,154.47,11),
 (10331,'S18_3685',26,67.91,12),
 (10331,'S24_2972',27,42.24,13),
 (10331,'S24_3371',25,123.14,9),
 (10331,'S24_3856',21,149.33,1),
 (10331,'S24_4620',41,139.4,2),
 (10331,'S32_2206',28,146.52,3),
 (10331,'S32_4485',32,157.08,4),
 (10331,'S50_4713',20,182.89,5),
 (10332,'S18_1342',46,95.13,15),
 (10332,'S18_1367',27,89.89,16),
 (10332,'S18_2248',38,84.25,9),
 (10332,'S18_2325',35,64.69,8),
 (10332,'S18_2795',24,52.67,1),
 (10332,'S18_2957',26,114.58,17),
 (10332,'S18_3136',40,39.8,18),
 (10332,'S18_4409',50,146.2,2),
 (10332,'S18_4933',21,165.38,3),
 (10332,'S24_1046',23,56.84,4),
 (10332,'S24_1628',20,87.96,5),
 (10332,'S24_1937',45,81.91,6),
 (10332,'S24_2022',26,85.52,10),
 (10332,'S24_2766',39,86.72,7),
 (10332,'S24_2887',44,42.26,11),
 (10332,'S24_3191',45,34.19,12),
 (10332,'S24_3432',31,37.18,13),
 (10332,'S24_3969',41,77.24,14),
 (10333,'S10_1949',26,115.5,3),
 (10333,'S12_1666',33,99.21,6),
 (10333,'S18_1097',29,40.25,7),
 (10333,'S18_2949',31,90.17,5),
 (10333,'S18_3320',46,246.45,2),
 (10333,'S18_4668',24,79.86,8),
 (10333,'S24_4258',39,113.44,1),
 (10333,'S32_3522',33,73.69,4),
 (10334,'S10_4962',26,122.62,2),
 (10334,'S18_2319',46,126.41,6),
 (10334,'S18_2432',34,61.38,1),
 (10334,'S18_3232',20,143.94,3),
 (10334,'S18_4600',49,138.03,4),
 (10334,'S24_2300',42,131.62,5),
 (10335,'S24_2840',33,37.13,2),
 (10335,'S32_1268',44,107.87,1),
 (10335,'S32_2509',40,60.6,3),
 (10336,'S12_1108',33,57.22,10),
 (10336,'S12_3148',33,123.01,11),
 (10336,'S12_3891',49,63.38,1),
 (10336,'S12_4473',38,167.7,3),
 (10336,'S18_2238',49,152.26,6),
 (10336,'S18_3140',48,120.38,12),
 (10336,'S18_3259',21,106.21,7),
 (10336,'S24_1444',45,132.72,4),
 (10336,'S24_4048',31,148.99,5),
 (10336,'S32_3207',31,84.71,9),
 (10336,'S50_1392',23,136.59,8),
 (10336,'S700_2824',46,207.8,2),
 (10337,'S10_4757',25,48.05,8),
 (10337,'S18_4027',36,157.76,3),
 (10337,'S18_4522',29,155.11,2),
 (10337,'S24_2011',29,71.97,4),
 (10337,'S50_1514',21,109.37,6),
 (10337,'S700_1938',36,70.3,9),
 (10337,'S700_3505',31,89.38,1),
 (10337,'S700_3962',36,71.89,7),
 (10337,'S72_3212',42,97.16,5),
 (10338,'S18_1662',41,137.19,1),
 (10338,'S18_3029',28,82.58,3),
 (10338,'S18_3856',45,122.81,2),
 (10339,'S10_2016',40,68.92,4),
 (10339,'S10_4698',39,76.67,3),
 (10339,'S18_2581',27,104.1,2),
 (10339,'S18_2625',30,62.16,1),
 (10339,'S24_1578',27,84.39,10),
 (10339,'S24_1785',21,50.65,7),
 (10339,'S24_2841',55,112.99,12),
 (10339,'S24_3151',55,195.6,13),
 (10339,'S24_3420',29,99.69,14),
 (10339,'S24_3816',42,59.36,16),
 (10339,'S24_3949',45,96.92,11),
 (10339,'S700_1138',22,128.02,5),
 (10339,'S700_2047',55,71.25,15),
 (10339,'S700_2610',50,74.35,9),
 (10339,'S700_4002',50,57.86,8),
 (10339,'S72_1253',27,76.31,6),
 (10340,'S24_2000',55,79.98,8),
 (10340,'S24_4278',40,84.77,1),
 (10340,'S32_1374',55,117.87,2),
 (10340,'S32_4289',39,59.16,3),
 (10340,'S50_1341',40,50.62,4),
 (10340,'S700_1691',30,88.6,5),
 (10340,'S700_2466',55,87.75,7),
 (10340,'S700_2834',29,141.19,6),
 (10341,'S10_1678',41,188.73,9),
 (10341,'S12_1099',45,79.65,2),
 (10341,'S12_2823',55,147.61,8),
 (10341,'S12_3380',44,95.93,1),
 (10341,'S12_3990',36,93.56,10),
 (10341,'S12_4675',55,75.2,7),
 (10341,'S24_2360',32,103.35,6),
 (10341,'S32_4485',31,71.02,4),
 (10341,'S50_4713',38,123.22,3),
 (10341,'S700_3167',34,107.18,5),
 (10342,'S18_1129',40,161.36,2),
 (10342,'S18_1889',55,65.45,1),
 (10342,'S18_1984',22,143.67,3),
 (10342,'S18_3232',30,167.65,4),
 (10342,'S18_3278',25,66.74,5),
 (10342,'S18_3482',55,119.06,7),
 (10342,'S18_3782',26,55.95,8),
 (10342,'S18_4721',38,165.17,11),
 (10342,'S24_2972',39,40.4,9),
 (10342,'S24_3371',48,62.45,10),
 (10342,'S24_3856',42,119.37,6),
 (10343,'S18_1589',36,162.47,4),
 (10343,'S18_2870',25,52.32,3),
 (10343,'S18_3685',44,84.88,2),
 (10343,'S24_1628',27,36.21,6),
 (10343,'S24_4620',30,103.29,1),
 (10343,'S32_2206',29,128.04,5),
 (10344,'S18_1749',45,170,1),
 (10344,'S18_2248',40,56.91,2),
 (10344,'S18_2325',30,130.94,3),
 (10344,'S18_4409',21,104.91,4),
 (10344,'S18_4933',26,63.43,5),
 (10344,'S24_1046',29,59.53,7),
 (10344,'S24_1937',20,35.18,6),
 (10345,'S24_2022',43,53.76,1),
 (10346,'S18_1342',42,36.11,3),
 (10346,'S24_2766',25,115.07,1),
 (10346,'S24_2887',24,87.24,5),
 (10346,'S24_3191',24,138.58,2),
 (10346,'S24_3432',26,95.88,6),
 (10346,'S24_3969',22,97.44,4),
 (10347,'S10_1949',30,131.49,1),
 (10347,'S10_4962',27,164,2),
 (10347,'S12_1666',29,123.67,3),
 (10347,'S18_1097',42,49.6,5),
 (10347,'S18_1367',21,58.95,7),
 (10347,'S18_2432',50,136.69,8),
 (10347,'S18_2795',21,229.3,6),
 (10347,'S18_2949',48,100.3,9),
 (10347,'S18_2957',34,64.96,10),
 (10347,'S18_3136',45,109.96,11),
 (10347,'S18_3320',26,102.19,12),
 (10347,'S18_4600',45,130.77,4),
 (10348,'S12_1108',48,52.36,8),
 (10348,'S12_3148',47,102.16,4),
 (10348,'S18_4668',29,245.2,6),
 (10348,'S24_2300',37,161.66,1),
 (10348,'S24_4258',39,50.31,2),
 (10348,'S32_1268',42,152.07,3),
 (10348,'S32_3522',31,101.29,5),
 (10348,'S700_2824',32,82.83,7),
 (10349,'S12_3891',26,169.56,10),
 (10349,'S12_4473',48,109.02,9),
 (10349,'S18_2238',38,176.83,8),
 (10349,'S18_2319',38,137.46,7),
 (10349,'S18_3232',48,154.1,6),
 (10349,'S18_4027',34,129.26,5),
 (10349,'S24_1444',48,47.4,4),
 (10349,'S24_2840',36,37.13,3),
 (10349,'S24_4048',23,138.39,2),
 (10349,'S32_2509',33,46.53,1),
 (10350,'S10_4757',26,75.47,5),
 (10350,'S18_3029',43,64.97,6),
 (10350,'S18_3140',44,117.98,1),
 (10350,'S18_3259',41,93.04,2),
 (10350,'S18_4522',30,100.77,3),
 (10350,'S24_2011',34,50.33,7),
 (10350,'S24_3151',30,100.7,9),
 (10350,'S24_3816',25,60.34,10),
 (10350,'S32_3207',27,163.2,14),
 (10350,'S50_1392',31,71.4,8),
 (10350,'S50_1514',44,147.52,17),
 (10350,'S700_1138',46,76.67,11),
 (10350,'S700_1938',28,104.44,4),
 (10350,'S700_2610',29,75.35,12),
 (10350,'S700_3505',31,77.34,13),
 (10350,'S700_3962',25,114.19,16),
 (10350,'S72_3212',20,112.22,15),
 (10351,'S18_1662',39,99.52,1),
 (10351,'S18_3856',20,168.73,2),
 (10351,'S24_2841',25,74.68,5),
 (10351,'S24_3420',38,68.38,4),
 (10351,'S24_3949',34,59.37,3),
 (10352,'S700_2047',23,102.29,3),
 (10352,'S700_2466',49,100.72,2),
 (10352,'S700_4002',22,75.51,1),
 (10352,'S72_1253',49,52.64,4),
 (10353,'S18_2581',27,130.21,1),
 (10353,'S24_1785',28,71.73,2),
 (10353,'S24_4278',35,89.9,3),
 (10353,'S32_1374',46,81.17,5),
 (10353,'S32_4289',40,44.51,7),
 (10353,'S50_1341',40,82.21,8),
 (10353,'S700_1691',39,129.33,9),
 (10353,'S700_2834',48,68.8,4),
 (10353,'S700_3167',43,81.95,6),
 (10354,'S10_1678',42,86.13,6),
 (10354,'S10_2016',20,104.67,2),
 (10354,'S10_4698',42,213.03,3),
 (10354,'S12_1099',31,93.28,9),
 (10354,'S12_2823',35,182.9,4),
 (10354,'S12_3380',29,73.15,11),
 (10354,'S12_3990',23,50.88,12),
 (10354,'S12_4675',28,86.84,13),
 (10354,'S18_1889',21,110.45,8),
 (10354,'S18_2625',28,165.68,10),
 (10354,'S18_3278',36,82.26,7),
 (10354,'S24_1578',21,113.92,5),
 (10354,'S24_2000',28,69.43,1),
 (10355,'S18_3482',23,138.17,7),
 (10355,'S18_3782',31,53.47,1),
 (10355,'S18_4721',25,168.14,2),
 (10355,'S24_2360',41,70.65,3),
 (10355,'S24_2972',36,38.52,4),
 (10355,'S24_3371',44,62.45,6),
 (10355,'S24_3856',32,165.71,8),
 (10355,'S24_4620',28,95.39,9),
 (10355,'S32_2206',38,39.83,10),
 (10355,'S32_4485',40,108.17,5),
 (10356,'S18_1129',43,97.6,8),
 (10356,'S18_1342',50,50.18,9),
 (10356,'S18_1367',22,72.41,6),
 (10356,'S18_1984',27,64.69,2),
 (10356,'S18_2325',29,125.18,3),
 (10356,'S18_2795',30,148.74,1),
 (10356,'S24_1937',48,202.5,5),
 (10356,'S24_2022',26,31.86,7),
 (10356,'S50_4713',26,151.45,4),
 (10357,'S10_1949',32,177.87,10),
 (10357,'S10_4962',43,134.44,9),
 (10357,'S12_1666',49,121.64,8),
 (10357,'S18_1097',39,98,1),
 (10357,'S18_2432',41,61.99,7),
 (10357,'S18_2949',41,87.13,6),
 (10357,'S18_2957',49,70.58,5),
 (10357,'S18_3136',44,117.29,4),
 (10357,'S18_3320',25,104.17,3),
 (10357,'S18_4600',28,127.13,2),
 (10358,'S12_3148',49,55.34,5),
 (10358,'S12_4473',42,64.16,9),
 (10358,'S18_2238',20,121.4,10),
 (10358,'S18_2319',20,36.42,11),
 (10358,'S18_3232',32,93.49,12),
 (10358,'S18_4027',25,101.13,13),
 (10358,'S18_4668',30,176.76,8),
 (10358,'S24_1444',44,60.76,14),
 (10358,'S24_2300',41,138.65,7),
 (10358,'S24_2840',36,82.94,4),
 (10358,'S24_4258',41,167,6),
 (10358,'S32_1268',41,108,1),
 (10358,'S32_3522',36,157.49,2),
 (10358,'S700_2824',27,139.31,3),
 (10359,'S10_4757',48,54.68,6),
 (10359,'S12_1108',42,113.44,8),
 (10359,'S12_3891',49,62.09,5),
 (10359,'S24_4048',22,118.32,7),
 (10359,'S32_2509',36,176.63,3),
 (10359,'S32_3207',22,195.51,1),
 (10359,'S50_1392',46,106.45,2),
 (10359,'S50_1514',25,64.93,4),
 (10360,'S18_1662',50,58.67,12),
 (10360,'S18_2581',41,87.48,13),
 (10360,'S18_3029',46,77.34,14),
 (10360,'S18_3140',29,175.04,8),
 (10360,'S18_3259',29,101.38,18),
 (10360,'S18_3856',40,87.15,15),
 (10360,'S18_4522',40,86.02,1),
 (10360,'S24_1785',22,115.2,17),
 (10360,'S24_2011',31,118.83,2),
 (10360,'S24_2841',49,56.78,16),
 (10360,'S24_3151',36,113.95,3),
 (10360,'S24_3816',22,111.16,4),
 (10360,'S700_1138',32,100.94,5),
 (10360,'S700_1938',26,97.38,6),
 (10360,'S700_2610',30,125.35,7),
 (10360,'S700_3505',35,65.77,9),
 (10360,'S700_3962',31,103.56,10),
 (10360,'S72_3212',31,96.44,11),
 (10361,'S10_1678',20,72.55,13),
 (10361,'S10_2016',26,51.15,8),
 (10361,'S24_3420',34,113.88,6),
 (10361,'S24_3949',26,142.73,7),
 (10361,'S24_4278',25,62.46,1),
 (10361,'S32_4289',49,72.33,2),
 (10361,'S50_1341',33,82.59,3),
 (10361,'S700_1691',20,60.54,4),
 (10361,'S700_2047',24,45.39,14),
 (10361,'S700_2466',26,105.95,9),
 (10361,'S700_2834',44,72.42,5),
 (10361,'S700_3167',44,113.68,10),
 (10361,'S700_4002',35,122.21,11),
 (10361,'S72_1253',23,95.2,12),
 (10362,'S10_4698',22,166.55,4),
 (10362,'S12_2823',22,176.23,1),
 (10362,'S18_2625',23,49.67,3),
 (10362,'S24_1578',50,96.92,2),
 (10363,'S12_1099',33,85.39,3),
 (10363,'S12_3380',34,96.73,4),
 (10363,'S12_3990',34,81.62,5),
 (10363,'S12_4675',46,88.45,6),
 (10363,'S18_1889',22,167.57,7),
 (10363,'S18_3278',46,60.3,10),
 (10363,'S18_3482',24,172.61,11),
 (10363,'S18_3782',32,89.12,12),
 (10363,'S18_4721',28,58.18,13),
 (10363,'S24_2000',21,171.22,8),
 (10363,'S24_2360',43,61.23,14),
 (10363,'S24_3371',21,116.56,15),
 (10363,'S24_3856',31,94.58,1),
 (10363,'S24_4620',43,119.87,9),
 (10363,'S32_1374',50,131.53,2),
 (10364,'S32_2206',48,48.28,1),
 (10365,'S18_1129',30,87.06,1),
 (10365,'S32_4485',22,155.69,3),
 (10365,'S50_4713',44,113.28,2),
 (10366,'S18_1984',34,123.76,3),
 (10366,'S18_2870',49,125.4,2),
 (10366,'S18_3232',34,184.58,1),
 (10367,'S18_1589',49,56.3,1),
 (10367,'S18_1749',37,127.13,3),
 (10367,'S18_2248',45,197.44,4),
 (10367,'S18_2325',27,155.41,5),
 (10367,'S18_2795',32,94.79,7),
 (10367,'S18_3685',46,104.53,6),
 (10367,'S18_4409',43,62.72,8),
 (10367,'S18_4933',44,85.25,9),
 (10367,'S24_1046',21,60.37,10),
 (10367,'S24_1628',38,38.5,11),
 (10367,'S24_1937',23,36.29,13),
 (10367,'S24_2022',28,30.59,12),
 (10367,'S24_2972',36,139.4,2),
 (10368,'S24_2766',40,102.68,2),
 (10368,'S24_2887',31,136.23,5),
 (10368,'S24_3191',46,79.62,1),
 (10368,'S24_3432',20,99.58,4),
 (10368,'S24_3969',46,37.34,3),
 (10369,'S10_1949',41,110.12,2),
 (10369,'S18_1342',44,210.01,8),
 (10369,'S18_1367',32,98.63,7),
 (10369,'S18_2949',42,109.08,1),
 (10369,'S18_2957',28,44.21,6),
 (10369,'S18_3136',21,94.22,5),
 (10369,'S18_3320',45,73.08,4),
 (10369,'S24_4258',40,86.92,3),
 (10370,'S10_4962',35,65.63,4),
 (10370,'S12_1666',49,172.86,8),
 (10370,'S18_1097',27,144.87,1),
 (10370,'S18_2319',22,179.5,5),
 (10370,'S18_2432',22,96.86,7),
 (10370,'S18_3232',27,56.85,9),
 (10370,'S18_4600',29,57.53,6),
 (10370,'S18_4668',20,136.5,2),
 (10370,'S32_3522',25,126.41,3),
 (10371,'S12_1108',32,111.27,6),
 (10371,'S12_4473',49,35.71,4),
 (10371,'S18_2238',25,104.09,7),
 (10371,'S24_1444',25,97.27,12),
 (10371,'S24_2300',20,172.47,5),
 (10371,'S24_2840',45,123.24,8),
 (10371,'S24_4048',28,50.32,9),
 (10371,'S32_1268',26,155.54,1),
 (10371,'S32_2509',20,66.47,2),
 (10371,'S32_3207',30,99.55,11),
 (10371,'S50_1392',48,56.55,10),
 (10371,'S700_2824',34,126.51,3),
 (10372,'S12_3148',40,146.55,4),
 (10372,'S12_3891',34,174.75,1),
 (10372,'S18_3140',28,137.96,3),
 (10372,'S18_3259',25,84.71,5),
 (10372,'S18_4027',48,146.49,6),
 (10372,'S18_4522',41,86.89,7),
 (10372,'S24_2011',37,105.69,8),
 (10372,'S50_1514',24,58.58,9),
 (10372,'S700_1938',44,102.2,2),
 (10373,'S10_4757',39,103.75,3),
 (10373,'S18_1662',28,57.55,4),
 (10373,'S18_3029',22,86.74,5),
 (10373,'S18_3856',50,60.49,6),
 (10373,'S24_2841',38,70.44,7),
 (10373,'S24_3151',33,57.32,12),
 (10373,'S24_3420',46,66,11),
 (10373,'S24_3816',23,104.1,10),
 (10373,'S24_3949',39,73,13),
 (10373,'S700_1138',44,105.18,14),
 (10373,'S700_2047',32,84.41,15),
 (10373,'S700_2610',41,70.33,16),
 (10373,'S700_3505',34,96.34,2),
 (10373,'S700_3962',37,108.8,8),
 (10373,'S700_4002',45,55.62,17),
 (10373,'S72_1253',25,64.97,9),
 (10373,'S72_3212',29,137.19,1),
 (10374,'S10_2016',39,135.59,5),
 (10374,'S10_4698',22,174.29,1),
 (10374,'S18_2581',42,69.27,2),
 (10374,'S18_2625',22,53.3,4),
 (10374,'S24_1578',38,110.45,6),
 (10374,'S24_1785',46,94.1,3),
 (10375,'S10_1678',21,34.91,12),
 (10375,'S12_1099',45,76,7),
 (10375,'S12_2823',49,78.92,13),
 (10375,'S24_2000',23,106.23,9),
 (10375,'S24_2360',20,102.3,14),
 (10375,'S24_4278',43,233.48,2),
 (10375,'S32_1374',37,171.71,3),
 (10375,'S32_4289',44,82.26,4),
 (10375,'S32_4485',41,114.68,15),
 (10375,'S50_1341',49,65.8,5),
 (10375,'S50_4713',49,110.34,8),
 (10375,'S700_1691',37,81.87,6),
 (10375,'S700_2466',33,116.87,1),
 (10375,'S700_2834',25,66.73,10),
 (10375,'S700_3167',44,118.38,11),
 (10376,'S12_3380',35,113.92,1),
 (10377,'S12_3990',24,67.83,5),
 (10377,'S12_4675',50,103.64,1),
 (10377,'S18_1129',35,168.43,2),
 (10377,'S18_1889',31,67.76,4),
 (10377,'S18_1984',36,120.91,6),
 (10377,'S18_3232',39,186.27,3),
 (10378,'S18_1589',34,42.64,5),
 (10378,'S18_3278',22,112,4),
 (10378,'S18_3482',43,96.49,10),
 (10378,'S18_3782',28,164.63,9),
 (10378,'S18_4721',49,67.14,8),
 (10378,'S24_2972',41,142.85,7),
 (10378,'S24_3371',46,41.54,6),
 (10378,'S24_3856',33,53.27,3),
 (10378,'S24_4620',41,119.37,2),
 (10378,'S32_2206',40,82.46,1),
 (10379,'S18_1749',39,138.45,2),
 (10379,'S18_2248',27,49.3,1),
 (10379,'S18_2870',29,176.8,5),
 (10379,'S18_3685',32,70.83,4),
 (10379,'S24_1628',32,124.08,3),
 (10380,'S18_1342',27,93.16,13),
 (10380,'S18_2325',40,123.29,10),
 (10380,'S18_2795',21,47.18,8),
 (10380,'S18_4409',32,105.52,1),
 (10380,'S18_4933',24,189,2),
 (10380,'S24_1046',34,101.23,3),
 (10380,'S24_1937',32,70.56,4),
 (10380,'S24_2022',27,68.35,5),
 (10380,'S24_2766',36,37.5,6),
 (10380,'S24_2887',44,36.29,7),
 (10380,'S24_3191',44,79.06,9),
 (10380,'S24_3432',34,116.27,11),
 (10380,'S24_3969',43,95.03,12),
 (10381,'S10_1949',36,229.3,3),
 (10381,'S10_4962',37,168.42,6),
 (10381,'S12_1666',20,147.6,1),
 (10381,'S18_1097',48,98,2),
 (10381,'S18_1367',25,52.83,9),
 (10381,'S18_2432',35,48.62,7),
 (10381,'S18_2949',41,105.36,8),
 (10381,'S18_2957',40,68.08,4),
 (10381,'S18_3136',35,122.52,5),
 (10382,'S12_1108',34,112.46,10),
 (10382,'S12_3148',37,110.05,11),
 (10382,'S12_3891',34,95.35,12),
 (10382,'S12_4473',32,66.58,13),
 (10382,'S18_2238',25,88,5),
 (10382,'S18_3320',50,178.71,7),
 (10382,'S18_4600',39,125.4,1),
 (10382,'S18_4668',39,200.7,2),
 (10382,'S24_2300',20,132.72,3),
 (10382,'S24_4258',33,139.17,4),
 (10382,'S32_1268',26,104.17,6),
 (10382,'S32_3522',48,141.66,8),
 (10382,'S700_2824',34,54.84,9),
 (10383,'S18_2319',27,142.37,11),
 (10383,'S18_3140',24,61.52,9),
 (10383,'S18_3232',47,146.15,6),
 (10383,'S18_3259',26,128.48,12),
 (10383,'S18_4027',38,140.55,1),
 (10383,'S18_4522',28,58.58,7),
 (10383,'S24_1444',22,91.76,2),
 (10383,'S24_2840',40,152.24,3),
 (10383,'S24_4048',21,93.91,4),
 (10383,'S32_2509',32,53.18,5),
 (10383,'S32_3207',44,36.07,8),
 (10383,'S50_1392',29,106.45,13),
 (10383,'S50_1514',38,60.06,10),
 (10384,'S10_4757',34,142.55,4),
 (10384,'S24_2011',28,80.54,3),
 (10384,'S24_3151',43,97.87,2),
 (10384,'S700_1938',49,130.56,1),
 (10385,'S24_3816',37,85.54,2),
 (10385,'S700_1138',25,77.34,1),
 (10386,'S18_1662',25,54.57,7),
 (10386,'S18_2581',21,74.77,18),
 (10386,'S18_3029',37,93.01,5),
 (10386,'S18_3856',22,57.55,6),
 (10386,'S24_1785',33,41.71,11),
 (10386,'S24_2841',39,55.96,1),
 (10386,'S24_3420',35,63.76,9),
 (10386,'S24_3949',41,73.32,12),
 (10386,'S24_4278',50,63.34,8),
 (10386,'S700_2047',29,85.76,13),
 (10386,'S700_2466',37,83.84,14),
 (10386,'S700_2610',37,135.61,10),
 (10386,'S700_3167',32,94.34,17),
 (10386,'S700_3505',45,92.08,2),
 (10386,'S700_3962',30,95.48,3),
 (10386,'S700_4002',44,86.4,15),
 (10386,'S72_1253',50,87.15,16),
 (10386,'S72_3212',43,125.99,4),
 (10387,'S32_1374',44,94.9,1),
 (10388,'S10_1678',42,76.36,4),
 (10388,'S10_2016',50,44.51,5),
 (10388,'S10_4698',21,86.77,7),
 (10388,'S12_2823',44,135.26,6),
 (10388,'S32_4289',35,111.97,8),
 (10388,'S50_1341',27,118.94,1),
 (10388,'S700_1691',46,218.84,2),
 (10388,'S700_2834',50,143.09,3),
 (10389,'S12_1099',26,99.04,4),
 (10389,'S12_3380',25,72.38,6),
 (10389,'S12_3990',36,70.26,7),
 (10389,'S12_4675',47,111.57,8),
 (10389,'S18_1889',49,79.22,3),
 (10389,'S18_2625',39,179,5),
 (10389,'S24_1578',45,102.17,1),
 (10389,'S24_2000',49,81.4,2),
 (10390,'S18_1129',36,93.77,14),
 (10390,'S18_1984',34,43.05,15),
 (10390,'S18_2325',31,98.99,16),
 (10390,'S18_2795',26,78.11,7),
 (10390,'S18_3278',40,137.29,9),
 (10390,'S18_3482',50,147.94,1),
 (10390,'S18_3782',36,141.11,2),
 (10390,'S18_4721',49,140.06,3),
 (10390,'S24_2360',35,65.13,4),
 (10390,'S24_2972',37,132.29,5),
 (10390,'S24_3371',46,52.84,6),
 (10390,'S24_3856',45,150.29,8),
 (10390,'S24_4620',30,82.42,10),
 (10390,'S32_2206',41,44.56,11),
 (10390,'S32_4485',45,48.98,12),
 (10390,'S50_4713',22,158.69,13),
 (10391,'S10_1949',24,100.69,4),
 (10391,'S10_4962',37,46.9,7),
 (10391,'S12_1666',39,63.2,9),
 (10391,'S18_1097',29,85.1,10),
 (10391,'S18_1342',35,158.54,2),
 (10391,'S18_1367',42,119,3),
 (10391,'S18_2432',44,38.5,5),
 (10391,'S18_2949',32,45.25,6),
 (10391,'S24_1937',33,252.87,8),
 (10391,'S24_2022',24,168.42,1),
 (10392,'S18_2957',37,59.96,3),
 (10392,'S18_3136',29,86.92,2),
 (10392,'S18_3320',36,112.11,1),
 (10393,'S12_3148',35,109.08,8),
 (10393,'S12_4473',32,101.13,10),
 (10393,'S18_2238',20,69.81,11),
 (10393,'S18_2319',38,100.14,7),
 (10393,'S18_4600',30,120.86,9),
 (10393,'S18_4668',44,110.21,1),
 (10393,'S24_2300',33,176.83,2),
 (10393,'S24_4258',33,98.18,3),
 (10393,'S32_1268',38,145.3,4),
 (10393,'S32_3522',31,57.86,5),
 (10393,'S700_2824',21,102.23,6),
 (10394,'S18_3232',22,152.41,5),
 (10394,'S18_4027',37,172.34,1),
 (10394,'S24_1444',31,50.29,2),
 (10394,'S24_2840',46,38.9,6),
 (10394,'S24_4048',37,140.75,7),
 (10394,'S32_2509',36,62.77,3),
 (10394,'S32_3207',30,60.28,4),
 (10395,'S10_4757',32,105.33,2),
 (10395,'S12_1108',33,69.12,1),
 (10395,'S50_1392',46,123.76,4),
 (10395,'S50_1514',45,199.49,3),
 (10396,'S12_3891',33,185.13,3),
 (10396,'S18_3140',33,159.81,2),
 (10396,'S18_3259',24,89.75,4),
 (10396,'S18_4522',45,105.32,5),
 (10396,'S24_2011',49,116.75,6),
 (10396,'S24_3151',27,83.2,7),
 (10396,'S24_3816',37,90.57,8),
 (10396,'S700_1138',39,66.67,1),
 (10397,'S700_1938',32,80.55,5),
 (10397,'S700_2610',22,66.5,4),
 (10397,'S700_3505',48,108.18,3),
 (10397,'S700_3962',36,105.27,2),
 (10397,'S72_3212',34,62.24,1),
 (10398,'S18_1662',33,127.73,11),
 (10398,'S18_2581',34,76.88,15),
 (10398,'S18_3029',28,72.26,18),
 (10398,'S18_3856',45,106.93,17),
 (10398,'S24_1785',43,129.12,16),
 (10398,'S24_2841',28,57.55,3),
 (10398,'S24_3420',34,71.67,13),
 (10398,'S24_3949',41,68.24,2),
 (10398,'S24_4278',45,78.25,14),
 (10398,'S32_4289',22,67.41,4),
 (10398,'S50_1341',49,36.66,5),
 (10398,'S700_1691',47,87.69,6),
 (10398,'S700_2047',36,108.62,7),
 (10398,'S700_2466',22,86.76,8),
 (10398,'S700_2834',23,122.21,9),
 (10398,'S700_3167',29,65.6,10),
 (10398,'S700_4002',36,87.36,12),
 (10398,'S72_1253',34,40.22,1),
 (10399,'S10_1678',40,113.88,8),
 (10399,'S10_2016',51,123.7,7),
 (10399,'S10_4698',22,158.8,6),
 (10399,'S12_2823',29,164.18,5),
 (10399,'S18_2625',30,68.44,4),
 (10399,'S24_1578',57,105.94,3),
 (10399,'S24_2000',58,89.12,2),
 (10399,'S32_1374',32,99.89,1),
 (10400,'S10_4757',64,150.96,9),
 (10400,'S18_1662',34,189.23,1),
 (10400,'S18_3029',30,74.84,7),
 (10400,'S18_3856',58,125.99,6),
 (10400,'S24_2841',24,61.66,2),
 (10400,'S24_3420',38,57.2,3),
 (10400,'S24_3816',42,72.96,8),
 (10400,'S700_2047',46,87.8,5),
 (10400,'S72_1253',20,56.12,4),
 (10401,'S18_2581',42,76.03,3),
 (10401,'S24_1785',38,96.29,5),
 (10401,'S24_3949',64,60.05,12),
 (10401,'S24_4278',52,81.14,4),
 (10401,'S32_1374',49,101.89,1),
 (10401,'S32_4289',62,77.73,6),
 (10401,'S50_1341',56,35.35,7),
 (10401,'S700_1691',11,103.21,8),
 (10401,'S700_2466',85,88.75,10),
 (10401,'S700_2834',21,96.11,2),
 (10401,'S700_3167',77,92,9),
 (10401,'S700_4002',28,72.55,11),
 (10402,'S10_2016',45,129.64,1),
 (10402,'S18_2625',55,55.72,2),
 (10402,'S24_2000',59,87.6,3),
 (10403,'S10_1678',24,101.44,7),
 (10403,'S10_4698',66,180.1,9),
 (10403,'S12_2823',66,131.04,6),
 (10403,'S18_3782',36,52.22,1),
 (10403,'S24_1578',46,114.95,8),
 (10403,'S24_2360',27,79.65,4),
 (10403,'S32_2206',30,40.23,2),
 (10403,'S32_4485',45,115.32,5),
 (10403,'S50_4713',31,68.34,3),
 (10404,'S12_1099',64,206.24,3),
 (10404,'S12_3380',43,109.22,1),
 (10404,'S12_3990',77,74.21,4),
 (10404,'S18_3278',90,73.17,6),
 (10404,'S18_3482',28,133.76,5),
 (10404,'S18_4721',48,144.34,8),
 (10404,'S24_3371',49,62.45,2),
 (10404,'S24_4620',48,93.77,7),
 (10405,'S12_4675',97,93.28,5),
 (10405,'S18_1889',61,73.92,4),
 (10405,'S18_3232',55,150.71,1),
 (10405,'S24_2972',47,44.56,2),
 (10405,'S24_3856',76,154.47,3),
 (10406,'S18_1129',61,137.29,3),
 (10406,'S18_1984',48,149.36,2),
 (10406,'S18_3685',65,161.06,1),
 (10407,'S18_1589',59,119.46,11),
 (10407,'S18_1749',76,185.3,2),
 (10407,'S18_2248',42,72.65,1),
 (10407,'S18_2870',41,155.76,12),
 (10407,'S18_4409',6,90.19,3),
 (10407,'S18_4933',66,66.99,4),
 (10407,'S24_1046',26,76.43,8),
 (10407,'S24_1628',64,40.25,10),
 (10407,'S24_2766',76,94.5,6),
 (10407,'S24_2887',59,98.65,5),
 (10407,'S24_3191',13,81.33,7),
 (10407,'S24_3432',43,86.73,9),
 (10408,'S24_3969',15,36.93,1),
 (10409,'S18_2325',6,130.94,2),
 (10409,'S24_1937',61,29.54,1),
 (10410,'S18_1342',65,117.12,7),
 (10410,'S18_1367',44,58.22,6),
 (10410,'S18_2795',56,138.38,8),
 (10410,'S18_2949',47,117.52,1),
 (10410,'S18_2957',53,58.09,3),
 (10410,'S18_3136',34,115.19,2),
 (10410,'S18_3320',44,84.33,5),
 (10410,'S24_2022',31,45.25,9),
 (10410,'S24_4258',50,86.68,4),
 (10411,'S10_1949',23,180.01,9),
 (10411,'S10_4962',27,163.99,2),
 (10411,'S12_1666',40,155.8,6),
 (10411,'S18_1097',27,119,8),
 (10411,'S18_4600',46,113.82,3),
 (10411,'S18_4668',35,59.87,7),
 (10411,'S32_1268',26,111.72,1),
 (10411,'S32_3522',27,69.16,5),
 (10411,'S700_2824',34,105.2,4),
 (10412,'S12_4473',54,110.21,5),
 (10412,'S18_2238',41,163.73,4),
 (10412,'S18_2319',56,98.18,8),
 (10412,'S18_2432',47,61.99,11),
 (10412,'S18_3232',60,198.13,9),
 (10412,'S24_1444',21,52.6,2),
 (10412,'S24_2300',70,121.4,10),
 (10412,'S24_2840',30,36.07,6),
 (10412,'S24_4048',31,137.2,1),
 (10412,'S32_2509',19,48.7,7),
 (10412,'S50_1392',26,133.11,3),
 (10413,'S12_1108',36,241.05,2),
 (10413,'S12_3148',47,175.25,3),
 (10413,'S12_3891',22,153.99,1),
 (10413,'S18_4027',49,140.75,5),
 (10413,'S32_3207',24,49.71,6),
 (10413,'S50_1514',51,63.85,4),
 (10414,'S10_4757',19,145.52,3),
 (10414,'S18_3029',44,73.98,1),
 (10414,'S18_3140',41,118.83,12),
 (10414,'S18_3259',48,121.01,14),
 (10414,'S18_4522',16,75.48,11),
 (10414,'S24_2011',23,145.01,10),
 (10414,'S24_3151',60,101.79,5),
 (10414,'S24_3816',51,76.31,2),
 (10414,'S700_1138',37,71.34,6),
 (10414,'S700_1938',34,103.93,13),
 (10414,'S700_2610',31,75.89,4),
 (10414,'S700_3505',28,108.18,7),
 (10414,'S700_3962',27,90.37,8),
 (10414,'S72_3212',47,65.52,9),
 (10415,'S18_3856',51,121.75,5),
 (10415,'S24_2841',21,67.82,1),
 (10415,'S24_3420',18,69.7,2),
 (10415,'S700_2047',32,95.95,4),
 (10415,'S72_1253',42,57.61,3),
 (10416,'S18_1662',24,181.34,14),
 (10416,'S18_2581',15,98.84,4),
 (10416,'S24_1785',47,88.63,6),
 (10416,'S24_2000',32,87.6,1),
 (10416,'S24_3949',18,75.06,13),
 (10416,'S24_4278',48,74.62,5),
 (10416,'S32_1374',45,105.88,2),
 (10416,'S32_4289',26,61.22,7),
 (10416,'S50_1341',37,51.93,8),
 (10416,'S700_1691',23,91.34,9),
 (10416,'S700_2466',22,111.69,11),
 (10416,'S700_2834',41,137.63,3),
 (10416,'S700_3167',39,67.2,10),
 (10416,'S700_4002',43,62.19,12),
 (10417,'S10_1678',66,113.88,2),
 (10417,'S10_2016',45,130.83,5),
 (10417,'S10_4698',56,164.61,4),
 (10417,'S12_2823',21,164.18,1),
 (10417,'S18_2625',36,61.18,6),
 (10417,'S24_1578',35,101.43,3),
 (10418,'S18_3278',16,76.39,2),
 (10418,'S18_3482',27,164.63,1),
 (10418,'S18_3782',33,52.84,5),
 (10418,'S18_4721',28,136.9,4),
 (10418,'S24_2360',52,65.8,8),
 (10418,'S24_4620',10,87.31,3),
 (10418,'S32_2206',43,48.28,6),
 (10418,'S32_4485',50,113.28,9),
 (10418,'S50_4713',40,72.41,7),
 (10419,'S12_1099',12,163.44,13),
 (10419,'S12_3380',10,109.22,11),
 (10419,'S12_3990',34,90.17,14),
 (10419,'S12_4675',32,119.77,10),
 (10419,'S18_1129',38,117.48,5),
 (10419,'S18_1589',37,140.62,1),
 (10419,'S18_1889',39,83.93,9),
 (10419,'S18_1984',34,135.14,4),
 (10419,'S18_2870',55,139.92,2),
 (10419,'S18_3232',35,169.34,6),
 (10419,'S18_3685',43,129.98,3),
 (10419,'S24_2972',15,42.67,7),
 (10419,'S24_3371',55,52.66,12),
 (10419,'S24_3856',70,132,8),
 (10420,'S18_1749',37,142.8,5),
 (10420,'S18_2248',36,63.57,4),
 (10420,'S18_2325',45,110.6,2),
 (10420,'S18_4409',66,92.95,6),
 (10420,'S18_4933',36,57.73,7),
 (10420,'S24_1046',60,64.67,11),
 (10420,'S24_1628',37,60.37,13),
 (10420,'S24_1937',45,26.88,1),
 (10420,'S24_2766',39,100.87,9),
 (10420,'S24_2887',55,96.3,8),
 (10420,'S24_3191',35,96.74,10),
 (10420,'S24_3432',26,100.66,12),
 (10420,'S24_3969',15,43.49,3),
 (10421,'S18_2795',35,155.25,1),
 (10421,'S24_2022',40,45.7,2),
 (10422,'S18_1342',51,95.55,2),
 (10422,'S18_1367',25,51.75,1),
 (10423,'S18_2949',10,88.14,1),
 (10423,'S18_2957',31,53.72,3),
 (10423,'S18_3136',21,84.82,2),
 (10423,'S18_3320',21,89.29,5),
 (10423,'S24_4258',28,78.89,4),
 (10424,'S10_1949',50,240.02,6),
 (10424,'S12_1666',49,162.64,3),
 (10424,'S18_1097',54,133,5),
 (10424,'S18_4668',26,59.87,4),
 (10424,'S32_3522',44,61.41,2),
 (10424,'S700_2824',46,80.92,1),
 (10425,'S10_4962',38,155.13,12),
 (10425,'S12_4473',33,142.2,4),
 (10425,'S18_2238',28,189.93,3),
 (10425,'S18_2319',38,99.41,7),
 (10425,'S18_2432',19,49.22,10),
 (10425,'S18_3232',28,135.47,8),
 (10425,'S18_4600',38,113.82,13),
 (10425,'S24_1444',55,46.82,1),
 (10425,'S24_2300',49,112.46,9),
 (10425,'S24_2840',31,33.24,5),
 (10425,'S32_1268',41,86.68,11),
 (10425,'S32_2509',11,43.83,6),
 (10425,'S50_1392',18,105.33,2);

DROP TABLE IF EXISTS `classicmodels`.`Payment`;
CREATE TABLE  `classicmodels`.`Payment` (
  `customerNumber` int(11) NOT NULL,
  `checkNumber` varchar(50) NOT NULL,
  `paymentDate` datetime NOT NULL,
  `amount` double NOT NULL,
  PRIMARY KEY (`customerNumber`,`checkNumber`)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `classicmodels`.`Payment` (`customerNumber`,`checkNumber`,`paymentDate`,`amount`) VALUES 
 (103,'HQ336336','2004-10-19 00:00:00',5307.98),
 (103,'JM555205','2003-06-05 00:00:00',16560.3),
 (103,'OM314933','2004-12-18 00:00:00',2311.68),
 (112,'BO864823','2004-12-17 00:00:00',14449.61),
 (112,'HQ55022','2003-06-06 00:00:00',33847.62),
 (112,'ND748579','2004-08-20 00:00:00',34453.85),
 (114,'GG31455','2003-05-20 00:00:00',50397.66),
 (114,'MA765515','2004-12-15 00:00:00',85591.32),
 (114,'NP603840','2003-05-31 00:00:00',9738.18),
 (114,'NR27552','2004-03-10 00:00:00',49637.57),
 (119,'DB933704','2004-11-14 00:00:00',20719.91),
 (119,'LN373447','2004-08-08 00:00:00',56002.9),
 (119,'NG94694','2005-02-22 00:00:00',59617.44),
 (121,'DB889831','2003-02-16 00:00:00',54702),
 (121,'FD317790','2003-10-28 00:00:00',1474.66),
 (121,'KI831359','2004-11-04 00:00:00',19769.68),
 (121,'MA302151','2004-11-28 00:00:00',40652.85),
 (124,'AE215433','2005-02-18 00:00:00',51826.36),
 (124,'AQ50522','2005-06-03 00:00:00',32194.79),
 (124,'BG255406','2004-08-28 00:00:00',93928.73),
 (124,'CQ287967','2003-04-11 00:00:00',12398.56),
 (124,'ET64396','2005-04-16 00:00:00',121972.78),
 (124,'HI366474','2004-12-27 00:00:00',50547.68),
 (124,'HR86578','2004-11-02 00:00:00',63075.06),
 (124,'KI131716','2003-08-15 00:00:00',122368.67),
 (124,'LF217299','2004-03-26 00:00:00',48922.77),
 (124,'NT141748','2003-11-25 00:00:00',50360.89),
 (128,'DI925118','2003-01-28 00:00:00',11432.34),
 (128,'FA465482','2003-10-18 00:00:00',27257.79),
 (128,'FH668230','2004-03-24 00:00:00',37266.49),
 (128,'IP383901','2004-11-18 00:00:00',9214.97),
 (129,'DM826140','2004-12-08 00:00:00',30348.72),
 (129,'ID449593','2003-12-11 00:00:00',25431.88),
 (129,'PI42991','2003-04-09 00:00:00',18695.58),
 (131,'CL442705','2003-03-12 00:00:00',25783.76),
 (131,'KG113538','2004-05-22 00:00:00',45357.66),
 (131,'MA724562','2004-12-02 00:00:00',53152.28),
 (131,'NB445135','2004-09-11 00:00:00',39775.74),
 (141,'AU364101','2003-07-19 00:00:00',39615.82),
 (141,'DB583216','2004-11-01 00:00:00',34872.13),
 (141,'DL460618','2005-05-19 00:00:00',22353.86),
 (141,'HJ32686','2004-01-30 00:00:00',65165.17),
 (141,'ID10962','2004-12-31 00:00:00',133588.75),
 (141,'IN446258','2005-03-25 00:00:00',95065.46),
 (141,'JE105477','2005-03-18 00:00:00',90135.87),
 (141,'JN355280','2003-10-26 00:00:00',53502.3),
 (141,'JN722010','2003-02-25 00:00:00',44621.96),
 (141,'KT52578','2003-12-09 00:00:00',72487.5),
 (141,'MC46946','2004-07-09 00:00:00',91328.4),
 (141,'MF629602','2004-08-16 00:00:00',21986.27),
 (141,'NU627706','2004-05-17 00:00:00',28327.64),
 (144,'IR846303','2004-12-12 00:00:00',66005.88),
 (144,'LA685678','2003-04-09 00:00:00',9749),
 (145,'CN328545','2004-07-03 00:00:00',4749.45),
 (145,'ED39322','2004-04-26 00:00:00',31329.56),
 (145,'HR182688','2004-12-01 00:00:00',24078.61),
 (145,'JJ246391','2003-02-20 00:00:00',58871.11),
 (146,'FP549817','2004-03-18 00:00:00',46802.27),
 (146,'FU793410','2004-01-16 00:00:00',54536.87),
 (146,'LJ160635','2003-12-10 00:00:00',41535.11),
 (148,'BI507030','2003-04-22 00:00:00',43657.47),
 (148,'DD635282','2004-08-11 00:00:00',3127.88),
 (148,'KM172879','2003-12-26 00:00:00',122028.73),
 (148,'ME497970','2005-03-27 00:00:00',4175.6),
 (151,'BF686658','2003-12-22 00:00:00',64316.09),
 (151,'GB852215','2004-07-26 00:00:00',23252.18),
 (151,'IP568906','2003-06-18 00:00:00',68462.15),
 (151,'KI884577','2004-12-14 00:00:00',41706.52),
 (157,'HI618861','2004-11-19 00:00:00',44040.73),
 (157,'NN711988','2004-09-07 00:00:00',71930.61),
 (161,'BR352384','2004-11-14 00:00:00',2916.2),
 (161,'BR478494','2003-11-18 00:00:00',62305.47),
 (161,'KG644125','2005-02-02 00:00:00',13529.57),
 (161,'NI908214','2003-08-05 00:00:00',42031.83),
 (166,'BQ327613','2004-09-16 00:00:00',42902.84),
 (166,'DC979307','2004-07-07 00:00:00',45788.72),
 (166,'LA318629','2004-02-28 00:00:00',24219.59),
 (167,'ED743615','2004-09-19 00:00:00',16363.1),
 (167,'GN228846','2003-12-03 00:00:00',95277.18),
 (171,'GB878038','2004-03-15 00:00:00',20178.13),
 (171,'IL104425','2003-11-22 00:00:00',48874.28),
 (172,'AD832091','2004-09-09 00:00:00',2173.6),
 (172,'CE51751','2004-12-04 00:00:00',56812.67),
 (172,'EH208589','2003-04-20 00:00:00',38217.41),
 (173,'GP545698','2004-05-13 00:00:00',14380.92),
 (173,'IG462397','2004-03-29 00:00:00',21782.7),
 (175,'IO448913','2003-11-19 00:00:00',26115.8),
 (175,'PI15215','2004-07-10 00:00:00',44130.52),
 (177,'AU750837','2004-04-17 00:00:00',17114.43),
 (177,'CI381435','2004-01-19 00:00:00',50490.64),
 (181,'CM564612','2004-04-25 00:00:00',24804.34),
 (181,'GQ132144','2003-01-30 00:00:00',6864.05),
 (181,'OH367219','2004-11-16 00:00:00',56372.87),
 (186,'AE192287','2005-03-10 00:00:00',26422.82),
 (186,'AK412714','2003-10-27 00:00:00',42083.5),
 (186,'KA602407','2004-10-21 00:00:00',42744.06),
 (187,'AM968797','2004-11-03 00:00:00',57827.61),
 (187,'BQ39062','2004-12-08 00:00:00',48962.28),
 (187,'KL124726','2003-03-27 00:00:00',51017.92),
 (189,'BO711618','2004-10-03 00:00:00',18971.96),
 (189,'NM916675','2004-03-01 00:00:00',38784.47),
 (198,'FI192930','2004-12-06 00:00:00',11528.53),
 (198,'HQ920205','2003-07-06 00:00:00',7277.35),
 (198,'IS946883','2004-09-21 00:00:00',7673.38),
 (201,'DP677013','2003-10-20 00:00:00',26797.21),
 (201,'OO846801','2004-06-15 00:00:00',50408.25),
 (202,'HI358554','2003-12-18 00:00:00',38662.21),
 (202,'IQ627690','2004-11-08 00:00:00',36576.71),
 (204,'GC697638','2004-08-13 00:00:00',52505.36),
 (204,'IS150005','2004-09-24 00:00:00',4692.6),
 (205,'GL756480','2003-12-04 00:00:00',4512.48),
 (205,'LL562733','2003-09-05 00:00:00',55776.12),
 (205,'NM739638','2005-02-06 00:00:00',44273.36),
 (209,'ED520529','2004-06-21 00:00:00',5416.9),
 (209,'PH785937','2004-05-04 00:00:00',39341.23),
 (211,'BJ535230','2003-12-09 00:00:00',48784.36),
 (216,'BG407567','2003-05-09 00:00:00',4219.2),
 (216,'ML780814','2004-12-06 00:00:00',21249.77),
 (216,'MM342086','2003-12-14 00:00:00',44009.31),
 (219,'BN17870','2005-03-02 00:00:00',3987.2),
 (219,'BR941480','2003-10-18 00:00:00',5142.15),
 (227,'MQ413968','2003-10-31 00:00:00',40321.61),
 (227,'NU21326','2004-11-02 00:00:00',60273.94),
 (233,'II180006','2004-07-01 00:00:00',24564.53),
 (233,'JG981190','2003-11-18 00:00:00',15947.29),
 (239,'NQ865547','2004-03-15 00:00:00',87489.23),
 (240,'IF245157','2004-11-16 00:00:00',51334.16),
 (240,'JO719695','2004-03-28 00:00:00',26906.68),
 (242,'AF40894','2003-11-22 00:00:00',38098.24),
 (242,'HR224331','2005-06-03 00:00:00',15139.12),
 (242,'KI744716','2003-07-21 00:00:00',17251.08),
 (249,'IJ399820','2004-09-19 00:00:00',38039),
 (249,'NE404084','2004-09-04 00:00:00',56078.26),
 (250,'EQ12267','2005-05-17 00:00:00',20321.53),
 (250,'HD284647','2004-12-30 00:00:00',32623.93),
 (250,'HN114306','2003-07-18 00:00:00',25624.88),
 (256,'EP227123','2004-02-10 00:00:00',5759.42),
 (256,'HE84936','2004-10-22 00:00:00',59074.88),
 (259,'EU280955','2004-11-06 00:00:00',68943.4),
 (259,'GB361972','2003-12-07 00:00:00',31363.18),
 (260,'IO164641','2004-08-30 00:00:00',43332.35),
 (260,'NH776924','2004-04-24 00:00:00',31302.5),
 (276,'EM979878','2005-02-09 00:00:00',29852.17),
 (276,'KM841847','2003-11-13 00:00:00',41791.95),
 (276,'LE432182','2003-09-28 00:00:00',47191.76),
 (276,'OJ819725','2005-04-30 00:00:00',35160.25),
 (278,'BJ483870','2004-12-05 00:00:00',41696.69),
 (278,'GP636783','2003-03-02 00:00:00',56181.32),
 (278,'NI983021','2003-11-24 00:00:00',40077.71),
 (282,'IA793562','2003-08-03 00:00:00',28397.26),
 (282,'JT819493','2004-08-02 00:00:00',41297.14),
 (282,'OD327378','2005-01-03 00:00:00',37905.15),
 (286,'DR578578','2004-10-28 00:00:00',54251.66),
 (286,'KH910279','2004-09-05 00:00:00',48828.72),
 (298,'AJ574927','2004-03-13 00:00:00',50432.55),
 (298,'LF501133','2004-09-18 00:00:00',67281.01),
 (299,'AD304085','2003-10-24 00:00:00',45078.76),
 (299,'NR157385','2004-09-05 00:00:00',34145.47),
 (311,'DG336041','2005-02-15 00:00:00',49055.4),
 (311,'FA728475','2003-10-06 00:00:00',37501.58),
 (311,'NQ966143','2004-04-25 00:00:00',17813.4),
 (314,'LQ244073','2004-08-09 00:00:00',47760.48),
 (314,'MD809704','2004-03-03 00:00:00',18800.09),
 (319,'HL685576','2004-11-06 00:00:00',46873.04),
 (319,'OM548174','2003-12-07 00:00:00',38682.95),
 (320,'GJ597719','2005-01-18 00:00:00',11021.3),
 (320,'HO576374','2003-08-20 00:00:00',45738.39),
 (320,'MU817160','2003-11-24 00:00:00',52191.44),
 (321,'DJ15149','2003-11-03 00:00:00',95678.88),
 (321,'LA556321','2005-03-15 00:00:00',54203.62),
 (323,'AL493079','2005-05-23 00:00:00',39267.74),
 (323,'ES347491','2004-06-24 00:00:00',40034.67),
 (323,'HG738664','2003-07-05 00:00:00',2476.8),
 (323,'PQ803830','2004-12-24 00:00:00',43930.62),
 (324,'DQ409197','2004-12-13 00:00:00',13739.9),
 (324,'FP443161','2003-07-07 00:00:00',32376.29),
 (324,'HB150714','2003-11-23 00:00:00',42688.31),
 (328,'EN930356','2004-04-16 00:00:00',8722.12),
 (328,'NR631421','2004-05-30 00:00:00',27987.07),
 (333,'HL209210','2003-11-15 00:00:00',27098.8),
 (333,'JK479662','2003-10-17 00:00:00',10640.29),
 (333,'NF959653','2005-03-01 00:00:00',21730.03),
 (334,'CS435306','2005-01-27 00:00:00',51373.49),
 (334,'HH517378','2003-08-16 00:00:00',31569.43),
 (334,'LF737277','2004-05-22 00:00:00',31018.23),
 (339,'AP286625','2004-10-24 00:00:00',27445.31),
 (339,'DA98827','2003-11-28 00:00:00',40061.66),
 (344,'AF246722','2003-11-24 00:00:00',34311.35),
 (344,'NJ906924','2004-04-02 00:00:00',15330.7),
 (347,'DG700707','2004-01-18 00:00:00',23889.32),
 (347,'LG808674','2003-10-24 00:00:00',24159.14),
 (350,'BQ602907','2004-12-11 00:00:00',20136.86),
 (350,'CI471510','2003-05-25 00:00:00',52481.84),
 (350,'OB648482','2005-01-29 00:00:00',2317.44),
 (353,'CO351193','2005-01-10 00:00:00',48895.59),
 (353,'ED878227','2003-07-21 00:00:00',15146.32),
 (353,'GT878649','2003-05-21 00:00:00',18971.96),
 (353,'HJ618252','2005-06-09 00:00:00',52029.07),
 (357,'AG240323','2003-12-16 00:00:00',23294.8),
 (357,'NB291497','2004-07-01 00:00:00',41418.55),
 (362,'FP170292','2004-07-11 00:00:00',19548.35),
 (362,'OG208861','2004-09-21 00:00:00',15344.64),
 (363,'HL575273','2004-11-17 00:00:00',55570.6),
 (363,'IS232033','2003-01-16 00:00:00',12133.25),
 (363,'PN238558','2003-12-05 00:00:00',63981.45),
 (379,'CA762595','2005-02-12 00:00:00',31474.78),
 (379,'FR499138','2003-09-16 00:00:00',34992.4),
 (379,'GB890854','2004-08-02 00:00:00',15110.8),
 (381,'BC726082','2004-12-03 00:00:00',13463.48),
 (381,'CC475233','2003-04-19 00:00:00',1711.26),
 (381,'GB117430','2005-02-03 00:00:00',16628.16),
 (381,'MS154481','2003-08-22 00:00:00',1637.2),
 (382,'CC871084','2003-05-12 00:00:00',38629.14),
 (382,'CT821147','2004-08-01 00:00:00',6693.28),
 (382,'PH29054','2004-11-27 00:00:00',37353.16),
 (385,'BN347084','2003-12-02 00:00:00',22841.96),
 (385,'CP804873','2004-11-19 00:00:00',15928.75),
 (385,'EK785462','2003-03-09 00:00:00',55245.02),
 (386,'DO106109','2003-11-18 00:00:00',44669.74),
 (386,'HG438769','2004-07-18 00:00:00',56421.65),
 (398,'AJ478695','2005-02-14 00:00:00',38191.39),
 (398,'DO787644','2004-06-21 00:00:00',25928.75),
 (398,'KB54275','2004-11-29 00:00:00',44802.04),
 (406,'HJ217687','2004-01-28 00:00:00',51172.65),
 (406,'NA197101','2004-06-17 00:00:00',27931.21),
 (412,'GH197075','2004-07-25 00:00:00',35911.81),
 (412,'PJ434867','2004-04-14 00:00:00',36409.31),
 (415,'ER54537','2004-09-28 00:00:00',34993.92),
 (424,'KF480160','2004-12-07 00:00:00',27733.04),
 (424,'LM271923','2003-04-16 00:00:00',24777.41),
 (424,'OA595449','2003-10-31 00:00:00',25284.75),
 (447,'AO757239','2003-09-15 00:00:00',7600.12),
 (447,'ER615123','2003-06-25 00:00:00',20350.95),
 (447,'OU516561','2004-12-17 00:00:00',29343.35),
 (448,'EQ620556','2003-11-06 00:00:00',48710.92),
 (448,'FS299615','2005-04-18 00:00:00',31606.72),
 (448,'KR822727','2004-09-30 00:00:00',53941.69),
 (450,'EF485824','2004-06-21 00:00:00',64600.34),
 (452,'ED473873','2003-11-15 00:00:00',28550.59),
 (452,'FN640986','2003-11-20 00:00:00',14938.15),
 (452,'HG635467','2005-05-03 00:00:00',8775.16),
 (455,'HA777606','2003-12-05 00:00:00',42498.76),
 (455,'IR662429','2004-05-12 00:00:00',36973.31),
 (456,'GJ715659','2004-11-13 00:00:00',31446.15),
 (456,'MO743231','2004-04-30 00:00:00',1698.78),
 (458,'DD995006','2004-11-15 00:00:00',34546.6),
 (458,'NA377824','2004-02-06 00:00:00',24995.47),
 (458,'OO606861','2003-06-13 00:00:00',61073.21),
 (462,'ED203908','2005-04-15 00:00:00',37557.7),
 (462,'GC60330','2003-11-08 00:00:00',11861.69),
 (462,'PE176846','2004-11-27 00:00:00',49504.38),
 (471,'AB661578','2004-07-28 00:00:00',12334.82),
 (471,'CO645196','2003-12-10 00:00:00',37878.55),
 (473,'LL427009','2004-02-17 00:00:00',7278.98),
 (473,'PC688499','2003-10-27 00:00:00',21672.93),
 (475,'JP113227','2003-12-09 00:00:00',8234.56),
 (475,'PB951268','2004-02-13 00:00:00',37850.08),
 (484,'GK294076','2004-10-26 00:00:00',3220.88),
 (484,'JH546765','2003-11-29 00:00:00',51502.74),
 (486,'BL66528','2004-04-14 00:00:00',7287.24),
 (486,'HS86661','2004-11-23 00:00:00',48996.1),
 (486,'JB117768','2003-03-20 00:00:00',27398.82),
 (487,'AH612904','2003-09-28 00:00:00',34100.03),
 (487,'PT550181','2004-02-29 00:00:00',16118.48),
 (489,'OC773849','2003-12-04 00:00:00',27541.82),
 (489,'PO860906','2004-01-31 00:00:00',8477.22),
 (495,'BH167026','2003-12-26 00:00:00',63730.78),
 (495,'FN155234','2004-05-14 00:00:00',7129),
 (496,'EU531600','2005-06-25 00:00:00',34332.29),
 (496,'MB342426','2003-07-16 00:00:00',37754.33),
 (496,'MN89921','2004-12-31 00:00:00',58593.28),
 (496,'PL783960','2003-11-29 00:00:00',26421.24);

DROP TABLE IF EXISTS `classicmodels`.`Product`;
CREATE TABLE  `classicmodels`.`Product` (
  `productCode` varchar(50) NOT NULL,
  `productName` varchar(70) NOT NULL,
  `productLine` varchar(50) NOT NULL,
  `productScale` varchar(10) NOT NULL,
  `productVendor` varchar(50) NOT NULL,
  `productDescription` text NOT NULL,
  `quantityInStock` smallint(6) NOT NULL,
  `buyPrice` double NOT NULL,
  `MSRP` double NOT NULL,
  PRIMARY KEY (`productCode`)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `classicmodels`.`Product` (`productCode`,`productName`,`productLine`,`productScale`,`productVendor`,`productDescription`,`quantityInStock`,`buyPrice`,`MSRP`) VALUES 
 ('S10_1678','1969 Harley Davidson Ultimate Chopper','Motorcycles','1:10','Min Lin Diecast','This replica features working kickstand, front suspension, gear-shift lever, footbrake lever, drive chain, wheels and steering. All parts are particularly delicate due to their precise scale and require special care and attention.',7933,48.81,95.7),
 ('S10_1949','1952 Alpine Renault 1300','Classic Cars','1:10','Classic Metal Creations','Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.',7305,98.58,214.3),
 ('S10_2016','1996 Moto Guzzi 1100i','Motorcycles','1:10','Highway 66 Mini Classics','Official Moto Guzzi logos and insignias, saddle bags located on side of motorcycle, detailed engine, working steering, working suspension, two leather seats, luggage rack, dual exhaust pipes, small saddle bag located on handle bars, two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand, diecast metal with plastic parts and baked enamel finish.',6625,68.99,118.94),
 ('S10_4698','2003 Harley-Davidson Eagle Drag Bike','Motorcycles','1:10','Red Start Diecast','Model features, official Harley Davidson logos and insignias, detachable rear wheelie bar, heavy diecast metal with resin parts, authentic multi-color tampo-printed graphics, separate engine drive belts, free-turning front fork, rotating tires and rear racing slick, certificate of authenticity, detailed engine, display stand\r\n, precision diecast replica, baked enamel finish, 1:10 scale model, removable fender, seat and tank cover piece for displaying the superior detail of the v-twin engine',5582,91.02,193.66),
 ('S10_4757','1972 Alfa Romeo GTA','Classic Cars','1:10','Motor City Art Classics','Features include: Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.',3252,85.68,136),
 ('S10_4962','1962 LanciaA Delta 16V','Classic Cars','1:10','Second Gear Diecast','Features include: Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.',6791,103.42,147.74),
 ('S12_1099','1968 Ford Mustang','Classic Cars','1:12','Autoart Studio Design','Hood, doors and trunk all open to reveal highly detailed interior features. Steering wheel actually turns the front wheels. Color dark green.',68,95.34,194.57),
 ('S12_1108','2001 Ferrari Enzo','Classic Cars','1:12','Second Gear Diecast','Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.',3619,95.59,207.8),
 ('S12_1666','1958 Setra Bus','Trucks and Buses','1:12','Welly Diecast Productions','Model features 30 windows, skylights & glare resistant glass, working steering system, original logos',1579,77.9,136.67),
 ('S12_2823','2002 Suzuki XREO','Motorcycles','1:12','Unimax Art Galleries','Official logos and insignias, saddle bags located on side of motorcycle, detailed engine, working steering, working suspension, two leather seats, luggage rack, dual exhaust pipes, small saddle bag located on handle bars, two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand, diecast metal with plastic parts and baked enamel finish.',9997,66.27,150.62),
 ('S12_3148','1969 Corvair Monza','Classic Cars','1:18','Welly Diecast Productions','1:18 scale die-cast about 10\" long doors open, hood opens, trunk opens and wheels roll',6906,89.14,151.08),
 ('S12_3380','1968 Dodge Charger','Classic Cars','1:12','Welly Diecast Productions','1:12 scale model of a 1968 Dodge Charger. Hood, doors and trunk all open to reveal highly detailed interior features. Steering wheel actually turns the front wheels. Color black',9123,75.16,117.44),
 ('S12_3891','1969 Ford Falcon','Classic Cars','1:12','Second Gear Diecast','Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.',1049,83.05,173.02),
 ('S12_3990','1970 Plymouth Hemi Cuda','Classic Cars','1:12','Studio M Art Models','Very detailed 1970 Plymouth Cuda model in 1:12 scale. The Cuda is generally accepted as one of the fastest original muscle cars from the 1970s. This model is a reproduction of one of the orginal 652 cars built in 1970. Red color.',5663,31.92,79.8),
 ('S12_4473','1957 Chevy Pickup','Trucks and Buses','1:12','Exoto Designs','1:12 scale die-cast about 20\" long Hood opens, Rubber wheels',6125,55.7,118.5),
 ('S12_4675','1969 Dodge Charger','Classic Cars','1:12','Welly Diecast Productions','Detailed model of the 1969 Dodge Charger. This model includes finely detailed interior and exterior features. Painted in red and white.',7323,58.73,115.16),
 ('S18_1097','1940 Ford Pickup Truck','Trucks and Buses','1:18','Studio M Art Models','This model features soft rubber tires, working steering, rubber mud guards, authentic Ford logos, detailed undercarriage, opening doors and hood,  removable split rear gate, full size spare mounted in bed, detailed interior with opening glove box',2613,58.33,116.67),
 ('S18_1129','1993 Mazda RX-7','Classic Cars','1:18','Highway 66 Mini Classics','This model features, opening hood, opening doors, detailed engine, rear spoiler, opening trunk, working steering, tinted windows, baked enamel finish. Color red.',3975,83.51,141.54),
 ('S18_1342','1937 Lincoln Berline','Vintage Cars','1:18','Motor City Art Classics','Features opening engine cover, doors, trunk, and fuel filler cap. Color black',8693,60.62,102.74),
 ('S18_1367','1936 Mercedes-Benz 500K Special Roadster','Vintage Cars','1:18','Studio M Art Models','This 1:18 scale replica is constructed of heavy die-cast metal and has all the features of the original: working doors and rumble seat, independent spring suspension, detailed interior, working steering system, and a bifold hood that reveals an engine so accurate that it even includes the wiring. All this is topped off with a baked enamel finish. Color white.',8635,24.26,53.91),
 ('S18_1589','1965 Aston Martin DB5','Classic Cars','1:18','Classic Metal Creations','Die-cast model of the silver 1965 Aston Martin DB5 in silver. This model includes full wire wheels and doors that open with fully detailed passenger compartment. In 1:18 scale, this model measures approximately 10 inches/20 cm long.',9042,65.96,124.44),
 ('S18_1662','1980s Black Hawk Helicopter','Planes','1:18','Red Start Diecast','1:18 scale replica of actual Armys UH-60L BLACK HAWK Helicopter. 100% hand-assembled. Features rotating rotor blades, propeller blades and rubber wheels.',5330,77.27,157.69),
 ('S18_1749','1917 Grand Touring Sedan','Vintage Cars','1:18','Welly Diecast Productions','This 1:18 scale replica of the 1917 Grand Touring car has all the features you would expect from museum quality reproductions: all four doors and bi-fold hood opening, detailed engine and instrument panel, chrome-look trim, and tufted upholstery, all topped off with a factory baked-enamel finish.',2724,86.7,170),
 ('S18_1889','1948 Porsche 356-A Roadster','Classic Cars','1:18','Gearbox Collectibles','This precision die-cast replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.',8826,53.9,77),
 ('S18_1984','1995 Honda Civic','Classic Cars','1:18','Min Lin Diecast','This model features, opening hood, opening doors, detailed engine, rear spoiler, opening trunk, working steering, tinted windows, baked enamel finish. Color yellow.',9772,93.89,142.25),
 ('S18_2238','1998 Chrysler Plymouth Prowler','Classic Cars','1:18','Gearbox Collectibles','Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.',4724,101.51,163.73),
 ('S18_2248','1911 Ford Town Car','Vintage Cars','1:18','Motor City Art Classics','Features opening hood, opening doors, opening trunk, wide white wall tires, front door arm rests, working steering system',540,33.3,60.54),
 ('S18_2319','1964 Mercedec Tour Bus','Trucks and Buses','1:18','Unimax Art Galleries','Exact replica. 100+ parts. working steering system, original logos',8258,74.86,122.73),
 ('S18_2325','1932 Model A Ford J-Coupe','Vintage Cars','1:18','Autoart Studio Design','This model features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system, chrome-covered spare, opening doors, detailed and wired engine',9354,58.48,127.13),
 ('S18_2432','1926 Ford Fire Engine','Trucks and Buses','1:18','Carousel DieCast Legends','Gleaming red handsome appearance. Everything is here the fire hoses, ladder, axes, bells, lanterns, ready to fight any inferno.',2018,24.92,60.77),
 ('S18_2581','P-51-D Mustang','Planes','1:72','Gearbox Collectibles','Has retractable wheels and comes with a stand',992,49,84.48),
 ('S18_2625','1936 Harley Davidson El Knucklehead','Motorcycles','1:18','Welly Diecast Productions','Intricately detailed with chrome accents and trim, official die-struck logos and baked enamel finish.',4357,24.23,60.57),
 ('S18_2795','1928 Mercedes-Benz SSK','Vintage Cars','1:18','Gearbox Collectibles','This 1:18 replica features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system, chrome-covered spare, opening doors, detailed and wired engine. Color black.',548,72.56,168.75),
 ('S18_2870','1999 Indy 500 Monte Carlo SS','Classic Cars','1:18','Red Start Diecast','Features include opening and closing doors. Color: Red',8164,56.76,132),
 ('S18_2949','1913 Ford Model T Speedster','Vintage Cars','1:18','Carousel DieCast Legends','This 250 part reproduction includes moving handbrakes, clutch, throttle and foot pedals, squeezable horn, detailed wired engine, removable water, gas, and oil cans, pivoting monocle windshield, all topped with a baked enamel red finish. Each replica comes with an Owners Title and Certificate of Authenticity. Color red.',4189,60.78,101.31),
 ('S18_2957','1934 Ford V8 Coupe','Vintage Cars','1:18','Min Lin Diecast','Chrome Trim, Chrome Grille, Opening Hood, Opening Doors, Opening Trunk, Detailed Engine, Working Steering System',5649,34.35,62.46),
 ('S18_3029','1999 Yamaha Speed Boat','Ships','1:18','Min Lin Diecast','Exact replica. Wood and Metal. Many extras including rigging, long boats, pilot house, anchors, etc. Comes with three masts, all square-rigged.',4259,51.61,86.02),
 ('S18_3136','18th Century Vintage Horse Carriage','Vintage Cars','1:18','Red Start Diecast','Hand crafted diecast-like metal horse carriage is re-created in about 1:18 scale of antique horse carriage. This antique style metal Stagecoach is all hand-assembled with many different parts.\r\n\r\nThis collectible metal horse carriage is painted in classic Red, and features turning steering wheel and is entirely hand-finished.',5992,60.74,104.72),
 ('S18_3140','1903 Ford Model A','Vintage Cars','1:18','Unimax Art Galleries','Features opening trunk,  working steering system',3913,68.3,136.59),
 ('S18_3232','1992 Ferrari 360 Spider red','Classic Cars','1:18','Unimax Art Galleries','his replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.',8347,77.9,169.34),
 ('S18_3233','1985 Toyota Supra','Classic Cars','1:18','Highway 66 Mini Classics','This model features soft rubber tires, working steering, rubber mud guards, authentic Ford logos, detailed undercarriage, opening doors and hood, removable split rear gate, full size spare mounted in bed, detailed interior with opening glove box',7733,57.01,107.57),
 ('S18_3259','Collectable Wooden Train','Trains','1:18','Carousel DieCast Legends','Hand crafted wooden toy train set is in about 1:18 scale, 25 inches in total length including 2 additional carts, of actual vintage train. This antique style wooden toy train model set is all hand-assembled with 100% wood.',6450,67.56,100.84),
 ('S18_3278','1969 Dodge Super Bee','Classic Cars','1:18','Min Lin Diecast','This replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.',1917,49.05,80.41),
 ('S18_3320','1917 Maxwell Touring Car','Vintage Cars','1:18','Exoto Designs','Features Gold Trim, Full Size Spare Tire, Chrome Trim, Chrome Grille, Opening Hood, Opening Doors, Opening Trunk, Detailed Engine, Working Steering System',7913,57.54,99.21),
 ('S18_3482','1976 Ford Gran Torino','Classic Cars','1:18','Gearbox Collectibles','Highly detailed 1976 Ford Gran Torino \"Starsky and Hutch\" diecast model. Very well constructed and painted in red and white patterns.',9127,73.49,146.99),
 ('S18_3685','1948 Porsche Type 356 Roadster','Classic Cars','1:18','Gearbox Collectibles','This model features working front and rear suspension on accurately replicated and actuating shock absorbers as well as opening engine cover, rear stabilizer flap,  and 4 opening doors.',8990,62.16,141.28),
 ('S18_3782','1957 Vespa GS150','Motorcycles','1:18','Studio M Art Models','Features rotating wheels , working kick stand. Comes with stand.',7689,32.95,62.17),
 ('S18_3856','1941 Chevrolet Special Deluxe Cabriolet','Vintage Cars','1:18','Exoto Designs','Features opening hood, opening doors, opening trunk, wide white wall tires, front door arm rests, working steering system, leather upholstery. Color black.',2378,64.58,105.87),
 ('S18_4027','1970 Triumph Spitfire','Classic Cars','1:18','Min Lin Diecast','Features include opening and closing doors. Color: White.',5545,91.92,143.62),
 ('S18_4409','1932 Alfa Romeo 8C2300 Spider Sport','Vintage Cars','1:18','Exoto Designs','This 1:18 scale precision die cast replica features the 6 front headlights of the original, plus a detailed version of the 142 horsepower straight 8 engine, dual spares and their famous comprehensive dashboard. Color black.',6553,43.26,92.03),
 ('S18_4522','1904 Buick Runabout','Vintage Cars','1:18','Exoto Designs','Features opening trunk,  working steering system',8290,52.66,87.77),
 ('S18_4600','1940s Ford truck','Trucks and Buses','1:18','Motor City Art Classics','This 1940s Ford Pick-Up truck is re-created in 1:18 scale of original 1940s Ford truck. This antique style metal 1940s Ford Flatbed truck is all hand-assembled. This collectible 1940s Pick-Up truck is painted in classic dark green color, and features rotating wheels.',3128,84.76,121.08),
 ('S18_4668','1939 Cadillac Limousine','Vintage Cars','1:18','Studio M Art Models','Features completely detailed interior including Velvet flocked drapes,deluxe wood grain floor, and a wood grain casket with seperate chrome handles',6645,23.14,50.31),
 ('S18_4721','1957 Corvette Convertible','Classic Cars','1:18','Classic Metal Creations','1957 die cast Corvette Convertible in Roman Red with white sides and whitewall tires. 1:18 scale quality die-cast with detailed engine and underbvody. Now you can own The Classic Corvette.',1249,69.93,148.8),
 ('S18_4933','1957 Ford Thunderbird','Classic Cars','1:18','Studio M Art Models','This 1:18 scale precision die-cast replica, with its optional porthole hardtop and factory baked-enamel Thunderbird Bronze finish, is a 100% accurate rendition of this American classic.',3209,34.21,71.27),
 ('S24_1046','1970 Chevy Chevelle SS 454','Classic Cars','1:24','Unimax Art Galleries','This model features rotating wheels, working streering system and opening doors. All parts are particularly delicate due to their precise scale and require special care and attention. It should not be picked up by the doors, roof, hood or trunk.',1005,49.24,73.49),
 ('S24_1444','1970 Dodge Coronet','Classic Cars','1:24','Highway 66 Mini Classics','1:24 scale die-cast about 18\" long doors open, hood opens and rubber wheels',4074,32.37,57.8),
 ('S24_1578','1997 BMW R 1100 S','Motorcycles','1:24','Autoart Studio Design','Detailed scale replica with working suspension and constructed from over 70 parts',7003,60.86,112.7),
 ('S24_1628','1966 Shelby Cobra 427 S/C','Classic Cars','1:24','Carousel DieCast Legends','This diecast model of the 1966 Shelby Cobra 427 S/C includes many authentic details and operating parts. The 1:24 scale model of this iconic lighweight sports car from the 1960s comes in silver and its own display case.',8197,29.18,50.31),
 ('S24_1785','1928 British Royal Navy Airplane','Planes','1:24','Classic Metal Creations','Official logos and insignias',3627,66.74,109.42),
 ('S24_1937','1939 Chevrolet Deluxe Coupe','Vintage Cars','1:24','Motor City Art Classics','This 1:24 scale die-cast replica of the 1939 Chevrolet Deluxe Coupe has the same classy look as the original. Features opening trunk, hood and doors and a showroom quality baked enamel finish.',7332,22.57,33.19),
 ('S24_2000','1960 BSA Gold Star DBD34 1960','Motorcycles','1:24','Highway 66 Mini Classics','Detailed scale replica with working suspension and constructed from over 70 parts',15,37.32,76.17),
 ('S24_2011','18th century schooner','Ships','1:24','Carousel DieCast Legends','All wood with canvas sails. Many extras including rigging, long boats, pilot house, anchors, etc. Comes with 4 masts, all square-rigged.',1898,82.34,122.89),
 ('S24_2022','1938 Cadillac V-16 Presidential Limousine','Vintage Cars','1:24','Classic Metal Creations','This 1:24 scale precision die cast replica of the 1938 Cadillac V-16 Presidential Limousine has all the details of the original, from the flags on the front to an opening back seat compartment complete with telephone and rifle. Features factory baked-enamel black finish, hood goddess ornament, working jump seats.',2847,20.61,44.8),
 ('S24_2300','1962 Volkswagen Microbus','Trucks and Buses','1:24','Autoart Studio Design','This 1:18 scale die cast replica of the 1962 Microbus is loaded with features: A working steering system, opening front doors and tailgate, and famous two-tone factory baked enamel finish, are all topped of by the sliding, real fabric, sunroof.',2327,61.34,127.79),
 ('S24_2360','1982 Ducati 900 Monster','Motorcycles','1:24','Highway 66 Mini Classics','Features two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand',6840,47.1,69.26),
 ('S24_2766','1949 Jaguar XK 120','Classic Cars','1:24','Classic Metal Creations','Precision-engineered from original Jaguar specification in perfect scale ratio. Features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.',2350,47.25,90.87),
 ('S24_2840','1958 Chevy Corvette Limited Edition','Classic Cars','1:24','Carousel DieCast Legends','The operating parts of this 1958 Chevy Corvette Limited Edition are particularly delicate due to their precise scale and require special care and attention. Features rotating wheels, working streering, opening doors and trunk. Color dark green.',2542,15.91,35.36),
 ('S24_2841','1900s Vintage Bi-Plane','Planes','1:24','Autoart Studio Design','Hand crafted diecast-like metal bi-plane is re-created in about 1:24 scale of antique pioneer airplane. All hand-assembled with many different parts. Hand-painted in classic yellow and features correct markings of original airplane.',5942,34.25,68.51),
 ('S24_2887','1952 Citroen-15CV','Classic Cars','1:24','Exoto Designs','Precision crafted hand-assembled 1:18 scale reproduction of the 1952 15CV, with its independent spring suspension, working steering system, opening doors and hood, detailed engine and instrument panel, all topped of with a factory fresh baked enamel finish.',1452,72.82,117.44),
 ('S24_2972','1982 Lamborghini Diablo','Classic Cars','1:24','Second Gear Diecast','This replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.',7723,16.24,37.76),
 ('S24_3151','1912 Ford Model T Delivery Wagon','Vintage Cars','1:24','Min Lin Diecast','This model features chrome trim and grille, opening hood, opening doors, opening trunk, detailed engine, working steering system. Color white.',9173,46.91,88.51),
 ('S24_3191','1969 Chevrolet Camaro Z28','Classic Cars','1:24','Exoto Designs','1969 Z/28 Chevy Camaro 1:24 scale replica. The operating parts of this limited edition 1:24 scale diecast model car 1969 Chevy Camaro Z28- hood, trunk, wheels, streering, suspension and doors- are particularly delicate due to their precise scale and require special care and attention.',4695,50.51,85.61),
 ('S24_3371','1971 Alpine Renault 1600s','Classic Cars','1:24','Welly Diecast Productions','This 1971 Alpine Renault 1600s replica Features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.',7995,38.58,61.23),
 ('S24_3420','1937 Horch 930V Limousine','Vintage Cars','1:24','Autoart Studio Design','Features opening hood, opening doors, opening trunk, wide white wall tires, front door arm rests, working steering system',2902,26.3,65.75),
 ('S24_3432','2002 Chevy Corvette','Classic Cars','1:24','Gearbox Collectibles','The operating parts of this limited edition Diecast 2002 Chevy Corvette 50th Anniversary Pace car Limited Edition are particularly delicate due to their precise scale and require special care and attention. Features rotating wheels, poseable streering, opening doors and trunk.',9446,62.11,107.08),
 ('S24_3816','1940 Ford Delivery Sedan','Vintage Cars','1:24','Carousel DieCast Legends','Chrome Trim, Chrome Grille, Opening Hood, Opening Doors, Opening Trunk, Detailed Engine, Working Steering System. Color black.',6621,48.64,83.86),
 ('S24_3856','1956 Porsche 356A Coupe','Classic Cars','1:18','Classic Metal Creations','Features include: Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.',6600,98.3,140.43),
 ('S24_3949','Corsair F4U ( Bird Cage)','Planes','1:24','Second Gear Diecast','Has retractable wheels and comes with a stand. Official logos and insignias.',6812,29.34,68.24),
 ('S24_3969','1936 Mercedes Benz 500k Roadster','Vintage Cars','1:24','Red Start Diecast','This model features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system and rubber wheels. Color black.',2081,21.75,41.03),
 ('S24_4048','1992 Porsche Cayenne Turbo Silver','Classic Cars','1:24','Exoto Designs','This replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.',6582,69.78,118.28),
 ('S24_4258','1936 Chrysler Airflow','Vintage Cars','1:24','Second Gear Diecast','Features opening trunk,  working steering system. Color dark green.',4710,57.46,97.39),
 ('S24_4278','1900s Vintage Tri-Plane','Planes','1:24','Unimax Art Galleries','Hand crafted diecast-like metal Triplane is Re-created in about 1:24 scale of antique pioneer airplane. This antique style metal triplane is all hand-assembled with many different parts.',2756,36.23,72.45),
 ('S24_4620','1961 Chevrolet Impala','Classic Cars','1:18','Classic Metal Creations','This 1:18 scale precision die-cast reproduction of the 1961 Chevrolet Impala has all the features-doors, hood and trunk that open; detailed 409 cubic-inch engine; chrome dashboard and stick shift, two-tone interior; working steering system; all topped of with a factory baked-enamel finish.',7869,32.33,80.84),
 ('S32_1268','1980’s GM Manhattan Express','Trucks and Buses','1:32','Motor City Art Classics','This 1980’s era new look Manhattan express is still active, running from the Bronx to mid-town Manhattan. Has 35 opeining windows and working lights. Needs a battery.',5099,53.93,96.31),
 ('S32_1374','1997 BMW F650 ST','Motorcycles','1:32','Exoto Designs','Features official die-struck logos and baked enamel finish. Comes with stand.',178,66.92,99.89),
 ('S32_2206','1982 Ducati 996 R','Motorcycles','1:32','Gearbox Collectibles','Features rotating wheels , working kick stand. Comes with stand.',9241,24.14,40.23),
 ('S32_2509','1954 Greyhound Scenicruiser','Trucks and Buses','1:32','Classic Metal Creations','Model features bi-level seating, 50 windows, skylights & glare resistant glass, working steering system, original logos',2874,25.98,54.11),
 ('S32_3207','1950s Chicago Surface Lines Streetcar','Trains','1:32','Gearbox Collectibles','This streetcar is a joy to see. It has 80 separate windows, electric wire guides, detailed interiors with seats, poles and drivers controls, rolling and turning wheel assemblies, plus authentic factory baked-enamel finishes (Green Hornet for Chicago and Cream and Crimson for Boston).',8601,26.72,62.14),
 ('S32_3522','1996 Peterbilt 379 Stake Bed with Outrigger','Trucks and Buses','1:32','Red Start Diecast','This model features, opening doors, detailed engine, working steering, tinted windows, detailed interior, die-struck logos, removable stakes operating outriggers, detachable second trailer, functioning 360-degree self loader, precision molded resin trailer and trim, baked enamel finish on cab',814,33.61,64.64),
 ('S32_4289','1928 Ford Phaeton Deluxe','Vintage Cars','1:32','Highway 66 Mini Classics','This model features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system',136,33.02,68.79),
 ('S32_4485','1974 Ducati 350 Mk3 Desmo','Motorcycles','1:32','Second Gear Diecast','This model features two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand',3341,56.13,102.05),
 ('S50_1341','1930 Buick Marquette Phaeton','Vintage Cars','1:50','Studio M Art Models','Features opening trunk,  working steering system',7062,27.06,43.64),
 ('S50_1392','Diamond T620 Semi-Skirted Tanker','Trucks and Buses','1:50','Highway 66 Mini Classics','This limited edition model is licensed and perfectly scaled for Lionel Trains. The Diamond T620 has been produced in solid precision diecast and painted with a fire baked enamel finish. It comes with a removable tanker and is a perfect model to add authenticity to your static train or car layout or to just have on display.',1016,68.29,115.75),
 ('S50_1514','1962 City of Detroit Streetcar','Trains','1:50','Classic Metal Creations','This streetcar is a joy to see. It has 99 separate windows, electric wire guides, detailed interiors with seats, poles and drivers controls, rolling and turning wheel assemblies, plus authentic factory baked-enamel finishes (Green Hornet for Chicago and Cream and Crimson for Boston).',1645,37.49,58.58),
 ('S50_4713','2002 Yamaha YZR M1','Motorcycles','1:50','Autoart Studio Design','Features rotating wheels , working kick stand. Comes with stand.',600,34.17,81.36),
 ('S700_1138','The Schooner Bluenose','Ships','1:700','Autoart Studio Design','All wood with canvas sails. Measures 31 1/2 inches in Length, 22 inches High and 4 3/4 inches Wide. Many extras.\r\nThe schooner Bluenose was built in Nova Scotia in 1921 to fish the rough waters off the coast of Newfoundland. Because of the Bluenose racing prowess she became the pride of all Canadians. Still featured on stamps and the Canadian dime, the Bluenose was lost off Haiti in 1946.',1897,34,66.67),
 ('S700_1691','American Airlines: B767-300','Planes','1:700','Min Lin Diecast','Exact replia with official logos and insignias and retractable wheels',5841,51.15,91.34),
 ('S700_1938','The Mayflower','Ships','1:700','Studio M Art Models','Measures 31 1/2 inches Long x 25 1/2 inches High x 10 5/8 inches Wide\r\nAll wood with canvas sail. Extras include long boats, rigging, ladders, railing, anchors, side cannons, hand painted, etc.\r\n\r\nThe Mayfower was already old in 1620, when the pilgrims charted her to bring their band of 103 to North America.',737,43.3,86.61),
 ('S700_2047','HMS Bounty','Ships','1:700','Unimax Art Galleries','Measures 30 inches Long x 27 1/2 inches High x 4 3/4 inches Wide. \r\nMany extras including rigging, long boats, pilot house, anchors, etc. Comes with three masts, all square-rigged.',3501,39.83,90.52),
 ('S700_2466','America West Airlines B757-200','Planes','1:700','Motor City Art Classics','Official logos and insignias. Working steering system. Rotating jet engines',9653,68.8,99.72),
 ('S700_2610','The USS Constitution Ship','Ships','1:700','Red Start Diecast','All wood with canvas sails. Measures 31 1/2\" Length x 22 3/8\" High x 8 1/4\" Width. Extras include 4 boats on deck, sea sprite on bow, anchors, copper railing, pilot houses, etc.\r\n\r\nThis was one of six warships commissioned by George Washington and launched in 1797. The nickname Old Ironsides was given the ship when British cannonballs bounced off the 21-inch oak planking of the American frigates hull. The Constitution has been restored and now resides in Boston Harbor.',7083,33.97,72.28),
 ('S700_2824','1982 Camaro Z28','Classic Cars','1:18','Carousel DieCast Legends','Features include opening and closing doors. Color: White. \r\nMeasures approximately 9 1/2\" Long.',6934,46.53,101.15),
 ('S700_2834','ATA: B757-300','Planes','1:700','Highway 66 Mini Classics','Exact replia with official logos and insignias and retractable wheels',7106,59.33,118.65),
 ('S700_3167','F/A 18 Hornet 1/72','Planes','1:72','Motor City Art Classics','10\" Wingspan with retractable landing gears.Comes with pilot',551,54.4,80),
 ('S700_3505','The Titanic','Ships','1:700','Carousel DieCast Legends','Completed model measures 19 1/2 inches long, 9 inches high, 3inches wide and is in barn red/black. All wood and metal.',1956,51.09,100.17),
 ('S700_3962','The Queen Mary','Ships','1:700','Welly Diecast Productions','Exact replica. Wood and Metal. Many extras including rigging, long boats, pilot house, anchors, etc. Comes with three masts, all square-rigged.',5088,53.63,99.31),
 ('S700_4002','American Airlines: MD-11S','Planes','1:700','Second Gear Diecast','Polished finish. Exact replia with official logos and insignias and retractable wheels',8820,36.27,74.03),
 ('S72_1253','Boeing X-32A JSF','Planes','1:72','Motor City Art Classics','10\" Wingspan with retractable landing gears.Comes with pilot',4857,32.77,49.66),
 ('S72_3212','Pont Yacht','Ships','1:72','Unimax Art Galleries','Measures 38 inches Long x 33 3/4 inches High. Includes a stand.\r\nMany extras including rigging, long boats, pilot house, anchors, etc. Comes with 2 masts, all square-rigged',414,33.3,54.6);


DROP TABLE IF EXISTS `classicmodels`.`Contrato`;
CREATE TABLE  `classicmodels`.`Contrato` (
  `id` numeric(10) NOT NULL,
  `numero_contrato` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `classicmodels`.`Contrato` (`id`,`numero_contrato`) VALUES 
 (1, '100001-9');
 
DROP TABLE IF EXISTS `classicmodels`.`Parcela`;
CREATE TABLE  `classicmodels`.`Parcela` (
  `id` numeric(10) NOT NULL,
  `numero_parcela` numeric(10) NOT NULL,
  `contrato_id` numeric(10) NOT NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `classicmodels`.`Parcela` (`id`,`numero_parcela`,`contrato_id`) VALUES 
 (1, 1, 1);
 
DROP TABLE IF EXISTS `classicmodels`.`Liquidacao`;
CREATE TABLE  `classicmodels`.`Liquidacao` (
  `id` numeric(10) NOT NULL,
  `valor_total` numeric(10) NOT NULL,
  `contrato_id` numeric(10) NOT NULL,
  `parcela_id` numeric(10) NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `classicmodels`.`Liquidacao` (`id`,`valor_total`,`contrato_id`, `parcela_id`) VALUES 
 (1, 10000, 1, 1);
 

 
 
-- Return to H2 regular mode
SET MODE REGULAR;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
