/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.util.ArrayList;
import java.util.List;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;

public class TupleSet<@RegexBottom E> {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<E>> tuples;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int tupleLength;

    public TupleSet() {
        this.tuples = new ArrayList<List<E>>(1);
        this.tuples.add(new ArrayList(0));
        this.tupleLength = 0;
    }

    private TupleSet(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<E>> tuples, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int tupleLength) {
        this.tuples = tuples;
        this.tupleLength = tupleLength;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<E>> tuples() {
        return this.tuples;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TupleSet<E> extend(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<E> elements) {
        ArrayList<List<List<E>>> tupleList = new ArrayList<List<List<E>>>(this.tuples.size() * elements.size());
        for (List<E> tuple : this.tuples) {
            for (E e : elements) {
                List<E> extTuple = this.extendTuple(tuple, e);
                assert (extTuple.size() == this.tupleLength + 1) : "tuple lengths don't match, expected " + this.tupleLength + " have " + extTuple.size();
                tupleList.add(extTuple);
            }
        }
        return new TupleSet<E>(tupleList, this.tupleLength + 1);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TupleSet<E> exhaustivelyExtend(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<E> elements) {
        ArrayList<List<List<E>>> tupleList = new ArrayList<List<List<E>>>(this.tuples.size() * (this.tupleLength + 1));
        for (List<E> tuple : this.tuples) {
            for (E e : elements) {
                for (int i = 0; i <= tuple.size(); ++i) {
                    tupleList.add(this.insertInTuple(tuple, e, i));
                }
            }
        }
        return new TupleSet<E>(tupleList, this.tupleLength + 1);
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<E> extendTuple(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<E> tuple, E e) {
        ArrayList<E> extTuple = new ArrayList<E>(this.tupleLength + 1);
        extTuple.addAll(tuple);
        extTuple.add(e);
        return extTuple;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<E> insertInTuple(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<E> tuple, E e, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int i) {
        ArrayList<E> extTuple = new ArrayList<E>(this.tupleLength + 1);
        extTuple.addAll(tuple);
        extTuple.add(i, e);
        return extTuple;
    }
}

