/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.io.File;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import randoop.Globals;
import randoop.generation.AbstractGenerator;
import randoop.main.GenInputsAbstract;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.util.DumpHeap;
import randoop.org.plumelib.util.StringsPlume;
import randoop.org.plumelib.util.SystemPlume;
import randoop.util.ReflectionExecutor;

public class ProgressDisplay
extends Thread {
    public static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object print_synchro = new Object();
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int exit_if_no_steps_after_milliseconds = 10000;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Mode outputMode;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AbstractGenerator generator;
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean shouldStop = false;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long lastStepTime = System.currentTimeMillis();
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long lastNumSteps = 0L;

    public ProgressDisplay(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AbstractGenerator generator, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Mode outputMode) {
        super("randoop.util.ProgressDisplay");
        if (generator == null) {
            throw new IllegalArgumentException("generator is null");
        }
        this.generator = generator;
        this.outputMode = outputMode;
        this.setDaemon(true);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String message(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean withTime) {
        return "Progress update: steps=" + this.generator.num_steps + ", test inputs generated=" + this.generator.num_sequences_generated + ", failing inputs=" + this.generator.num_failing_sequences + (withTime ? "      (" + Instant.now() + "     " + StringsPlume.abbreviateNumber(SystemPlume.usedMemory(false)) + " used)" : "");
    }

    @Override
    public void run() {
        long progressInterval = GenInputsAbstract.progressintervalmillis;
        while (true) {
            if (this.shouldStop) {
                this.clear();
                return;
            }
            if (progressInterval > 0L) {
                this.display(true);
            }
            if (!ReflectionExecutor.usethreads) {
                this.updateLastStepTime();
                long now = System.currentTimeMillis();
                if (now - this.lastStepTime > (long)exit_if_no_steps_after_milliseconds) {
                    this.exitDueToNoSteps();
                }
            }
            try {
                ProgressDisplay.sleep(progressInterval > 0L ? progressInterval : 1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void exitDueToNoSteps() {
        System.out.println();
        System.out.println();
        System.out.printf("*** Randoop has spent over %s seconds executing the following test.%n", exit_if_no_steps_after_milliseconds / 1000);
        System.out.println("See https://randoop.github.io/randoop/manual/index.html#no-input-generation .");
        System.out.println();
        System.out.println(AbstractGenerator.currSeq);
        System.out.println();
        System.out.println("Will dump a heap profile to randoop-slow.hprof.");
        File hprofFile = new File("randoop-slow.hprof");
        if (hprofFile.exists()) {
            hprofFile.delete();
        }
        DumpHeap.dumpHeap("randoop-slow.hprof");
        System.out.println("Will print all thread stack traces (twice) and exit with code 1.");
        System.out.println();
        this.printAllStackTraces();
        System.out.println();
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.printAllStackTraces();
        System.exit(1);
    }

    private void printAllStackTraces() {
        for (Map.Entry<Thread, StackTraceElement[]> trace : Thread.getAllStackTraces().entrySet()) {
            StackTraceElement[] elts;
            System.out.println("--------------------------------------------------");
            System.out.println("Thread " + trace.getKey().toString());
            System.out.println("Stack trace:");
            for (StackTraceElement elt : elts = trace.getValue()) {
                System.out.println(elt);
            }
        }
        System.out.println("--------------------------------------------------");
    }

    private void updateLastStepTime() {
        long seqs = this.generator.num_steps;
        if (seqs > this.lastNumSteps) {
            this.lastStepTime = System.currentTimeMillis();
            this.lastNumSteps = seqs;
        }
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean noProgressOutput() {
        return GenInputsAbstract.progressintervalmillis <= 0L && GenInputsAbstract.progressintervalsteps <= 0L;
    }

    public void clear() {
        if (this.noProgressOutput()) {
            return;
        }
        System.out.print("\r" + StringsPlume.rpad("", 199));
        System.out.print("\r");
        System.out.flush();
    }

    public void display(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean withTime) {
        if (this.noProgressOutput()) {
            return;
        }
        this.display(this.message(withTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void display(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String message) {
        if (this.noProgressOutput()) {
            return;
        }
        Object object = print_synchro;
        synchronized (object) {
            System.out.print((this.outputMode == Mode.SINGLE_LINE_OVERWRITE ? "\r" : Globals.lineSep) + message);
            System.out.flush();
        }
    }

    public static enum Mode {
        SINGLE_LINE_OVERWRITE,
        MULTILINE,
        NO_DISPLAY;

    }
}

