/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import randoop.Globals;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.util.Log;
import randoop.util.ReflectionCode;

public final class MethodReflectionCode
extends ReflectionCode {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method method;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object receiver;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] inputs;

    public MethodReflectionCode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method method, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object receiver, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] inputs) {
        this.receiver = receiver;
        this.method = method;
        this.inputs = inputs;
        if (!this.method.isAccessible()) {
            this.method.setAccessible(true);
            Log.logPrintf("not accessible: %s%n", this.method);
        }
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isInstanceMethod() {
        return !Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    public void runReflectionCodeRaw() {
        Log.logPrintf("runReflectionCodeRaw: %s%n", this.method);
        try {
            this.retval = this.method.invoke(this.receiver, this.inputs);
            try {
                Log.logPrintf("runReflectionCodeRaw(%s) => %s%n", this.method, this.status());
            }
            catch (OutOfMemoryError e) {
                Log.logPrintf("runReflectionCodeRaw(%s) => OutOfMemoryError, %s%n", this.method, this.status());
            }
            if (this.receiver == null && this.isInstanceMethod()) {
                throw new ReflectionCode.ReflectionCodeException("receiver was null - expected NPE from call to: " + this.method);
            }
        }
        catch (NullPointerException e) {
            this.exceptionThrown = e;
        }
        catch (InvocationTargetException e) {
            this.exceptionThrown = e.getCause();
        }
        catch (Throwable e) {
            String message = String.format("error invoking %s on %d arguments:", this.method, (this.receiver == null ? 0 : 1) + this.inputs.length);
            if (this.receiver != null) {
                message = message + Globals.lineSep + "  " + this.receiver;
            }
            for (Object input : this.inputs) {
                message = message + Globals.lineSep + "  " + input;
            }
            throw new ReflectionCode.ReflectionCodeException(message, e);
        }
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return "Call to " + this.method + " receiver: " + this.receiver + " args: " + Arrays.toString(this.inputs) + this.status();
    }
}

