/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.formatter.qual.FormatMethod;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;

public final class Log {
    private Log() {
        throw new IllegalStateException("no instance");
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isLoggingOn() {
        return GenInputsAbstract.log != null;
    }

    @FormatMethod
    public static void logPrintf(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String fmt, Object ... args) {
        String msg;
        if (!Log.isLoggingOn()) {
            return;
        }
        try {
            msg = String.format(fmt, args);
        }
        catch (Throwable t2) {
            Log.logPrintf("A user-defined toString() method failed.%n", new Object[0]);
            Object[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
            }
            Log.logPrintf("  fmt = %s%n", fmt);
            Log.logPrintf("  arg types = %s%n", Arrays.toString(argTypes));
            Log.logStackTrace(t2);
            return;
        }
        try {
            GenInputsAbstract.log.write(msg);
            GenInputsAbstract.log.flush();
        }
        catch (IOException e) {
            throw new RandoopBug("Exception while writing to log", e);
        }
    }

    public static void logPrintln(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String msg) {
        if (!Log.isLoggingOn()) {
            return;
        }
        try {
            GenInputsAbstract.log.write(msg);
            GenInputsAbstract.log.write(System.lineSeparator());
            GenInputsAbstract.log.flush();
        }
        catch (IOException e) {
            throw new RandoopBug("Exception while writing to log", e);
        }
    }

    public static void logPrintln() {
        if (!Log.isLoggingOn()) {
            return;
        }
        try {
            GenInputsAbstract.log.write(System.lineSeparator());
            GenInputsAbstract.log.flush();
        }
        catch (IOException e) {
            throw new RandoopBug("Exception while writing to log", e);
        }
    }

    public static void logStackTrace(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable t2) {
        if (!Log.isLoggingOn()) {
            return;
        }
        try {
            PrintWriter pw = new PrintWriter(GenInputsAbstract.log);
            t2.printStackTrace(pw);
            pw.flush();
            GenInputsAbstract.log.flush();
        }
        catch (IOException e) {
            throw new RandoopBug("Exception while writing to log", e);
        }
    }
}

