/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.util.MultiSet;

public class KeyToMultiSet<@RegexBottom K, @RegexBottom V> {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<K, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiSet<V>> map = new LinkedHashMap<K, MultiSet<V>>();

    public void addAll(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@RegexBottom @MustCall(value={}) @CalledMethodsBottom @BottomVal @SignednessBottom @SignatureBottom ? extends K, @RegexBottom @MustCall(value={}) @CalledMethodsBottom @BottomVal @SignednessBottom @SignatureBottom ? extends V> m4) {
        for (K t1 : m4.keySet()) {
            this.add(t1, m4.get(t1));
        }
    }

    public void addAll(K key, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@RegexBottom @MustCall(value={}) @CalledMethodsBottom @BottomVal @SignednessBottom @SignatureBottom ? extends V> values) {
        for (V t2 : values) {
            this.add(key, t2);
        }
    }

    public void add(K key, V value) {
        MultiSet values = this.map.computeIfAbsent(key, __ -> new MultiSet());
        this.map.put(key, values);
    }

    public void remove(K key, V value) {
        MultiSet<V> values = this.map.get(key);
        if (values == null) {
            throw new IllegalStateException("No values were found when trying to remove from multiset. Key: " + key + " Variable: " + value);
        }
        values.remove(value);
    }

    public void remove(K key) {
        MultiSet<V> values = this.map.get(key);
        if (values == null) {
            throw new IllegalStateException("No values were found when trying to remove from multiset. Key: " + key);
        }
        this.map.remove(key);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<V> getVariables(K key) {
        MultiSet<V> values = this.map.get(key);
        if (values == null) {
            return Collections.emptySet();
        }
        return values.getElements();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<K> keySet() {
        return this.map.keySet();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean contains(K obj) {
        return this.map.containsKey(obj);
    }

    public void clean() {
        Iterator<Map.Entry<K, MultiSet<V>>> iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<K, MultiSet<V>> element = iter.next();
            if (!element.getValue().isEmpty()) continue;
            iter.remove();
        }
    }

    public void removeAllInstances(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<V> values) {
        for (MultiSet<V> multiSet : this.map.values()) {
            multiSet.removeAllInstances(values);
        }
    }

    public void clear() {
        this.map.clear();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int size() {
        return this.map.size();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isEmpty() {
        return this.map.isEmpty();
    }
}

