/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import randoop.Globals;
import randoop.main.RandoopBug;
import randoop.operation.NonreceiverTerm;
import randoop.org.apache.bcel.classfile.ClassParser;
import randoop.org.apache.bcel.classfile.Constant;
import randoop.org.apache.bcel.classfile.ConstantClass;
import randoop.org.apache.bcel.classfile.ConstantDouble;
import randoop.org.apache.bcel.classfile.ConstantFieldref;
import randoop.org.apache.bcel.classfile.ConstantFloat;
import randoop.org.apache.bcel.classfile.ConstantInteger;
import randoop.org.apache.bcel.classfile.ConstantInterfaceMethodref;
import randoop.org.apache.bcel.classfile.ConstantInvokeDynamic;
import randoop.org.apache.bcel.classfile.ConstantLong;
import randoop.org.apache.bcel.classfile.ConstantMethodHandle;
import randoop.org.apache.bcel.classfile.ConstantMethodType;
import randoop.org.apache.bcel.classfile.ConstantMethodref;
import randoop.org.apache.bcel.classfile.ConstantNameAndType;
import randoop.org.apache.bcel.classfile.ConstantPool;
import randoop.org.apache.bcel.classfile.ConstantString;
import randoop.org.apache.bcel.classfile.ConstantUtf8;
import randoop.org.apache.bcel.classfile.JavaClass;
import randoop.org.apache.bcel.classfile.Method;
import randoop.org.apache.bcel.generic.ClassGen;
import randoop.org.apache.bcel.generic.ConstantPoolGen;
import randoop.org.apache.bcel.generic.ConstantPushInstruction;
import randoop.org.apache.bcel.generic.Instruction;
import randoop.org.apache.bcel.generic.InstructionList;
import randoop.org.apache.bcel.generic.LDC;
import randoop.org.apache.bcel.generic.LDC2_W;
import randoop.org.apache.bcel.generic.LDC_W;
import randoop.org.apache.bcel.generic.MethodGen;
import randoop.org.apache.bcel.util.ClassPath;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.ClassGetName;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.checker.signedness.qual.Unsigned;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.reflection.TypeNames;
import randoop.types.JavaTypes;
import randoop.util.MultiMap;

public class ClassFileConstants {
    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown byte bb = (byte)23;
    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown double d = 35.3;
    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown float f = 3.0f;
    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int ii = 20;
    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long ll = 200000L;
    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown short s = (short)32000;
    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Unsigned @SignatureUnknown char c = (char)97;

    public static void main(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] args) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IOException {
        for (String classname : args) {
            System.out.println(ClassFileConstants.getConstants(classname));
        }
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ConstantSet getConstants(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classname) {
        ConstantSet result = new ConstantSet();
        ClassFileConstants.getConstants(classname, result);
        return result;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ConstantSet getConstants(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classname, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ConstantSet result) {
        String resultClassname;
        JavaClass jc;
        String classfileBase = classname.replace('.', '/');
        try (InputStream is = ClassPath.SYSTEM_CLASS_PATH.getInputStream(classfileBase, ".class");){
            ClassParser cp = new ClassParser(is, classname);
            jc = cp.parse();
        }
        catch (IOException e) {
            throw new Error("IOException while reading '" + classname + "': " + e.getMessage());
        }
        result.classname = resultClassname = jc.getClassName();
        ConstantPool constant_pool = jc.getConstantPool();
        for (Constant c : constant_pool.getConstantPool()) {
            if (c == null || c instanceof ConstantClass || c instanceof ConstantFieldref || c instanceof ConstantInterfaceMethodref || c instanceof ConstantMethodref || c instanceof ConstantNameAndType || c instanceof ConstantMethodHandle || c instanceof ConstantMethodType || c instanceof ConstantInvokeDynamic || c instanceof ConstantUtf8) continue;
            if (c instanceof ConstantString) {
                result.strings.add((String)((ConstantString)c).getConstantValue(constant_pool));
                continue;
            }
            if (c instanceof ConstantDouble) {
                result.doubles.add((Double)((ConstantDouble)c).getConstantValue(constant_pool));
                continue;
            }
            if (c instanceof ConstantFloat) {
                result.floats.add((Float)((ConstantFloat)c).getConstantValue(constant_pool));
                continue;
            }
            if (c instanceof ConstantInteger) {
                result.ints.add((Integer)((ConstantInteger)c).getConstantValue(constant_pool));
                continue;
            }
            if (c instanceof ConstantLong) {
                result.longs.add((Long)((ConstantLong)c).getConstantValue(constant_pool));
                continue;
            }
            throw new RuntimeException("Unrecognized constant of type " + c.getClass() + ": " + c);
        }
        ClassGen gen = new ClassGen(jc);
        ConstantPoolGen pool = gen.getConstantPool();
        for (Method m4 : jc.getMethods()) {
            MethodGen mg = new MethodGen(m4, jc.getClassName(), pool);
            InstructionList il = mg.getInstructionList();
            if (il == null) continue;
            block63: for (Instruction inst : il.getInstructions()) {
                switch (inst.getOpcode()) {
                    case 165: 
                    case 166: {
                        continue block63;
                    }
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: {
                        ClassFileConstants.registerIntegerConstant(0, result);
                        continue block63;
                    }
                    case 193: {
                        continue block63;
                    }
                    case 89: {
                        continue block63;
                    }
                    case 90: {
                        continue block63;
                    }
                    case 93: {
                        continue block63;
                    }
                    case 92: {
                        continue block63;
                    }
                    case 91: {
                        continue block63;
                    }
                    case 94: {
                        continue block63;
                    }
                    case 87: {
                        continue block63;
                    }
                    case 88: {
                        continue block63;
                    }
                    case 95: {
                        continue block63;
                    }
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: {
                        continue block63;
                    }
                    case 180: {
                        continue block63;
                    }
                    case 181: {
                        continue block63;
                    }
                    case 178: {
                        continue block63;
                    }
                    case 179: {
                        continue block63;
                    }
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: {
                        continue block63;
                    }
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: {
                        continue block63;
                    }
                    case 18: {
                        LDC ldcInstruction = (LDC)inst;
                        int index = ldcInstruction.getIndex();
                        Constant constant = constant_pool.getConstant(index);
                        ClassFileConstants.registerConstant(constant, constant_pool, result);
                        continue block63;
                    }
                    case 19: {
                        LDC_W ldc_w = (LDC_W)inst;
                        int index = ldc_w.getIndex();
                        Constant constant = constant_pool.getConstant(index);
                        ClassFileConstants.registerConstant(constant, constant_pool, result);
                        continue block63;
                    }
                    case 20: {
                        LDC2_W ldc2_w = (LDC2_W)inst;
                        int index = ldc2_w.getIndex();
                        Constant constant = constant_pool.getConstant(index);
                        ClassFileConstants.registerConstant(constant, constant_pool, result);
                        continue block63;
                    }
                    case 190: {
                        continue block63;
                    }
                    case 14: {
                        ClassFileConstants.registerDoubleConstant(0.0, result);
                        continue block63;
                    }
                    case 15: {
                        ClassFileConstants.registerDoubleConstant(1.0, result);
                        continue block63;
                    }
                    case 11: {
                        ClassFileConstants.registerFloatConstant(Float.valueOf(0.0f), result);
                        continue block63;
                    }
                    case 12: {
                        ClassFileConstants.registerFloatConstant(Float.valueOf(1.0f), result);
                        continue block63;
                    }
                    case 13: {
                        ClassFileConstants.registerFloatConstant(Float.valueOf(2.0f), result);
                        continue block63;
                    }
                    case 3: {
                        ClassFileConstants.registerIntegerConstant(0, result);
                        continue block63;
                    }
                    case 4: {
                        ClassFileConstants.registerIntegerConstant(1, result);
                        continue block63;
                    }
                    case 5: {
                        ClassFileConstants.registerIntegerConstant(2, result);
                        continue block63;
                    }
                    case 6: {
                        ClassFileConstants.registerIntegerConstant(3, result);
                        continue block63;
                    }
                    case 7: {
                        ClassFileConstants.registerIntegerConstant(4, result);
                        continue block63;
                    }
                    case 8: {
                        ClassFileConstants.registerIntegerConstant(5, result);
                        continue block63;
                    }
                    case 2: {
                        ClassFileConstants.registerIntegerConstant(-1, result);
                        continue block63;
                    }
                    case 9: {
                        ClassFileConstants.registerLongConstant(0L, result);
                        continue block63;
                    }
                    case 10: {
                        ClassFileConstants.registerLongConstant(1L, result);
                        continue block63;
                    }
                    case 16: 
                    case 17: {
                        ConstantPushInstruction cpi = (ConstantPushInstruction)((Object)inst);
                        ClassFileConstants.registerIntegerConstant((Integer)cpi.getValue(), result);
                        continue block63;
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: {
                        continue block63;
                    }
                    case 170: 
                    case 171: {
                        continue block63;
                    }
                    case 188: 
                    case 189: {
                        continue block63;
                    }
                    case 197: {
                        continue block63;
                    }
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: {
                        continue block63;
                    }
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: {
                        continue block63;
                    }
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: {
                        continue block63;
                    }
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 186: {
                        continue block63;
                    }
                    case 191: {
                        continue block63;
                    }
                    case 0: 
                    case 1: 
                    case 25: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 58: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 201: {
                        continue block63;
                    }
                    default: {
                        throw new RandoopBug("instruction " + inst + " unsupported");
                    }
                }
            }
        }
        return result;
    }

    static void registerConstant(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Constant constant, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ConstantPool constant_pool, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ConstantSet cs) {
        if (constant instanceof ConstantInteger) {
            int intValue = ((ConstantInteger)constant).getBytes();
            ClassFileConstants.registerIntegerConstant(intValue, cs);
        } else if (constant instanceof ConstantFloat) {
            float floatValue = ((ConstantFloat)constant).getBytes();
            ClassFileConstants.registerFloatConstant(Float.valueOf(floatValue), cs);
        } else if (constant instanceof ConstantLong) {
            long longValue = ((ConstantLong)constant).getBytes();
            ClassFileConstants.registerLongConstant(longValue, cs);
        } else if (constant instanceof ConstantDouble) {
            double doubleValue = ((ConstantDouble)constant).getBytes();
            ClassFileConstants.registerDoubleConstant(doubleValue, cs);
        } else if (constant instanceof ConstantString) {
            String s2 = ((ConstantString)constant).getBytes(constant_pool);
            ClassFileConstants.registerStringConstant(s2, cs);
        } else if (constant instanceof ConstantClass) {
            String className = ((ConstantClass)constant).getBytes(constant_pool);
            className = className.replace('/', '.');
            try {
                Class<?> c = Class.forName(className);
                ClassFileConstants.registerClassConstant(c, cs);
            }
            catch (ClassNotFoundException e) {
                throw new RandoopBug(e);
            }
        } else {
            throw new RuntimeException("Unrecognized constant of type " + constant.getClass());
        }
    }

    static void registerDoubleConstant(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Double value, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ConstantSet cs) {
        cs.doubles.add(value);
        CollectionsPlume.incrementMap(cs.constantFrequency, value);
    }

    static void registerFloatConstant(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Float value, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ConstantSet cs) {
        cs.floats.add(value);
        CollectionsPlume.incrementMap(cs.constantFrequency, value);
    }

    static void registerIntegerConstant(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Integer value, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ConstantSet cs) {
        cs.ints.add(value);
        CollectionsPlume.incrementMap(cs.constantFrequency, value);
    }

    static void registerLongConstant(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Long value, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ConstantSet cs) {
        cs.longs.add(value);
        CollectionsPlume.incrementMap(cs.constantFrequency, value);
    }

    static void registerStringConstant(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String value, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ConstantSet cs) {
        cs.strings.add(value);
        CollectionsPlume.incrementMap(cs.constantFrequency, value);
    }

    static void registerClassConstant(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> value, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ConstantSet cs) {
        cs.classes.add(value);
        CollectionsPlume.incrementMap(cs.constantFrequency, value);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NonreceiverTerm> getNonreceiverTerms(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        ConstantSet cs = ClassFileConstants.getConstants(c.getName());
        return ClassFileConstants.constantSetToNonreceiverTerms(cs);
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?>, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NonreceiverTerm> toMap(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ConstantSet> constantSets) {
        MultiMap map = new MultiMap();
        for (ConstantSet cs : constantSets) {
            ClassFileConstants.addToConstantMap(cs, map);
        }
        return map;
    }

    private static void addToConstantMap(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ConstantSet cs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?>, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NonreceiverTerm> map) {
        Class<?> clazz;
        try {
            clazz = TypeNames.getTypeForName(cs.classname);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new Error("Class " + cs.classname + " not found on the classpath.");
        }
        map.addAll(clazz, ClassFileConstants.constantSetToNonreceiverTerms(cs));
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NonreceiverTerm> constantSetToNonreceiverTerms(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ConstantSet cs) {
        HashSet<NonreceiverTerm> result = new HashSet<NonreceiverTerm>();
        for (Integer n : cs.ints) {
            result.add(new NonreceiverTerm(JavaTypes.INT_TYPE, n));
        }
        for (Long l : cs.longs) {
            result.add(new NonreceiverTerm(JavaTypes.LONG_TYPE, l));
        }
        for (Float f : cs.floats) {
            result.add(new NonreceiverTerm(JavaTypes.FLOAT_TYPE, f));
        }
        for (Double d : cs.doubles) {
            result.add(new NonreceiverTerm(JavaTypes.DOUBLE_TYPE, d));
        }
        for (String string : cs.strings) {
            result.add(new NonreceiverTerm(JavaTypes.STRING_TYPE, string));
        }
        for (Class clazz : cs.classes) {
            result.add(new NonreceiverTerm(JavaTypes.CLASS_TYPE, clazz));
        }
        return result;
    }

    public static class ConstantSet {
        public @ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String classname;
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Integer> ints = new TreeSet<Integer>();
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Long> longs = new TreeSet<Long>();
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Float> floats = new TreeSet<Float>();
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Double> doubles = new TreeSet<Double>();
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> strings = new TreeSet<String>();
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?>> classes = new HashSet();
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Integer> constantFrequency = new HashMap<Object, Integer>();

        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int getConstantFrequency(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value) {
            return this.constantFrequency.getOrDefault(value, 0);
        }

        @SideEffectFree
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
            StringJoiner sb = new StringJoiner(Globals.lineSep);
            sb.add("START CLASSLITERALS for " + this.classname);
            Iterator<Object> iterator = this.ints.iterator();
            while (iterator.hasNext()) {
                int n = iterator.next();
                sb.add("int:" + n);
            }
            iterator = this.longs.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                sb.add("long:" + l);
            }
            iterator = this.floats.iterator();
            while (iterator.hasNext()) {
                float f = ((Float)iterator.next()).floatValue();
                sb.add("float:" + f);
            }
            iterator = this.doubles.iterator();
            while (iterator.hasNext()) {
                double d = (Double)iterator.next();
                sb.add("double:" + d);
            }
            for (String string : this.strings) {
                sb.add("String:\"" + string + "\"");
            }
            for (Class clazz : this.classes) {
                sb.add("Class:" + clazz);
            }
            sb.add("END CLASSLITERALS for " + this.classname);
            return sb.toString();
        }
    }
}

