/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.util.IMultiMap;
import randoop.util.Log;

public class CheckpointingMultiMap<@RegexBottom K, @RegexBottom V>
implements IMultiMap<K, V> {
    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean verbose_log = false;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<K, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<V>> map = new LinkedHashMap<K, Set<V>>();
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Integer> marks = new ArrayList<Integer>();
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown CheckpointingMultiMap. @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OpKeyVal> ops = new ArrayList<OpKeyVal>();
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int steps = 0;

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean add(K key, V value) {
        if (verbose_log) {
            Log.logPrintf("ADD %s -> %s%n", key, value);
        }
        this.add_bare(key, value);
        this.ops.add(new OpKeyVal(Ops.ADD, key, value));
        ++this.steps;
        return true;
    }

    private void add_bare(K key, V value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("args cannot be null.");
        }
        Set values = this.map.computeIfAbsent(key, __ -> new LinkedHashSet(1));
        if (values.contains(value)) {
            throw new IllegalArgumentException("Mapping already present: " + key + " -> " + value);
        }
        values.add(value);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean remove(K key, V value) {
        if (verbose_log) {
            Log.logPrintf("REMOVE %s -> %s%n", key, value);
        }
        this.remove_bare(key, value);
        this.ops.add(new OpKeyVal(Ops.REMOVE, key, value));
        ++this.steps;
        return true;
    }

    private void remove_bare(K key, V value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("args cannot be null.");
        }
        Set<V> values = this.map.get(key);
        if (values == null) {
            throw new IllegalArgumentException("Mapping not present: " + key + " -> " + value);
        }
        values.remove(value);
        if (values.isEmpty()) {
            this.map.remove(key);
        }
    }

    public void mark() {
        this.marks.add(this.steps);
        this.steps = 0;
    }

    public void undoToLastMark() {
        if (this.marks.isEmpty()) {
            throw new IllegalArgumentException("No marks.");
        }
        Log.logPrintf("marks: %s%n", this.marks);
        for (int i = 0; i < this.steps; ++i) {
            this.undoLastOp();
        }
        this.steps = this.marks.remove(this.marks.size() - 1);
    }

    private void undoLastOp() {
        if (this.ops.isEmpty()) {
            throw new IllegalStateException("ops empty.");
        }
        OpKeyVal last = this.ops.remove(this.ops.size() - 1);
        Ops op = last.op;
        Object key = last.key;
        Object val = last.val;
        if (op == Ops.ADD) {
            Log.logPrintf("REMOVE %s%n", key + " ->" + val);
            this.remove_bare(key, val);
        } else if (op == Ops.REMOVE) {
            Log.logPrintf("ADD %s -> %s%n", key, val);
            this.add_bare(key, val);
        } else {
            throw new IllegalStateException("Unhandled op: " + (Object)((Object)op));
        }
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<V> getValues(K key) {
        if (key == null) {
            throw new IllegalArgumentException("arg cannot be null.");
        }
        return this.map.getOrDefault(key, Collections.emptySet());
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean containsKey(@UnknownSignedness @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @SignatureUnknown Object key) {
        if (key == null) {
            throw new IllegalArgumentException("arg cannot be null.");
        }
        return this.map.containsKey(key);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int size() {
        return this.map.size();
    }

    @Override
    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return this.map.toString();
    }

    private class OpKeyVal {
        final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Ops op;
        final K key;
        final V val;

        OpKeyVal(Ops op, K key, V val) {
            this.op = op;
            this.key = key;
            this.val = val;
        }
    }

    private static enum Ops {
        ADD,
        REMOVE;

    }
}

