/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.lang.reflect.GenericArrayType;
import java.util.ArrayList;
import java.util.List;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.types.ArrayType;
import randoop.types.ClassOrInterfaceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeVariable;

public abstract class ReferenceType
extends Type {
    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType forClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> classType) {
        if (classType.isPrimitive()) {
            throw new IllegalArgumentException("type must be a reference type");
        }
        if (classType.isArray()) {
            return ArrayType.forClass(classType);
        }
        return ClassOrInterfaceType.forClass(classType);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType forType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown java.lang.reflect.Type type) {
        if (type instanceof GenericArrayType) {
            return ArrayType.forType(type);
        }
        if (type instanceof java.lang.reflect.TypeVariable) {
            return TypeVariable.forType(type);
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            return ArrayType.forType(type);
        }
        return ClassOrInterfaceType.forType(type);
    }

    @Override
    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution var1);

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType applyCaptureConversion() {
        return this;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> getTypeParameters() {
        return new ArrayList<TypeVariable>(0);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isAssignableFrom(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type sourceType) {
        return super.isAssignableFrom(sourceType) || sourceType.isReferenceType() && sourceType.isSubtypeOf(this);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isCaptureVariable() {
        return false;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isInstantiationOf(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType otherType) {
        if (this.equals(otherType)) {
            return true;
        }
        if (otherType.isVariable()) {
            TypeVariable variable = (TypeVariable)otherType;
            return variable.canBeInstantiatedBy(this);
        }
        return false;
    }

    public @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution getInstantiatingSubstitution(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType goalType) {
        return ReferenceType.getInstantiatingSubstitutionforTypeVariable(this, goalType);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution getInstantiatingSubstitutionforTypeVariable(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType instantiatedType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType goalType) {
        if (instantiatedType.equals(goalType)) {
            return new Substitution();
        }
        if (goalType.isVariable()) {
            TypeVariable variable = (TypeVariable)goalType;
            Substitution substitution = new Substitution(variable, instantiatedType);
            if (variable.getLowerTypeBound().isLowerBound(instantiatedType, substitution) && variable.getUpperTypeBound().isUpperBound(instantiatedType, substitution)) {
                return substitution;
            }
        }
        return null;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isReferenceType() {
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isSubtypeOf(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type otherType) {
        if (otherType == null) {
            throw new IllegalArgumentException("type may not be null");
        }
        if (super.isSubtypeOf(otherType)) {
            return true;
        }
        return otherType.isObject();
    }
}

