/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.types.EagerReferenceBound;
import randoop.types.InstantiatedType;
import randoop.types.ParameterBound;
import randoop.types.ReferenceBound;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeVariable;

class LazyReferenceBound
extends ReferenceBound {
    LazyReferenceBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType boundType) {
        super(boundType);
    }

    @Override
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.toString());
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceBound substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        if (substitution.isEmpty()) {
            return this;
        }
        for (TypeVariable parameter : this.getTypeParameters()) {
            if (substitution.get(parameter) != null) continue;
            return this;
        }
        ReferenceType referenceType = this.getBoundType().substitute(substitution);
        if (referenceType.equals(this.getBoundType())) {
            return this;
        }
        if (this.getBoundType().isVariable()) {
            if (referenceType.isVariable()) {
                return new LazyReferenceBound(referenceType);
            }
            return new EagerReferenceBound(referenceType);
        }
        if (this.getBoundType().isParameterized()) {
            return new EagerReferenceBound(referenceType);
        }
        return this;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceBound applyCaptureConversion() {
        return null;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> getTypeParameters() {
        if (this.getBoundType().isVariable()) {
            ArrayList<TypeVariable> parameters = new ArrayList<TypeVariable>(1);
            parameters.add((TypeVariable)this.getBoundType());
            return parameters;
        }
        if (this.getBoundType().isParameterized()) {
            List<ReferenceType> referenceArgs = ((InstantiatedType)this.getBoundType()).getReferenceArguments();
            ArrayList<TypeVariable> parameters = new ArrayList<TypeVariable>(referenceArgs.size());
            for (ReferenceType argType : referenceArgs) {
                if (!argType.isVariable()) continue;
                parameters.add((TypeVariable)argType);
            }
            return parameters;
        }
        return new ArrayList<TypeVariable>(0);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isLowerBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type argType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        ReferenceBound b = this.substitute(substitution);
        return !this.equals(b) && b.isLowerBound(argType, substitution);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isSubtypeOf(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound boundType) {
        assert (false) : "subtype not implemented for LazyReferenceBound";
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isUpperBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type argType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        ReferenceBound b = this.substitute(substitution);
        return !this.equals(b) && b.isUpperBound(argType, substitution);
    }

    @Override
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isUpperBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound bound, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        assert (false) : "isUpperBound(ParameterBound, Substitution) not implemented";
        return false;
    }
}

