/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.org.plumelib.util.StringsPlume;
import randoop.types.ParameterBound;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeVariable;

class IntersectionTypeBound
extends ParameterBound {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound> boundList;

    IntersectionTypeBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound> boundList) {
        if (boundList == null) {
            throw new IllegalArgumentException("bounds list may not be null");
        }
        this.boundList = boundList;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntersectionTypeBound)) {
            return false;
        }
        IntersectionTypeBound b = (IntersectionTypeBound)obj;
        return this.boundList.equals(b.boundList);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.boundList);
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return StringsPlume.join((CharSequence)" & ", this.boundList);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IntersectionTypeBound substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        List<ParameterBound> bounds = CollectionsPlume.mapList(bound -> bound.substitute(substitution), this.boundList);
        return new IntersectionTypeBound(bounds);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound applyCaptureConversion() {
        List<ParameterBound> convertedBoundList = CollectionsPlume.mapList(ParameterBound::applyCaptureConversion, this.boundList);
        return new IntersectionTypeBound(convertedBoundList);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> getTypeParameters() {
        ArrayList<TypeVariable> paramList = new ArrayList<TypeVariable>(this.boundList.size());
        for (ParameterBound b : this.boundList) {
            paramList.addAll(b.getTypeParameters());
        }
        return paramList;
    }

    @Override
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasWildcard() {
        for (ParameterBound b : this.boundList) {
            if (!b.hasWildcard()) continue;
            return true;
        }
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasCaptureVariable() {
        for (ParameterBound b : this.boundList) {
            if (!b.hasCaptureVariable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isGeneric(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean ignoreWildcards) {
        for (ParameterBound b : this.boundList) {
            if (!b.isGeneric(ignoreWildcards)) continue;
            return true;
        }
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isLowerBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type otherType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution subst) {
        for (ParameterBound b : this.boundList) {
            if (b.isLowerBound(otherType, subst)) continue;
            return false;
        }
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isObject() {
        for (ParameterBound b : this.boundList) {
            if (b.isObject()) continue;
            return false;
        }
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isSubtypeOf(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound boundType) {
        assert (false) : "intersection type bound isSubTypeOf not implemented";
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isUpperBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type argType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution subst) {
        for (ParameterBound b : this.boundList) {
            if (b.isUpperBound(argType, subst)) continue;
            return false;
        }
        return true;
    }

    @Override
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isUpperBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound bound, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        for (ParameterBound b : this.boundList) {
            if (b.isUpperBound(bound, substitution)) continue;
            return false;
        }
        return true;
    }
}

