/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.util.List;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.types.ClassOrInterfaceType;
import randoop.types.InstantiatedType;
import randoop.types.JavaTypes;
import randoop.types.LazyParameterBound;
import randoop.types.ParameterBound;
import randoop.types.ReferenceBound;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeVariable;

class EagerReferenceBound
extends ReferenceBound {
    EagerReferenceBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType boundType) {
        super(boundType);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown EagerReferenceBound substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        ReferenceType referenceType = this.getBoundType().substitute(substitution);
        if (referenceType.equals(this.getBoundType())) {
            return this;
        }
        return new EagerReferenceBound(referenceType);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown EagerReferenceBound applyCaptureConversion() {
        ReferenceType referenceType = this.getBoundType().applyCaptureConversion();
        if (referenceType.equals(this.getBoundType())) {
            return this;
        }
        return new EagerReferenceBound(referenceType);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> getTypeParameters() {
        return this.getBoundType().getTypeParameters();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isLowerBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type argType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution subst) {
        ReferenceType boundType = this.getBoundType().substitute(subst);
        if (boundType.equals(JavaTypes.NULL_TYPE)) {
            return true;
        }
        if (boundType.isVariable()) {
            return ((TypeVariable)boundType).getLowerTypeBound().isLowerBound(argType, subst);
        }
        if (argType.isParameterized()) {
            if (!(boundType instanceof ClassOrInterfaceType)) {
                return false;
            }
            InstantiatedType argClassType = (InstantiatedType)argType.applyCaptureConversion();
            InstantiatedType boundSuperType = ((ClassOrInterfaceType)boundType).getMatchingSupertype(argClassType.getGenericClassType());
            if (boundSuperType == null) {
                return false;
            }
            boundSuperType = boundSuperType.applyCaptureConversion();
            return boundSuperType.isInstantiationOf(argClassType);
        }
        return boundType.isSubtypeOf(argType);
    }

    @Override
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isLowerBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound bound, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        assert (bound instanceof EagerReferenceBound) : "only handling reference bounds";
        return this.isLowerBound(((EagerReferenceBound)bound).getBoundType(), substitution);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isSubtypeOf(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound bound) {
        if (bound instanceof EagerReferenceBound) {
            return this.getBoundType().isSubtypeOf(((EagerReferenceBound)bound).getBoundType());
        }
        assert (false) : "not handling EagerReferenceBound subtype of other bound type";
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isUpperBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type argType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution subst) {
        ReferenceType boundType = this.getBoundType().substitute(subst);
        if (boundType.equals(JavaTypes.OBJECT_TYPE)) {
            return true;
        }
        if (boundType.isVariable()) {
            return ((TypeVariable)boundType).getUpperTypeBound().isUpperBound(argType, subst);
        }
        if (boundType.isParameterized()) {
            InstantiatedType boundClassType;
            if (!(argType instanceof ClassOrInterfaceType)) {
                return false;
            }
            try {
                boundClassType = (InstantiatedType)boundType.applyCaptureConversion();
            }
            catch (LazyParameterBound.LazyBoundException e) {
                return false;
            }
            InstantiatedType argSuperType = ((ClassOrInterfaceType)argType).getMatchingSupertype(boundClassType.getGenericClassType());
            if (argSuperType == null) {
                return false;
            }
            argSuperType = argSuperType.applyCaptureConversion();
            return argSuperType.isInstantiationOf(boundClassType);
        }
        return argType.isSubtypeOf(boundType);
    }

    @Override
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isUpperBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound bound, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        return this.isUpperBound(this.getBoundType(), substitution);
    }
}

