/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.util.ArrayList;
import java.util.List;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.NotExecuted;
import randoop.condition.ExecutableBooleanExpression;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.sequence.DummyVariable;
import randoop.sequence.ExecutableSequence;
import randoop.sequence.Variable;
import randoop.test.ErrorRevealingChecks;
import randoop.test.PostConditionCheck;
import randoop.test.RegressionChecks;
import randoop.test.TestCheckGenerator;
import randoop.test.TestChecks;

public class PostConditionCheckGenerator
extends TestCheckGenerator {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableBooleanExpression> postConditions;

    public PostConditionCheckGenerator(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableBooleanExpression> postConditions) {
        this.postConditions = postConditions;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TestChecks<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @Signed @SignednessBottom @SignatureUnknown @SignatureBottom ?> generateTestChecks(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence eseq) {
        int finalIndex = eseq.sequence.size() - 1;
        ExecutionOutcome result = eseq.getResult(finalIndex);
        if (result instanceof NotExecuted) {
            throw new Error("Abnormal execution in sequence: " + eseq);
        }
        if (result instanceof NormalExecution) {
            ArrayList<Variable> inputs = new ArrayList<Variable>(eseq.sequence.getInputs(finalIndex));
            inputs.add(eseq.sequence.getVariable(finalIndex));
            Object[] inputValues = eseq.getRuntimeInputs(inputs);
            if (eseq.sequence.getStatement(finalIndex).getOperation().isStatic()) {
                inputValues = this.addNullReceiver(inputValues);
                inputs.add(0, DummyVariable.DUMMY);
            }
            ArrayList<ExecutableBooleanExpression> failed = new ArrayList<ExecutableBooleanExpression>(this.postConditions.size());
            for (ExecutableBooleanExpression postCondition : this.postConditions) {
                if (postCondition.check(inputValues)) continue;
                failed.add(postCondition);
            }
            eseq.sequence.doNotInlineLiterals();
            if (failed.isEmpty()) {
                return new RegressionChecks(new PostConditionCheck(this.postConditions, inputs));
            }
            return new ErrorRevealingChecks(new PostConditionCheck(failed, inputs));
        }
        return ErrorRevealingChecks.EMPTY;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] addNullReceiver(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] values) {
        Object[] args = new Object[values.length + 1];
        args[0] = null;
        System.arraycopy(values, 0, args, 1, values.length);
        return args;
    }
}

