/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import randoop.Globals;
import randoop.condition.ExecutableBooleanExpression;
import randoop.contract.ObjectContractUtils;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.sequence.Variable;
import randoop.test.Check;

public class PostConditionCheck
implements Check {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableBooleanExpression> postConditions;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] inputVariables;

    public PostConditionCheck(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableBooleanExpression> postConditions, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> inputVariables) {
        this.postConditions = postConditions;
        this.inputVariables = inputVariables.toArray(new Variable[0]);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PostConditionCheck)) {
            return false;
        }
        PostConditionCheck other = (PostConditionCheck)object;
        if (!this.postConditions.equals(other.postConditions)) {
            return false;
        }
        if (this.inputVariables.length != other.inputVariables.length) {
            return false;
        }
        for (int i = 0; i < this.inputVariables.length; ++i) {
            if (this.inputVariables[i].equals(other.inputVariables[i])) continue;
            return false;
        }
        return true;
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.postConditions, Arrays.hashCode(this.inputVariables));
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        StringJoiner sj = new StringJoiner(" && ");
        for (ExecutableBooleanExpression condition : this.postConditions) {
            sj.add(condition.getContractSource());
        }
        return sj.toString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeStringPreStatement() {
        return "";
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeStringPostStatement() {
        StringBuilder builder = new StringBuilder();
        for (ExecutableBooleanExpression postCondition : this.postConditions) {
            String conditionString = ObjectContractUtils.localizeContractCode(postCondition.getContractSource(), this.inputVariables);
            builder.append("// Checks the post-condition: ").append(postCondition.getComment()).append(Globals.lineSep);
            builder.append("org.junit.Assert.assertTrue(\"Post-condition: ").append(postCondition.getComment()).append("\", ").append(conditionString).append(");").append(Globals.lineSep);
        }
        return builder.toString();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableBooleanExpression> getPostConditions() {
        return this.postConditions;
    }
}

