/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import randoop.Globals;
import randoop.condition.ThrowsClause;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.org.plumelib.util.StringsPlume;
import randoop.test.Check;

public class MissingExceptionCheck
implements Check {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ThrowsClause>> expected;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index;

    MissingExceptionCheck(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ThrowsClause>> expected, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index) {
        this.expected = expected;
        this.index = index;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MissingExceptionCheck)) {
            return false;
        }
        MissingExceptionCheck other = (MissingExceptionCheck)obj;
        return this.expected.equals(other.expected) && this.index == other.index;
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.expected, this.index);
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        StringBuilder result = new StringBuilder("MissingExceptionCheck at line " + this.index + Globals.lineSep);
        for (List<ThrowsClause> set : this.expected) {
            result.append(set.toString()).append(Globals.lineSep);
        }
        return result.toString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeStringPreStatement() {
        StringBuilder msg = new StringBuilder(String.format("// this statement should throw one of%n", new Object[0]));
        for (List<ThrowsClause> exceptionSet : this.expected) {
            for (ThrowsClause exception : exceptionSet) {
                msg.append(String.format("//   %s %s%n", exception.getExceptionType().getBinaryName(), exception.getComment()));
            }
        }
        return msg.toString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeStringPostStatement() {
        ArrayList<String> exceptionNameList = new ArrayList<String>(this.expected.size());
        for (List<ThrowsClause> set : this.expected) {
            List<String> expectedNames = CollectionsPlume.mapList(exception -> exception.getExceptionType().getBinaryName(), set);
            exceptionNameList.add("\"[ " + StringsPlume.join((CharSequence)", ", expectedNames) + " ]\"");
        }
        return "org.junit.Assert.fail(\"exception is expected: \" + " + StringsPlume.join((CharSequence)" + ", exceptionNameList) + ");";
    }
}

