/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.util.Objects;
import randoop.Globals;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.test.Check;

public abstract class ExceptionCheck
implements Check {
    protected final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable exception;
    final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int statementIndex;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String catchClassName;

    protected ExceptionCheck(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable exception, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int statementIndex, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String catchClassName) {
        this.exception = exception;
        this.statementIndex = statementIndex;
        this.catchClassName = catchClassName;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionCheck other = (ExceptionCheck)o;
        return this.exception.equals(other.exception) && this.statementIndex == other.statementIndex;
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.exception, this.statementIndex);
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return "// throws exception of type " + this.exception.getClass().getCanonicalName() + Globals.lineSep;
    }

    @Override
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeStringPreStatement() {
        return "// The following exception was thrown during execution in test generation" + Globals.lineSep + "try {" + Globals.lineSep;
    }

    @Override
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeStringPostStatement() {
        StringBuilder b = new StringBuilder();
        if (this.catchClassName == null) {
            this.catchClassName = "Exception";
        }
        this.appendTryBehavior(b);
        b.append("} catch (").append(this.catchClassName).append(" e) {").append(Globals.lineSep);
        b.append("  // Expected exception.").append(Globals.lineSep);
        this.appendCatchBehavior(b);
        b.append("}").append(Globals.lineSep);
        return b.toString();
    }

    protected abstract void appendCatchBehavior(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringBuilder var1);

    protected abstract void appendTryBehavior(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringBuilder var1);

    public @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getExceptionName() {
        return this.exception.getClass().getCanonicalName();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable getException() {
        return this.exception;
    }
}

