/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.sequence.Sequence;
import randoop.types.ArrayType;
import randoop.types.ClassOrInterfaceType;
import randoop.types.JavaTypes;
import randoop.types.NonParameterizedType;
import randoop.types.ReferenceArgument;
import randoop.types.Type;
import randoop.types.TypeArgument;

class VariableRenamer {
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence sequence;
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int VAR_NAME_MAX_DEPTH = 2;

    public VariableRenamer(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence sequence) {
        assert (sequence != null) : "The given sequence to rename cannot be null";
        this.sequence = sequence;
    }

    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getVariableName(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type) {
        String varName = VariableRenamer.getVariableName(type, 2);
        if (Character.isUpperCase(varName.charAt(0))) {
            varName = VariableRenamer.lowercaseFirstCharacter(varName);
        }
        if (Character.isDigit(varName.charAt(varName.length() - 1))) {
            varName = varName + "_";
        }
        return varName;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getVariableName(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int depth) {
        if (type.isVoid()) {
            return "void";
        }
        if (type.equals(JavaTypes.CLASS_TYPE)) {
            return "cls";
        }
        if (type.isObject()) {
            return "obj";
        }
        if (type.isString()) {
            return "str";
        }
        if (type.isBoxedPrimitive()) {
            type = ((NonParameterizedType)type).toPrimitive();
        }
        if (type.isPrimitive()) {
            return type.getFqName();
        }
        if (type.isArray()) {
            while (type.isArray()) {
                type = ((ArrayType)type).getComponentType();
            }
            return VariableRenamer.getVariableName(type, depth - 1) + "Array";
        }
        String varName = type.getSimpleName();
        if (varName.length() == 0) {
            return "anonymous";
        }
        if (type.isParameterized()) {
            Class<?> typeClass = type.getRuntimeClass();
            if (Iterator.class.isAssignableFrom(typeClass)) {
                varName = "itor";
            } else if (List.class.isAssignableFrom(typeClass)) {
                varName = "list";
            } else if (Set.class.isAssignableFrom(typeClass)) {
                varName = "set";
            } else if (Map.class.isAssignableFrom(typeClass)) {
                varName = "map";
            } else if (Queue.class.isAssignableFrom(typeClass)) {
                varName = "queue";
            } else if (Collection.class.isAssignableFrom(typeClass)) {
                varName = "collection";
            }
            List<TypeArgument> arglist = ((ClassOrInterfaceType)type).getTypeArguments();
            if (!arglist.isEmpty()) {
                TypeArgument argument = arglist.get(0);
                if (argument.isWildcard()) {
                    varName = "wildcard" + VariableRenamer.capitalizeString(varName);
                } else if (depth >= 0) {
                    String argumentName = VariableRenamer.getVariableName(((ReferenceArgument)argument).getReferenceType(), depth - 1);
                    varName = argumentName + VariableRenamer.capitalizeString(varName);
                }
            }
        }
        return varName;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String capitalizeString(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String variableName) {
        return variableName.substring(0, 1).toUpperCase(Locale.getDefault()) + variableName.substring(1);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String lowercaseFirstCharacter(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String variableName) {
        return variableName.substring(0, 1).toLowerCase(Locale.getDefault()) + variableName.substring(1);
    }
}

