/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.contract.EnumValue;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.util.StringsPlume;
import randoop.sequence.ExecutableSequence;
import randoop.sequence.Sequence;
import randoop.sequence.StringTooLongException;
import randoop.types.JavaTypes;
import randoop.types.NonParameterizedType;
import randoop.types.Type;
import randoop.util.Log;

public class Value {
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Pattern OBJECT_TOSTRING_PATTERN = Pattern.compile("@[0-9a-h]{1,8}");
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Boolean> escapedStringLengthOkCached = new WeakHashMap<String, Boolean>();

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeString(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value) {
        String rep;
        if (value == null) {
            return "null";
        }
        Type valueType = Type.forClass(value.getClass());
        assert (valueType.isNonreceiverType() || valueType.isEnum()) : "expecting nonreceiver type or enum: " + valueType;
        if (valueType.isString()) {
            String escaped = StringsPlume.escapeJava(value.toString());
            if (!Value.stringLengthOk(escaped)) {
                throw new StringTooLongException(escaped);
            }
            return "\"" + escaped + "\"";
        }
        if (valueType.getRuntimeClass().equals(Class.class)) {
            return ((Class)value).getCanonicalName() + ".class";
        }
        if (valueType.isEnum()) {
            return new EnumValue((Enum)value).getValueName();
        }
        if (valueType.isBoxedPrimitive()) {
            valueType = ((NonParameterizedType)valueType).toPrimitive();
        }
        if (valueType.equals(JavaTypes.CHAR_TYPE)) {
            if (value.equals(Character.valueOf(' '))) {
                return "' '";
            }
            if (value.equals(Character.valueOf('\''))) {
                return "'\\''";
            }
            return "'" + StringsPlume.escapeJava(value.toString()) + "'";
        }
        if (valueType.equals(JavaTypes.BOOLEAN_TYPE)) {
            return value.toString();
        }
        if (valueType.equals(JavaTypes.DOUBLE_TYPE)) {
            Double d = (Double)value;
            if (d.isNaN()) {
                return "Double.NaN";
            }
            if (d.equals(Double.POSITIVE_INFINITY)) {
                return "Double.POSITIVE_INFINITY";
            }
            if (d.equals(Double.NEGATIVE_INFINITY)) {
                return "Double.NEGATIVE_INFINITY";
            }
            rep = d.toString();
            assert (rep != null);
            rep = rep + "d";
        } else if (valueType.equals(JavaTypes.FLOAT_TYPE)) {
            Float f = (Float)value;
            if (f.isNaN()) {
                return "Float.NaN";
            }
            if (f.equals(Float.valueOf(Float.POSITIVE_INFINITY))) {
                return "Float.POSITIVE_INFINITY";
            }
            if (f.floatValue() == Float.NEGATIVE_INFINITY) {
                return "Float.NEGATIVE_INFINITY";
            }
            rep = f.toString();
            assert (rep != null);
            rep = rep + "f";
        } else if (valueType.equals(JavaTypes.LONG_TYPE)) {
            rep = value.toString() + "L";
        } else if (valueType.equals(JavaTypes.BYTE_TYPE)) {
            rep = "(byte)" + value.toString();
        } else if (valueType.equals(JavaTypes.SHORT_TYPE)) {
            rep = "(short)" + value.toString();
        } else if (valueType.equals(JavaTypes.INT_TYPE)) {
            rep = value.toString();
        } else {
            throw new RandoopBug("type should be a nonreceiver type: " + valueType);
        }
        if (rep.charAt(0) == '-') {
            rep = "(" + rep + ")";
        }
        return rep;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isUnassertableString(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object o) {
        if (!(o instanceof String)) {
            return false;
        }
        String str = (String)o;
        if (Value.looksLikeObjectToString(str)) {
            return true;
        }
        if (!Value.escapedStringLengthOk(str)) {
            Log.logPrintf("Ignoring a string that exceeds the maximum length of %d%n", GenInputsAbstract.string_maxlen);
            return true;
        }
        return false;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean looksLikeObjectToString(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("s is null");
        }
        return OBJECT_TOSTRING_PATTERN.matcher(s2).find();
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean stringLengthOk(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String s2) {
        return s2.length() <= GenInputsAbstract.string_maxlen;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean escapedStringLengthOk(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException();
        }
        Boolean b = escapedStringLengthOkCached.get(s2);
        if (b != null) {
            return b;
        }
        int length = s2.length();
        if (length > GenInputsAbstract.string_maxlen) {
            return false;
        }
        if (length * 6 < GenInputsAbstract.string_maxlen) {
            return true;
        }
        boolean result = Value.stringLengthOk(StringsPlume.escapeJava(s2));
        escapedStringLengthOkCached.put(s2, result);
        return result;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean arrayLengthOk(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object a) {
        if (a == null) {
            throw new IllegalArgumentException();
        }
        return Array.getLength(a) <= GenInputsAbstract.string_maxlen;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean valueSizeOk(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object v) {
        if (v == null) {
            return true;
        }
        if (v instanceof String) {
            return Value.escapedStringLengthOk((String)v);
        }
        if (v.getClass().isArray()) {
            return Value.arrayLengthOk(v);
        }
        return true;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean lastValueSizeOk(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence eseq) {
        Sequence seq = eseq.sequence;
        int lastIndex = seq.size() - 1;
        ExecutionOutcome lastResult = eseq.getResult(lastIndex);
        if (lastResult instanceof NormalExecution) {
            Object lastValue = ((NormalExecution)lastResult).getRuntimeValue();
            return Value.valueSizeOk(lastValue);
        }
        return true;
    }
}

