/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import randoop.Globals;
import randoop.SubTypeSet;
import randoop.main.GenInputsAbstract;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.reflection.TypeInstantiator;
import randoop.sequence.Sequence;
import randoop.sequence.Variable;
import randoop.types.ClassOrInterfaceType;
import randoop.types.Type;
import randoop.util.ListOfLists;
import randoop.util.Log;
import randoop.util.SimpleArrayList;
import randoop.util.SimpleList;

public class SequenceCollection {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleArrayList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence>> sequenceMap = new LinkedHashMap<Type, SimpleArrayList<Sequence>>();
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SubTypeSet typeSet = new SubTypeSet(false);
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type> typesAndSupertypes = new TreeSet<Type>();
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int sequenceCount = 0;

    private void checkRep(@UnknownInitialization(value=SequenceCollection.class) SequenceCollection this) {
        if (!GenInputsAbstract.debug_checks) {
            return;
        }
        if (this.sequenceMap.size() != this.typeSet.size()) {
            String b = "sequenceMap.keySet()=" + Globals.lineSep + this.sequenceMap.keySet() + ", typeSet.types=" + Globals.lineSep + this.typeSet.types;
            throw new IllegalStateException(b);
        }
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int size() {
        return this.sequenceCount;
    }

    public void clear() {
        Log.logPrintf("Clearing sequence collection.%n", new Object[0]);
        this.sequenceMap = new LinkedHashMap<Type, SimpleArrayList<Sequence>>();
        this.typeSet = new SubTypeSet(false);
        this.sequenceCount = 0;
        this.checkRep();
    }

    public SequenceCollection() {
        this(new ArrayList<Sequence>(0));
    }

    public SequenceCollection(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> initialSequences) {
        if (initialSequences == null) {
            throw new IllegalArgumentException("initialSequences is null.");
        }
        this.sequenceMap = new LinkedHashMap<Type, SimpleArrayList<Sequence>>();
        this.typeSet = new SubTypeSet(false);
        this.sequenceCount = 0;
        this.addAll(initialSequences);
        this.checkRep();
    }

    public void addAll(@UnknownInitialization(value=SequenceCollection.class) SequenceCollection this, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> col) {
        for (Sequence s2 : col) {
            this.add(s2);
        }
    }

    public void addAll(@UnknownInitialization(value=SequenceCollection.class) SequenceCollection this, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceCollection components) {
        for (SimpleArrayList<Sequence> s2 : components.sequenceMap.values()) {
            for (Sequence seq : s2) {
                this.add(seq);
            }
        }
    }

    public void add(@UnknownInitialization(value=SequenceCollection.class) SequenceCollection this, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence sequence) {
        List<Type> formalTypes = sequence.getTypesForLastStatement();
        List<Variable> arguments = sequence.getVariablesOfLastStatement();
        assert (formalTypes.size() == arguments.size());
        for (int i = 0; i < formalTypes.size(); ++i) {
            Variable argument = arguments.get(i);
            Type formalType = formalTypes.get(i);
            assert (formalType.isAssignableFrom(argument.getType())) : formalType.getBinaryName() + " should be assignable from " + argument.getType().getBinaryName();
            if (!sequence.isActive(argument.getDeclIndex())) continue;
            this.typesAndSupertypes.add(formalType);
            if (formalType.isClassOrInterfaceType()) {
                this.typesAndSupertypes.addAll(((ClassOrInterfaceType)formalType).getSuperTypes());
            }
            this.typeSet.add(formalType);
            this.updateCompatibleMap(sequence, formalType);
        }
        this.checkRep();
    }

    private void updateCompatibleMap(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence sequence, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type) {
        SimpleArrayList set = this.sequenceMap.computeIfAbsent(type, __ -> new SimpleArrayList());
        Log.logPrintf("Adding sequence #%d of type %s of length %d%n", set.size() + 1, type, sequence.size());
        boolean added = set.add(sequence);
        assert (added);
        ++this.sequenceCount;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> getSequencesForType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean exactMatch, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean onlyReceivers) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        Log.logPrintf("getSequencesForType(%s, %s, %s)%n", type, exactMatch, onlyReceivers);
        ArrayList<SimpleList<Object>> resultList = new ArrayList<SimpleList<Object>>();
        if (exactMatch) {
            SimpleList l = this.sequenceMap.get(type);
            if (l != null) {
                resultList.add(l);
            }
        } else {
            for (Type compatibleType : this.typeSet.getMatches(type)) {
                Log.logPrintf("candidate compatibleType (isNonreceiverType=%s): %s%n", compatibleType.isNonreceiverType(), compatibleType);
                if (onlyReceivers && compatibleType.isNonreceiverType()) continue;
                SimpleArrayList<Sequence> newMethods = this.sequenceMap.get(compatibleType);
                Log.logPrintf("  Adding %d methods.%n", newMethods.size());
                resultList.add(newMethods);
            }
        }
        if (resultList.isEmpty()) {
            Log.logPrintf("getSequencesForType: found no sequences matching type %s%n", type);
        }
        ListOfLists<Sequence> selector = new ListOfLists<Sequence>(resultList);
        Log.logPrintf("getSequencesForType(%s) => %s sequences.%n", type, selector.size());
        return selector;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> getAllSequences() {
        LinkedHashSet<Sequence> result = new LinkedHashSet<Sequence>();
        for (SimpleArrayList<Sequence> a : this.sequenceMap.values()) {
            result.addAll(a);
        }
        return result;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeInstantiator getTypeInstantiator() {
        return new TypeInstantiator(this.typesAndSupertypes);
    }

    public void log() {
        if (!Log.isLoggingOn()) {
            return;
        }
        for (Type t2 : this.sequenceMap.keySet()) {
            SimpleArrayList<Sequence> a = this.sequenceMap.get(t2);
            int asize = a.size();
            Log.logPrintf("Type %s: %d sequences%n", t2, asize);
            for (int i = 0; i < asize; ++i) {
                Log.logPrintf("  #%d: %s%n", i, ((Sequence)a.get(i)).toString().trim().replace("\n", "\n       "));
            }
        }
    }
}

