/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import randoop.Globals;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.operation.MethodCall;
import randoop.operation.OperationParseException;
import randoop.operation.OperationParser;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.initialization.qual.UnderInitialization;
import randoop.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.org.plumelib.util.StringsPlume;
import randoop.sequence.SequenceParseException;
import randoop.sequence.Statement;
import randoop.sequence.StringTooLongException;
import randoop.sequence.TupleSequence;
import randoop.sequence.Value;
import randoop.sequence.Variable;
import randoop.types.JavaTypes;
import randoop.types.NonParameterizedType;
import randoop.types.Type;
import randoop.util.ListOfLists;
import randoop.util.Log;
import randoop.util.OneMoreElementList;
import randoop.util.Randomness;
import randoop.util.SimpleArrayList;
import randoop.util.SimpleList;

public final class Sequence {
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Statement> statements;
    private final transient @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> lastStatementVariables = new ArrayList<Variable>();
    private final transient @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type> lastStatementTypes = new ArrayList<Type>();
    private transient @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean shouldInlineLiterals = true;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BitSet activeFlags;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int savedHashCode;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int savedNetSize;

    public Sequence() {
        this(new SimpleArrayList<Statement>(0), 0, 0);
    }

    private Sequence(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Statement> statements, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int netSize) {
        if (statements == null) {
            throw new IllegalArgumentException("`statements' argument cannot be null");
        }
        this.statements = statements;
        this.savedHashCode = hashCode;
        this.savedNetSize = netSize;
        this.computeLastStatementInfo();
        this.activeFlags = new BitSet(this.size());
        this.setAllActiveFlags();
        this.checkRep();
    }

    public Sequence(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Statement> statements) {
        this(statements, Sequence.computeHashcode(statements), Sequence.computeNetSize(statements));
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence zero(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type c) {
        return new Sequence().extend(TypedOperation.createNullOrZeroInitializationForType(c), new ArrayList<Variable>(0));
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence createSequenceForPrimitive(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        Type type = Type.forValue(value);
        if (!type.isNonreceiverType()) {
            throw new IllegalArgumentException("value is not a (boxed) primitive or String");
        }
        if (type.isBoxedPrimitive()) {
            type = ((NonParameterizedType)type).toPrimitive();
        }
        if (type.equals(JavaTypes.STRING_TYPE) && !Value.stringLengthOk((String)value)) {
            throw new StringTooLongException((String)value);
        }
        return new Sequence().extend(TypedOperation.createPrimitiveInitialization(type, value), new Variable[0]);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence createSequence(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation operation, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> inputSequences, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Integer> indexes) {
        Sequence inputSequence = Sequence.concatenate(inputSequences);
        List<Variable> inputs = CollectionsPlume.mapList(inputSequence::getVariable, indexes);
        return inputSequence.extend(operation, inputs);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence createSequence(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation operation, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TupleSequence elementsSequence) {
        List<Variable> inputs = CollectionsPlume.mapList(elementsSequence.sequence::getVariable, elementsSequence.getOutputIndices());
        return elementsSequence.sequence.extend(operation, inputs);
    }

    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence extend(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation operation, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> inputVariables) {
        this.checkInputs(operation, inputVariables);
        int size = this.size();
        List<RelativeNegativeIndex> indexList = CollectionsPlume.mapList(v -> Sequence.getRelativeIndexForVariable(size, v), inputVariables);
        Statement statement = new Statement(operation, indexList);
        int newNetSize = operation.isNonreceivingValue() ? this.savedNetSize : this.savedNetSize + 1;
        return new Sequence(new OneMoreElementList<Statement>(this.statements, statement), this.savedHashCode + statement.hashCode(), newNetSize);
    }

    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence extend(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation operation, Variable ... inputs) {
        return this.extend(operation, Arrays.asList(inputs));
    }

    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence extend(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Statement statement, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> inputs) {
        return this.extend(statement.getOperation(), inputs);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence concatenate(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> sequences) {
        ArrayList<SimpleList<SimpleList<Statement>>> statements1 = new ArrayList<SimpleList<SimpleList<Statement>>>(sequences.size());
        int newHashCode = 0;
        int newNetSize = 0;
        for (Sequence c : sequences) {
            newHashCode += c.savedHashCode;
            newNetSize += c.savedNetSize;
            statements1.add(c.statements);
        }
        return new Sequence(new ListOfLists<Statement>(statements1), newHashCode, newNetSize);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence concatenate(Sequence ... sequences) {
        return Sequence.concatenate(Arrays.asList(sequences));
    }

    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Statement getStatement(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index) {
        return this.getStatementWithInputs(index);
    }

    @Pure
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int size(@UnknownInitialization Sequence this) {
        return this.statements.size();
    }

    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int numMethodCalls() {
        int result = 0;
        for (int i = 0; i < this.statements.size(); ++i) {
            Statement statement = this.statements.get(i);
            if (!(statement.getOperation().getOperation() instanceof MethodCall)) continue;
            ++result;
        }
        return result;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable getVariable(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int i) {
        this.checkIndex(i);
        return new Variable(this, i);
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> getVariablesOfLastStatement() {
        return this.lastStatementVariables;
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type> getTypesForLastStatement() {
        return this.lastStatementTypes;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable getLastVariable() {
        return new Variable(this, this.statements.size() - 1);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Statement getCreatingStatement(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable value) {
        if (value.sequence != this) {
            throw new IllegalArgumentException("value.owner != this");
        }
        return this.statements.get(value.index);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> getInputs(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int statementIndex) {
        return CollectionsPlume.mapList(relIndex -> this.getVariableForInput(statementIndex, (RelativeNegativeIndex)relIndex), this.statements.get((int)statementIndex).inputs);
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            if (i != this.size() - 1 && this.shouldInlineLiterals() && this.getStatement(i).getInlinedForm() != null) continue;
            this.appendCode(b, i);
            b.append(Globals.lineSep);
        }
        return b.toString();
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toFullCodeString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            this.appendCode(b, i);
        }
        return b.toString();
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return this.toCodeString();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasActiveFlags() {
        return !this.activeFlags.isEmpty();
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isActive(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int i) {
        return this.activeFlags.get(i);
    }

    private void setAllActiveFlags(@UnderInitialization Sequence this) {
        this.activeFlags.set(0, this.size());
    }

    public void clearAllActiveFlags() {
        this.activeFlags.clear(0, this.size());
    }

    public void clearActiveFlag(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int i) {
        this.activeFlags.clear(i);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RelativeNegativeIndex getRelativeIndexForVariable(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int statementPosition, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable v) {
        if (v.index >= statementPosition) {
            throw new IllegalArgumentException();
        }
        return new RelativeNegativeIndex(-(statementPosition - v.index));
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable getVariableForInput(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int statementPosition, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RelativeNegativeIndex input) {
        int absoluteIndex = statementPosition + input.index;
        if (absoluteIndex < 0) {
            throw new IllegalArgumentException("index should be non-negative: " + absoluteIndex);
        }
        return new Variable(this, absoluteIndex);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int computeHashcode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Statement> statements) {
        int hashCode = 0;
        for (int i = 0; i < statements.size(); ++i) {
            Statement s2 = statements.get(i);
            hashCode += s2.hashCode();
        }
        return hashCode;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int computeNetSize(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Statement> statements) {
        int netSize = 0;
        for (int i = 0; i < statements.size(); ++i) {
            if (statements.get(i).isNonreceivingInitialization()) continue;
            ++netSize;
        }
        return netSize;
    }

    private void computeLastStatementInfo(@UnderInitialization Sequence this) {
        assert (this.lastStatementTypes.isEmpty());
        assert (this.lastStatementVariables.isEmpty());
        if (!this.statements.isEmpty()) {
            int lastStatementIndex = this.statements.size() - 1;
            Statement lastStatement = this.statements.get(lastStatementIndex);
            if (!lastStatement.getOutputType().isVoid()) {
                this.lastStatementTypes.add(lastStatement.getOutputType());
                this.lastStatementVariables.add(new Variable(this, lastStatementIndex));
            }
            if (lastStatement.inputs.size() != lastStatement.getInputTypes().size()) {
                throw new RuntimeException(lastStatement.inputs + ", " + lastStatement.getInputTypes() + ", " + lastStatement.toString());
            }
            List<Variable> vars = this.getInputs(lastStatementIndex);
            if (vars.size() != lastStatement.getInputTypes().size()) {
                throw new RuntimeException();
            }
            for (int i = 0; i < vars.size(); ++i) {
                Variable actualArgument = vars.get(i);
                assert (lastStatement.getInputTypes().get(i).isAssignableFrom(actualArgument.getType()));
                this.lastStatementTypes.add(actualArgument.getType());
                this.lastStatementVariables.add(actualArgument);
            }
        }
    }

    private void checkRep(@UnknownInitialization(value=Sequence.class) Sequence this) {
        if (!GenInputsAbstract.debug_checks) {
            return;
        }
        if (this.statements == null) {
            throw new RuntimeException("statements == null");
        }
        for (int si = 0; si < this.statements.size(); ++si) {
            Statement statementWithInputs = this.statements.get(si);
            if (statementWithInputs == null) {
                throw new IllegalStateException("Null statement in sequence: " + Globals.lineSep + this.toString());
            }
            if (statementWithInputs.inputs == null) {
                throw new IllegalArgumentException("parameters cannot be null.");
            }
            if (statementWithInputs.getInputTypes().size() != statementWithInputs.inputs.size()) {
                throw new IllegalArgumentException("statement.getInputConstraints().size()=" + statementWithInputs.getInputTypes().size() + " is different from inputIndices.length=" + statementWithInputs.inputs.size() + ", sequence: " + this.toString());
            }
            for (int i = 0; i < statementWithInputs.inputs.size(); ++i) {
                int index = statementWithInputs.inputs.get((int)i).index;
                if (index >= 0) {
                    throw new IllegalStateException();
                }
                Type newRefConstraint = this.statements.get(si + statementWithInputs.inputs.get((int)i).index).getOutputType();
                if (newRefConstraint == null) {
                    throw new IllegalStateException();
                }
                if (statementWithInputs.getInputTypes().get(i).isAssignableFrom(newRefConstraint)) continue;
                throw new IllegalArgumentException(i + "th input constraint " + newRefConstraint + " does not imply statement's " + i + "th input constraint " + statementWithInputs.getInputTypes().get(i) + Globals.lineSep + ".Sequence:" + Globals.lineSep + this.toString());
            }
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sequence)) {
            return false;
        }
        Sequence other = (Sequence)o;
        if (this.getStatementsWithInputs().size() != other.getStatementsWithInputs().size()) {
            this.verifyNotEqual("size", other);
            return false;
        }
        for (int i = 0; i < this.statements.size(); ++i) {
            Statement thisStatement = this.statements.get(i);
            Statement otherStatement = other.statements.get(i);
            if (GenInputsAbstract.debug_checks) {
                assert (this.statements.get(i) == thisStatement);
                assert (other.statements.get(i) == otherStatement);
            }
            if (thisStatement.equals(otherStatement)) continue;
            this.verifyNotEqual("statement index " + i, other);
            return false;
        }
        return true;
    }

    private void verifyNotEqual(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String message, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence other) {
    }

    @Pure
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return this.savedHashCode;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isValidIndex(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index) {
        return index >= 0 && index <= this.size() - 1;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Statement> getStatementsWithInputs() {
        return this.statements;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Statement getStatementWithInputs(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index) {
        if (!this.isValidIndex(index)) {
            throw new IllegalArgumentException("Index " + index + " not valid for sequence " + this);
        }
        return this.getStatementsWithInputs().get(index);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> allVariablesForTypeLastStatement(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean onlyReceivers) {
        ArrayList<Variable> possibleVars = new ArrayList<Variable>(this.lastStatementVariables.size());
        for (Variable var : this.lastStatementVariables) {
            if (!this.matchesVariable(var, type, onlyReceivers)) continue;
            possibleVars.add(var);
        }
        return possibleVars;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean matchesVariable(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable var, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean onlyReceivers) {
        Statement s2 = this.statements.get(var.index);
        Type outputType = s2.getOutputType();
        return !(!type.isAssignableFrom(outputType) || onlyReceivers && outputType.isNonreceiverType() || onlyReceivers && this.getCreatingStatement(var).isNonreceivingInitialization());
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable randomVariableForTypeLastStatement(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean onlyReceivers) {
        List<Variable> possibleVars = this.allVariablesForTypeLastStatement(type, onlyReceivers);
        if (possibleVars.isEmpty()) {
            Statement lastStatement = this.statements.get(this.statements.size() - 1);
            throw new RandoopBug(String.format("In rVFTLS, no candidates for %svariable with input type %s from statement %s", onlyReceivers ? "receiver " : "", type, lastStatement));
        }
        if (possibleVars.size() == 1) {
            return possibleVars.get(0);
        }
        return Randomness.randomMember(possibleVars);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable randomVariableForType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean onlyReceivers) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        ArrayList<Integer> possibleIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.size(); ++i) {
            Type outputType;
            Statement s2 = this.statements.get(i);
            if (!this.isActive(i) || !type.isAssignableFrom(outputType = s2.getOutputType()) || onlyReceivers && outputType.isNonreceiverType()) continue;
            possibleIndices.add(i);
        }
        if (possibleIndices.isEmpty()) {
            throw new RandoopBug("Failed to select variable with input type " + type + " from sequence " + this);
        }
        int index = possibleIndices.size() == 1 ? ((Integer)possibleIndices.get(0)).intValue() : ((Integer)Randomness.randomMember(possibleIndices)).intValue();
        return new Variable(this, index);
    }

    void checkIndex(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int i) {
        if (i < 0 || i > this.size() - 1) {
            throw new IllegalArgumentException("index " + i + " out of range [0, " + (this.size() - 1) + "]");
        }
    }

    private void checkInputs(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation operation, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> inputVariables) {
        if (operation.getInputTypes().size() != inputVariables.size()) {
            String msg = "statement.getInputTypes().size():" + operation.getInputTypes().size() + " inputVariables.size():" + inputVariables.size() + " statement:" + operation;
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < inputVariables.size(); ++i) {
            if (inputVariables.get((int)i).sequence != this) {
                String msg = "inputVariables.get(" + i + ").owner != this for" + Globals.lineSep + "sequence: " + this.toString() + Globals.lineSep + "statement:" + operation + Globals.lineSep + "inputVariables:" + inputVariables;
                throw new IllegalArgumentException(msg);
            }
            Type newRefConstraint = this.statements.get(inputVariables.get((int)i).index).getOutputType();
            if (newRefConstraint == null) {
                String msg = "newRefConstraint == null for" + Globals.lineSep + "sequence: " + this.toString() + Globals.lineSep + "statement:" + operation + Globals.lineSep + "inputVariables:" + inputVariables;
                throw new IllegalArgumentException(msg);
            }
            Type inputType = operation.getInputTypes().get(i);
            if (inputType.isAssignableFrom(newRefConstraint)) continue;
            String msg = String.format("Mismatch at %dth argument:%n  %s%n is not assignable from%n  %s%n", i, StringsPlume.toStringAndClass(inputType), StringsPlume.toStringAndClass(newRefConstraint)) + String.format("Sequence:%n%s%nstatement:%s%ninputVariables:%s", this, operation, inputVariables);
            throw new IllegalArgumentException(msg);
        }
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Integer> getInputsAsAbsoluteIndices(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int i) {
        return CollectionsPlume.mapList(relIndex -> this.getVariableForInput((int)i, (RelativeNegativeIndex)relIndex).index, this.statements.get((int)i).inputs);
    }

    public void appendCode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringBuilder b, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index) {
        this.getStatement(index).appendCode(this.getVariable(index), this.getInputs(index), b);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toParsableString() {
        return this.toParsableString(Globals.lineSep);
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toParsableString(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String statementSep) {
        assert (statementSep != null);
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            Statement sk = this.getStatement(i);
            b.append(sk.toParsableString(Variable.classToVariableName(sk.getOutputType()) + i, this.getInputs(i)));
            b.append(statementSep);
        }
        return b.toString();
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence parse(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> statements) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceParseException {
        LinkedHashMap<String, Integer> valueMap = new LinkedHashMap<String, Integer>(statements.size());
        Sequence sequence = new Sequence();
        int statementCount = 0;
        try {
            for (String statement : statements) {
                TypedOperation operation;
                String msg;
                statement = statement.trim();
                int equalsInd = statement.indexOf(61);
                int colonInd = statement.lastIndexOf(58);
                if (equalsInd == -1) {
                    msg = "A statement must be of the form varname = <operation-name> : varname ... varname but the " + statementCount + "-th (1-based) is missing an \"=\" symbol.";
                    throw new SequenceParseException(msg, statements, statementCount);
                }
                if (colonInd == -1) {
                    msg = "A statement must be of the form varname = <operation-name> : varname ... varname but the " + statementCount + "-th (1-based) is missing a \":\" symbol.";
                    throw new SequenceParseException(msg, statements, statementCount);
                }
                String newVar = statement.substring(0, equalsInd).trim();
                String opStr = statement.substring(equalsInd + 1, colonInd).trim();
                String inVarsStr = statement.substring(colonInd + 1).trim();
                if (valueMap.containsKey(newVar)) {
                    String msg2 = "(Statement " + statementCount + ") result variable name " + newVar + " was already declared in a previous statement.";
                    throw new SequenceParseException(msg2, statements, statementCount);
                }
                System.out.println("operation string: " + opStr);
                try {
                    operation = OperationParser.parse(opStr);
                }
                catch (OperationParseException e) {
                    throw new SequenceParseException(e.getMessage(), statements, statementCount);
                }
                assert (operation != null);
                String[] inVars = new String[]{};
                if (!inVarsStr.trim().isEmpty()) {
                    inVars = inVarsStr.split("\\s");
                }
                if (inVars.length != operation.getInputTypes().size()) {
                    String msg3 = "Number of input variables given (" + inVarsStr + ") does not match expected (expected " + operation.getInputTypes().size() + ")";
                    throw new SequenceParseException(msg3, statements, statementCount);
                }
                ArrayList<Variable> inputs = new ArrayList<Variable>(inVars.length);
                for (String inVar : inVars) {
                    Integer index = (Integer)valueMap.get(inVar);
                    if (index == null) {
                        String msg4 = "(Statement " + statementCount + ") input variable name " + newVar + " is not declared by a previous statement.";
                        throw new IllegalArgumentException(msg4);
                    }
                    inputs.add(sequence.getVariable(index));
                }
                sequence = sequence.extend(operation, inputs);
                valueMap.put(newVar, sequence.getLastVariable().getDeclIndex());
                ++statementCount;
            }
        }
        catch (RuntimeException e) {
            StringBuilder b = new StringBuilder();
            b.append("Error while parsing the following list of strings as a sequence (error was at index ").append(statementCount).append("):").append(Globals.lineSep).append(Globals.lineSep);
            for (String s2 : statements) {
                b.append(s2).append(Globals.lineSep);
            }
            b.append("").append(Globals.lineSep).append(Globals.lineSep);
            b.append("Error: ").append(e.toString()).append(Globals.lineSep);
            b.append("Stack trace:").append(Globals.lineSep);
            for (StackTraceElement s3 : e.getStackTrace()) {
                b.append(s3.toString());
            }
            throw new Error(b.toString());
        }
        return sequence;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence parse(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String string) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceParseException {
        return Sequence.parse(Arrays.asList(string.split(Globals.lineSep)));
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isNonreceiver() {
        return this.size() == 1 && this.getStatement(0).isNonreceivingInitialization();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasUseOfMatchingClass(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Pattern classNames) {
        for (int i = 0; i < this.statements.size(); ++i) {
            Type declaringType = this.statements.get(i).getDeclaringClass();
            if (declaringType == null || !classNames.matcher(declaringType.getBinaryName()).matches()) continue;
            return true;
        }
        return false;
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence getSubsequence(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index) {
        return new Sequence(this.statements.getSublist(index));
    }

    public void log() {
        if (!Log.isLoggingOn()) {
            return;
        }
        try {
            GenInputsAbstract.log.write(Globals.lineSep);
            GenInputsAbstract.log.write(this.toFullCodeString());
            GenInputsAbstract.log.write(Globals.lineSep);
            GenInputsAbstract.log.flush();
        }
        catch (IOException e) {
            throw new RandoopBug("Error while logging sequence", e);
        }
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean shouldInlineLiterals() {
        return this.shouldInlineLiterals;
    }

    public void doNotInlineLiterals() {
        this.shouldInlineLiterals = false;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation getOperation() {
        return this.statements.get(this.statements.size() - 1).getOperation();
    }

    public static final class RelativeNegativeIndex {
        public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index;

        public RelativeNegativeIndex(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index) {
            if (index >= 0) {
                throw new IllegalArgumentException("index should be negative: " + index);
            }
            this.index = index;
        }

        @SideEffectFree
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
            return Integer.toString(this.index);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RelativeNegativeIndex)) {
                return false;
            }
            return this.index == ((RelativeNegativeIndex)o).index;
        }

        @Pure
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
            return this.index;
        }
    }
}

