/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.sequence.Sequence;
import randoop.sequence.SequenceCollection;
import randoop.types.Type;
import randoop.util.ListOfLists;
import randoop.util.SimpleList;

public class MappedSequences<@RegexBottom K> {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<K, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceCollection> map = new LinkedHashMap<K, SequenceCollection>();
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> emptyList;

    public void addSequence(K key, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException("seq is null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        SequenceCollection c = this.map.computeIfAbsent(key, __ -> new SequenceCollection());
        c.add(seq);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> getSequences(K key, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type desiredType) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        SequenceCollection sc = this.map.get(key);
        if (sc == null) {
            return emptyList;
        }
        return sc.getSequencesForType(desiredType, true, false);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> getAllSequences() {
        LinkedHashSet<Sequence> result = new LinkedHashSet<Sequence>();
        for (SequenceCollection c : this.map.values()) {
            result.addAll(c.getAllSequences());
        }
        return result;
    }

    static {
        List emptyJDKList = Collections.emptyList();
        emptyList = new ListOfLists<Sequence>(emptyJDKList);
    }
}

