/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.util.ClassDeterministic;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.reflection.AccessibilityPredicate;
import randoop.reflection.ClassVisitor;
import randoop.util.Log;

public class ReflectionManager {
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean logToStdout = false;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate predicate;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ArrayList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassVisitor> visitors;

    public ReflectionManager(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate predicate) {
        this.predicate = predicate;
        this.visitors = new ArrayList();
    }

    public void add(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassVisitor visitor) {
        this.visitors.add(visitor);
    }

    public void apply(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        for (ClassVisitor visitor : this.visitors) {
            this.apply(visitor, c);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void apply(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassVisitor visitor, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        this.logPrintf("Applying visitor %s to class %s%n", visitor, c.getName());
        boolean classIsAccessible = this.predicate.isAccessible(c);
        if (!classIsAccessible) {
            this.logPrintf("Continuing even though class is not accessible: %s%n", c);
        }
        this.visitBefore(visitor, c);
        if (c.isEnum()) {
            this.applyToEnum(visitor, c);
        } else {
            void var9_21;
            Field f;
            void var9_19;
            try {
                this.logPrintf("ReflectionManager.apply%n  %s%n  getMethods = %d%n  getDeclaredMethods = %d%n  visitor = %s%n", c, ClassDeterministic.getMethods(c).length, ClassDeterministic.getDeclaredMethods(c).length, visitor);
            }
            catch (Throwable e) {
                throw new Error(String.format("Problem with ReflectionManager.apply(%s, %s)", visitor, c), e);
            }
            Method[] deterministicMethods = ClassDeterministic.getMethods(c);
            HashSet<Method> methods = new HashSet<Method>(CollectionsPlume.mapCapacity(deterministicMethods.length));
            for (Method method : deterministicMethods) {
                Log.logPrintf("ReflectionManager.apply considering method %s%n", method);
                methods.add(method);
                if (this.isAccessible(method)) {
                    if (classIsAccessible || Modifier.isStatic(method.getModifiers())) {
                        Log.logPrintf("ReflectionManager applying %s to method %s%n", visitor, method);
                        this.applyTo(visitor, method);
                        continue;
                    }
                    this.logPrintln("ReflectionManager.apply: method " + method + " is in an inaccessible class");
                    continue;
                }
                this.logPrintln("ReflectionManager.apply: method " + method + " is not accessible");
            }
            this.logPrintf("ReflectionManager.apply done with getMethods for class %s%n", c);
            for (Method method : ClassDeterministic.getDeclaredMethods(c)) {
                if (methods.contains(method)) continue;
                if (this.isAccessible(method)) {
                    this.applyTo(visitor, method);
                    continue;
                }
                this.logPrintln("ReflectionManager.apply: declared method " + method + " is not accessible");
            }
            this.logPrintf("ReflectionManager.apply done with getDeclaredMethods for class %s%n", c);
            if (classIsAccessible) {
                for (GenericDeclaration genericDeclaration : ClassDeterministic.getDeclaredConstructors(c)) {
                    if (!this.isAccessible((Constructor<?>)genericDeclaration)) continue;
                    this.applyTo(visitor, (Constructor<?>)genericDeclaration);
                }
            }
            for (GenericDeclaration genericDeclaration : ClassDeterministic.getDeclaredClasses(c)) {
                if (!this.isAccessible((Type)((Object)genericDeclaration)) || !classIsAccessible && !Modifier.isStatic(c.getModifiers())) continue;
                this.applyTo(visitor, (Class<?>)genericDeclaration);
            }
            TreeSet<String> declaredNames = new TreeSet<String>();
            Field[] fieldArray = ClassDeterministic.getDeclaredFields(c);
            int n = fieldArray.length;
            boolean bl = false;
            while (var9_19 < n) {
                f = fieldArray[var9_19];
                declaredNames.add(f.getName());
                if (this.predicate.isAccessible(f) && (classIsAccessible || Modifier.isStatic(f.getModifiers()))) {
                    this.applyTo(visitor, f);
                }
                ++var9_19;
            }
            fieldArray = ClassDeterministic.getFields(c);
            n = fieldArray.length;
            boolean bl2 = false;
            while (var9_21 < n) {
                f = fieldArray[var9_21];
                if (this.predicate.isAccessible(f) && (classIsAccessible || Modifier.isStatic(f.getModifiers())) && !declaredNames.contains(f.getName())) {
                    this.applyTo(visitor, f);
                }
                ++var9_21;
            }
        }
        this.visitAfter(visitor, c);
    }

    private void applyToEnum(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassVisitor visitor, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        HashMap<String, Set> overrideMethods = new HashMap<String, Set>();
        for (Object obj : c.getEnumConstants()) {
            Enum e = (Enum)obj;
            this.applyTo(visitor, e);
            if (e.getClass().equals(c)) continue;
            for (Method m4 : e.getClass().getDeclaredMethods()) {
                Set methodSet = overrideMethods.computeIfAbsent(m4.getName(), __ -> new LinkedHashSet());
                methodSet.add(m4);
            }
        }
        for (Method method : ClassDeterministic.getDeclaredMethods(c)) {
            if (!this.isAccessible(method) || method.getName().equals("values") || method.getName().equals("valueOf")) continue;
            this.applyTo(visitor, method);
        }
        for (Method method : ClassDeterministic.getMethods(c)) {
            Set methodSet;
            if (!this.isAccessible(method) || (methodSet = (Set)overrideMethods.get(method.getName())) == null) continue;
            for (Method method2 : methodSet) {
                this.applyTo(visitor, method2);
            }
        }
    }

    private void applyTo(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassVisitor v, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Field f) {
        this.logPrintf("Visiting field %s%n", f.toGenericString());
        v.visit(f);
    }

    private void applyTo(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassVisitor v, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        this.logPrintf("Visiting member class %s%n", c.toString());
        v.visit(c, this);
    }

    private void applyTo(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassVisitor v, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Constructor<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> co) {
        this.logPrintf("Visiting constructor %s%n", co.toGenericString());
        v.visit(co);
    }

    private void applyTo(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassVisitor v, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method m4) {
        this.logPrintf("ReflectionManager visiting method %s, visitor=%s%n", m4.toGenericString(), v);
        v.visit(m4);
    }

    private void applyTo(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassVisitor v, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Enum<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @Signed @SignednessBottom @SignatureUnknown @SignatureBottom ?> e) {
        this.logPrintf("Visiting enum %s%n", e);
        v.visit(e);
    }

    private void visitBefore(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassVisitor v, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        v.visitBefore(c);
    }

    private void visitAfter(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassVisitor v, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        v.visitAfter(c);
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isAccessible(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method m4) {
        if (!this.predicate.isAccessible(m4)) {
            this.logPrintf("Will not use non-accessible method: %s%n", m4.toGenericString());
            return false;
        }
        if (!this.isAccessible(m4.getGenericReturnType())) {
            this.logPrintf("Will not use method with non-accessible return type: %s%n", m4.toGenericString());
            return false;
        }
        for (Type p : m4.getGenericParameterTypes()) {
            if (this.isAccessible(p)) continue;
            this.logPrintf("Will not use method with non-accessible parameter %s: %s%n", p, m4.toGenericString());
            return false;
        }
        return true;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isAccessible(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Constructor<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        if (!this.predicate.isAccessible(c)) {
            this.logPrintf("Will not use non-accessible constructor: %s%n", c.toGenericString());
            return false;
        }
        for (Type p : c.getGenericParameterTypes()) {
            if (this.isAccessible(p)) continue;
            this.logPrintf("Will not use constructor with non-accessible parameter %s: %s%n", p, c.toGenericString());
            return false;
        }
        return true;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isAccessible(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type) {
        if (type instanceof GenericArrayType) {
            return this.isAccessible(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof ParameterizedType) {
            if (!this.isAccessible(((ParameterizedType)type).getRawType())) {
                return false;
            }
            for (Type argType : ((ParameterizedType)type).getActualTypeArguments()) {
                if (this.isAccessible(argType)) continue;
                return false;
            }
            return true;
        }
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof WildcardType) {
            return true;
        }
        Class rawType = (Class)type;
        return this.predicate.isAccessible(rawType);
    }

    private void logPrintf(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String fmt, Object ... args) {
        if (this.logToStdout) {
            System.out.printf(fmt, args);
        } else {
            Log.logPrintf(fmt, args);
        }
    }

    private void logPrintln(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String s2) {
        if (this.logToStdout) {
            System.out.println(s2);
        } else {
            Log.logPrintln(s2);
        }
    }
}

