/*
 * Decompiled with CFR 0.152.
 */
package randoop.output;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import randoop.main.Minimize;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.output.ClassRenamingVisitor;
import randoop.output.CodeWriter;
import randoop.output.JavaFileWriter;
import randoop.output.RandoopOutputException;

public class MinimizerWriter
implements CodeWriter {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown JavaFileWriter javaFileWriter;

    public MinimizerWriter(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown JavaFileWriter javaFileWriter) {
        this.javaFileWriter = javaFileWriter;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path writeClassCode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String packageName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classname, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classCode) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RandoopOutputException {
        Path testFile = this.javaFileWriter.writeClassCode(packageName, classname, classCode);
        try {
            Minimize.mainMinimize(testFile, System.getProperty("java.class.path"), Minimize.testsuitetimeout, Minimize.verboseminimizer);
        }
        catch (IOException e) {
            throw new RandoopOutputException(e);
        }
        String minimizedClassName = Minimize.minimizedClassName(testFile);
        Path minimizedFile = testFile.resolveSibling(minimizedClassName + ".java");
        try {
            Path testFile2 = ClassRenamingVisitor.copyAndRename(minimizedFile, classname);
            assert (testFile.equals(testFile2));
            Files.delete(minimizedFile);
        }
        catch (IOException e) {
            throw new RandoopBug(String.format("Problem while renaming %s to %s", minimizedFile, testFile), e);
        }
        return testFile;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path writeUnmodifiedClassCode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String packageName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classname, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classCode) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RandoopOutputException {
        return this.javaFileWriter.writeClassCode(packageName, classname, classCode);
    }
}

