/*
 * Decompiled with CFR 0.152.
 */
package randoop.output;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.output.CodeWriter;
import randoop.output.RandoopOutputException;

public class JavaFileWriter
implements CodeWriter {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String dirName;

    public JavaFileWriter(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String junitDirName) {
        this.dirName = junitDirName;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path writeClassCode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String packageName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String className, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classCode) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RandoopOutputException {
        Path dir = this.createOutputDir(packageName);
        Path file = new File(dir.toFile(), className + ".java").toPath();
        try (PrintWriter out = new PrintWriter(file.toFile(), StandardCharsets.UTF_8.name());){
            out.println(classCode);
        }
        catch (IOException e) {
            String message = "Exception creating print writer for file " + file.toString();
            throw new RandoopOutputException(message, e);
        }
        return file;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path writeUnmodifiedClassCode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String packageName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classname, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classCode) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RandoopOutputException {
        return this.writeClassCode(packageName, classname, classCode);
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path createOutputDir(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String packageName) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RandoopOutputException {
        boolean success;
        Path dir = this.getDir(packageName);
        if (!Files.exists(dir, new LinkOption[0]) && !(success = dir.toFile().mkdirs())) {
            throw new RandoopOutputException("Unable to create directory: " + dir.toAbsolutePath());
        }
        return dir;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path getDir(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String packageName) {
        String[] split;
        Path dir = this.dirName == null || this.dirName.length() == 0 ? Paths.get(System.getProperty("user.dir"), new String[0]) : Paths.get(this.dirName, new String[0]);
        if (packageName == null) {
            return dir;
        }
        if (packageName.length() == 0) {
            return dir;
        }
        for (String s2 : split = packageName.split("\\.")) {
            dir = new File(dir.toFile(), s2).toPath();
        }
        return dir;
    }
}

