/*
 * Decompiled with CFR 0.152.
 */
package randoop.output;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import randoop.Globals;
import randoop.com.github.javaparser.JavaParser;
import randoop.com.github.javaparser.ParseException;
import randoop.com.github.javaparser.ast.CompilationUnit;
import randoop.com.github.javaparser.ast.ImportDeclaration;
import randoop.com.github.javaparser.ast.Modifier;
import randoop.com.github.javaparser.ast.Node;
import randoop.com.github.javaparser.ast.NodeList;
import randoop.com.github.javaparser.ast.PackageDeclaration;
import randoop.com.github.javaparser.ast.body.BodyDeclaration;
import randoop.com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import randoop.com.github.javaparser.ast.body.MethodDeclaration;
import randoop.com.github.javaparser.ast.body.Parameter;
import randoop.com.github.javaparser.ast.body.TypeDeclaration;
import randoop.com.github.javaparser.ast.body.VariableDeclarator;
import randoop.com.github.javaparser.ast.expr.AnnotationExpr;
import randoop.com.github.javaparser.ast.expr.AssignExpr;
import randoop.com.github.javaparser.ast.expr.BooleanLiteralExpr;
import randoop.com.github.javaparser.ast.expr.Expression;
import randoop.com.github.javaparser.ast.expr.FieldAccessExpr;
import randoop.com.github.javaparser.ast.expr.IntegerLiteralExpr;
import randoop.com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import randoop.com.github.javaparser.ast.expr.MethodCallExpr;
import randoop.com.github.javaparser.ast.expr.Name;
import randoop.com.github.javaparser.ast.expr.NameExpr;
import randoop.com.github.javaparser.ast.expr.ObjectCreationExpr;
import randoop.com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import randoop.com.github.javaparser.ast.expr.StringLiteralExpr;
import randoop.com.github.javaparser.ast.expr.VariableDeclarationExpr;
import randoop.com.github.javaparser.ast.stmt.BlockStmt;
import randoop.com.github.javaparser.ast.stmt.CatchClause;
import randoop.com.github.javaparser.ast.stmt.ExpressionStmt;
import randoop.com.github.javaparser.ast.stmt.IfStmt;
import randoop.com.github.javaparser.ast.stmt.Statement;
import randoop.com.github.javaparser.ast.stmt.TryStmt;
import randoop.com.github.javaparser.ast.type.ClassOrInterfaceType;
import randoop.com.github.javaparser.ast.type.ReferenceType;
import randoop.com.github.javaparser.ast.type.Type;
import randoop.com.github.javaparser.ast.type.VoidType;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.util.StringsPlume;
import randoop.output.NameGenerator;
import randoop.sequence.ExecutableSequence;

public class JUnitCreator {
    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown JavaParser javaParser = new JavaParser();
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NodeList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Modifier> PUBLIC = new NodeList((Node[])new Modifier[]{Modifier.publicModifier()});
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NodeList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Modifier> PUBLIC_STATIC = new NodeList((Node[])new Modifier[]{Modifier.publicModifier(), Modifier.staticModifier()});
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String packageName;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Integer> classMethodCounts;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BlockStmt beforeAllBody = null;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BlockStmt afterAllBody = null;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BlockStmt beforeEachBody = null;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BlockStmt afterEachBody = null;
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String BEFORE_ALL = "BeforeClass";
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String AFTER_ALL = "AfterClass";
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String BEFORE_EACH = "Before";
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String AFTER_EACH = "After";
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String BEFORE_ALL_METHOD = "setupAll";
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String AFTER_ALL_METHOD = "teardownAll";
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String BEFORE_EACH_METHOD = "setup";
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String AFTER_EACH_METHOD = "teardown";
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String BOOLEAN_ARRAY_EQUALS_METHOD = StringsPlume.joinLines("public void assertBooleanArrayEquals(boolean[] expectedArray, boolean[] actualArray) {", "  if (expectedArray.length != actualArray.length) {", "    throw new AssertionError(\"Array lengths differ: \"", "        + expectedArray.length + \" != \" + actualArray.length);", "  }", "  for (int i = 0; i < expectedArray.length; i++) {", "    if (expectedArray[i] != actualArray[i]) {", "      throw new AssertionError(\"Arrays differ at index \" + i + \": \"", "          + expectedArray[i] + \" != \" + actualArray[i]);", "    }", "  }", "}");

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown JUnitCreator getTestCreator(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String junit_package_name, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BlockStmt beforeAllBody, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BlockStmt afterAllBody, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BlockStmt beforeEachBody, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BlockStmt afterEachBody) {
        assert (!Objects.equals(junit_package_name, ""));
        JUnitCreator junitCreator = new JUnitCreator(junit_package_name);
        if (beforeAllBody != null) {
            junitCreator.addBeforeAll(beforeAllBody);
        }
        if (afterAllBody != null) {
            junitCreator.addAfterAll(afterAllBody);
        }
        if (beforeEachBody != null) {
            junitCreator.addBeforeEach(beforeEachBody);
        }
        if (afterEachBody != null) {
            junitCreator.addAfterEach(afterEachBody);
        }
        return junitCreator;
    }

    private JUnitCreator(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String packageName) {
        assert (!Objects.equals(packageName, ""));
        this.packageName = packageName;
        this.classMethodCounts = new LinkedHashMap<String, Integer>();
    }

    private void addBeforeAll(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BlockStmt body) {
        this.beforeAllBody = body;
    }

    private void addAfterAll(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BlockStmt body) {
        this.afterAllBody = body;
    }

    private void addBeforeEach(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BlockStmt body) {
        this.beforeEachBody = body;
    }

    private void addAfterEach(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BlockStmt text) {
        this.afterEachBody = text;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown CompilationUnit createTestClass(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String testClassName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NameGenerator methodNameGen, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence> sequences) {
        MethodDeclaration fixture;
        this.classMethodCounts.put(testClassName, sequences.size());
        CompilationUnit compilationUnit = new CompilationUnit();
        if (this.packageName != null) {
            compilationUnit.setPackageDeclaration(new PackageDeclaration(new Name(this.packageName)));
        }
        NodeList<ImportDeclaration> imports = new NodeList<ImportDeclaration>();
        if (this.afterEachBody != null) {
            imports.add(new ImportDeclaration(new Name("org.junit.After"), false, false));
        }
        if (this.afterAllBody != null) {
            imports.add(new ImportDeclaration(new Name("org.junit.AfterClass"), false, false));
        }
        if (this.beforeEachBody != null) {
            imports.add(new ImportDeclaration(new Name("org.junit.Before"), false, false));
        }
        if (this.beforeAllBody != null) {
            imports.add(new ImportDeclaration(new Name("org.junit.BeforeClass"), false, false));
        }
        imports.add(new ImportDeclaration(new Name("org.junit.FixMethodOrder"), false, false));
        imports.add(new ImportDeclaration(new Name("org.junit.Test"), false, false));
        imports.add(new ImportDeclaration(new Name("org.junit.runners.MethodSorters"), false, false));
        compilationUnit.setImports(imports);
        ClassOrInterfaceDeclaration classDeclaration = new ClassOrInterfaceDeclaration(this.PUBLIC, false, testClassName);
        NodeList annotations = new NodeList((Node[])new AnnotationExpr[]{new SingleMemberAnnotationExpr(new Name("FixMethodOrder"), new NameExpr("MethodSorters.NAME_ASCENDING"))});
        classDeclaration.setAnnotations(annotations);
        NodeList<BodyDeclaration> bodyDeclarations = new NodeList<BodyDeclaration>();
        BodyDeclaration debugField = (BodyDeclaration)javaParser.parseBodyDeclaration("public static boolean debug=false;").getResult().get();
        bodyDeclarations.add(debugField);
        if (this.beforeAllBody != null && (fixture = this.createFixture(BEFORE_ALL, this.PUBLIC_STATIC, BEFORE_ALL_METHOD, this.beforeAllBody)) != null) {
            bodyDeclarations.add(fixture);
        }
        if (this.afterAllBody != null && (fixture = this.createFixture(AFTER_ALL, this.PUBLIC_STATIC, AFTER_ALL_METHOD, this.afterAllBody)) != null) {
            bodyDeclarations.add(fixture);
        }
        if (this.beforeEachBody != null && (fixture = this.createFixture(BEFORE_EACH, this.PUBLIC, BEFORE_EACH_METHOD, this.beforeEachBody)) != null) {
            bodyDeclarations.add(fixture);
        }
        if (this.afterEachBody != null && (fixture = this.createFixture(AFTER_EACH, this.PUBLIC, AFTER_EACH_METHOD, this.afterEachBody)) != null) {
            bodyDeclarations.add(fixture);
        }
        MethodDeclaration assertBooleanArrayEqualsMethod = javaParser.parseMethodDeclaration(BOOLEAN_ARRAY_EQUALS_METHOD).getResult().get();
        bodyDeclarations.add(assertBooleanArrayEqualsMethod);
        for (ExecutableSequence eseq : sequences) {
            MethodDeclaration testMethod = this.createTestMethod(testClassName, methodNameGen.next(), eseq);
            if (testMethod == null) continue;
            bodyDeclarations.add(testMethod);
        }
        classDeclaration.setMembers(bodyDeclarations);
        NodeList types = new NodeList((Node[])new TypeDeclaration[]{classDeclaration});
        compilationUnit.setTypes(types);
        return compilationUnit;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodDeclaration createTestMethod(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String className, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String methodName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence testSequence) {
        MethodDeclaration method = new MethodDeclaration(this.PUBLIC, new VoidType(), methodName);
        NodeList annotations = new NodeList((Node[])new AnnotationExpr[]{new MarkerAnnotationExpr(new Name("Test"))});
        method.setAnnotations(annotations);
        NodeList throwsList = new NodeList((Node[])new ReferenceType[]{new ClassOrInterfaceType("Throwable")});
        method.setThrownExceptions(throwsList);
        BlockStmt body = new BlockStmt();
        NodeList<Statement> statements = new NodeList<Statement>();
        FieldAccessExpr field = new FieldAccessExpr(new NameExpr("System"), "out");
        MethodCallExpr call = new MethodCallExpr((Expression)field, "format");
        NodeList<StringLiteralExpr> arguments = new NodeList<StringLiteralExpr>();
        arguments.add(new StringLiteralExpr("%n%s%n"));
        arguments.add(new StringLiteralExpr(className + "." + methodName));
        call.setArguments(arguments);
        statements.add(new IfStmt(new NameExpr("debug"), new ExpressionStmt(call), null));
        String sequenceBlockString = "{ " + testSequence.toCodeString() + " }";
        BlockStmt sequenceBlock = javaParser.parseBlock(sequenceBlockString).getResult().get();
        statements.addAll(sequenceBlock.getStatements());
        body.setStatements((NodeList)statements);
        method.setBody(body);
        return method;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodDeclaration createFixture(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String annotation, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NodeList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Modifier> modifiers, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String methodName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BlockStmt body) {
        MethodDeclaration method = new MethodDeclaration(modifiers, new VoidType(), methodName);
        NodeList annotations = new NodeList((Node[])new AnnotationExpr[]{new MarkerAnnotationExpr(new Name(annotation))});
        method.setAnnotations(annotations);
        method.setBody(body);
        return method;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String createTestSuite(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String suiteClassName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Iterable<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> testClassNames) {
        CompilationUnit compilationUnit = new CompilationUnit();
        if (this.packageName != null) {
            compilationUnit.setPackageDeclaration(new PackageDeclaration(new Name(this.packageName)));
        }
        NodeList<ImportDeclaration> imports = new NodeList<ImportDeclaration>();
        imports.add(new ImportDeclaration(new Name("org.junit.runner.RunWith"), false, false));
        imports.add(new ImportDeclaration(new Name("org.junit.runners.Suite"), false, false));
        compilationUnit.setImports(imports);
        ClassOrInterfaceDeclaration suiteClass = new ClassOrInterfaceDeclaration(this.PUBLIC, false, suiteClassName);
        NodeList<SingleMemberAnnotationExpr> annotations = new NodeList<SingleMemberAnnotationExpr>();
        annotations.add(new SingleMemberAnnotationExpr(new Name("RunWith"), new NameExpr("Suite.class")));
        StringJoiner classList = new StringJoiner(".class, ", "{ ", ".class }");
        for (String testClassName : testClassNames) {
            classList.add(testClassName);
        }
        annotations.add(new SingleMemberAnnotationExpr(new Name("Suite.SuiteClasses"), new NameExpr(classList.toString())));
        suiteClass.setAnnotations(annotations);
        NodeList types = new NodeList((Node[])new TypeDeclaration[]{suiteClass});
        compilationUnit.setTypes(types);
        return compilationUnit.toString();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String createTestDriver(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String driverName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Iterable<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> testClassNames, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int numMethods) {
        CompilationUnit compilationUnit = new CompilationUnit();
        if (this.packageName != null) {
            compilationUnit.setPackageDeclaration(new PackageDeclaration(new Name(this.packageName)));
        }
        MethodDeclaration mainMethod = new MethodDeclaration(this.PUBLIC_STATIC, new VoidType(), "main");
        NodeList<Parameter> parameters = new NodeList<Parameter>();
        Parameter parameter = new Parameter((Type)new ClassOrInterfaceType("String"), "args");
        parameter.setVarArgs(true);
        parameters.add(parameter);
        mainMethod.setParameters((NodeList)parameters);
        ((Parameter)mainMethod.getParameters().get(0)).setVarArgs(true);
        NodeList<Statement> bodyStatements = new NodeList<Statement>();
        String failureVariableName = "hadFailure";
        Statement hadFailureDecl = javaParser.parseStatement("boolean " + failureVariableName + " = false;").getResult().get();
        bodyStatements.add(hadFailureDecl);
        NameGenerator instanceNameGen = new NameGenerator("t");
        NameGenerator methodNameGen = new NameGenerator("test", 1, numMethods);
        for (String testClass : testClassNames) {
            if (this.beforeAllBody != null) {
                bodyStatements.add(new ExpressionStmt(new MethodCallExpr((Expression)new NameExpr(testClass), BEFORE_ALL_METHOD)));
            }
            String testVariable = instanceNameGen.next();
            ClassOrInterfaceType testClassType = new ClassOrInterfaceType(testClass);
            VariableDeclarator variableDecl = new VariableDeclarator((Type)testClassType, testVariable, (Expression)new ObjectCreationExpr(null, testClassType, new NodeList<Expression>()));
            NodeList variableList = new NodeList((Node[])new VariableDeclarator[]{variableDecl});
            VariableDeclarationExpr variableExpr = new VariableDeclarationExpr(variableList);
            bodyStatements.add(new ExpressionStmt(variableExpr));
            int classMethodCount = this.classMethodCounts.get(testClass);
            for (int i = 0; i < classMethodCount; ++i) {
                if (this.beforeEachBody != null) {
                    bodyStatements.add(new ExpressionStmt(new MethodCallExpr((Expression)new NameExpr(testVariable), BEFORE_EACH_METHOD)));
                }
                String methodName = methodNameGen.next();
                TryStmt tryStmt = new TryStmt();
                NodeList tryStatements = new NodeList((Node[])new Statement[]{new ExpressionStmt(new MethodCallExpr((Expression)new NameExpr(testVariable), methodName))});
                BlockStmt tryBlock = new BlockStmt();
                tryBlock.setStatements(tryStatements);
                tryStmt.setTryBlock(tryBlock);
                CatchClause catchClause = new CatchClause();
                catchClause.setParameter(new Parameter((Type)new ClassOrInterfaceType("Throwable"), "e"));
                BlockStmt catchBlock = new BlockStmt();
                NodeList<ExpressionStmt> catchStatements = new NodeList<ExpressionStmt>();
                catchStatements.add(new ExpressionStmt(new AssignExpr(new NameExpr(failureVariableName), new BooleanLiteralExpr(true), AssignExpr.Operator.ASSIGN)));
                catchStatements.add(new ExpressionStmt(new MethodCallExpr((Expression)new NameExpr("e"), "printStackTrace")));
                catchBlock.setStatements(catchStatements);
                catchClause.setBody(catchBlock);
                NodeList catches = new NodeList((Node[])new CatchClause[]{catchClause});
                tryStmt.setCatchClauses(catches);
                bodyStatements.add(tryStmt);
                if (this.afterEachBody == null) continue;
                bodyStatements.add(new ExpressionStmt(new MethodCallExpr((Expression)new NameExpr(testVariable), AFTER_EACH_METHOD)));
            }
            if (this.afterAllBody == null) continue;
            bodyStatements.add(new ExpressionStmt(new MethodCallExpr((Expression)new NameExpr(testClass), AFTER_ALL_METHOD)));
        }
        BlockStmt exitCall = new BlockStmt();
        NodeList args = new NodeList((Node[])new Expression[]{new IntegerLiteralExpr("1")});
        NodeList exitStatement = new NodeList((Node[])new Statement[]{new ExpressionStmt(new MethodCallExpr((Expression)new NameExpr("Runtime.getRuntime()"), "exit", (NodeList<Expression>)args))});
        exitCall.setStatements(exitStatement);
        bodyStatements.add(new IfStmt(new NameExpr(failureVariableName), exitCall, null));
        BlockStmt body = new BlockStmt();
        body.setStatements((NodeList)bodyStatements);
        mainMethod.setBody(body);
        NodeList bodyDeclarations = new NodeList((Node[])new BodyDeclaration[]{mainMethod});
        ClassOrInterfaceDeclaration driverClass = new ClassOrInterfaceDeclaration(this.PUBLIC, false, driverName);
        driverClass.setMembers(bodyDeclarations);
        NodeList types = new NodeList((Node[])new TypeDeclaration[]{driverClass});
        compilationUnit.setTypes(types);
        return compilationUnit.toString();
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BlockStmt parseFixture(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> bodyText) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParseException {
        if (bodyText == null) {
            return null;
        }
        StringBuilder blockText = new StringBuilder();
        blockText.append("{").append(Globals.lineSep);
        for (String line : bodyText) {
            blockText.append(line).append(Globals.lineSep);
        }
        blockText.append(Globals.lineSep).append("}");
        return javaParser.parseBlock(blockText.toString()).getResult().get();
    }
}

