/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.plumelib.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.formatter.qual.FormatBottom;
import randoop.org.checkerframework.checker.formatter.qual.UnknownFormat;
import randoop.org.checkerframework.checker.index.qual.LessThanUnknown;
import randoop.org.checkerframework.checker.index.qual.LowerBoundUnknown;
import randoop.org.checkerframework.checker.index.qual.SameLenUnknown;
import randoop.org.checkerframework.checker.index.qual.SearchIndexUnknown;
import randoop.org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import randoop.org.checkerframework.checker.index.qual.UpperBoundUnknown;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.lock.qual.GuardedBy;
import randoop.org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.initializedfields.qual.InitializedFields;
import randoop.org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import randoop.org.checkerframework.common.value.qual.UnknownVal;

public class RandomSelector<@FormatBottom T> {
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean coinTossMode;
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) double keepProbability = -1.0;
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int numElts = -1;
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int observed = -1;
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Random generator;
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) ArrayList<T> values = new ArrayList();

    public RandomSelector(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int numElts) {
        this(numElts, new Random());
    }

    public RandomSelector(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int numElts, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Random r) {
        this.coinTossMode = false;
        this.numElts = numElts;
        this.observed = 0;
        this.generator = r;
    }

    public RandomSelector(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) double keepProbability, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Random r) {
        this.coinTossMode = true;
        this.keepProbability = keepProbability;
        this.generator = r;
    }

    public void accept(T next) {
        int n;
        if (this.coinTossMode) {
            if (this.generator.nextDouble() < this.keepProbability) {
                this.values.add(next);
            }
            return;
        }
        ++this.observed;
        if (this.generator.nextDouble() < (double)this.numElts / (double)n) {
            if (this.values.size() < this.numElts) {
                this.values.add(next);
            } else {
                int rem = this.generator.nextInt(this.values.size());
                this.values.set(rem, next);
            }
        }
    }

    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) List<T> getValues() {
        ArrayList<T> ret = new ArrayList<T>();
        ret.addAll(this.values);
        return ret;
    }
}

