/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.io.output;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import randoop.org.apache.commons.io.IOUtils;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DemuxOutputStream
extends OutputStream {
    private final @UnknownKeyFor @NonNull @Initialized InheritableThreadLocal<@Nullable @UnknownKeyFor @Initialized OutputStream> outputStreamThreadLocal = new InheritableThreadLocal();

    public @Nullable @UnknownKeyFor @Initialized OutputStream bindStream(@UnknownKeyFor @NonNull @Initialized OutputStream output) {
        OutputStream stream = (OutputStream)this.outputStreamThreadLocal.get();
        this.outputStreamThreadLocal.set(output);
        return stream;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.close((Closeable)this.outputStreamThreadLocal.get());
    }

    @Override
    public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
        OutputStream output = (OutputStream)this.outputStreamThreadLocal.get();
        if (null != output) {
            output.flush();
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized int ch) throws @UnknownKeyFor @NonNull @Initialized IOException {
        OutputStream output = (OutputStream)this.outputStreamThreadLocal.get();
        if (null != output) {
            output.write(ch);
        }
    }
}

