/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.io.output;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class AppendableWriter<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Appendable>
extends Writer {
    private final T appendable;

    public AppendableWriter(T appendable) {
        this.appendable = appendable;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Writer append(@UnknownKeyFor @NonNull @Initialized char c) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.appendable.append(c);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Writer append(@Nullable @UnknownKeyFor @Initialized CharSequence csq) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.appendable.append(csq);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Writer append(@Nullable @UnknownKeyFor @Initialized CharSequence csq, @UnknownKeyFor @NonNull @Initialized int start, @UnknownKeyFor @NonNull @Initialized int end) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.appendable.append(csq, start, end);
        return this;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    @Override
    public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    public T getAppendable() {
        return this.appendable;
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] cbuf, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Objects.requireNonNull(cbuf, "Character array is missing");
        if (len < 0 || off + len > cbuf.length) {
            throw new IndexOutOfBoundsException("Array Size=" + cbuf.length + ", offset=" + off + ", length=" + len);
        }
        for (int i = 0; i < len; ++i) {
            this.appendable.append(cbuf[off + i]);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized int c) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.appendable.append((char)c);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized String str, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Objects.requireNonNull(str, "String is missing");
        this.appendable.append(str, off, off + len);
    }
}

