/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.io.output;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import randoop.org.apache.commons.io.input.ClosedInputStream;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class AbstractByteArrayOutputStream
extends OutputStream {
    static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_SIZE = 1024;
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] EMPTY_BYTE_ARRAY = new byte[0];
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> buffers = new ArrayList<byte[]>();
    private @UnknownKeyFor @NonNull @Initialized int currentBufferIndex;
    private @UnknownKeyFor @NonNull @Initialized int filledBufferSum;
    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] currentBuffer;
    protected @UnknownKeyFor @NonNull @Initialized int count;
    private @UnknownKeyFor @NonNull @Initialized boolean reuseBuffers = true;

    protected void needNewBuffer(@UnknownInitialization(value=OutputStream.class) AbstractByteArrayOutputStream this, @UnknownKeyFor @NonNull @Initialized int newcount) {
        if (this.currentBufferIndex < this.buffers.size() - 1) {
            assert (this.currentBuffer != null) : "@AssumeAssertion(nullness): dependent on array indices";
            this.filledBufferSum += this.currentBuffer.length;
            ++this.currentBufferIndex;
            this.currentBuffer = this.buffers.get(this.currentBufferIndex);
        } else {
            int newBufferSize;
            if (this.currentBuffer == null) {
                newBufferSize = newcount;
                this.filledBufferSum = 0;
            } else {
                newBufferSize = Math.max(this.currentBuffer.length << 1, newcount - this.filledBufferSum);
                this.filledBufferSum += this.currentBuffer.length;
            }
            ++this.currentBufferIndex;
            this.currentBuffer = new byte[newBufferSize];
            this.buffers.add(this.currentBuffer);
        }
    }

    @Override
    public abstract void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] var1, @UnknownKeyFor @NonNull @Initialized int var2, @UnknownKeyFor @NonNull @Initialized int var3);

    protected void writeImpl(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) {
        int newcount = this.count + len;
        int remaining = len;
        int inBufferPos = this.count - this.filledBufferSum;
        while (remaining > 0) {
            int part = Math.min(remaining, this.currentBuffer.length - inBufferPos);
            System.arraycopy(b, off + len - remaining, this.currentBuffer, inBufferPos, part);
            if ((remaining -= part) <= 0) continue;
            this.needNewBuffer(newcount);
            inBufferPos = 0;
        }
        this.count = newcount;
    }

    @Override
    public abstract void write(@UnknownKeyFor @NonNull @Initialized int var1);

    protected void writeImpl(@UnknownKeyFor @NonNull @Initialized int b) {
        int inBufferPos = this.count - this.filledBufferSum;
        if (inBufferPos == this.currentBuffer.length) {
            this.needNewBuffer(this.count + 1);
            inBufferPos = 0;
        }
        this.currentBuffer[inBufferPos] = (byte)b;
        ++this.count;
    }

    public abstract @UnknownKeyFor @NonNull @Initialized int write(@UnknownKeyFor @NonNull @Initialized InputStream var1) throws @UnknownKeyFor @NonNull @Initialized IOException;

    protected @UnknownKeyFor @NonNull @Initialized int writeImpl(@UnknownKeyFor @NonNull @Initialized InputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int readCount = 0;
        int inBufferPos = this.count - this.filledBufferSum;
        int n = in.read(this.currentBuffer, inBufferPos, this.currentBuffer.length - inBufferPos);
        while (n != -1) {
            readCount += n;
            this.count += n;
            if ((inBufferPos += n) == this.currentBuffer.length) {
                this.needNewBuffer(this.currentBuffer.length);
                inBufferPos = 0;
            }
            n = in.read(this.currentBuffer, inBufferPos, this.currentBuffer.length - inBufferPos);
        }
        return readCount;
    }

    public abstract @UnknownKeyFor @NonNull @Initialized int size();

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    public abstract void reset();

    protected void resetImpl() {
        this.count = 0;
        this.filledBufferSum = 0;
        this.currentBufferIndex = 0;
        if (this.reuseBuffers) {
            this.currentBuffer = this.buffers.get(this.currentBufferIndex);
        } else {
            this.currentBuffer = null;
            int size = this.buffers.get(0).length;
            this.buffers.clear();
            this.needNewBuffer(size);
            this.reuseBuffers = true;
        }
    }

    public abstract void writeTo(@UnknownKeyFor @NonNull @Initialized OutputStream var1) throws @UnknownKeyFor @NonNull @Initialized IOException;

    protected void writeToImpl(@UnknownKeyFor @NonNull @Initialized OutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int remaining = this.count;
        for (byte[] buf : this.buffers) {
            int c = Math.min(buf.length, remaining);
            out.write(buf, 0, c);
            if ((remaining -= c) != 0) continue;
            break;
        }
    }

    public abstract @UnknownKeyFor @NonNull @Initialized InputStream toInputStream();

    protected <T extends InputStream> @UnknownKeyFor @NonNull @Initialized InputStream toInputStream(@UnknownKeyFor @NonNull @Initialized InputStreamConstructor<T> isConstructor) {
        int remaining = this.count;
        if (remaining == 0) {
            return ClosedInputStream.CLOSED_INPUT_STREAM;
        }
        ArrayList<T> list = new ArrayList<T>(this.buffers.size());
        for (byte[] buf : this.buffers) {
            int c = Math.min(buf.length, remaining);
            list.add(isConstructor.construct(buf, 0, c));
            if ((remaining -= c) != 0) continue;
            break;
        }
        this.reuseBuffers = false;
        return new SequenceInputStream(Collections.enumeration(list));
    }

    public abstract @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray();

    protected @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArrayImpl() {
        int remaining = this.count;
        if (remaining == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] newbuf = new byte[remaining];
        int pos = 0;
        for (byte[] buf : this.buffers) {
            int c = Math.min(buf.length, remaining);
            System.arraycopy(buf, 0, newbuf, pos, c);
            pos += c;
            if ((remaining -= c) != 0) continue;
            break;
        }
        return newbuf;
    }

    @Deprecated
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return new String(this.toByteArray(), Charset.defaultCharset());
    }

    public @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized String enc) throws @UnknownKeyFor @NonNull @Initialized UnsupportedEncodingException {
        return new String(this.toByteArray(), enc);
    }

    public @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized Charset charset) {
        return new String(this.toByteArray(), charset);
    }

    @FunctionalInterface
    protected static interface InputStreamConstructor<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized InputStream> {
        public T construct(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] var1, @UnknownKeyFor @NonNull @Initialized int var2, @UnknownKeyFor @NonNull @Initialized int var3);
    }
}

