/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.io.input;

import java.io.InputStream;
import java.util.Objects;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CircularInputStream
extends InputStream {
    private @UnknownKeyFor @NonNull @Initialized long byteCount;
    private @UnknownKeyFor @NonNull @Initialized int position = -1;
    private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] repeatedContent;
    private final @UnknownKeyFor @NonNull @Initialized long targetByteCount;

    private static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] validate(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] repeatContent) {
        Objects.requireNonNull(repeatContent, "repeatContent");
        for (byte b : repeatContent) {
            if (b != -1) continue;
            throw new IllegalArgumentException("repeatContent contains the end-of-stream marker -1");
        }
        return repeatContent;
    }

    public CircularInputStream(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] repeatContent, @UnknownKeyFor @NonNull @Initialized long targetByteCount) {
        this.repeatedContent = CircularInputStream.validate(repeatContent);
        if (repeatContent.length == 0) {
            throw new IllegalArgumentException("repeatContent is empty.");
        }
        this.targetByteCount = targetByteCount;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read() {
        if (this.targetByteCount >= 0L) {
            if (this.byteCount == this.targetByteCount) {
                return -1;
            }
            ++this.byteCount;
        }
        this.position = (this.position + 1) % this.repeatedContent.length;
        return this.repeatedContent[this.position] & 0xFF;
    }
}

