/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Objects;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CharSequenceInputStream
extends InputStream {
    private static final @UnknownKeyFor @NonNull @Initialized int BUFFER_SIZE = 2048;
    private static final @UnknownKeyFor @NonNull @Initialized int NO_MARK = -1;
    private final @UnknownKeyFor @NonNull @Initialized CharsetEncoder encoder;
    private final @UnknownKeyFor @NonNull @Initialized CharBuffer cbuf;
    private final @UnknownKeyFor @NonNull @Initialized ByteBuffer bbuf;
    private @UnknownKeyFor @NonNull @Initialized int mark_cbuf;
    private @UnknownKeyFor @NonNull @Initialized int mark_bbuf;

    public CharSequenceInputStream(@UnknownKeyFor @NonNull @Initialized CharSequence cs, @UnknownKeyFor @NonNull @Initialized Charset charset, @UnknownKeyFor @NonNull @Initialized int bufferSize) {
        this.encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        float maxBytesPerChar = this.encoder.maxBytesPerChar();
        if ((float)bufferSize < maxBytesPerChar) {
            throw new IllegalArgumentException("Buffer size " + bufferSize + " is less than maxBytesPerChar " + maxBytesPerChar);
        }
        this.bbuf = ByteBuffer.allocate(bufferSize);
        this.bbuf.flip();
        this.cbuf = CharBuffer.wrap(cs);
        this.mark_cbuf = -1;
        this.mark_bbuf = -1;
    }

    public CharSequenceInputStream(@UnknownKeyFor @NonNull @Initialized CharSequence cs, @UnknownKeyFor @NonNull @Initialized String charset, @UnknownKeyFor @NonNull @Initialized int bufferSize) {
        this(cs, Charset.forName(charset), bufferSize);
    }

    public CharSequenceInputStream(@UnknownKeyFor @NonNull @Initialized CharSequence cs, @UnknownKeyFor @NonNull @Initialized Charset charset) {
        this(cs, charset, 2048);
    }

    public CharSequenceInputStream(@UnknownKeyFor @NonNull @Initialized CharSequence cs, @UnknownKeyFor @NonNull @Initialized String charset) {
        this(cs, charset, 2048);
    }

    private void fillBuffer() throws @UnknownKeyFor @NonNull @Initialized CharacterCodingException {
        this.bbuf.compact();
        CoderResult result = this.encoder.encode(this.cbuf, this.bbuf, true);
        if (result.isError()) {
            result.throwException();
        }
        this.bbuf.flip();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] array, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Objects.requireNonNull(array, "array");
        if (len < 0 || off + len > array.length) {
            throw new IndexOutOfBoundsException("Array Size=" + array.length + ", offset=" + off + ", length=" + len);
        }
        if (len == 0) {
            return 0;
        }
        if (!this.bbuf.hasRemaining() && !this.cbuf.hasRemaining()) {
            return -1;
        }
        int bytesRead = 0;
        while (len > 0) {
            if (this.bbuf.hasRemaining()) {
                int chunk = Math.min(this.bbuf.remaining(), len);
                this.bbuf.get(array, off, chunk);
                off += chunk;
                len -= chunk;
                bytesRead += chunk;
                continue;
            }
            this.fillBuffer();
            if (this.bbuf.hasRemaining() || this.cbuf.hasRemaining()) continue;
        }
        return bytesRead == 0 && !this.cbuf.hasRemaining() ? -1 : bytesRead;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
        do {
            if (this.bbuf.hasRemaining()) {
                return this.bbuf.get() & 0xFF;
            }
            this.fillBuffer();
        } while (this.bbuf.hasRemaining() || this.cbuf.hasRemaining());
        return -1;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long skip(@UnknownKeyFor @NonNull @Initialized long n) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long skipped = 0L;
        while (n > 0L && this.available() > 0) {
            this.read();
            --n;
            ++skipped;
        }
        return skipped;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int available() throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.bbuf.remaining() + this.cbuf.remaining();
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    @Override
    public synchronized void mark(@UnknownKeyFor @NonNull @Initialized int readlimit) {
        this.mark_cbuf = this.cbuf.position();
        this.mark_bbuf = this.bbuf.position();
        this.cbuf.mark();
        this.bbuf.mark();
    }

    @Override
    public synchronized void reset() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.mark_cbuf != -1) {
            if (this.cbuf.position() != 0) {
                this.encoder.reset();
                this.cbuf.rewind();
                this.bbuf.rewind();
                this.bbuf.limit(0);
                while (this.cbuf.position() < this.mark_cbuf) {
                    this.bbuf.rewind();
                    this.bbuf.limit(0);
                    this.fillBuffer();
                }
            }
            if (this.cbuf.position() != this.mark_cbuf) {
                throw new IllegalStateException("Unexpected CharBuffer position: actual=" + this.cbuf.position() + " expected=" + this.mark_cbuf);
            }
            this.bbuf.position(this.mark_bbuf);
            this.mark_cbuf = -1;
            this.mark_bbuf = -1;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean markSupported() {
        return true;
    }
}

