/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.io;

import java.nio.ByteOrder;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class ByteOrderParser {
    private ByteOrderParser() {
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteOrder parseByteOrder(@UnknownKeyFor @NonNull @Initialized String value) {
        if (ByteOrder.BIG_ENDIAN.toString().equals(value)) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (ByteOrder.LITTLE_ENDIAN.toString().equals(value)) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        throw new IllegalArgumentException("Unsupported byte order setting: " + value + ", expected one of " + ByteOrder.LITTLE_ENDIAN + ", " + ByteOrder.BIG_ENDIAN);
    }
}

