/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.exec.launcher;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import randoop.org.apache.commons.exec.CommandLine;
import randoop.org.apache.commons.exec.launcher.Java13CommandLauncher;
import randoop.org.apache.commons.exec.util.StringUtils;

public class VmsCommandLauncher
extends Java13CommandLauncher {
    File createCommandFile(CommandLine cmd, Map<String, String> env) throws IOException {
        Path path = Files.createTempFile("EXEC", ".TMP", new FileAttribute[0]);
        File script = path.toFile();
        script.deleteOnExit();
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(path, Charset.defaultCharset(), new OpenOption[0]));){
            String[] args;
            if (env != null) {
                Set<Map.Entry<String, String>> entries = env.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    writer.print("$ ");
                    writer.print(entry.getKey());
                    writer.print(" == ");
                    writer.println('\"');
                    String value = entry.getValue();
                    if (value.indexOf(34) > 0) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < value.length(); ++i) {
                            char c = value.charAt(i);
                            if (c == '\"') {
                                sb.append('\"');
                            }
                            sb.append(c);
                        }
                        value = sb.toString();
                    }
                    writer.print(value);
                    writer.println('\"');
                }
            }
            String command = cmd.getExecutable();
            if (cmd.isFile()) {
                writer.print("$ @");
                String[] parts = StringUtils.split(command, "/");
                writer.print(parts[0]);
                writer.print(":[");
                writer.print(parts[1]);
                int lastPart = parts.length - 1;
                for (int i = 2; i < lastPart; ++i) {
                    writer.print(".");
                    writer.print(parts[i]);
                }
                writer.print("]");
                writer.print(parts[lastPart]);
            } else {
                writer.print("$ ");
                writer.print(command);
            }
            for (String arg : args = cmd.getArguments()) {
                writer.println(" -");
                writer.print(arg);
            }
            writer.println();
        }
        return script;
    }

    @Override
    public Process exec(CommandLine cmd, Map<String, String> env) throws IOException {
        return super.exec(new CommandLine(this.createCommandFile(cmd, env).getPath()), env);
    }

    @Override
    public Process exec(CommandLine cmd, Map<String, String> env, File workingDir) throws IOException {
        return super.exec(new CommandLine(this.createCommandFile(cmd, env).getPath()), env, workingDir);
    }

    @Override
    public boolean isFailure(int exitValue) {
        return exitValue % 2 == 0;
    }
}

