/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.exec;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import randoop.org.apache.commons.exec.TimeoutObserver;
import randoop.org.apache.commons.exec.Watchdog;
import randoop.org.apache.commons.exec.util.DebugUtils;

public class ExecuteWatchdog
implements TimeoutObserver {
    public static final long INFINITE_TIMEOUT = -1L;
    public static final Duration INFINITE_TIMEOUT_DURATION = Duration.ofMillis(-1L);
    private Process process;
    private final boolean hasWatchdog;
    private boolean watch = false;
    private Exception caught;
    private boolean killedProcess = false;
    private final Watchdog watchdog;
    private volatile boolean processStarted;
    private final ThreadFactory threadFactory;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public ExecuteWatchdog(long timeoutMillis) {
        this(Executors.defaultThreadFactory(), Duration.ofMillis(timeoutMillis));
    }

    private ExecuteWatchdog(ThreadFactory threadFactory, Duration timeout) {
        this.hasWatchdog = !INFINITE_TIMEOUT_DURATION.equals(timeout);
        this.processStarted = false;
        ThreadFactory threadFactory2 = this.threadFactory = threadFactory != null ? threadFactory : Executors.defaultThreadFactory();
        if (this.hasWatchdog) {
            this.watchdog = Watchdog.builder().setThreadFactory(this.threadFactory).setTimeout(timeout).get();
            this.watchdog.addTimeoutObserver(this);
        } else {
            this.watchdog = null;
        }
    }

    public synchronized void checkException() throws Exception {
        if (this.caught != null) {
            throw this.caught;
        }
    }

    protected synchronized void cleanUp() {
        this.watch = false;
        this.process = null;
    }

    public synchronized void destroyProcess() {
        this.ensureStarted();
        this.timeoutOccured(null);
        this.stop();
    }

    private void ensureStarted() {
        while (!this.processStarted && this.caught == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public synchronized void failedToStart(Exception e) {
        this.processStarted = true;
        this.caught = e;
        this.notifyAll();
    }

    public synchronized boolean isWatching() {
        this.ensureStarted();
        return this.watch;
    }

    public synchronized boolean killedProcess() {
        return this.killedProcess;
    }

    void setProcessNotStarted() {
        this.processStarted = false;
    }

    public synchronized void start(Process processToMonitor) {
        Objects.requireNonNull(processToMonitor, "processToMonitor");
        if (this.process != null) {
            throw new IllegalStateException("Already running.");
        }
        this.caught = null;
        this.killedProcess = false;
        this.watch = true;
        this.process = processToMonitor;
        this.processStarted = true;
        this.notifyAll();
        if (this.hasWatchdog) {
            this.watchdog.start();
        }
    }

    public synchronized void stop() {
        if (this.hasWatchdog) {
            this.watchdog.stop();
        }
        this.watch = false;
        this.process = null;
    }

    @Override
    public synchronized void timeoutOccured(Watchdog w) {
        try {
            try {
                if (this.process != null) {
                    this.process.exitValue();
                }
            }
            catch (IllegalThreadStateException itse) {
                if (this.watch) {
                    this.killedProcess = true;
                    this.process.destroy();
                }
            }
        }
        catch (Exception e) {
            this.caught = e;
            DebugUtils.handleException("Getting the exit value of the process failed", e);
        }
        finally {
            this.cleanUp();
        }
    }

    public static final class Builder
    implements Supplier<ExecuteWatchdog> {
        private ThreadFactory threadFactory;
        private Duration timeout;

        @Override
        public ExecuteWatchdog get() {
            return new ExecuteWatchdog(this.threadFactory, this.timeout);
        }

        public Builder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }
    }
}

