/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.exec;

import java.time.Duration;
import java.time.Instant;
import randoop.org.apache.commons.exec.ExecuteException;
import randoop.org.apache.commons.exec.ExecuteResultHandler;

public class DefaultExecuteResultHandler
implements ExecuteResultHandler {
    private static final int SLEEP_TIME_MS = 50;
    private volatile boolean hasResult = false;
    private volatile int exitValue = -559038737;
    private volatile ExecuteException exception;

    public ExecuteException getException() {
        if (!this.hasResult) {
            throw new IllegalStateException("The process has not exited yet therefore no result is available ...");
        }
        return this.exception;
    }

    public int getExitValue() {
        if (!this.hasResult) {
            throw new IllegalStateException("The process has not exited yet therefore no result is available ...");
        }
        return this.exitValue;
    }

    public boolean hasResult() {
        return this.hasResult;
    }

    @Override
    public void onProcessComplete(int exitValue) {
        this.exitValue = exitValue;
        this.exception = null;
        this.hasResult = true;
    }

    @Override
    public void onProcessFailed(ExecuteException e) {
        this.exitValue = e.getExitValue();
        this.exception = e;
        this.hasResult = true;
    }

    public void waitFor() throws InterruptedException {
        while (!this.hasResult()) {
            Thread.sleep(50L);
        }
    }

    public void waitFor(Duration timeout) throws InterruptedException {
        Instant until = Instant.now().plus(timeout);
        while (!this.hasResult() && Instant.now().isBefore(until)) {
            Thread.sleep(50L);
        }
    }

    @Deprecated
    public void waitFor(long timeoutMillis) throws InterruptedException {
        long untilMillis = System.currentTimeMillis() + timeoutMillis;
        while (!this.hasResult() && System.currentTimeMillis() < untilMillis) {
            Thread.sleep(50L);
        }
    }
}

