/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.verifier.structurals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import randoop.org.apache.bcel.generic.ASTORE;
import randoop.org.apache.bcel.generic.ATHROW;
import randoop.org.apache.bcel.generic.BranchInstruction;
import randoop.org.apache.bcel.generic.CodeExceptionGen;
import randoop.org.apache.bcel.generic.GotoInstruction;
import randoop.org.apache.bcel.generic.IndexedInstruction;
import randoop.org.apache.bcel.generic.Instruction;
import randoop.org.apache.bcel.generic.InstructionHandle;
import randoop.org.apache.bcel.generic.JsrInstruction;
import randoop.org.apache.bcel.generic.LocalVariableInstruction;
import randoop.org.apache.bcel.generic.MethodGen;
import randoop.org.apache.bcel.generic.RET;
import randoop.org.apache.bcel.generic.ReturnInstruction;
import randoop.org.apache.bcel.generic.Select;
import randoop.org.apache.bcel.verifier.exc.AssertionViolatedException;
import randoop.org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import randoop.org.apache.bcel.verifier.structurals.Subroutine;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.interning.qual.UsesObjectEquals;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public class Subroutines {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Subroutine> subroutines = new HashMap<InstructionHandle, Subroutine>();
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Subroutine TOPLEVEL;

    public Subroutines(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen mg) {
        this(mg, true);
    }

    public Subroutines(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen mg, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean enableJustIceCheck) {
        Object[] leader;
        Instruction inst;
        InstructionHandle[] all = mg.getInstructionList().getInstructionHandles();
        CodeExceptionGen[] handlers = mg.getExceptionHandlers();
        this.TOPLEVEL = new SubroutineImpl();
        HashSet<InstructionHandle> sub_leaders = new HashSet<InstructionHandle>();
        for (InstructionHandle instructionHandle : all) {
            inst = instructionHandle.getInstruction();
            if (!(inst instanceof JsrInstruction)) continue;
            sub_leaders.add(((JsrInstruction)inst).getTarget());
        }
        for (InstructionHandle astore : sub_leaders) {
            SubroutineImpl sr = new SubroutineImpl();
            sr.setLocalVariable(((ASTORE)astore.getInstruction()).getIndex());
            this.subroutines.put(astore, sr);
        }
        this.subroutines.put(all[0], this.TOPLEVEL);
        sub_leaders.add(all[0]);
        for (InstructionHandle instructionHandle : all) {
            inst = instructionHandle.getInstruction();
            if (!(inst instanceof JsrInstruction)) continue;
            leader = ((JsrInstruction)inst).getTarget();
            ((SubroutineImpl)this.getSubroutine((InstructionHandle)leader)).addEnteringJsrInstruction(instructionHandle);
        }
        HashSet<InstructionHandle> instructions_assigned = new HashSet<InstructionHandle>();
        HashMap<InstructionHandle, ColourConstants> colors = new HashMap<InstructionHandle, ColourConstants>();
        ArrayList<InstructionHandle> Q = new ArrayList<InstructionHandle>();
        for (InstructionHandle actual : sub_leaders) {
            int n;
            leader = all;
            int n2 = leader.length;
            for (n = 0; n < n2; ++n) {
                InstructionHandle element = leader[n];
                colors.put(element, ColourConstants.WHITE);
            }
            colors.put(actual, ColourConstants.GRAY);
            Q.clear();
            Q.add(actual);
            if (actual == all[0]) {
                leader = handlers;
                n2 = leader.length;
                for (n = 0; n < n2; ++n) {
                    Object handler = leader[n];
                    colors.put(((CodeExceptionGen)handler).getHandlerPC(), ColourConstants.GRAY);
                    Q.add(((CodeExceptionGen)handler).getHandlerPC());
                }
            }
            while (Q.size() != 0) {
                InstructionHandle[] successors;
                InstructionHandle u = (InstructionHandle)Q.remove(0);
                for (InstructionHandle successor : successors = Subroutines.getSuccessors(u)) {
                    if (colors.get(successor) != ColourConstants.WHITE) continue;
                    colors.put(successor, ColourConstants.GRAY);
                    Q.add(successor);
                }
                colors.put(u, ColourConstants.BLACK);
            }
            InstructionHandle[] instructionHandleArray = all;
            int successors = instructionHandleArray.length;
            for (n = 0; n < successors; ++n) {
                InstructionHandle element = instructionHandleArray[n];
                if (colors.get(element) != ColourConstants.BLACK) continue;
                ((SubroutineImpl)(actual == all[0] ? this.getTopLevel() : this.getSubroutine(actual))).addInstruction(element);
                if (instructions_assigned.contains(element)) {
                    throw new StructuralCodeConstraintException("Instruction '" + element + "' is part of more than one subroutine (or of the top level and a subroutine).");
                }
                instructions_assigned.add(element);
            }
            if (actual == all[0]) continue;
            ((SubroutineImpl)this.getSubroutine(actual)).setLeavingRET();
        }
        if (enableJustIceCheck) {
            for (CodeExceptionGen handler : handlers) {
                for (InstructionHandle _protected = handler.getStartPC(); _protected != handler.getEndPC().getNext(); _protected = _protected.getNext()) {
                    for (Subroutine sub : this.subroutines.values()) {
                        if (sub == this.subroutines.get(all[0]) || !sub.contains(_protected)) continue;
                        throw new StructuralCodeConstraintException("Subroutine instruction '" + _protected + "' is protected by an exception handler, '" + handler + "'. This is forbidden by the JustIce verifier due to its clear definition of subroutines.");
                    }
                }
            }
        }
        this.noRecursiveCalls(this.getTopLevel(), new HashSet<Integer>());
    }

    private void noRecursiveCalls(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Subroutine sub, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Set<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Integer> set) {
        Subroutine[] subs;
        for (Subroutine sub2 : subs = sub.subSubs()) {
            int index = ((RET)sub2.getLeavingRET().getInstruction()).getIndex();
            if (!set.add(index)) {
                SubroutineImpl si = (SubroutineImpl)sub2;
                throw new StructuralCodeConstraintException("Subroutine with local variable '" + si.localVariable + "', JSRs '" + si.theJSRs + "', RET '" + si.theRET + "' is called by a subroutine which uses the same local variable index as itself; maybe even a recursive call? JustIce's clean definition of a subroutine forbids both.");
            }
            this.noRecursiveCalls(sub2, set);
            set.remove(index);
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Subroutine getSubroutine(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle leader) {
        Subroutine ret = this.subroutines.get(leader);
        if (ret == null) {
            throw new AssertionViolatedException("Subroutine requested for an InstructionHandle that is not a leader of a subroutine.");
        }
        if (ret == this.TOPLEVEL) {
            throw new AssertionViolatedException("TOPLEVEL special subroutine requested; use getTopLevel().");
        }
        return ret;
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Subroutine subroutineOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle any) {
        for (Subroutine s2 : this.subroutines.values()) {
            if (!s2.contains(any)) continue;
            return s2;
        }
        System.err.println("DEBUG: Please verify '" + any.toString(true) + "' lies in dead code.");
        return null;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Subroutine getTopLevel() {
        return this.TOPLEVEL;
    }

    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getSuccessors(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle instruction) {
        InstructionHandle[] empty = new InstructionHandle[]{};
        InstructionHandle[] single = new InstructionHandle[1];
        Instruction inst = instruction.getInstruction();
        if (inst instanceof RET) {
            return empty;
        }
        if (inst instanceof ReturnInstruction) {
            return empty;
        }
        if (inst instanceof ATHROW) {
            return empty;
        }
        if (inst instanceof JsrInstruction) {
            single[0] = instruction.getNext();
            return single;
        }
        if (inst instanceof GotoInstruction) {
            single[0] = ((GotoInstruction)inst).getTarget();
            return single;
        }
        if (inst instanceof BranchInstruction) {
            if (inst instanceof Select) {
                InstructionHandle[] matchTargets = ((Select)inst).getTargets();
                InstructionHandle[] ret = new InstructionHandle[matchTargets.length + 1];
                ret[0] = ((Select)inst).getTarget();
                System.arraycopy(matchTargets, 0, ret, 1, matchTargets.length);
                return ret;
            }
            InstructionHandle[] pair = new InstructionHandle[]{instruction.getNext(), ((BranchInstruction)inst).getTarget()};
            return pair;
        }
        single[0] = instruction.getNext();
        return single;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "---\n" + this.subroutines + "\n---\n";
    }

    private static enum ColourConstants {
        WHITE,
        GRAY,
        BLACK;

    }

    @UsesObjectEquals
    private class SubroutineImpl
    implements Subroutine {
        private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int UNSET = -1;
        private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int localVariable = -1;
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Set<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle> instructions = new HashSet<InstructionHandle>();
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Set<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle> theJSRs = new HashSet<InstructionHandle>();
        private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle theRET;

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean contains(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle inst) {
            return this.instructions.contains(inst);
        }

        @SideEffectFree
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
            int[] alv;
            StringBuilder ret = new StringBuilder();
            ret.append("Subroutine: Local variable is '").append(this.localVariable);
            ret.append("', JSRs are '").append(this.theJSRs);
            ret.append("', RET is '").append(this.theRET);
            ret.append("', Instructions: '").append(this.instructions).append("'.");
            ret.append(" Accessed local variable slots: '");
            for (int element : alv = this.getAccessedLocalsIndices()) {
                ret.append(element);
                ret.append(" ");
            }
            ret.append("'.");
            ret.append(" Recursively (via subsub...routines) accessed local variable slots: '");
            for (int element : alv = this.getRecursivelyAccessedLocalsIndices()) {
                ret.append(element);
                ret.append(" ");
            }
            ret.append("'.");
            return ret.toString();
        }

        void setLeavingRET() {
            if (this.localVariable == -1) {
                throw new AssertionViolatedException("setLeavingRET() called for top-level 'subroutine' or forgot to set local variable first.");
            }
            InstructionHandle ret = null;
            for (InstructionHandle actual : this.instructions) {
                if (!(actual.getInstruction() instanceof RET)) continue;
                if (ret != null) {
                    throw new StructuralCodeConstraintException("Subroutine with more then one RET detected: '" + ret + "' and '" + actual + "'.");
                }
                ret = actual;
            }
            if (ret == null) {
                throw new StructuralCodeConstraintException("Subroutine without a RET detected.");
            }
            if (((RET)ret.getInstruction()).getIndex() != this.localVariable) {
                throw new StructuralCodeConstraintException("Subroutine uses '" + ret + "' which does not match the correct local variable '" + this.localVariable + "'.");
            }
            this.theRET = ret;
        }

        @Override
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getEnteringJsrInstructions() {
            if (this == Subroutines.this.getTopLevel()) {
                throw new AssertionViolatedException("getLeavingRET() called on top level pseudo-subroutine.");
            }
            InstructionHandle[] jsrs = new InstructionHandle[this.theJSRs.size()];
            return this.theJSRs.toArray(jsrs);
        }

        public void addEnteringJsrInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle jsrInst) {
            if (jsrInst == null || !(jsrInst.getInstruction() instanceof JsrInstruction)) {
                throw new AssertionViolatedException("Expecting JsrInstruction InstructionHandle.");
            }
            if (this.localVariable == -1) {
                throw new AssertionViolatedException("Set the localVariable first!");
            }
            if (this.localVariable != ((ASTORE)((JsrInstruction)jsrInst.getInstruction()).getTarget().getInstruction()).getIndex()) {
                throw new AssertionViolatedException("Setting a wrong JsrInstruction.");
            }
            this.theJSRs.add(jsrInst);
        }

        @Override
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle getLeavingRET() {
            if (this == Subroutines.this.getTopLevel()) {
                throw new AssertionViolatedException("getLeavingRET() called on top level pseudo-subroutine.");
            }
            return this.theRET;
        }

        @Override
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getInstructions() {
            InstructionHandle[] ret = new InstructionHandle[this.instructions.size()];
            return this.instructions.toArray(ret);
        }

        void addInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle ih) {
            if (this.theRET != null) {
                throw new AssertionViolatedException("All instructions must have been added before invoking setLeavingRET().");
            }
            this.instructions.add(ih);
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getRecursivelyAccessedLocalsIndices() {
            int[] lvs;
            HashSet<Integer> s2 = new HashSet<Integer>();
            for (int lv : lvs = this.getAccessedLocalsIndices()) {
                s2.add(lv);
            }
            this._getRecursivelyAccessedLocalsIndicesHelper(s2, this.subSubs());
            int[] ret = new int[s2.size()];
            int j = -1;
            for (Integer index : s2) {
                ret[++j] = index;
            }
            return ret;
        }

        private void _getRecursivelyAccessedLocalsIndicesHelper(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Set<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Integer> s2, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Subroutine @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] subs) {
            for (Subroutine sub : subs) {
                int[] lvs;
                for (int lv : lvs = sub.getAccessedLocalsIndices()) {
                    s2.add(lv);
                }
                if (sub.subSubs().length == 0) continue;
                this._getRecursivelyAccessedLocalsIndicesHelper(s2, sub.subSubs());
            }
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getAccessedLocalsIndices() {
            HashSet<Integer> acc = new HashSet<Integer>();
            if (this.theRET == null && this != Subroutines.this.getTopLevel()) {
                throw new AssertionViolatedException("This subroutine object must be built up completely before calculating accessed locals.");
            }
            for (InstructionHandle ih : this.instructions) {
                if (!(ih.getInstruction() instanceof LocalVariableInstruction) && !(ih.getInstruction() instanceof RET)) continue;
                int idx = ((IndexedInstruction)((Object)ih.getInstruction())).getIndex();
                acc.add(idx);
                try {
                    int s2;
                    if (!(ih.getInstruction() instanceof LocalVariableInstruction) || (s2 = ((LocalVariableInstruction)ih.getInstruction()).getType(null).getSize()) != 2) continue;
                    acc.add(idx + 1);
                }
                catch (RuntimeException re) {
                    throw new AssertionViolatedException("BCEL did not like NULL as a ConstantPoolGen object.", re);
                }
            }
            int[] ret = new int[acc.size()];
            int j = -1;
            for (Integer accessedLocal : acc) {
                ret[++j] = accessedLocal;
            }
            return ret;
        }

        @Override
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Subroutine @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] subSubs() {
            HashSet<Subroutine> h2 = new HashSet<Subroutine>();
            for (InstructionHandle ih : this.instructions) {
                Instruction inst = ih.getInstruction();
                if (!(inst instanceof JsrInstruction)) continue;
                InstructionHandle targ = ((JsrInstruction)inst).getTarget();
                h2.add(Subroutines.this.getSubroutine(targ));
            }
            Subroutine[] ret = new Subroutine[h2.size()];
            return h2.toArray(ret);
        }

        void setLocalVariable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
            if (this.localVariable != -1) {
                throw new AssertionViolatedException("localVariable set twice.");
            }
            this.localVariable = i;
        }
    }
}

