/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.generic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import randoop.org.apache.bcel.classfile.ClassFormatException;
import randoop.org.apache.bcel.classfile.Utility;
import randoop.org.apache.bcel.generic.ArrayType;
import randoop.org.apache.bcel.generic.BasicType;
import randoop.org.apache.bcel.generic.ObjectType;
import randoop.org.apache.bcel.generic.ReferenceType;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.InternedDistinct;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.BinaryName;
import randoop.org.checkerframework.checker.signature.qual.ClassGetName;
import randoop.org.checkerframework.checker.signature.qual.FieldDescriptor;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class Type {
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte type;
    @Deprecated
    protected @FieldDescriptor @UnknownInterned @UnknownKeyFor @NonNull @Initialized String signature;
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BasicType VOID = new BasicType(12);
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BasicType BOOLEAN = new BasicType(4);
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BasicType INT = new BasicType(10);
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BasicType SHORT = new BasicType(9);
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BasicType BYTE = new BasicType(8);
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BasicType LONG = new BasicType(11);
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BasicType DOUBLE = new BasicType(7);
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BasicType FLOAT = new BasicType(6);
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BasicType CHAR = new BasicType(5);
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType OBJECT = new ObjectType("java.lang.Object");
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType CLASS = new ObjectType("java.lang.Class");
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType STRING = new ObjectType("java.lang.String");
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType STRINGBUFFER = new ObjectType("java.lang.StringBuffer");
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType THROWABLE = new ObjectType("java.lang.Throwable");
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] NO_ARGS = new Type[0];
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ReferenceType NULL = new ReferenceType(){};
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type UNKNOWN = new Type(15, "<unknown object>"){};
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ThreadLocal<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Integer> consumed_chars = new ThreadLocal<Integer>(){

        @Override
        protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Integer initialValue() {
            return 0;
        }
    };

    protected Type(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte t2, @FieldDescriptor @UnknownInterned @UnknownKeyFor @NonNull @Initialized String s2) {
        this.type = t2;
        this.signature = s2;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return this.type ^ this.signature.hashCode();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object o) {
        if (o instanceof Type) {
            Type t2 = (Type)o;
            return this.type == t2.type && this.signature.equals(t2.signature);
        }
        return false;
    }

    public @FieldDescriptor @UnknownInterned @UnknownKeyFor @NonNull @Initialized String getSignature() {
        return this.signature;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte getType() {
        return this.type;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type normalizeForStackOrLocal() {
        if (this == BOOLEAN || this == BYTE || this == SHORT || this == CHAR) {
            return INT;
        }
        return this;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getSize() {
        switch (this.type) {
            case 7: 
            case 11: {
                return 2;
            }
            case 12: {
                return 0;
            }
        }
        return 1;
    }

    @SideEffectFree
    public @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.equals(NULL) || this.type >= 15 ? this.signature : Utility.signatureToString(this.signature, false);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getMethodSignature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type return_type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] arg_types) {
        StringBuilder buf = new StringBuilder("(");
        if (arg_types != null) {
            for (Type arg_type : arg_types) {
                buf.append(arg_type.getSignature());
            }
        }
        buf.append(')');
        buf.append(return_type.getSignature());
        return buf.toString();
    }

    private static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int unwrap(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ThreadLocal<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Integer> tl) {
        return tl.get();
    }

    private static void wrap(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ThreadLocal<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Integer> tl, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int value) {
        tl.set(value);
    }

    public static @NonNull @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Type getType(@ClassGetName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String signature) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StringIndexOutOfBoundsException {
        byte type = Utility.typeOfSignature(signature);
        if (type <= 12) {
            Type.wrap(consumed_chars, 1);
            return BasicType.getType(type);
        }
        if (type == 13) {
            int dim = 0;
            while (signature.charAt(++dim) == '[') {
            }
            Type t2 = Type.getType(signature.substring(dim));
            int _temp = Type.unwrap(consumed_chars) + dim;
            Type.wrap(consumed_chars, _temp);
            return new ArrayType(t2, dim);
        }
        String parsedSignature = Utility.typeSignatureToString(signature, false);
        Type.wrap(consumed_chars, parsedSignature.length() + 2);
        @BinaryName String className = parsedSignature.replace('/', '.');
        return ObjectType.getInstance(className);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getReturnType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) {
        try {
            int index = signature.lastIndexOf(41) + 1;
            return Type.getType(signature.substring(index));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature, e);
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getArgumentTypes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) {
        ArrayList<Type> vec = new ArrayList<Type>();
        try {
            int index = signature.indexOf(40) + 1;
            if (index <= 0) {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            while (signature.charAt(index) != ')') {
                vec.add(Type.getType(signature.substring(index)));
                index += Type.unwrap(consumed_chars);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature, e);
        }
        Type[] types = new Type[vec.size()];
        vec.toArray(types);
        return types;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Class<@UnknownInterned @InternedDistinct @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @SignatureUnknown @SignatureBottom ?> cl) {
        if (cl == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (cl.isArray()) {
            return Type.getType(cl.getName());
        }
        if (cl.isPrimitive()) {
            if (cl == Integer.TYPE) {
                return INT;
            }
            if (cl == Void.TYPE) {
                return VOID;
            }
            if (cl == Double.TYPE) {
                return DOUBLE;
            }
            if (cl == Float.TYPE) {
                return FLOAT;
            }
            if (cl == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (cl == Byte.TYPE) {
                return BYTE;
            }
            if (cl == Short.TYPE) {
                return SHORT;
            }
            if (cl == Byte.TYPE) {
                return BYTE;
            }
            if (cl == Long.TYPE) {
                return LONG;
            }
            if (cl == Character.TYPE) {
                return CHAR;
            }
            throw new IllegalStateException("Unknown primitive type " + cl);
        }
        return ObjectType.getInstance(cl.getName());
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getTypes(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Class<@UnknownInterned @InternedDistinct @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @SignatureUnknown @SignatureBottom ?> @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] classes) {
        Type[] ret = new Type[classes.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Type.getType(classes[i]);
        }
        return ret;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getSignature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method meth) {
        Class<?>[] params;
        StringBuilder sb = new StringBuilder("(");
        for (Class<?> param : params = meth.getParameterTypes()) {
            sb.append(Type.getType(param).getSignature());
        }
        sb.append(")");
        sb.append(Type.getType(meth.getReturnType()).getSignature());
        return sb.toString();
    }

    static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int size(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int coded) {
        return coded & 3;
    }

    static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int consumed(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int coded) {
        return coded >> 2;
    }

    static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int encode(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int size, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int consumed) {
        return consumed << 2 | size;
    }

    static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getArgumentTypesSize(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) {
        int res = 0;
        try {
            int index = signature.indexOf(40) + 1;
            if (index <= 0) {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            while (signature.charAt(index) != ')') {
                int coded = Type.getTypeSize(signature.substring(index));
                res += Type.size(coded);
                index += Type.consumed(coded);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature, e);
        }
        return res;
    }

    static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getTypeSize(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StringIndexOutOfBoundsException {
        byte type = Utility.typeOfSignature(signature);
        if (type <= 12) {
            return Type.encode(BasicType.getType(type).getSize(), 1);
        }
        if (type == 13) {
            int dim = 0;
            while (signature.charAt(++dim) == '[') {
            }
            int consumed = Type.consumed(Type.getTypeSize(signature.substring(dim)));
            return Type.encode(1, dim + consumed);
        }
        int index = signature.indexOf(59);
        if (index < 0) {
            throw new ClassFormatException("Invalid signature: " + signature);
        }
        return Type.encode(1, index + 1);
    }

    static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getReturnTypeSize(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) {
        int index = signature.lastIndexOf(41) + 1;
        return Type.size(Type.getTypeSize(signature.substring(index)));
    }

    void setSignature(@FieldDescriptor @UnknownInterned @UnknownKeyFor @NonNull @Initialized String signature) {
        this.signature = signature;
    }
}

