/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.generic;

import randoop.org.apache.bcel.classfile.CodeException;
import randoop.org.apache.bcel.generic.BranchInstruction;
import randoop.org.apache.bcel.generic.ClassGenException;
import randoop.org.apache.bcel.generic.ConstantPoolGen;
import randoop.org.apache.bcel.generic.InstructionHandle;
import randoop.org.apache.bcel.generic.InstructionTargeter;
import randoop.org.apache.bcel.generic.ObjectType;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public final class CodeExceptionGen
implements InstructionTargeter,
Cloneable {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle startPc;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle endPc;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle handlerPc;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType catchType;

    public CodeExceptionGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle startPc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle endPc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle handlerPc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType catchType) {
        this.setStartPC(startPc);
        this.setEndPC(endPc);
        this.setHandlerPC(handlerPc);
        this.catchType = catchType;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeException getCodeException(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        return new CodeException(this.startPc.getPosition(), this.endPc.getPosition() + this.endPc.getInstruction().getLength(), this.handlerPc.getPosition(), this.catchType == null ? 0 : cp.addClass(this.catchType));
    }

    public void setStartPC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle start_pc) {
        BranchInstruction.notifyTarget(this.startPc, start_pc, this);
        this.startPc = start_pc;
    }

    public void setEndPC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle end_pc) {
        BranchInstruction.notifyTarget(this.endPc, end_pc, this);
        this.endPc = end_pc;
    }

    public void setHandlerPC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle handler_pc) {
        BranchInstruction.notifyTarget(this.handlerPc, handler_pc, this);
        this.handlerPc = handler_pc;
    }

    @Override
    public void updateTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle old_ih, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle new_ih) {
        boolean targeted = false;
        if (this.startPc == old_ih) {
            targeted = true;
            this.setStartPC(new_ih);
        }
        if (this.endPc == old_ih) {
            targeted = true;
            this.setEndPC(new_ih);
        }
        if (this.handlerPc == old_ih) {
            targeted = true;
            this.setHandlerPC(new_ih);
        }
        if (!targeted) {
            throw new ClassGenException("Not targeting " + old_ih + ", but {" + this.startPc + ", " + this.endPc + ", " + this.handlerPc + "}");
        }
    }

    @Override
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean containsTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle ih) {
        return this.startPc == ih || this.endPc == ih || this.handlerPc == ih;
    }

    public void setCatchType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType catchType) {
        this.catchType = catchType;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType getCatchType() {
        return this.catchType;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle getStartPC() {
        return this.startPc;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle getEndPC() {
        return this.endPc;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle getHandlerPC() {
        return this.handlerPc;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "CodeExceptionGen(" + this.startPc + ", " + this.endPc + ", " + this.handlerPc + ")";
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }
}

