/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import randoop.org.apache.bcel.classfile.Attribute;
import randoop.org.apache.bcel.classfile.ConstantPool;
import randoop.org.apache.bcel.classfile.ModuleExports;
import randoop.org.apache.bcel.classfile.ModuleOpens;
import randoop.org.apache.bcel.classfile.ModuleProvides;
import randoop.org.apache.bcel.classfile.ModuleRequires;
import randoop.org.apache.bcel.classfile.Utility;
import randoop.org.apache.bcel.classfile.Visitor;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public final class Module
extends Attribute {
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int moduleNameIndex;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int moduleFlags;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int moduleVersionIndex;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModuleRequires @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] requiresTable;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModuleExports @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] exportsTable;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModuleOpens @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] opensTable;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int usesCount;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] usesIndex;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModuleProvides @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] providesTable;

    Module(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super((byte)22, name_index, length, constant_pool);
        int i;
        this.moduleNameIndex = input.readUnsignedShort();
        this.moduleFlags = input.readUnsignedShort();
        this.moduleVersionIndex = input.readUnsignedShort();
        int requires_count = input.readUnsignedShort();
        this.requiresTable = new ModuleRequires[requires_count];
        for (int i2 = 0; i2 < requires_count; ++i2) {
            this.requiresTable[i2] = new ModuleRequires(input);
        }
        int exports_count = input.readUnsignedShort();
        this.exportsTable = new ModuleExports[exports_count];
        for (int i3 = 0; i3 < exports_count; ++i3) {
            this.exportsTable[i3] = new ModuleExports(input);
        }
        int opens_count = input.readUnsignedShort();
        this.opensTable = new ModuleOpens[opens_count];
        for (i = 0; i < opens_count; ++i) {
            this.opensTable[i] = new ModuleOpens(input);
        }
        this.usesCount = input.readUnsignedShort();
        this.usesIndex = new int[this.usesCount];
        for (i = 0; i < this.usesCount; ++i) {
            this.usesIndex[i] = input.readUnsignedShort();
        }
        int provides_count = input.readUnsignedShort();
        this.providesTable = new ModuleProvides[provides_count];
        for (int i4 = 0; i4 < provides_count; ++i4) {
            this.providesTable[i4] = new ModuleProvides(input);
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitModule(this);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModuleRequires @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getRequiresTable() {
        return this.requiresTable;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModuleExports @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getExportsTable() {
        return this.exportsTable;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModuleOpens @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getOpensTable() {
        return this.opensTable;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModuleProvides @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getProvidesTable() {
        return this.providesTable;
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.moduleNameIndex);
        file.writeShort(this.moduleFlags);
        file.writeShort(this.moduleVersionIndex);
        file.writeShort(this.requiresTable.length);
        for (ModuleRequires moduleRequires : this.requiresTable) {
            moduleRequires.dump(file);
        }
        file.writeShort(this.exportsTable.length);
        for (ModuleExports moduleExports : this.exportsTable) {
            moduleExports.dump(file);
        }
        file.writeShort(this.opensTable.length);
        for (ModuleOpens moduleOpens : this.opensTable) {
            moduleOpens.dump(file);
        }
        file.writeShort(this.usesIndex.length);
        for (int n : this.usesIndex) {
            file.writeShort(n);
        }
        file.writeShort(this.providesTable.length);
        for (ModuleProvides moduleProvides : this.providesTable) {
            moduleProvides.dump(file);
        }
    }

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        ConstantPool cp = super.getConstantPool();
        StringBuilder buf = new StringBuilder();
        buf.append("Module:\n");
        buf.append("  name:    ").append(cp.getConstantString(this.moduleNameIndex, (byte)19).replace('/', '.')).append("\n");
        buf.append("  flags:   ").append(String.format("%04x", this.moduleFlags)).append("\n");
        String version = this.moduleVersionIndex == 0 ? "0" : cp.getConstantString(this.moduleVersionIndex, (byte)1);
        buf.append("  version: ").append(version).append("\n");
        buf.append("  requires(").append(this.requiresTable.length).append("):\n");
        for (ModuleRequires moduleRequires : this.requiresTable) {
            buf.append("    ").append(moduleRequires.toString(cp)).append("\n");
        }
        buf.append("  exports(").append(this.exportsTable.length).append("):\n");
        for (ModuleExports moduleExports : this.exportsTable) {
            buf.append("    ").append(moduleExports.toString(cp)).append("\n");
        }
        buf.append("  opens(").append(this.opensTable.length).append("):\n");
        for (ModuleOpens moduleOpens : this.opensTable) {
            buf.append("    ").append(moduleOpens.toString(cp)).append("\n");
        }
        buf.append("  uses(").append(this.usesIndex.length).append("):\n");
        for (int n : this.usesIndex) {
            String class_name = cp.getConstantString(n, (byte)7);
            buf.append("    ").append(Utility.compactClassName(class_name, false)).append("\n");
        }
        buf.append("  provides(").append(this.providesTable.length).append("):\n");
        for (ModuleProvides moduleProvides : this.providesTable) {
            buf.append("    ").append(moduleProvides.toString(cp)).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        int i;
        Module c = (Module)this.clone();
        c.requiresTable = new ModuleRequires[this.requiresTable.length];
        for (i = 0; i < this.requiresTable.length; ++i) {
            c.requiresTable[i] = this.requiresTable[i].copy();
        }
        c.exportsTable = new ModuleExports[this.exportsTable.length];
        for (i = 0; i < this.exportsTable.length; ++i) {
            c.exportsTable[i] = this.exportsTable[i].copy();
        }
        c.opensTable = new ModuleOpens[this.opensTable.length];
        for (i = 0; i < this.opensTable.length; ++i) {
            c.opensTable[i] = this.opensTable[i].copy();
        }
        c.providesTable = new ModuleProvides[this.providesTable.length];
        for (i = 0; i < this.providesTable.length; ++i) {
            c.providesTable[i] = this.providesTable[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

