/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import randoop.org.apache.bcel.classfile.Attribute;
import randoop.org.apache.bcel.classfile.ConstantPool;
import randoop.org.apache.bcel.classfile.LocalVariable;
import randoop.org.apache.bcel.classfile.Visitor;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public class LocalVariableTable
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] localVariableTable;

    public LocalVariableTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableTable c) {
        this(c.getNameIndex(), c.getLength(), c.getLocalVariableTable(), c.getConstantPool());
    }

    public LocalVariableTable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] localVariableTable, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool) {
        super((byte)5, nameIndex, length, constantPool);
        this.localVariableTable = localVariableTable;
    }

    LocalVariableTable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(name_index, length, (LocalVariable[])null, constant_pool);
        int local_variable_table_length = input.readUnsignedShort();
        this.localVariableTable = new LocalVariable[local_variable_table_length];
        for (int i = 0; i < local_variable_table_length; ++i) {
            this.localVariableTable[i] = new LocalVariable(input, constant_pool);
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitLocalVariableTable(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.localVariableTable.length);
        for (LocalVariable variable : this.localVariableTable) {
            variable.dump(file);
        }
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getLocalVariableTable() {
        return this.localVariableTable;
    }

    @Deprecated
    public final @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown LocalVariable getLocalVariable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        for (LocalVariable variable : this.localVariableTable) {
            if (variable.getIndex() != index) continue;
            return variable;
        }
        return null;
    }

    public final @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown LocalVariable getLocalVariable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int pc) {
        for (LocalVariable variable : this.localVariableTable) {
            if (variable.getIndex() != index) continue;
            int start_pc = variable.getStartPC();
            int end_pc = start_pc + variable.getLength();
            if (pc < start_pc || pc > end_pc) continue;
            return variable;
        }
        return null;
    }

    public final void setLocalVariableTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] local_variable_table) {
        this.localVariableTable = local_variable_table;
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.localVariableTable.length; ++i) {
            buf.append(this.localVariableTable[i]);
            if (i >= this.localVariableTable.length - 1) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        LocalVariableTable c = (LocalVariableTable)this.clone();
        c.localVariableTable = new LocalVariable[this.localVariableTable.length];
        for (int i = 0; i < this.localVariableTable.length; ++i) {
            c.localVariableTable[i] = this.localVariableTable[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getTableLength() {
        return this.localVariableTable == null ? 0 : this.localVariableTable.length;
    }
}

