/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import randoop.org.apache.bcel.classfile.Attribute;
import randoop.org.apache.bcel.classfile.ConstantPool;
import randoop.org.apache.bcel.classfile.Utility;
import randoop.org.apache.bcel.classfile.Visitor;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public final class ExceptionTable
extends Attribute {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] exceptionIndexTable;

    public ExceptionTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ExceptionTable c) {
        this(c.getNameIndex(), c.getLength(), c.getExceptionIndexTable(), c.getConstantPool());
    }

    public ExceptionTable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] exceptionIndexTable, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super((byte)3, name_index, length, constant_pool);
        this.exceptionIndexTable = exceptionIndexTable != null ? exceptionIndexTable : new int[]{};
    }

    ExceptionTable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(nameIndex, length, (int[])null, constantPool);
        int number_of_exceptions = input.readUnsignedShort();
        this.exceptionIndexTable = new int[number_of_exceptions];
        for (int i = 0; i < number_of_exceptions; ++i) {
            this.exceptionIndexTable[i] = input.readUnsignedShort();
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitExceptionTable(this);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.exceptionIndexTable.length);
        for (int index : this.exceptionIndexTable) {
            file.writeShort(index);
        }
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getExceptionIndexTable() {
        return this.exceptionIndexTable;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNumberOfExceptions() {
        return this.exceptionIndexTable == null ? 0 : this.exceptionIndexTable.length;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getExceptionNames() {
        String[] names = new String[this.exceptionIndexTable.length];
        for (int i = 0; i < this.exceptionIndexTable.length; ++i) {
            names[i] = super.getConstantPool().getConstantString(this.exceptionIndexTable[i], (byte)7).replace('/', '.');
        }
        return names;
    }

    public void setExceptionIndexTable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] exceptionIndexTable) {
        this.exceptionIndexTable = exceptionIndexTable != null ? exceptionIndexTable : new int[]{};
    }

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Exceptions: ");
        for (int i = 0; i < this.exceptionIndexTable.length; ++i) {
            String str = super.getConstantPool().getConstantString(this.exceptionIndexTable[i], (byte)7);
            buf.append(Utility.compactClassName(str, false));
            if (i >= this.exceptionIndexTable.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        ExceptionTable c = (ExceptionTable)this.clone();
        if (this.exceptionIndexTable != null) {
            c.exceptionIndexTable = new int[this.exceptionIndexTable.length];
            System.arraycopy(this.exceptionIndexTable, 0, c.exceptionIndexTable, 0, this.exceptionIndexTable.length);
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

