/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import randoop.org.apache.bcel.classfile.Constant;
import randoop.org.apache.bcel.classfile.ConstantPool;
import randoop.org.apache.bcel.classfile.Visitor;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public final class ConstantNameAndType
extends Constant {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signatureIndex;

    public ConstantNameAndType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantNameAndType c) {
        this(c.getNameIndex(), c.getSignatureIndex());
    }

    ConstantNameAndType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort());
    }

    public ConstantNameAndType(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signatureIndex) {
        super((byte)12);
        this.nameIndex = nameIndex;
        this.signatureIndex = signatureIndex;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitConstantNameAndType(this);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeByte(super.getTag());
        file.writeShort(this.nameIndex);
        file.writeShort(this.signatureIndex);
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNameIndex() {
        return this.nameIndex;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cp) {
        return cp.constantToString(this.getNameIndex(), (byte)1);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getSignatureIndex() {
        return this.signatureIndex;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getSignature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cp) {
        return cp.constantToString(this.getSignatureIndex(), (byte)1);
    }

    public void setNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex) {
        this.nameIndex = nameIndex;
    }

    public void setSignatureIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signatureIndex) {
        this.signatureIndex = signatureIndex;
    }

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return super.toString() + "(nameIndex = " + this.nameIndex + ", signatureIndex = " + this.signatureIndex + ")";
    }
}

