/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import randoop.condition.ExecutableSpecification;
import randoop.operation.CallableOperation;
import randoop.operation.ConstructorCall;
import randoop.operation.MethodCall;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.org.plumelib.util.StringsPlume;
import randoop.reflection.RawSignature;
import randoop.sequence.Variable;
import randoop.types.ClassOrInterfaceType;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeTuple;
import randoop.types.TypeVariable;

public class TypedClassOperation
extends TypedOperation {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType declaringType;
    private @MonotonicNonNull @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RawSignature rawSignature = null;

    public TypedClassOperation(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown CallableOperation operation, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType declaringType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type outputType) {
        this(operation, declaringType, inputTypes, outputType, null);
    }

    public TypedClassOperation(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown CallableOperation operation, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType declaringType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type outputType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSpecification execSpec) {
        super(operation, inputTypes, outputType, execSpec);
        this.declaringType = declaringType;
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypedClassOperation)) {
            return false;
        }
        TypedClassOperation op = (TypedClassOperation)obj;
        return this.declaringType.equals(op.declaringType) && super.equals(obj);
    }

    @Override
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(super.hashCode(), this.declaringType);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        if (substitution.isEmpty()) {
            return this;
        }
        ClassOrInterfaceType declaringType = this.declaringType.substitute(substitution);
        TypeTuple inputTypes = this.getInputTypes().substitute(substitution);
        Type outputType = this.getOutputType().substitute(substitution);
        return new TypedClassOperation(this.getOperation(), declaringType, inputTypes, outputType, this.getExecutableSpecification());
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation applyCaptureConversion() {
        TypeTuple inputTypes = this.getInputTypes().applyCaptureConversion();
        Type outputType = this.getOutputType();
        return new TypedClassOperation(this.getOperation(), this.declaringType, inputTypes, outputType, this.getExecutableSpecification());
    }

    @Override
    public void appendCode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> inputVars, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringBuilder b) {
        assert (inputVars.size() == this.getInputTypes().size()) : "number of inputs doesn't match on operation appendCode";
        this.getOperation().appendCode(this.declaringType, this.getInputTypes(), this.getOutputType(), inputVars, b);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toParsableString() {
        return this.getOperation().toParsableString(this.declaringType, this.getInputTypes(), this.getOutputType());
    }

    @Override
    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        if (this.isGeneric()) {
            String b = "<" + StringsPlume.join((CharSequence)",", this.getTypeParameters()) + "> ";
            return b + super.toString();
        }
        return super.toString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getName() {
        return this.declaringType + "." + super.getName();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getUnqualifiedBinaryName() {
        return super.getName();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasWildcardTypes() {
        return this.getInputTypes().hasWildcard() || this.getOutputType().isParameterized() && ((ClassOrInterfaceType)this.getOutputType()).hasWildcard();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> getTypeParameters() {
        List<TypeVariable> inputTypeParams = this.getInputTypes().getTypeParameters();
        LinkedHashSet<TypeVariable> paramSet = new LinkedHashSet<TypeVariable>(CollectionsPlume.mapCapacity(inputTypeParams.size()));
        paramSet.addAll(inputTypeParams);
        if (this.getOutputType().isReferenceType()) {
            paramSet.addAll(((ReferenceType)this.getOutputType()).getTypeParameters());
        }
        return new ArrayList<TypeVariable>(paramSet);
    }

    public @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getFullyQualifiedSignature() {
        if (!this.isConstructorCall() && !this.isMethodCall()) {
            return null;
        }
        Package classPackage = this.declaringType.getPackage();
        String packageName = RawSignature.getPackageName(classPackage);
        String classname = this.getDeclaringType().getRawtype().getUnqualifiedBinaryName();
        String name = this.getUnqualifiedBinaryName().equals("<init>") ? classname : this.getUnqualifiedBinaryName();
        Iterator<Type> inputTypeIterator = this.inputTypes.iterator();
        ArrayList<String> typeNames = new ArrayList<String>(this.inputTypes.size());
        int i = 0;
        while (inputTypeIterator.hasNext()) {
            String typeName = inputTypeIterator.next().getFqName();
            if (i != 0 || this.isStatic()) {
                typeNames.add(typeName);
            }
            ++i;
        }
        return (packageName == null ? "" : packageName + ".") + (classname.equals(name) ? name : classname + "." + name) + "(" + StringsPlume.join((CharSequence)",", typeNames) + ")";
    }

    public @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RawSignature getRawSignature() {
        if (!this.isConstructorCall() && !this.isMethodCall()) {
            return null;
        }
        if (this.rawSignature == null) {
            Package classPackage = this.declaringType.getPackage();
            String packageName = RawSignature.getPackageName(classPackage);
            String classname = RawSignature.classNameToIdentifier(this.getDeclaringType().getRawtype().getUnqualifiedBinaryName());
            String name = this.getUnqualifiedBinaryName().equals("<init>") ? classname : this.getUnqualifiedBinaryName();
            Class<?>[] parameterTypes = this.isMethodCall() ? ((MethodCall)this.getOperation()).getMethod().getParameterTypes() : ((ConstructorCall)this.getOperation()).getConstructor().getParameterTypes();
            this.rawSignature = new RawSignature(packageName, classname, name, parameterTypes);
        }
        return this.rawSignature;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation getOperationForType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType type) {
        if (type == this.getDeclaringType()) {
            return this;
        }
        return new TypedClassOperation(this.getOperation(), type, this.getInputTypes(), this.getOutputType(), this.getExecutableSpecification());
    }
}

