/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.operation.CallableOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.sequence.Variable;
import randoop.types.Type;
import randoop.types.TypeTuple;

public class PlusOperation
extends CallableOperation {
    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return "+";
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof PlusOperation;
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return 20250416;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionOutcome execute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] input) {
        if (input.length != 2) {
            throw new IllegalArgumentException("Plus operation requires two arguments, but received " + Arrays.toString(input));
        }
        Object a = input[0];
        Object b = input[1];
        if (!(a instanceof Number) && !(a instanceof Character) || !(b instanceof Number) && !(b instanceof Character)) {
            throw new IllegalArgumentException("Arguments must be numbers or characters, but received: a=" + a.getClass().getName() + ", b=" + b.getClass().getName());
        }
        long startTimeMillis = System.currentTimeMillis();
        Serializable result = a instanceof Byte && b instanceof Byte ? Byte.valueOf((byte)((Byte)a + (Byte)b)) : (a instanceof Short && b instanceof Short ? Short.valueOf((short)((Short)a + (Short)b)) : (a instanceof Character && b instanceof Character ? (Serializable)Character.valueOf((char)(((Character)a).charValue() + ((Character)b).charValue())) : (Serializable)(a instanceof Double || b instanceof Double ? (Number)(this.toDouble(a) + this.toDouble(b)) : (Number)(a instanceof Float || b instanceof Float ? (Number)Float.valueOf(this.toFloat(a) + this.toFloat(b)) : (Number)(a instanceof Long || b instanceof Long ? (Number)(this.toLong(a) + this.toLong(b)) : (Number)(this.toInt(a) + this.toInt(b)))))));
        long executionTimeMillis = System.currentTimeMillis() - startTimeMillis;
        return new NormalExecution(result, executionTimeMillis);
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int toInt(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object x) {
        return x instanceof Character ? ((Character)x).charValue() : ((Number)x).intValue();
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long toLong(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object x) {
        return x instanceof Character ? (long)((Character)x).charValue() : ((Number)x).longValue();
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown float toFloat(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object x) {
        return x instanceof Character ? (float)((Character)x).charValue() : ((Number)x).floatValue();
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown double toDouble(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object x) {
        return x instanceof Character ? (double)((Character)x).charValue() : ((Number)x).doubleValue();
    }

    @Override
    public void appendCode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type declaringType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type outputType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> inputVars, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringBuilder b) {
        boolean isNarrow;
        String out = outputType.getFqName();
        boolean bl = isNarrow = out.equals("byte") || out.equals("short") || out.equals("char");
        if (isNarrow) {
            b.append("(").append(out).append(")(");
        }
        b.append(this.getArgumentString(inputVars.get(0)));
        b.append(" + ");
        b.append(this.getArgumentString(inputVars.get(1)));
        if (isNarrow) {
            b.append(")");
        }
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toParsableString(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type declaringType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type outputType) {
        return "+";
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getName() {
        return "+";
    }
}

