/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.operation.CallableOperation;
import randoop.operation.OperationParseException;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.sequence.Variable;
import randoop.types.ArrayType;
import randoop.types.Type;
import randoop.types.TypeTuple;

public final class InitializedArrayCreation
extends CallableOperation {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int length;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type elementType;

    InitializedArrayCreation(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ArrayType arrayType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int length) {
        assert (length >= 0) : "array length may not be negative: " + length;
        this.elementType = arrayType.getComponentType();
        this.length = length;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int getLength() {
        return this.length;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionOutcome execute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] statementInput) {
        if (statementInput.length > this.length) {
            throw new IllegalArgumentException("Too many arguments: " + statementInput.length + ", capacity: " + this.length);
        }
        long startTime = System.currentTimeMillis();
        assert (statementInput.length == this.length);
        Object theArray = Array.newInstance(this.elementType.getRuntimeClass(), this.length);
        for (int i = 0; i < statementInput.length; ++i) {
            Array.set(theArray, i, statementInput[i]);
        }
        long totalTime = System.currentTimeMillis() - startTime;
        return new NormalExecution(theArray, totalTime);
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return this.elementType.getBinaryName() + "[" + this.length + "]";
    }

    @Override
    public void appendCode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type declaringType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type outputType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> inputVars, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringBuilder b) {
        if (inputVars.size() > this.length) {
            throw new IllegalArgumentException("Too many arguments: " + inputVars.size() + ", capacity: " + this.length);
        }
        String arrayTypeName = this.elementType.getFqName();
        b.append("new ").append(arrayTypeName).append("[] { ");
        StringJoiner sj = new StringJoiner(", ");
        for (Variable inputVar : inputVars) {
            sj.add(this.getArgumentString(inputVar));
        }
        b.append(sj);
        b.append(" }");
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.elementType, this.length);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InitializedArrayCreation)) {
            return false;
        }
        InitializedArrayCreation otherArrayDecl = (InitializedArrayCreation)o;
        return this.elementType.equals(otherArrayDecl.elementType) && this.length == otherArrayDecl.length;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toParsableString(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type declaringType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type outputType) {
        return this.elementType.getBinaryName() + "[" + Integer.toString(this.length) + "]";
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getName() {
        return this.toString();
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation parse(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String str) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationParseException {
        Type elementType;
        int openBr = str.indexOf(91);
        int closeBr = str.indexOf(93);
        String elementTypeName = str.substring(0, openBr);
        String lengthStr = str.substring(openBr + 1, closeBr);
        int length = Integer.parseInt(lengthStr);
        try {
            elementType = Type.forName(elementTypeName);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new OperationParseException("Type not found for array element type " + elementTypeName);
        }
        if (elementType.isGeneric()) {
            throw new OperationParseException("Array element type may not be generic " + elementTypeName);
        }
        return TypedOperation.createInitializedArrayCreation(ArrayType.ofComponentType(elementType), length);
    }
}

